/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinInputStream;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Packed;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.Id;

public class Wc3BinInputStream
extends BinInputStream {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Byte readByte(@Nonnull String label) throws BinStream.StreamException {
        Byte val = null;
        try {
            this.logBegin();
            Byte by = val = Byte.valueOf(this.readByte());
            return by;
        }
        finally {
            this.log("byte", label, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public byte[] readBytes(int size, @Nonnull String label) throws BinStream.StreamException {
        byte[] val = null;
        try {
            this.logBegin();
            byte[] byArray = val = this.readBytes(size);
            return byArray;
        }
        finally {
            this.log("bytes", label, val);
        }
    }

    public short readUByte() throws BinStream.StreamException {
        return (short)(this.readByte() & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Short readUByte(@Nonnull String label) throws BinStream.StreamException {
        Short val = null;
        try {
            this.logBegin();
            Short s = val = Short.valueOf(this.readUByte());
            return s;
        }
        finally {
            this.log("byte", label, val);
        }
    }

    public short readInt8() throws BinStream.StreamException {
        try {
            return this.readByte();
        }
        catch (IndexOutOfBoundsException e) {
            throw new BinStream.StreamException(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Short readInt8(@Nonnull String label) throws BinStream.StreamException {
        Short val = null;
        try {
            this.logBegin();
            Short s = val = Short.valueOf(this.readInt8());
            return s;
        }
        finally {
            this.log("int8", label, val);
        }
    }

    public short readUInt8() throws BinStream.StreamException {
        return (short)(this.readInt8() & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Short readUInt8(@Nonnull String label) throws BinStream.StreamException {
        Short val = null;
        try {
            this.logBegin();
            Short s = val = Short.valueOf(this.readUInt8());
            return s;
        }
        finally {
            this.log("uint8", label, val);
        }
    }

    public short readInt16() throws BinStream.StreamException {
        try {
            byte[] sub = this.readBytes(2);
            return ByteBuffer.wrap(sub).order(ByteOrder.LITTLE_ENDIAN).getShort();
        }
        catch (IndexOutOfBoundsException e) {
            throw new BinStream.StreamException(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Short readInt16(@Nonnull String label) throws BinStream.StreamException {
        Short val = null;
        try {
            this.logBegin();
            Short s = val = Short.valueOf(this.readInt16());
            return s;
        }
        finally {
            this.log("short", label, val);
        }
    }

    public int readUInt16() throws BinStream.StreamException {
        return this.readInt16() & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Integer readUInt16(@Nonnull String label) throws BinStream.StreamException {
        Integer val = null;
        try {
            this.logBegin();
            Integer n = val = Integer.valueOf(this.readUInt16());
            return n;
        }
        finally {
            this.log("uint16", label, val);
        }
    }

    public int readInt32() throws BinStream.StreamException {
        try {
            byte[] sub = this.readBytes(4);
            return ByteBuffer.wrap(sub).order(ByteOrder.LITTLE_ENDIAN).getInt();
        }
        catch (IndexOutOfBoundsException e) {
            throw new BinStream.StreamException(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Integer readInt32(@Nonnull String label) throws BinStream.StreamException {
        Integer val = null;
        try {
            this.logBegin();
            Integer n = val = Integer.valueOf(this.readInt32());
            return n;
        }
        finally {
            this.log("int32", label, val);
        }
    }

    public long readUInt32() throws BinStream.StreamException {
        return this.readInt32() & 0xFFFFFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Long readUInt32(@Nonnull String label) throws BinStream.StreamException {
        Long val = null;
        try {
            this.logBegin();
            Long l = val = Long.valueOf(this.readUInt32());
            return l;
        }
        finally {
            this.log("uint32", label, val);
        }
    }

    @Nonnull
    public War3Int readWc3Int() throws BinStream.StreamException {
        return War3Int.valueOf(this.readInt32());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public War3Int readWc3Int(@Nonnull String label) throws BinStream.StreamException {
        War3Int val = null;
        try {
            this.logBegin();
            War3Int war3Int = val = this.readWc3Int();
            return war3Int;
        }
        finally {
            this.log("wc3int", label, val);
        }
    }

    public char readChar() throws BinStream.StreamException {
        try {
            return (char)this.readByte();
        }
        catch (IndexOutOfBoundsException e) {
            throw new BinStream.StreamException(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Character readChar(@Nullable String label) throws BinStream.StreamException {
        Character val = null;
        try {
            this.logBegin();
            Character c = val = Character.valueOf(this.readChar());
            return c;
        }
        finally {
            this.log("char", label, val);
        }
    }

    @Nonnull
    public String readString() throws BinStream.StreamException {
        try {
            long cutPos;
            for (cutPos = this.getPos(); cutPos < this.size() && this.get(cutPos) != 0; ++cutPos) {
            }
            long size = cutPos - this.getPos();
            if (size == 0L) {
                this.setPos(Math.min(cutPos + 1L, this.size() - 1L));
                return "";
            }
            StringBuilder sb = new StringBuilder();
            while (size > 0L) {
                int sizeI = (int)size;
                byte[] retBytes = new byte[sizeI];
                int i = 0;
                while ((long)i < size) {
                    retBytes[i] = this.get(this.getPos() + (long)i);
                    ++i;
                }
                this.setPos(Math.min(cutPos + 1L, this.size() - 1L));
                sb.append(new String(retBytes, StandardCharsets.UTF_8));
                size -= (long)sizeI;
            }
            return sb.toString();
        }
        catch (IndexOutOfBoundsException e) {
            throw new BinStream.StreamException(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String readString(@Nullable String label) throws BinStream.StreamException {
        String val = null;
        try {
            this.logBegin();
            String string = val = this.readString();
            return string;
        }
        finally {
            this.log("string", label, val);
        }
    }

    @Nonnull
    public War3String readWc3String() throws BinStream.StreamException {
        return War3String.valueOf(this.readString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public War3String readWc3String(@Nullable String label) throws BinStream.StreamException {
        War3String val = null;
        try {
            this.logBegin();
            War3String war3String = val = this.readWc3String();
            return war3String;
        }
        finally {
            this.log("wc3string", label, val);
        }
    }

    @Nonnull
    public Id readId() throws BinStream.StreamException {
        Object val = null;
        try {
            byte[] sub = this.readBytes(4);
            return Id.valueOf(this.trimZeroes(new String(sub, StandardCharsets.US_ASCII)));
        }
        catch (IndexOutOfBoundsException e) {
            throw new BinStream.StreamException(this);
        }
    }

    private String trimZeroes(@Nonnull String input) {
        return input.replaceFirst("^\u0000+", "").replaceFirst("\u0000+$", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Id readId(@Nullable String label) throws BinStream.StreamException {
        Id val = null;
        try {
            this.logBegin();
            Id id = val = this.readId();
            return id;
        }
        finally {
            this.log("id", label, val);
        }
    }

    public float readFloat32() throws BinStream.StreamException {
        try {
            byte[] sub = this.readBytes(4);
            return ByteBuffer.wrap(sub).order(ByteOrder.LITTLE_ENDIAN).getFloat();
        }
        catch (IndexOutOfBoundsException e) {
            throw new BinStream.StreamException(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Float readFloat32(@Nullable String label) throws BinStream.StreamException {
        Float val = null;
        try {
            this.logBegin();
            Float f = val = Float.valueOf(this.readFloat32());
            return f;
        }
        finally {
            this.log("float32", label, val);
        }
    }

    @Nonnull
    public War3Real readReal() throws BinStream.StreamException {
        return War3Real.valueOf(this.readFloat32());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public War3Real readReal(@Nullable String label) throws BinStream.StreamException {
        War3Real val = null;
        try {
            this.logBegin();
            War3Real war3Real = val = War3Real.valueOf(this.readFloat32());
            return war3Real;
        }
        finally {
            this.log("real", label, val);
        }
    }

    public void pack() throws BinStream.StreamException {
        Wc3BinOutputStream newStream = Packed.compress(this);
        this._bytes = newStream._bytes;
    }

    public Wc3BinInputStream(@Nonnull InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public Wc3BinInputStream(@Nonnull File file) throws IOException {
        super(file);
    }

    public void checkFormatVersion(int expectedVersion, int actualVersion) throws BinStream.StreamException {
        if (actualVersion != expectedVersion) {
            throw new BinStream.StreamException(this, "version mismatch" + System.lineSeparator() + "expected: " + expectedVersion + System.lineSeparator() + "actual: " + actualVersion);
        }
    }

    @Nonnull
    public <EncodingFormat extends Format> EncodingFormat getFormat(@Nonnull Class<EncodingFormat> formatClass, int actualVersion) throws BinStream.StreamException {
        Map<Integer, Format> all = Format.getAll(formatClass);
        if (!all.containsKey(actualVersion)) {
            StringBuilder sb = new StringBuilder();
            for (Format format : all.values()) {
                if (sb.length() > 0) {
                    sb.append(System.lineSeparator());
                }
                sb.append(format.getVersion());
            }
            throw new BinStream.StreamException(this, "unknown format " + actualVersion + System.lineSeparator() + "supported formats:" + System.lineSeparator() + sb.toString());
        }
        try {
            return (EncodingFormat)((Format)formatClass.getMethod("valueOf", Integer.class).invoke(null, actualVersion));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

