/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.app;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.app.MMP;
import net.moonlightflower.wc3libs.bin.app.SHD;
import net.moonlightflower.wc3libs.bin.app.W3E;
import net.moonlightflower.wc3libs.bin.app.WPM;
import net.moonlightflower.wc3libs.dataTypes.app.Bounds;
import net.moonlightflower.wc3libs.dataTypes.app.Coords2DF;
import net.moonlightflower.wc3libs.port.JMpqPort;
import net.moonlightflower.wc3libs.port.MpqPort;

public class Env {
    private SHD _shd;
    private W3E _w3e;
    private WPM _wpm;
    private MMP _mmp;

    @Nonnull
    public SHD getSHD() {
        return this._shd;
    }

    @Nonnull
    public W3E getW3E() {
        return this._w3e;
    }

    @Nonnull
    public WPM getWPM() {
        return this._wpm;
    }

    @Nonnull
    public MMP getMMP() {
        return this._mmp;
    }

    public int getWidth() {
        return this._w3e.getWidth();
    }

    public int getHeight() {
        return this._w3e.getHeight();
    }

    public void setBounds(@Nonnull Bounds val) {
        this._shd.setBounds(val, true);
        this._w3e.setBounds(val, true, true);
        this._wpm.setBounds(val, true, true);
    }

    public boolean getShadow(@Nonnull Coords2DF pos) {
        return (Boolean)this._shd.getShadowMap().getByPos(pos);
    }

    public void setShadow(@Nonnull Coords2DF pos, boolean val) {
        this._shd.getShadowMap().setByPos(pos, val);
    }

    public Env(@Nonnull W3E w3e, @Nonnull SHD shd, @Nonnull WPM wpm, @Nonnull MMP mmp) {
        this._mmp = mmp;
        this._shd = shd;
        this._w3e = w3e;
        this._wpm = wpm;
    }

    public Env(@Nonnull Bounds bounds) {
        this(new W3E(bounds), new SHD(bounds), new WPM(bounds), new MMP());
    }

    public static Env ofMapFile(File map) throws Exception {
        InputStream inputStream4;
        InputStream inputStream3;
        InputStream inputStream2;
        if (!map.exists()) {
            throw new IOException(String.format("file %s does not exist", map));
        }
        JMpqPort.Out port = new JMpqPort.Out();
        port.add(W3E.GAME_PATH);
        port.add(SHD.GAME_PATH);
        port.add(WPM.GAME_PATH);
        port.add(MMP.GAME_PATH);
        MpqPort.Out.Result portResult = port.commit(map);
        W3E w3e = null;
        SHD shd = null;
        WPM wpm = null;
        MMP mmp = null;
        InputStream inputStream = portResult.getInputStream(W3E.GAME_PATH);
        if (inputStream != null) {
            w3e = new W3E(new Wc3BinInputStream(inputStream));
        }
        if ((inputStream2 = portResult.getInputStream(SHD.GAME_PATH)) != null) {
            shd = new SHD(new Wc3BinInputStream(inputStream2));
        }
        if ((inputStream3 = portResult.getInputStream(WPM.GAME_PATH)) != null) {
            wpm = new WPM(new Wc3BinInputStream(inputStream3));
        }
        if ((inputStream4 = portResult.getInputStream(MMP.GAME_PATH)) != null) {
            mmp = new MMP(new Wc3BinInputStream(inputStream4));
        }
        if (w3e != null && shd != null && wpm != null && mmp != null) {
            return new Env(w3e, shd, wpm, mmp);
        }
        return null;
    }
}

