/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.port.Context;
import net.moonlightflower.wc3libs.port.JMpqPort;
import net.moonlightflower.wc3libs.port.MpqPort;
import net.moonlightflower.wc3libs.port.NotFoundException;
import net.moonlightflower.wc3libs.txt.TXT;
import net.moonlightflower.wc3libs.txt.TXTSectionId;

public class WTG {
    public static final File GAME_PATH = new File("war3map.wtg");
    private final Map<FieldId, FuncCat> _funcCats = new LinkedHashMap<FieldId, FuncCat>();
    private final Map<String, Func> _funcs = new LinkedHashMap<String, Func>();
    private int _unknownNumB;
    private final List<Trig> _trigs = new ArrayList<Trig>();
    private final List<TrigCat> _trigCats = new ArrayList<TrigCat>();
    private final Map<String, Var> _vars = new LinkedHashMap<String, Var>();
    private static final Pattern categoryPattern = Pattern.compile("^_(.*)_Category$");

    @Nonnull
    public Map<FieldId, FuncCat> getFuncCats() {
        return new LinkedHashMap<FieldId, FuncCat>(this._funcCats);
    }

    public void addFuncCat(@Nonnull FuncCat val) {
        this._funcCats.put(val.getId(), val);
    }

    @Nonnull
    public FuncCat addFuncCat(@Nonnull FieldId id) {
        if (this._funcCats.containsKey(id)) {
            return this._funcCats.get(id);
        }
        FuncCat cat = new FuncCat(id);
        this.addFuncCat(cat);
        return cat;
    }

    @Nonnull
    private Map<String, Func> getFuncs() {
        return new LinkedHashMap<String, Func>(this._funcs);
    }

    private Func getFunc(String name) {
        return this.getFuncs().get(name);
    }

    private void addFunc(@Nonnull Func val) {
        this._funcs.put(val.getName(), val);
    }

    @Nonnull
    private Func addFunc(String name) {
        if (this._funcs.containsKey(name)) {
            return this._funcs.get(name);
        }
        Func func = new Func(name);
        this.addFunc(func);
        return func;
    }

    public int getUnknownNumB() {
        return this._unknownNumB;
    }

    public void setUnknownNumB(int val) {
        this._unknownNumB = val;
    }

    @Nonnull
    public List<Trig> getTrigs() {
        return new ArrayList<Trig>(this._trigs);
    }

    private void addTrig(@Nonnull Trig val) {
        this._trigs.add(val);
    }

    @Nonnull
    public Trig addTrig() {
        Trig trig = new Trig();
        this.addTrig(trig);
        return trig;
    }

    @Nonnull
    public List<TrigCat> getTrigCats() {
        return new ArrayList<TrigCat>(this._trigCats);
    }

    public void addTrigCat(@Nonnull TrigCat val) {
        this._trigCats.add(val);
    }

    @Nonnull
    public TrigCat addTrigCat() {
        TrigCat trigCat = new TrigCat();
        this.addTrigCat(trigCat);
        return trigCat;
    }

    public Map<String, Var> getVars() {
        return new LinkedHashMap<String, Var>(this._vars);
    }

    @Nullable
    public Var getVar(@Nonnull String name) {
        return this._vars.get(name);
    }

    private void addVar(@Nonnull Var val) {
        this._vars.put(val.getName(), val);
    }

    @Nonnull
    public Var addVar(@Nullable String name) {
        Var var = new Var(name);
        this.addVar(var);
        return var;
    }

    public void addTriggerData(@Nonnull TXT txt) {
        for (Map.Entry<FieldId, ? extends TXT.Section.Field> fieldEntry : txt.getSection(TXTSectionId.valueOf("TriggerCategories")).getFields().entrySet()) {
            FieldId fieldId = fieldEntry.getKey();
            TXT.Section.Field field = fieldEntry.getValue();
            FuncCat cat = new FuncCat(fieldId);
            cat.setIconFile(new File(field.get(1).toString()));
            this.addFuncCat(cat);
        }
        LinkedHashMap<String, Integer> sections = new LinkedHashMap<String, Integer>();
        sections.put("TriggerEvents", 1);
        sections.put("TriggerConditions", 1);
        sections.put("TriggerActions", 1);
        sections.put("TriggerCalls", 3);
        for (Map.Entry sectionEntry : sections.entrySet()) {
            String sectionName = (String)sectionEntry.getKey();
            int argsOffset = (Integer)sectionEntry.getValue();
            TXT.Section section = txt.getSection(TXTSectionId.valueOf(sectionName));
            for (Map.Entry<FieldId, ? extends TXT.Section.Field> fieldEntry : section.getFields().entrySet()) {
                FieldId key = fieldEntry.getKey();
                TXT.Section.Field field = fieldEntry.getValue();
                String[] vals = field.getValLine(null).split(",");
                if (key.toString().startsWith("_")) {
                    if (key.toString().endsWith("_Category")) {
                        Matcher mat = categoryPattern.matcher(key.toString());
                        mat.find();
                        if (mat.matches()) {
                            Func func = this.addFunc(mat.group(1));
                            func.setCat(vals[0]);
                        }
                    }
                    if (!key.toString().endsWith("_Defaults")) continue;
                    continue;
                }
                Func func = this.addFunc(key.toString());
                for (int i = argsOffset; i < vals.length; ++i) {
                    if (vals[i].equals("nothing")) continue;
                    func.addParam(vals[i]);
                }
            }
        }
    }

    @Nonnull
    protected MpqPort getMpqPort() {
        return Context.getService(MpqPort.class);
    }

    public void addGameTriggerData() throws NotFoundException {
        try {
            InputStream inputStream = this.getMpqPort().getGameFiles(new File("UI\\TriggerData.txt")).getInputStream(new File("UI\\TriggerData.txt"));
            if (inputStream == null) {
                throw new NotFoundException();
            }
            TXT txt = new TXT(inputStream);
            this.addTriggerData(txt);
        }
        catch (IOException e) {
            throw new NotFoundException(e);
        }
    }

    public void print(@Nonnull PrintStream outStream) {
    }

    public void print() {
        this.print(System.out);
    }

    private void read_0x4(@Nonnull Reader reader) throws Exception {
        Wc3BinInputStream stream = reader.getStream();
        Id startToken = stream.readId("startToken");
        int version = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.WTG_0x4.getVersion(), version);
        int trigCatsCount = stream.readInt32("trigCatsCount");
        for (int i = 0; i < trigCatsCount; ++i) {
            TrigCat trigCat = new TrigCat(reader);
            stream.beginGroup(String.format("trigCat%d", i));
            this.addTrigCat(trigCat);
            stream.endGroup();
        }
        int unknownNumB = stream.readInt32("unknownNumB");
        int varsCount = stream.readInt32("varsCount");
        for (int i = 0; i < varsCount; ++i) {
            stream.beginGroup(String.format("var%d", i));
            this.addVar(new Var(stream, EncodingFormat.WTG_0x4));
            stream.endGroup();
        }
        reader.getFuncMap().putAll(this.getFuncs());
        reader.getVarMap().putAll(this.getVars());
        int trigsCount = stream.readInt32("trigsCount");
        for (int i = 0; i < trigsCount; ++i) {
            stream.beginGroup(String.format("trig%d", i));
            this.addTrig(new Trig(reader));
            stream.endGroup();
        }
    }

    private void write_0x4(@Nonnull Writer writer) throws IOException {
        Wc3BinOutputStream stream = writer.getStream();
        stream.writeId(Id.valueOf("WTG!"));
        stream.writeInt32(EncodingFormat.WTG_0x4.getVersion());
        stream.writeInt32(this._trigCats.size());
        for (TrigCat trigCat : this._trigCats) {
            trigCat.write(writer);
        }
        stream.writeInt32(this._unknownNumB);
        stream.writeInt32(this._vars.size());
        for (Var var : this._vars.values()) {
            var.write(stream, EncodingFormat.WTG_0x4);
        }
        stream.writeInt32(this._trigs.size());
        for (Trig trig : this._trigs) {
            trig.write(writer);
        }
    }

    private void read_0x7(@Nonnull Reader reader) throws Exception {
        Wc3BinInputStream stream = reader.getStream();
        Id startToken = stream.readId("startToken");
        int version = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.WTG_0x7.getVersion(), version);
        int trigCatsCount = stream.readInt32("trigCatsCount");
        for (int i = 0; i < trigCatsCount; ++i) {
            stream.beginGroup(String.format("trigCat%d", i));
            TrigCat trigCat = new TrigCat(reader);
            stream.endGroup();
            this.addTrigCat(trigCat);
        }
        this._unknownNumB = stream.readInt32("unknownNumB");
        int varsCount = stream.readInt32("varsCount");
        for (int i = 0; i < varsCount; ++i) {
            stream.beginGroup(String.format("var%d", i));
            this.addVar(new Var(stream, EncodingFormat.WTG_0x7));
            stream.endGroup();
        }
        reader.getFuncMap().putAll(this.getFuncs());
        reader.getVarMap().putAll(this.getVars());
        int trigsCount = stream.readInt32("trigsCount");
        for (int i = 0; i < trigsCount; ++i) {
            stream.beginGroup(String.format("trig%d", i));
            Trig trig = new Trig(reader);
            stream.endGroup();
            this.addTrig(trig);
        }
    }

    private void write_0x7(@Nonnull Writer writer) throws IOException {
        Wc3BinOutputStream stream = writer.getStream();
        stream.writeId(Id.valueOf("WTG!"));
        stream.writeInt32(EncodingFormat.WTG_0x7.getVersion());
        stream.writeInt32(this._trigCats.size());
        for (TrigCat trigCat : this._trigCats) {
            trigCat.write(writer);
        }
        stream.writeInt32(this._unknownNumB);
        stream.writeInt32(this._vars.size());
        for (Var var : this._vars.values()) {
            var.write(stream, EncodingFormat.WTG_0x7);
        }
        stream.writeInt32(this._trigs.size());
        for (Trig trig : this._trigs) {
            trig.write(writer);
        }
    }

    private void read_auto(@Nonnull Reader reader) throws Exception {
        Wc3BinInputStream stream = reader.getStream();
        Id startToken = stream.readId("startToken");
        int version = stream.readInt32("version");
        stream.rewind();
        reader.setFormat(stream.getFormat(EncodingFormat.class, version));
        this.read(reader);
    }

    private void read(@Nonnull Reader reader) throws Exception {
        switch ((EncodingFormat.Enum)((Object)reader.getFormat().toEnum())) {
            case WTG_0x4: {
                this.read_0x4(reader);
                break;
            }
            case WTG_0x7: {
                this.read_0x7(reader);
                break;
            }
            case AUTO: {
                this.read_auto(reader);
            }
        }
    }

    private void write(@Nonnull Writer writer) throws IOException {
        switch ((EncodingFormat.Enum)((Object)writer.getFormat().toEnum())) {
            case WTG_0x4: {
                this.write_0x4(writer);
                break;
            }
            case WTG_0x7: {
                this.write_0x7(writer);
                break;
            }
            case AUTO: {
                this.write_0x7(writer);
            }
        }
    }

    public void write(@Nonnull Wc3BinOutputStream stream) throws IOException {
        this.write(new Writer(stream));
    }

    public void read(@Nonnull Wc3BinInputStream stream) throws Exception {
        this.read(new Reader(stream));
    }

    private void write(@Nonnull File file) throws IOException {
        Wc3BinOutputStream outStream = new Wc3BinOutputStream(file);
        this.write(outStream);
        outStream.close();
    }

    public WTG(@Nonnull Wc3BinInputStream stream) throws Exception {
        this.read(stream);
    }

    public WTG(@Nonnull File file) throws Exception {
        Wc3BinInputStream stream = new Wc3BinInputStream(file);
        this.read(stream);
        stream.close();
    }

    public WTG() {
    }

    @Nullable
    public static WTG ofMapFile(@Nonnull File mapFile) throws Exception {
        if (!mapFile.exists()) {
            throw new IOException(String.format("file %s does not exist", mapFile));
        }
        JMpqPort.Out port = new JMpqPort.Out();
        port.add(GAME_PATH);
        MpqPort.Out.Result portResult = port.commit(mapFile);
        if (!portResult.getExports().containsKey(GAME_PATH)) {
            throw new IOException("could not extract wtg file");
        }
        InputStream inStream = portResult.getInputStream(GAME_PATH);
        if (inStream == null) {
            return null;
        }
        Wc3BinInputStream stream = new Wc3BinInputStream(inStream);
        WTG wtg = new WTG(stream);
        stream.close();
        return wtg;
    }

    public static class Writer {
        private final Wc3BinOutputStream _stream;
        private EncodingFormat _format = EncodingFormat.AUTO;
        private final Map<String, Func> _funcMap = new LinkedHashMap<String, Func>();
        private final Map<String, Var> _varMap = new LinkedHashMap<String, Var>();

        @Nonnull
        public Wc3BinOutputStream getStream() {
            return this._stream;
        }

        public EncodingFormat getFormat() {
            return this._format;
        }

        public void setFormat(@Nonnull EncodingFormat val) {
            this._format = val;
        }

        @Nonnull
        public Map<String, Func> getFuncMap() {
            return this._funcMap;
        }

        @Nonnull
        public Map<String, Var> getVarMap() {
            return this._varMap;
        }

        public Writer(@Nonnull Wc3BinOutputStream stream) {
            this._stream = stream;
        }
    }

    public static class Reader {
        private final Wc3BinInputStream _stream;
        private EncodingFormat _format = EncodingFormat.AUTO;
        private final Map<String, Func> _funcMap = new LinkedHashMap<String, Func>();
        private final Map<String, Var> _varMap = new LinkedHashMap<String, Var>();

        @Nonnull
        public Wc3BinInputStream getStream() {
            return this._stream;
        }

        public EncodingFormat getFormat() {
            return this._format;
        }

        public void setFormat(@Nonnull EncodingFormat val) {
            this._format = val;
        }

        @Nonnull
        public Map<String, Func> getFuncMap() {
            return this._funcMap;
        }

        @Nonnull
        public Map<String, Var> getVarMap() {
            return this._varMap;
        }

        public Reader(@Nonnull Wc3BinInputStream stream) {
            this._stream = stream;
        }
    }

    public static class EncodingFormat
    extends Format<Enum> {
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, -1);
        public static final EncodingFormat WTG_0x4 = new EncodingFormat(Enum.WTG_0x4, 4);
        public static final EncodingFormat WTG_0x7 = new EncodingFormat(Enum.WTG_0x7, 7);

        @Nullable
        public static EncodingFormat valueOf(@Nonnull Integer version) {
            return EncodingFormat.get(EncodingFormat.class, version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, int version) {
            super(enumVal, version);
        }

        public static enum Enum {
            AUTO,
            WTG_0x4,
            WTG_0x7;

        }
    }

    public static class Var {
        private String _name;
        private String _type;
        private int _unknownNumE;
        private boolean _arrayFlag = false;
        private int _arraySize;
        private boolean _initedFlag = false;
        private String _initVal;

        public String getName() {
            return this._name;
        }

        public void setName(@Nullable String val) {
            this._name = val;
        }

        public String getType() {
            return this._type;
        }

        public void setType(@Nullable String val) {
            this._type = val;
        }

        public int getUnknownNumE() {
            return this._unknownNumE;
        }

        public void setUnknownNumE(int val) {
            this._unknownNumE = val;
        }

        public boolean isArray() {
            return this._arrayFlag;
        }

        public void setArray(boolean val) {
            this._arrayFlag = val;
        }

        public int getArraySize() {
            return this._arraySize;
        }

        public void setArraySize(int val) {
            this._arraySize = val;
        }

        public boolean isInited() {
            return this._initedFlag;
        }

        public void setInited(boolean val) {
            this._initedFlag = val;
        }

        public String getInitVal() {
            return this._initVal;
        }

        public void setInitVal(@Nullable String val) {
            this._initVal = val;
        }

        public String toString() {
            return this.getName();
        }

        private void read_0x4(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this.setName(stream.readString("name"));
            this.setType(stream.readString("type"));
            this.setUnknownNumE(stream.readInt32("unknownNumE"));
            this.setArray(stream.readInt32("array") != 0);
            this.setInited(stream.readInt32("inited") != 0);
            this.setInitVal(stream.readString("initVal"));
        }

        private void write_0x4(@Nonnull Wc3BinOutputStream stream) {
            stream.writeString(this._name);
            stream.writeString(this._type);
            stream.writeInt32(this._unknownNumE);
            stream.writeInt32(this._arrayFlag ? 1 : 0);
            stream.writeInt32(this._initedFlag ? 1 : 0);
            stream.writeString(this._initVal);
        }

        private void read_0x7(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this._name = stream.readString("name");
            this._type = stream.readString("type");
            this._unknownNumE = stream.readInt32("unknownNumE");
            this._arrayFlag = stream.readInt32("array") != 0;
            this._arraySize = stream.readInt32("arraySize");
            this._initedFlag = stream.readInt32("inited") != 0;
            this._initVal = stream.readString("initVal");
        }

        private void write_0x7(@Nonnull Wc3BinOutputStream stream) {
            stream.writeString(this._name);
            stream.writeString(this._type);
            stream.writeInt32(this._unknownNumE);
            stream.writeInt32(this._arrayFlag ? 1 : 0);
            stream.writeInt32(this._arraySize);
            stream.writeInt32(this._initedFlag ? 1 : 0);
            stream.writeString(this._initVal);
        }

        private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case WTG_0x7: {
                    this.read_0x7(stream);
                    break;
                }
                case WTG_0x4: {
                    this.read_0x4(stream);
                }
            }
        }

        private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case WTG_0x7: {
                    this.write_0x7(stream);
                    break;
                }
                case WTG_0x4: {
                    this.write_0x4(stream);
                }
            }
        }

        public Var(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this.read(stream, format);
        }

        public Var(@Nullable String name) {
            this._name = name;
        }
    }

    public static class TrigCat {
        private int _index;
        private String _name;
        private Type _type = Type.NORMAL;

        public int getIndex() {
            return this._index;
        }

        public void setIndex(int val) {
            this._index = val;
        }

        public String getName() {
            return this._name;
        }

        public void setName(@Nullable String val) {
            this._name = val;
        }

        @Nonnull
        public Type getType() {
            return this._type;
        }

        public void setType(@Nonnull Type val) {
            this._type = val;
        }

        public String toString() {
            return this.getName();
        }

        private void read_0x4(@Nonnull Reader reader) throws BinStream.StreamException {
            Wc3BinInputStream stream = reader.getStream();
            this.setIndex(stream.readInt32("index"));
            this.setName(stream.readString("name"));
        }

        private void write_0x4(@Nonnull Writer writer) {
            Wc3BinOutputStream stream = writer.getStream();
            stream.writeInt32(this.getIndex());
            stream.writeString(this.getName());
        }

        private void read_0x7(@Nonnull Reader reader) throws BinStream.StreamException {
            Wc3BinInputStream stream = reader.getStream();
            this.setIndex(stream.readInt32("index"));
            this.setName(stream.readString("name"));
            this.setType(Type.valueOf(stream.readInt32("type")));
        }

        private void write_0x7(@Nonnull Writer writer) {
            Wc3BinOutputStream stream = writer.getStream();
            stream.writeInt32(this.getIndex());
            stream.writeString(this.getName());
            stream.writeInt32(this.getType().getVal());
        }

        private void read(@Nonnull Reader reader) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)reader.getFormat().toEnum())) {
                case WTG_0x7: {
                    this.read_0x7(reader);
                    break;
                }
                case WTG_0x4: {
                    this.read_0x4(reader);
                }
            }
        }

        private void write(@Nonnull Writer writer) {
            switch ((EncodingFormat.Enum)((Object)writer.getFormat().toEnum())) {
                case WTG_0x7: 
                case AUTO: {
                    this.write_0x7(writer);
                    break;
                }
                case WTG_0x4: {
                    this.write_0x4(writer);
                }
            }
        }

        public TrigCat(@Nonnull Reader reader) throws BinStream.StreamException {
            this.read(reader);
        }

        public TrigCat() {
        }

        public static class Type {
            private static final Map<Integer, Type> _map = new LinkedHashMap<Integer, Type>();
            public static final Type COMMENT = new Type(1);
            public static final Type NORMAL = new Type(0);
            private int _val;

            public int getVal() {
                return this._val;
            }

            private Type(int val) {
                this._val = val;
                _map.put(val, this);
            }

            @Nullable
            public static Type valueOf(int val) {
                return _map.get(val);
            }
        }
    }

    public static class Trig {
        private String _name;
        private String _description;
        private TrigType _type = TrigType.NORMAL;
        private boolean _enabled = true;
        private boolean _customTxt = false;
        private boolean _initiallyOn = true;
        private boolean _runOnMapInit = true;
        private int _catIndex;
        private final List<ECA> _ecas = new ArrayList<ECA>();

        public String getName() {
            return this._name;
        }

        public void setName(String val) {
            this._name = val;
        }

        public String getDescription() {
            return this._description;
        }

        public void setDescription(String val) {
            this._description = val;
        }

        public TrigType getType() {
            return this._type;
        }

        public void setType(TrigType val) {
            this._type = val;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public void setEnabled(boolean val) {
            this._enabled = val;
        }

        public boolean isCustomTxt() {
            return this._customTxt;
        }

        public void setCustomTxt(boolean val) {
            this._customTxt = val;
        }

        public boolean isInitiallyOn() {
            return this._initiallyOn;
        }

        public void setInitiallyOn(boolean val) {
            this._initiallyOn = val;
        }

        public boolean isRunOnMapInit() {
            return this._runOnMapInit;
        }

        public void setRunOnMapInit(boolean val) {
            this._runOnMapInit = val;
        }

        public int getCatIndex() {
            return this._catIndex;
        }

        public void setCatIndex(int val) {
            this._catIndex = val;
        }

        @Nonnull
        public List<ECA> getECAs() {
            return new ArrayList<ECA>(this._ecas);
        }

        public void addECA(@Nonnull ECA eca) {
            this._ecas.add(eca);
        }

        public ECA addECA() {
            ECA eca = new ECA();
            this.addECA(eca);
            return eca;
        }

        public String toString() {
            return this.getName();
        }

        private void write_0x4(@Nonnull Writer writer) throws IOException {
            Wc3BinOutputStream stream = writer.getStream();
            stream.writeString(this.getName());
            stream.writeString(this.getDescription());
            stream.writeInt32(this.getType().getVal());
            stream.writeInt32(this.isEnabled() ? 1 : 0);
            stream.writeInt32(this.isCustomTxt() ? 1 : 0);
            stream.writeInt32(this.isInitiallyOn() ? 1 : 0);
            stream.writeInt32(0);
            stream.writeInt32(this.getCatIndex());
            stream.writeInt32(this._ecas.size());
            for (ECA eca : this._ecas) {
                eca.write(writer, false);
            }
        }

        private void read_0x4(@Nonnull Reader reader) throws Exception {
            Wc3BinInputStream stream = reader.getStream();
            this.setName(stream.readString("name"));
            this.setDescription(stream.readString("description"));
            this.setEnabled(stream.readInt32("enabled") != 0);
            this.setCustomTxt(stream.readInt32("customTxt") != 0);
            this.setInitiallyOn(stream.readInt32("initiallyOn") == 0);
            stream.readInt32("unknown");
            this.setCatIndex(stream.readInt32("catIndex"));
            int ECAsCount = stream.readInt32("ECAsCount");
            for (int i = 0; i < ECAsCount; ++i) {
                stream.beginGroup(String.format("ECA%d", i));
                ECA eca = new ECA(reader, false);
                stream.endGroup();
                this.addECA(eca);
            }
        }

        private void write_0x7(@Nonnull Writer writer) throws IOException {
            Wc3BinOutputStream stream = writer.getStream();
            stream.writeString(this.getName());
            stream.writeString(this.getDescription());
            stream.writeInt32(this.getType().getVal());
            stream.writeInt32(this.isEnabled() ? 1 : 0);
            stream.writeInt32(this.isCustomTxt() ? 1 : 0);
            stream.writeInt32(this.isInitiallyOn() ? 0 : 1);
            stream.writeInt32(this.isRunOnMapInit() ? 1 : 0);
            stream.writeInt32(this.getCatIndex());
            stream.writeInt32(this._ecas.size());
            for (ECA eca : this._ecas) {
                eca.write(writer, false);
            }
        }

        private void read_0x7(@Nonnull Reader reader) throws Exception {
            Wc3BinInputStream stream = reader.getStream();
            this.setName(stream.readString("name"));
            this.setDescription(stream.readString("description"));
            this.setType(TrigType.valueOf(stream.readInt32("type")));
            this.setEnabled(stream.readInt32("enabled") != 0);
            this.setCustomTxt(stream.readInt32("customTxt") != 0);
            this.setInitiallyOn(stream.readInt32("initiallyOn") == 0);
            this.setRunOnMapInit(stream.readInt32("runOnMapInit") != 0);
            this.setCatIndex(stream.readInt32("catIndex"));
            int ECAsCount = stream.readInt32("ECAsCount");
            for (int i = 0; i < ECAsCount; ++i) {
                stream.beginGroup(String.format("ECA%d", i));
                ECA eca = new ECA(reader, false);
                stream.endGroup();
                this.addECA(eca);
            }
        }

        public void read(@Nonnull Reader reader) throws Exception {
            switch ((EncodingFormat.Enum)((Object)reader.getFormat().toEnum())) {
                case WTG_0x7: {
                    this.read_0x7(reader);
                    break;
                }
                case WTG_0x4: {
                    this.read_0x4(reader);
                }
            }
        }

        public void write(@Nonnull Writer writer) throws IOException {
            switch ((EncodingFormat.Enum)((Object)writer.getFormat().toEnum())) {
                case WTG_0x7: 
                case AUTO: {
                    this.write_0x7(writer);
                    break;
                }
                case WTG_0x4: {
                    this.write_0x4(writer);
                }
            }
        }

        public Trig(@Nonnull Reader reader) throws Exception {
            this.read(reader);
        }

        public Trig() {
        }

        public static class ECA {
            private ECAType _type;
            private int _branch = -1;
            private Func _func;
            private boolean _enabled = true;
            private final List<Param> _params = new ArrayList<Param>();
            private final List<ECA> _ecas = new ArrayList<ECA>();

            public ECAType getType() {
                return this._type;
            }

            public void setType(ECAType val) {
                this._type = val;
            }

            public int getBranch() {
                return this._branch;
            }

            public void setBranch(int val) {
                this._branch = val;
            }

            public Func getFunc() {
                return this._func;
            }

            public void setFunc(Func val) {
                this._func = val;
            }

            public boolean isEnabled() {
                return this._enabled;
            }

            public void setEnabled(boolean val) {
                this._enabled = val;
            }

            public String toString() {
                return this.getFunc().toString();
            }

            @Nonnull
            public List<Param> getParams() {
                return new ArrayList<Param>(this._params);
            }

            public void addParam(@Nonnull Param val) {
                this._params.add(val);
            }

            @Nonnull
            public List<ECA> getECAs() {
                return new ArrayList<ECA>(this._ecas);
            }

            public void addECA(@Nonnull ECA val) {
                this._ecas.add(val);
            }

            @Nonnull
            public ECA addECA() {
                ECA sub = new ECA();
                this._ecas.add(sub);
                return sub;
            }

            private void read_0x4(@Nonnull Reader reader, boolean hasBranch) throws Exception {
                Wc3BinInputStream stream = reader.getStream();
                this._type = ECAType.valueOf(stream.readInt32("type"));
                if (hasBranch) {
                    this._branch = stream.readInt32("branch");
                }
                String funcName = stream.readString("func");
                this._func = reader.getFuncMap().get(funcName);
                boolean bl = this._enabled = stream.readInt32("enabled") != 0;
                if (this._func != null) {
                    for (int i = 0; i < this._func.getParams().size(); ++i) {
                        NormalParam sub = null;
                        stream.beginGroup(String.format("param%d", i));
                        sub = new NormalParam(reader, false);
                        stream.endGroup();
                        this.addParam(sub);
                    }
                } else {
                    throw new IOException(String.format("unknown func %s", funcName));
                }
            }

            private void write_0x4(@Nonnull Writer writer, boolean hasBranch) throws IOException {
                Wc3BinOutputStream stream = writer.getStream();
                stream.writeInt32(this._type.getVal());
                if (hasBranch) {
                    stream.writeInt32(this._branch);
                }
                stream.writeString(this._func.getName());
                stream.writeInt32(this._enabled ? 1 : 0);
                for (Param param : this.getParams()) {
                    param.write(writer);
                }
            }

            private void read_0x7(@Nonnull Reader reader, boolean hasBranch) throws Exception {
                Object sub;
                Wc3BinInputStream stream = reader.getStream();
                this._type = ECAType.valueOf(stream.readInt32("type"));
                if (hasBranch) {
                    this.setBranch(stream.readInt32("branch"));
                }
                String funcName = stream.readString("funcName");
                this._func = reader.getFuncMap().get(funcName);
                boolean bl = this._enabled = stream.readInt32("enabled") != 0;
                if (this._func == null) {
                    throw new IOException(String.format("unknown func %s", funcName));
                }
                for (int i = 0; i < this._func.getParams().size(); ++i) {
                    sub = null;
                    stream.beginGroup(String.format("param%d", i));
                    sub = new NormalParam(reader, false);
                    stream.endGroup();
                    this.addParam((Param)sub);
                }
                for (int ecasCount = stream.readInt32("ECAsCount").intValue(); ecasCount > 0; --ecasCount) {
                    sub = new ECA(reader, true);
                    this.addECA((ECA)sub);
                }
            }

            private void write_0x7(@Nonnull Writer writer, boolean hasBranch) throws IOException {
                Wc3BinOutputStream stream = writer.getStream();
                stream.writeInt32(this._type.getVal());
                if (hasBranch) {
                    stream.writeInt32(this.getBranch());
                }
                stream.writeString(this.getFunc().getName());
                stream.writeUInt32(this.isEnabled() ? 1L : 0L);
                if (this.getFunc() != null) {
                    for (Param param : this.getParams()) {
                        param.write(writer);
                    }
                }
                stream.writeInt32(this.getECAs().size());
                for (ECA eca : this.getECAs()) {
                    eca.write(writer, true);
                }
            }

            private void read(@Nonnull Reader reader, boolean hasBranch) throws Exception {
                switch ((EncodingFormat.Enum)((Object)reader.getFormat().toEnum())) {
                    case WTG_0x7: {
                        this.read_0x7(reader, hasBranch);
                        break;
                    }
                    case WTG_0x4: {
                        this.read_0x4(reader, hasBranch);
                    }
                }
            }

            private void write(@Nonnull Writer writer, boolean hasBranch) throws IOException {
                switch ((EncodingFormat.Enum)((Object)writer.getFormat().toEnum())) {
                    case WTG_0x7: 
                    case AUTO: {
                        this.write_0x7(writer, hasBranch);
                        break;
                    }
                    case WTG_0x4: {
                        this.write_0x4(writer, hasBranch);
                    }
                }
            }

            public ECA(@Nonnull Reader reader, boolean hasBranch) throws Exception {
                this.read(reader, hasBranch);
            }

            public ECA() {
            }

            public static class CodeParam
            extends ECAParam {
                private int _code_unknown1;
                private char _code_unknown2;
                private Character[] _code_unknown = new Character[12];
                protected int _dummyDoNothing;

                public int getCode_unknown1() {
                    return this._code_unknown1;
                }

                public void setCode_unknown1(int val) {
                    this._code_unknown1 = val;
                }

                public char getCode_unknown2() {
                    return this._code_unknown2;
                }

                public void setCode_unknown2(char val) {
                    this._code_unknown2 = val;
                }

                public char getCode_unknown(int index) {
                    return this._code_unknown[index].charValue();
                }

                public void setCode_unknown(int index, char val) {
                    this._code_unknown[index] = Character.valueOf(val);
                }

                private void read_0x4(@Nonnull Reader reader) throws Exception {
                    Wc3BinInputStream stream = reader.getStream();
                    stream.beginGroup("code");
                    this.setCode_unknown1(stream.readInt32("unknown1"));
                    this._dummyDoNothing = stream.readInt32("dummyDoNothing");
                    if (this._dummyDoNothing == 256) {
                        this.setCode_unknown2(stream.readChar("unknown2").charValue());
                    } else {
                        for (int i = 3; i < 13; ++i) {
                            this.setCode_unknown(i, stream.readChar(String.format("unknown%d", i)).charValue());
                        }
                    }
                    this._eca = new ECA(reader, false);
                    this._endToken = stream.readInt32();
                    stream.endGroup();
                }

                private void write_0x4(@Nonnull Writer writer) throws IOException {
                    Wc3BinOutputStream stream = writer.getStream();
                    stream.writeInt32(this._code_unknown1);
                    stream.writeInt32(this._dummyDoNothing);
                    if (this._dummyDoNothing == 256) {
                        stream.writeChar(this._code_unknown2);
                    } else {
                        for (int i = 3; i < 13; ++i) {
                            stream.writeChar(this.getCode_unknown(i));
                        }
                    }
                    this._eca.write(writer, false);
                    stream.writeInt32(this._endToken);
                }

                private void read_0x7(@Nonnull Reader reader) throws Exception {
                    Wc3BinInputStream stream = reader.getStream();
                    stream.beginGroup("code");
                    this.setCode_unknown1(stream.readInt32("unknown1"));
                    this._dummyDoNothing = stream.readInt32("dummyDoNothing");
                    if (this._dummyDoNothing == 256) {
                        this.setCode_unknown2(stream.readChar("unknown2").charValue());
                    } else {
                        for (int i = 3; i < 13; ++i) {
                            this.setCode_unknown(i, stream.readChar(String.format("unknown%d", i)).charValue());
                        }
                    }
                    this._eca = new ECA(reader, false);
                    this._endToken = stream.readInt32();
                    stream.endGroup();
                }

                private void write_0x7(@Nonnull Writer writer) throws IOException {
                    Wc3BinOutputStream stream = writer.getStream();
                    stream.writeInt32(this._code_unknown1);
                    stream.writeInt32(this._dummyDoNothing);
                    if (this._dummyDoNothing == 256) {
                        stream.writeChar(this._code_unknown2);
                    } else {
                        for (int i = 3; i < 13; ++i) {
                            stream.writeChar(this.getCode_unknown(i));
                        }
                    }
                    this._eca.write(writer, false);
                    stream.writeInt32(this._endToken);
                }

                private void read(@Nonnull Reader reader) throws Exception {
                    switch ((EncodingFormat.Enum)((Object)reader.getFormat().toEnum())) {
                        case WTG_0x7: {
                            this.read_0x7(reader);
                            break;
                        }
                        case WTG_0x4: {
                            this.read_0x4(reader);
                        }
                    }
                }

                @Override
                protected void write(@Nonnull Writer writer) throws IOException {
                    switch ((EncodingFormat.Enum)((Object)writer.getFormat().toEnum())) {
                        case WTG_0x7: 
                        case AUTO: {
                            this.write_0x7(writer);
                            break;
                        }
                        case WTG_0x4: {
                            this.write_0x4(writer);
                        }
                    }
                }

                public CodeParam(@Nonnull Reader reader) throws Exception {
                    this.read(reader);
                }
            }

            public static class BoolCodeParam
            extends ECAParam {
                private int _boolexpr_unknownA;
                private int _boolexpr_unknownB;
                private char _boolexpr_unknownC;

                public int getBoolexpr_UnknownA() {
                    return this._boolexpr_unknownA;
                }

                public void setBoolexpr_UnknownA(int val) {
                    this._boolexpr_unknownA = val;
                }

                public int getBoolexpr_UnknownB() {
                    return this._boolexpr_unknownB;
                }

                public void setBoolexpr_UnknownB(int val) {
                    this._boolexpr_unknownB = val;
                }

                public int getBoolexpr_UnknownC() {
                    return this._boolexpr_unknownC;
                }

                public void setBoolexpr_UnknownC(char val) {
                    this._boolexpr_unknownC = val;
                }

                private void read_0x4(@Nonnull Reader reader) throws Exception {
                    Wc3BinInputStream stream = reader.getStream();
                    stream.beginGroup("boolexpr");
                    this._boolexpr_unknownA = stream.readInt32("unknownA");
                    this._boolexpr_unknownB = stream.readInt32("unknownB");
                    this._boolexpr_unknownC = stream.readChar("unknownC").charValue();
                    this._eca = new ECA(reader, false);
                    this._endToken = stream.readInt32("endToken");
                    stream.endGroup();
                }

                private void write_0x4(@Nonnull Writer writer) throws IOException {
                    Wc3BinOutputStream stream = writer.getStream();
                    stream.writeInt32(this._boolexpr_unknownA);
                    stream.writeInt32(this._boolexpr_unknownB);
                    stream.writeChar(this._boolexpr_unknownC);
                    this._eca.write(writer, false);
                    stream.writeInt32(this._endToken);
                }

                private void read_0x7(@Nonnull Reader reader) throws Exception {
                    Wc3BinInputStream stream = reader.getStream();
                    stream.beginGroup("boolexpr");
                    this._boolexpr_unknownA = stream.readInt32("unknownA");
                    this._boolexpr_unknownB = stream.readInt32("unknownB");
                    this._boolexpr_unknownC = stream.readChar("unknownC").charValue();
                    this._eca = new ECA(reader, false);
                    this._endToken = stream.readInt32("endToken");
                    stream.endGroup();
                }

                private void write_0x7(@Nonnull Writer writer) throws IOException {
                    Wc3BinOutputStream stream = writer.getStream();
                    stream.writeInt32(this._boolexpr_unknownA);
                    stream.writeInt32(this._boolexpr_unknownB);
                    stream.writeChar(this._boolexpr_unknownC);
                    this._eca.write(writer, false);
                    stream.writeInt32(this._endToken);
                }

                private void read(@Nonnull Reader reader) throws Exception {
                    switch ((EncodingFormat.Enum)((Object)reader.getFormat().toEnum())) {
                        case WTG_0x7: {
                            this.read_0x7(reader);
                            break;
                        }
                        case WTG_0x4: {
                            this.read_0x4(reader);
                        }
                    }
                }

                @Override
                protected void write(@Nonnull Writer writer) throws IOException {
                    switch ((EncodingFormat.Enum)((Object)writer.getFormat().toEnum())) {
                        case WTG_0x7: 
                        case AUTO: {
                            this.write_0x7(writer);
                            break;
                        }
                        case WTG_0x4: {
                            this.write_0x4(writer);
                        }
                    }
                }

                public BoolCodeParam(@Nonnull Reader reader) throws Exception {
                    this.read(reader);
                }
            }

            public static abstract class ECAParam
            extends Param {
                protected ECA _eca;
                protected int _endToken = 0;

                public ECA getEca() {
                    return this._eca;
                }

                public void setECA(ECA val) {
                    this._eca = val;
                }

                public int getEndToken() {
                    return this._endToken;
                }

                public void setEndToken(int val) {
                    this._endToken = val;
                }
            }

            public static class NormalParam
            extends Param {
                private SpecType _specType;
                private int _beginFunc = 0;

                public SpecType getSpecType() {
                    return this._specType;
                }

                public void setSpecType(@Nonnull SpecType val) {
                    this._specType = val;
                }

                public int getBeginFunc() {
                    return this._beginFunc;
                }

                public void setBeginFunc(int val) {
                    this._beginFunc = val;
                }

                private void read_0x4(@Nonnull Reader reader, boolean hasBranch) throws Exception {
                    Wc3BinInputStream stream = reader.getStream();
                    this._specType = SpecType.valueOf(stream.readInt32("specType"));
                    this._val = stream.readString("val");
                    this._beginFunc = stream.readInt32("beginFunc");
                    if (this._beginFunc > 0) {
                        Func func;
                        this._specType = SpecType.valueOf(stream.readInt32("specType2"));
                        this._val = stream.readString("val2");
                        this._beginFunc = stream.readInt32("beginFunc2");
                        if (this._beginFunc > 0 && (func = reader.getFuncMap().get(this._val.toLowerCase())) != null) {
                            int i = 0;
                            int paramsCount = func.getParams().size();
                            while (paramsCount > 0) {
                                stream.beginGroup(String.format("param%d", i));
                                NormalParam sub = new NormalParam(reader, true);
                                stream.endGroup();
                                this.addParam(sub);
                                --paramsCount;
                                ++i;
                            }
                        }
                    }
                    stream.readInt32("endToken");
                }

                private void write_0x4(@Nonnull Writer writer) throws IOException {
                    Wc3BinOutputStream stream = writer.getStream();
                    stream.writeInt32(this._specType.getVal());
                    stream.writeString(this._val);
                    stream.writeInt32(this._beginFunc);
                    if (this._beginFunc > 0) {
                        stream.writeInt32(this._specType.getVal());
                        stream.writeString(this._val);
                        stream.writeInt32(this._beginFunc);
                        if (this._beginFunc > 0) {
                            for (Param param : this.getParams()) {
                                param.write(writer);
                            }
                        }
                    }
                }

                private void read_0x7(@Nonnull Reader reader, boolean hasBranch) throws Exception {
                    Wc3BinInputStream stream = reader.getStream();
                    this._specType = SpecType.valueOf(stream.readInt32("specType"));
                    this._val = stream.readString("val");
                    this._beginFunc = stream.readInt32("beginFunc");
                    if (this._beginFunc == 1) {
                        stream.beginGroup("beginFunc2");
                        this.setSpecType(SpecType.valueOf(stream.readInt32("specType2")));
                        long pos = stream.getPos();
                        String funcName = stream.readString("funcName2");
                        this.setVal(funcName);
                        Func func = reader.getFuncMap().get(funcName.toLowerCase());
                        this.setBeginFunc(stream.readInt32());
                        if (func != null) {
                            for (int i = 0; i < func.getParams().size(); ++i) {
                                NormalParam sub = null;
                                String subFuncName = func.getParam(i);
                                Func subFunc = reader.getFuncMap().get(funcName.toLowerCase());
                                if (subFunc != null) {
                                    stream.beginGroup(String.format("param%d", i));
                                    switch (subFunc.getType()) {
                                        case BOOLCALL: 
                                        case BOOLEXPR: 
                                        case EVENTCALL: {
                                            break;
                                        }
                                        case CODE: {
                                            break;
                                        }
                                        default: {
                                            sub = new NormalParam(reader, false);
                                        }
                                    }
                                } else {
                                    throw new IOException(String.format("unknown func %s", subFuncName));
                                }
                                stream.endGroup();
                                this.addParam(sub);
                            }
                        } else {
                            stream.endGroup();
                            stream.printLog(System.err);
                            throw new IOException(String.format("unknown func %s at %s (%s)", funcName, pos, String.format("%x", pos)));
                        }
                        stream.readInt32("endToken");
                        stream.endGroup();
                    }
                    stream.readInt32("endToken");
                    if (this._specType == SpecType.VARIABLE && reader.getVarMap().containsKey(this._val) && reader.getVarMap().get(this._val).isArray()) {
                        stream.beginGroup("arrayIndex");
                        NormalParam sub = new NormalParam(reader, false);
                        stream.endGroup();
                        this.addParam(sub);
                    }
                }

                private void write_0x7(@Nonnull Writer writer) throws IOException {
                    Wc3BinOutputStream stream = writer.getStream();
                    stream.writeInt32(this._specType.getVal());
                    stream.writeString(this._val);
                    stream.writeInt32(this._beginFunc);
                    if (this._beginFunc > 0) {
                        stream.writeInt32(this.getSpecType().getVal());
                        stream.writeString(this.getVal());
                        stream.writeInt32(this.getBeginFunc());
                        for (Param param : this.getParams()) {
                            param.write(writer);
                        }
                        stream.writeInt32(0);
                    }
                    stream.writeInt32(0);
                    if (this._specType == SpecType.VARIABLE && writer.getVarMap().containsKey(this._val) && writer.getVarMap().get(this._val).isArray()) {
                        Param param = this.getParams().get(this.getParams().size() - 1);
                        if (param instanceof NormalParam) {
                            param.write(writer);
                        } else {
                            throw new IllegalArgumentException("param " + param + " is not an array index");
                        }
                    }
                }

                private void read(@Nonnull Reader reader, boolean hasBranch) throws Exception {
                    switch ((EncodingFormat.Enum)((Object)reader.getFormat().toEnum())) {
                        case WTG_0x7: {
                            this.read_0x7(reader, hasBranch);
                            break;
                        }
                        case WTG_0x4: {
                            this.read_0x4(reader, hasBranch);
                        }
                    }
                }

                @Override
                protected void write(@Nonnull Writer writer) throws IOException {
                    switch ((EncodingFormat.Enum)((Object)writer.getFormat().toEnum())) {
                        case WTG_0x7: 
                        case AUTO: {
                            this.write_0x7(writer);
                            break;
                        }
                        case WTG_0x4: {
                            this.write_0x4(writer);
                        }
                    }
                }

                public NormalParam(@Nonnull Reader reader, boolean hasBranch) throws Exception {
                    this.read(reader, hasBranch);
                }

                public static class SpecType {
                    private static final Map<Integer, SpecType> _map = new LinkedHashMap<Integer, SpecType>();
                    public static final SpecType PRESET = new SpecType(0);
                    public static final SpecType VARIABLE = new SpecType(1);
                    public static final SpecType FUNCTION = new SpecType(2);
                    public static final SpecType LITERAL = new SpecType(3);
                    private int _val;

                    public int getVal() {
                        return this._val;
                    }

                    private SpecType(int val) {
                        this._val = val;
                        _map.put(val, this);
                    }

                    public static SpecType valueOf(int val) {
                        return _map.get(val);
                    }
                }
            }

            public static abstract class Param {
                protected String _val;
                private final List<Param> _params = new ArrayList<Param>();

                public String getVal() {
                    return this._val;
                }

                public void setVal(String val) {
                    this._val = val;
                }

                @Nonnull
                public List<Param> getParams() {
                    return new ArrayList<Param>(this._params);
                }

                public void addParam(@Nonnull Param val) {
                    this._params.add(val);
                }

                public String toString() {
                    return this.getVal();
                }

                protected abstract void write(@Nonnull Writer var1) throws IOException;
            }

            public static class ECAType {
                private static final Map<Integer, ECAType> _map = new LinkedHashMap<Integer, ECAType>();
                public static final ECAType ACTION = new ECAType(2);
                public static final ECAType CONDITION = new ECAType(1);
                public static final ECAType EVENT = new ECAType(0);
                private int _val;

                public int getVal() {
                    return this._val;
                }

                private ECAType(int val) {
                    this._val = val;
                    _map.put(val, this);
                }

                @Nullable
                public static ECAType valueOf(int val) {
                    return _map.get(val);
                }
            }
        }

        public static class TrigType {
            private static final Map<Integer, TrigType> _map = new LinkedHashMap<Integer, TrigType>();
            public static final TrigType COMMENT = new TrigType(1);
            public static final TrigType NORMAL = new TrigType(0);
            private int _val;

            public int getVal() {
                return this._val;
            }

            private TrigType(int val) {
                this._val = val;
                _map.put(val, this);
            }

            public static TrigType valueOf(int val) {
                return _map.get(val);
            }
        }
    }

    public static class Func {
        public static final Func BOOLCALL = new Func("boolcall");
        public static final Func BOOLEXPR = new Func("boolexpr");
        public static final Func CODE = new Func("code");
        public static final Func EVENTCALL = new Func("eventcall");
        private SpecialType _type = SpecialType.NORMAL;
        private String _cat = null;
        private final List<String> _params = new ArrayList<String>();
        private String _name;

        public SpecialType getType() {
            return this._type;
        }

        public String getCat() {
            return this._cat;
        }

        public void setCat(String val) {
            this._cat = val;
        }

        @Nonnull
        public List<String> getParams() {
            return new ArrayList<String>(this._params);
        }

        public String getParam(int index) {
            return this.getParams().get(index);
        }

        public void addParam(String val) {
            if (val.equals("nothing")) {
                val = null;
            }
            this._params.add(val);
        }

        public String getName() {
            return this._name;
        }

        public String toString() {
            return this.getName();
        }

        public Func(String name) {
            this._name = name;
            LinkedHashMap<String, SpecialType> typeMap = new LinkedHashMap<String, SpecialType>();
            typeMap.put("boolcall", SpecialType.BOOLCALL);
            typeMap.put("boolexpr", SpecialType.BOOLEXPR);
            typeMap.put("eventcall", SpecialType.EVENTCALL);
            typeMap.put("code", SpecialType.CODE);
        }

        public static enum SpecialType {
            NORMAL,
            BOOLCALL,
            BOOLEXPR,
            CODE,
            EVENTCALL;

        }
    }

    public static class FuncCat {
        private File _iconFile;
        private FieldId _id;

        public File getIconFile() {
            return this._iconFile;
        }

        public void setIconFile(File val) {
            this._iconFile = val;
        }

        public FieldId getId() {
            return this._id;
        }

        public FuncCat(@Nonnull FieldId id) {
            this._id = id;
        }
    }
}

