/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc;

import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.app.Bounds;
import net.moonlightflower.wc3libs.dataTypes.app.Coords2DF;
import net.moonlightflower.wc3libs.dataTypes.app.Coords2DI;
import net.moonlightflower.wc3libs.dataTypes.app.FlagsInt;
import net.moonlightflower.wc3libs.misc.Raster;
import net.moonlightflower.wc3libs.misc.Size;
import net.moonlightflower.wc3libs.misc.image.FxImg;
import net.moonlightflower.wc3libs.misc.image.Wc3RasterImg;

public class PathMap
extends Raster<Integer> {
    public static final int CELL_SIZE = 32;

    @Override
    public int getCellSize() {
        return 32;
    }

    @Override
    public void setBoundsByWorld(@Nonnull Bounds val, boolean retainContents, boolean retainContentsByPos) {
        val = val.scale(0.03125);
        this.setBounds(val, retainContents, retainContentsByPos);
    }

    @Override
    public int getIndexByXY(int x, int y) {
        return y * this.getWidth() + x;
    }

    @Override
    public int size() {
        return ((Integer[])this._cells).length;
    }

    @Override
    public void setSize(int cellsCount) {
        this._cells = new Integer[cellsCount];
    }

    @Override
    public Integer get(int index) {
        return ((Integer[])this._cells)[index];
    }

    @Nullable
    public Coords2DI indexToCoords(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return new Coords2DI(index % this.getWidth(), index / this.getWidth());
    }

    private int coordsToIndex(@Nonnull Coords2DI pos) {
        return pos.getY() * this.getWidth() + pos.getX();
    }

    @Override
    public Integer get(@Nonnull Coords2DI pos) {
        return this.get(this.coordsToIndex(pos));
    }

    @Override
    public void set(int index, int val) {
        ((Integer[])this._cells)[index] = val;
    }

    @Override
    public void set(@Nonnull Coords2DI pos, int val) {
        this.set(this.coordsToIndex(pos), val);
    }

    public boolean get(int index, Integer flag) {
        return (this.get(index) & flag) >= flag;
    }

    public void set(int index, Integer flag, boolean val) {
        if (val) {
            this.set(index, this.get(index) | flag);
        } else {
            this.set(index, this.get(index) & ~flag.intValue());
        }
    }

    @Override
    public Coords2DI worldToLocalCoords(@Nonnull Coords2DF pos) {
        int x = (int)(pos.getX().toFloat() - this.getCenterX()) / 32 + this.getWidth() / 2;
        int y = (int)(pos.getY().toFloat() - this.getCenterY()) / 32 + this.getHeight() / 2;
        return new Coords2DI(x, y);
    }

    @Override
    public Integer getByPos(@Nonnull Coords2DF pos) {
        return this.get(this.worldToLocalCoords(pos));
    }

    @Override
    public void setByPos(@Nonnull Coords2DF pos, int val) {
        this.set(this.worldToLocalCoords(pos), val);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size(); ++i) {
            ((Integer[])this._cells)[i] = 0;
        }
    }

    @Override
    public Integer mergeCellVal(@Nonnull Integer oldVal, @Nonnull Integer other) {
        return oldVal | other;
    }

    public void mergeCells(@Nonnull PathMap other) {
        for (int i = 0; i < other.size(); ++i) {
            this.set(i, this.get(i));
        }
    }

    public void mergeCellsByPos(@Nonnull PathMap other, boolean additive) {
        Coords2DF center = this.getCenter();
        Coords2DF otherCenter = other.getCenter();
        Size size = this.getSize();
        Size otherSize = other.getSize();
        int minX = (int)(otherCenter.getX().toFloat() - (float)(otherSize.getWidth() / 2) - (center.getX().toFloat() - (float)(size.getWidth() / 2)));
        int maxX = minX + otherSize.getWidth() - 1;
        int minY = (int)(otherCenter.getY().toFloat() - (float)(otherSize.getHeight() / 2) - (center.getY().toFloat() - (float)(size.getHeight() / 2)));
        int maxY = minY + otherSize.getHeight() - 1;
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                Coords2DI coords = new Coords2DI(x, y);
                if (additive) {
                    this.set(coords, this.get(coords) & other.get(coords));
                    continue;
                }
                this.set(coords, other.get(coords));
            }
        }
    }

    @Override
    public PathMap clone() {
        PathMap other = new PathMap(this.getBounds());
        other.mergeCells(this);
        return other;
    }

    @Nonnull
    public Wc3RasterImg toImg() {
        BufferedImage bufImg = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                bufImg.setRGB(x, y, PathingInt.valueOf(this.get(new Coords2DI(x, this.getHeight() - 1 - y))).getColor().getRGB());
            }
        }
        return new Wc3RasterImg(new FxImg(bufImg));
    }

    public PathMap(@Nonnull Bounds bounds) {
        super(bounds);
        this.setBounds(bounds, false, false);
    }

    public static class PathingInt
    extends FlagsInt {
        static FlagsInt.Flag UNUSED = new FlagsInt.Flag("unused (0)", 0);
        static FlagsInt.Flag UNWALK = new FlagsInt.Flag("nowalk", 1);
        static FlagsInt.Flag UNFLY = new FlagsInt.Flag("nofly", 2);
        static FlagsInt.Flag UNBUILD = new FlagsInt.Flag("nobuild", 3);
        static FlagsInt.Flag UNUSED4 = new FlagsInt.Flag("unused (4)", 4);
        static FlagsInt.Flag BLIGHT = new FlagsInt.Flag("blight", 5);
        static FlagsInt.Flag UNWATER = new FlagsInt.Flag("nowater", 6);
        static FlagsInt.Flag UNKNOWN = new FlagsInt.Flag("unknown", 7);

        @Nonnull
        public Color getColor() {
            int red = this.containsFlag(UNWALK) ? 255 : 0;
            int green = this.containsFlag(UNFLY) ? 255 : 0;
            int blue = this.containsFlag(UNBUILD) ? 255 : 0;
            return new Color(red, green, blue, 255);
        }

        private PathingInt(int val) {
            super(val);
        }

        public static PathingInt valueOf(int val) {
            return new PathingInt(val);
        }

        @Override
        public DataType decode(Object val) {
            return null;
        }

        @Override
        public Object toSLKVal() {
            return null;
        }

        @Override
        public Object toTXTVal() {
            return null;
        }
    }
}

