/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.intermediatelang.interpreter;

import com.google.common.collect.Maps;
import de.peeeq.wurstio.jassinterpreter.InterpreterException;
import de.peeeq.wurstscript.intermediatelang.ILconst;
import de.peeeq.wurstscript.intermediatelang.ILconstArray;
import de.peeeq.wurstscript.jassIm.ImArrayLikeType;
import de.peeeq.wurstscript.jassIm.ImArrayTypeMulti;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImVar;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public abstract class State {
    private final Map<ImVar, ILconst> values = Maps.newLinkedHashMap();
    protected Map<ImVar, ILconstArray> arrayValues = Maps.newLinkedHashMap();

    public void setVal(ImVar v, ILconst val) {
        this.values.put(v, val);
    }

    public @Nullable ILconst getVal(ImVar v) {
        return this.values.get(v);
    }

    protected ILconstArray getArray(ImVar v) {
        return this.arrayValues.computeIfAbsent(v, k -> State.createArrayConstantFromType(v.getType()));
    }

    static ILconstArray createArrayConstantFromType(ImType vType) {
        ImType componentType;
        int size = Integer.MAX_VALUE;
        if (vType instanceof ImArrayLikeType) {
            List<Integer> arraySize;
            componentType = ((ImArrayLikeType)vType).getEntryType();
            if (vType instanceof ImArrayTypeMulti && (arraySize = ((ImArrayTypeMulti)vType).getArraySize()).size() > 0) {
                size = arraySize.get(0);
            }
        } else {
            throw new InterpreterException("Cannot get array for variable of type " + vType);
        }
        ILconstArray r = new ILconstArray(size, componentType::defaultValue);
        return r;
    }

    public void setArrayVal(ImVar v, List<Integer> indexes, ILconst val) {
        ILconstArray ar = this.getArray(v);
        for (int i = 0; i < indexes.size() - 1; ++i) {
            ar = (ILconstArray)ar.get(indexes.get(i));
        }
        ar.set(indexes.get(indexes.size() - 1), val);
    }

    public @Nullable ILconst getArrayVal(ImVar v, List<Integer> indexes) {
        ILconstArray ar = this.getArray(v);
        for (int i = 0; i < indexes.size() - 1; ++i) {
            ar = (ILconstArray)ar.get(indexes.get(i));
        }
        return ar.get(indexes.get(indexes.size() - 1));
    }

    public @Nullable ILconst getVarValue(String varName) {
        for (Map.Entry<ImVar, ILconst> e : this.values.entrySet()) {
            if (!e.getKey().getName().equals(varName)) continue;
            return e.getValue();
        }
        return null;
    }
}

