/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import com.google.common.collect.Ordering;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprNewObject;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.NoSuperConstructorCall;
import de.peeeq.wurstscript.ast.SomeSuperConstructorCall;
import de.peeeq.wurstscript.ast.SuperConstructorCall;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeTypeParam;
import de.peeeq.wurstscript.utils.NotNullList;
import de.peeeq.wurstscript.utils.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;

public abstract class OverloadingResolver<F extends Element, C> {
    abstract int getParameterCount(F var1);

    abstract WurstType getParameterType(F var1, int var2);

    abstract int getArgumentCount(C var1);

    abstract WurstType getArgumentType(C var1, int var2);

    abstract void handleError(List<String> var1);

    Optional<F> resolve(Iterable<F> alternativeFunctions, C caller) {
        int size = Utils.size(alternativeFunctions);
        if (size == 0) {
            return Optional.empty();
        }
        if (size == 1) {
            return Optional.of((Element)Utils.getFirst(alternativeFunctions));
        }
        NotNullList hints = new NotNullList();
        HashMap<Element, Integer> numMatches = new HashMap<Element, Integer>();
        for (Element f2 : alternativeFunctions) {
            int matches = 0;
            for (int i = 0; i < this.getArgumentCount(caller) && i < this.getParameterCount(f2); ++i) {
                if (!(this.getArgumentType(caller, i) instanceof WurstTypeTypeParam && this.getParameterType(f2, i) instanceof WurstTypeTypeParam || this.getArgumentType(caller, i).isSubtypeOf(this.getParameterType(f2, i), f2))) {
                    hints.add("Expected " + this.getParameterType(f2, i) + " as parameter " + i + " ,but found " + this.getArgumentType(caller, i) + ".");
                    continue;
                }
                ++matches;
            }
            numMatches.put(f2, matches);
        }
        List funcs = Ordering.natural().reverse().onResultOf(numMatches::get).sortedCopy(alternativeFunctions);
        int maxMatches = (Integer)numMatches.get(funcs.get(0));
        funcs.removeIf(f -> (Integer)numMatches.get(f) < maxMatches);
        if (funcs.size() == 1) {
            return Optional.of((Element)funcs.get(0));
        }
        List rightNumberOfParams = funcs.stream().filter(f -> this.getParameterCount(f) == this.getArgumentCount(caller)).collect(Collectors.toList());
        if (rightNumberOfParams.size() == 1) {
            return Optional.of((Element)rightNumberOfParams.get(0));
        }
        if (rightNumberOfParams.size() > 1) {
            funcs = rightNumberOfParams;
        }
        String alts = funcs.stream().map(f -> {
            if (f instanceof FunctionDefinition) {
                FunctionDefinition func = (FunctionDefinition)f;
                return "function " + func.getName() + " defined in   line " + func.getSource().getLine();
            }
            return Utils.printElementWithSource(Optional.of(f));
        }).collect(Collectors.joining("\n * "));
        this.handleError(Utils.list("call is ambiguous, there are several alternatives: \n * " + alts));
        return Optional.of((Element)Ordering.natural().onResultOf(this::getParameterCount).max(funcs));
    }

    public static @Nullable ConstructorDef resolveExprNew(List<ConstructorDef> constructors, final ExprNewObject node) {
        return new OverloadingResolver<ConstructorDef, ExprNewObject>(){

            @Override
            int getParameterCount(ConstructorDef f) {
                return f.getParameters().size();
            }

            @Override
            WurstType getParameterType(ConstructorDef f, int i) {
                return ((WParameter)f.getParameters().get(i)).getTyp().attrTyp().dynamic();
            }

            @Override
            int getArgumentCount(ExprNewObject c) {
                return c.getArgs().size();
            }

            @Override
            WurstType getArgumentType(ExprNewObject c, int i) {
                return ((Expr)c.getArgs().get(i)).attrTyp();
            }

            @Override
            void handleError(List<String> hints) {
                node.addError("No suitable constructor found. \n" + Utils.join(hints, ", \n"));
            }
        }.resolve(constructors, node).orElse(null);
    }

    public static @Nullable ConstructorDef resolveSuperCall(List<ConstructorDef> constructors, final ConstructorDef node) {
        return new OverloadingResolver<ConstructorDef, ConstructorDef>(){

            @Override
            int getParameterCount(ConstructorDef f) {
                return f.getParameters().size();
            }

            @Override
            WurstType getParameterType(ConstructorDef f, int i) {
                return ((WParameter)f.getParameters().get(i)).getTyp().attrTyp().dynamic();
            }

            @Override
            int getArgumentCount(ConstructorDef c) {
                return c.getSuperConstructorCall().match(new SuperConstructorCall.Matcher<Integer>(){

                    @Override
                    public Integer case_NoSuperConstructorCall(NoSuperConstructorCall c) {
                        return 0;
                    }

                    @Override
                    public Integer case_SomeSuperConstructorCall(SomeSuperConstructorCall c) {
                        return c.getSuperArgs().size();
                    }
                });
            }

            @Override
            WurstType getArgumentType(ConstructorDef c, int i) {
                SomeSuperConstructorCall sc = (SomeSuperConstructorCall)c.getSuperConstructorCall();
                return ((Expr)sc.getSuperArgs().get(i)).attrTyp();
            }

            @Override
            void handleError(List<String> hints) {
                node.addError("No suitable constructor found. \n" + Utils.join(hints, ", \n"));
            }
        }.resolve(constructors, node).orElse(null);
    }
}

