/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.compilationserver;

import de.peeeq.wurstio.Main;
import de.peeeq.wurstscript.WLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.eclipse.jdt.annotation.Nullable;

public class WurstServer {
    private static final int portNumber = 27425;
    private volatile boolean stopped;
    private Consumer<String> printer = System.out::println;
    private @Nullable ServerSocket serverSocket;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try (ServerSocket serverSocket = new ServerSocket(27425, 1, InetAddress.getLoopbackAddress());){
            this.serverSocket = serverSocket;
            this.println("Server started.");
            while (!this.stopped) {
                this.handleRequest(serverSocket);
                System.gc();
            }
            this.println("Server stopped.");
        }
        catch (IOException e) {
            this.println("Server had a problem: " + e.getMessage());
            WLogger.severe(e);
        }
        finally {
            System.out.println("end start #################");
        }
    }

    public void startInNewThread() {
        new Thread(this::start).start();
    }

    private void println(String string) {
        this.printer.accept(string);
    }

    public void stop() {
        this.stopped = true;
        ServerSocket socket = this.serverSocket;
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleRequest(ServerSocket sock) {
        try (Socket s2 = sock.accept();
             PrintWriter out = new PrintWriter(s2.getOutputStream(), true);
             BufferedReader in = new BufferedReader(new InputStreamReader(s2.getInputStream()));){
            String inputLine;
            this.println("Server accepted compilation request");
            ArrayList<String> args = new ArrayList<String>();
            while ((inputLine = in.readLine()) != null && !inputLine.equals("<<<<")) {
                args.add(inputLine);
            }
            this.println(((Object)args).toString());
            long time = System.currentTimeMillis();
            if (args.contains("-stopServer")) {
                this.stop();
                return;
            }
            this.wurstMain(args);
            this.println("Server finished compilation in " + (System.currentTimeMillis() - time) + "ms");
            out.println("ok");
        }
        catch (SocketTimeoutException s2) {
        }
        catch (IOException e) {
            this.println("Error in server: " + e.getMessage());
            WLogger.severe(e);
        }
    }

    private void wurstMain(List<String> args) {
        String[] array = args.toArray(new String[0]);
        Main.main(array);
    }

    public static void startServer() {
        SwingUtilities.invokeLater(() -> {});
        WurstServer s = new WurstServer();
        s.start();
    }

    public static void main(String[] args) {
        WurstServer.startServer();
    }

    public void setPrinter(Consumer<String> printer) {
        this.printer = printer;
    }
}

