/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.slk.app.terrainArts;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.CliffClass;
import net.moonlightflower.wc3libs.dataTypes.app.CliffId;
import net.moonlightflower.wc3libs.dataTypes.app.TileId;
import net.moonlightflower.wc3libs.dataTypes.app.War3Bool;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.ObjId;
import net.moonlightflower.wc3libs.slk.ObjSLK;
import net.moonlightflower.wc3libs.slk.RawSLK;
import net.moonlightflower.wc3libs.slk.SLK;
import net.moonlightflower.wc3libs.slk.SLKState;

public class CliffSLK
extends ObjSLK<CliffSLK, CliffId, Obj> {
    public static final File GAME_PATH = new File("TerrainArt\\CliffTypes.slk");

    @Override
    @Nonnull
    public Map<CliffId, Obj> getObjs() {
        return this._objs;
    }

    @Override
    public void addObj(@Nonnull Obj val) {
        this._objs.put((CliffId)val.getId(), val);
    }

    @Override
    @Nonnull
    public Obj addObj(@Nonnull CliffId id) {
        if (this._objs.containsKey(id)) {
            return (Obj)this._objs.get(id);
        }
        Obj obj = new Obj(id);
        this.addObj(obj);
        return obj;
    }

    public RawSLK toRawSLK() {
        RawSLK slk = new RawSLK();
        for (Obj obj : this.getObjs().values()) {
            CliffId id = (CliffId)obj.getId();
            Object slkObj = slk.addObj(id);
            ((SLK.Obj)slkObj).merge(obj, true);
        }
        return slk;
    }

    @Override
    protected void read(@Nonnull SLK<?, ? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slk) {
        for (Map.Entry<? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slkEntry : slk.getObjs().entrySet()) {
            ObjId id = slkEntry.getKey();
            SLK.Obj<? extends ObjId> slkObj = slkEntry.getValue();
            Obj obj = new Obj(slkObj);
            this.addObj(obj);
        }
    }

    @Override
    public void read(@Nonnull File file) throws IOException {
        this.read(new RawSLK(file));
    }

    @Override
    public void write(@Nonnull File file) throws IOException {
        this.toRawSLK().write(file);
    }

    public CliffSLK() {
        this.addField(State.OBJ_ID);
        for (State state : State.values(State.class)) {
            this.addField(state);
        }
    }

    @Override
    @Nonnull
    public Obj createObj(@Nonnull ObjId id) {
        return new Obj(CliffId.valueOf(id));
    }

    @Override
    public void merge(@Nonnull CliffSLK other, boolean overwrite) {
    }

    public static class Obj
    extends SLK.Obj<CliffId> {
        private final Map<State, DataType> _stateVals = new LinkedHashMap<State, DataType>();

        @Override
        public Map<State, DataType> getStateVals() {
            return new LinkedHashMap<State, DataType>(this._stateVals);
        }

        @Override
        protected void on_set(@Nonnull FieldId fieldId, @Nullable DataType val) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.put(state, val);
            }
        }

        @Override
        protected void on_remove(@Nonnull FieldId fieldId) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.remove(state);
            }
        }

        @Override
        protected void on_clear() {
            this._stateVals.clear();
        }

        public Path getRampModelDir() {
            return Paths.get(this.get(State.ART_RAMP_MODEL_DIR).toString(), new String[0]);
        }

        public void setRampModelDir(Path val) {
            this.set(State.ART_RAMP_MODEL_DIR, War3String.valueOf(val.toString()));
        }

        public Path getCliffModelDir() {
            return Paths.get(this.get(State.ART_CLIFF_MODEL_DIR).toString(), new String[0]);
        }

        public void setCliffModelDir(Path val) {
            this.set(State.ART_CLIFF_MODEL_DIR, War3String.valueOf(val.toString()));
        }

        public Path getTex() {
            return Paths.get(this.get(State.ART_TEX_DIR).toString(), this.get(State.ART_TEX_FILE).toString());
        }

        public void setTex(Path val) {
            this.set(State.ART_TEX_DIR, War3String.valueOf(val.getParent().toString()));
            this.set(State.ART_TEX_DIR, War3String.valueOf(val.getFileName().toString()));
        }

        public String getName() {
            return this.get(State.EDITOR_NAME).toString();
        }

        public void setName(String val) {
            this.set(State.EDITOR_NAME, War3String.valueOf(val));
        }

        public TileId getGroundTile() {
            return this.get(State.DATA_GROUND_TILE);
        }

        public void setGroundTile(TileId val) {
            this.set(State.DATA_GROUND_TILE, val);
        }

        public TileId getUpperTile() {
            return this.get(State.DATA_UPPER_TILE);
        }

        public void setUpperTile(TileId val) {
            this.set(State.DATA_UPPER_TILE, val);
        }

        public CliffClass getCliffClass() {
            return this.get(State.DATA_CLIFF_CLASS);
        }

        public void setCliffClass(CliffClass val) {
            this.set(State.DATA_CLIFF_CLASS, val);
        }

        public TileId getOldId() {
            return this.get(State.DATA_OLD_ID);
        }

        public void setOldId(TileId val) {
            this.set(State.DATA_OLD_ID, val);
        }

        public <T extends DataType> T get(State<T> state) {
            try {
                return state.tryCastVal(super.get(state));
            }
            catch (DataTypeInfo.CastException castException) {
                return null;
            }
        }

        public <T extends DataType> void set(State<T> state, T val) {
            super.set(state, val);
        }

        public <T extends DataType> void remove(State<T> state) {
            super.set(state, null);
        }

        private void read(SLK.Obj<? extends ObjId> slkObj) {
            this.merge(slkObj, true);
        }

        public Obj(SLK.Obj<? extends ObjId> slkObj) {
            super(CliffId.valueOf(slkObj.getId()));
            this.read(slkObj);
        }

        public Obj(CliffId id) {
            super(id);
            for (State state : State.values(State.class)) {
                this.set((SLKState)state, (DataType)state.getDefVal());
            }
        }

        @Override
        public void reduce() {
        }
    }

    public static class State<T extends DataType>
    extends ObjSLK.State<T> {
        public static final State<CliffId> OBJ_ID = new State<CliffId>("cliffID", CliffId.class);
        public static final State<War3String> ART_CLIFF_MODEL_DIR = new State<War3String>("cliffModelDir", War3String.class);
        public static final State<War3String> ART_RAMP_MODEL_DIR = new State<War3String>("rampModelDir", War3String.class);
        public static final State<War3String> ART_TEX_DIR = new State<War3String>("texDir", War3String.class);
        public static final State<War3String> ART_TEX_FILE = new State<War3String>("texFile", War3String.class);
        public static final State<CliffClass> DATA_CLIFF_CLASS = new State<CliffClass>("cliffClass", CliffClass.class);
        public static final State<TileId> DATA_GROUND_TILE = new State<TileId>("groundTile", TileId.class);
        public static final State<TileId> DATA_OLD_ID = new State<TileId>("oldID", TileId.class);
        public static final State<TileId> DATA_UPPER_TILE = new State<TileId>("upperTile", TileId.class);
        public static final State<War3Bool> EDITOR_IN_BETA = new State<War3Bool>("inBeta", War3Bool.class);
        public static final State<War3String> EDITOR_NAME = new State<War3String>("name", War3String.class);
        public static final State<War3Int> EDITOR_VERSION = new State<War3Int>("version", War3Int.class);

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo, @Nullable T defVal) {
            super(idString, typeInfo, defVal);
        }

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo) {
            super(idString, typeInfo);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type) {
            super(idString, type);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type, @Nullable T defVal) {
            super(idString, type, defVal);
        }
    }
}

