/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc;

import javax.annotation.Nonnull;

public abstract class AsyncTask {
    private final Thread _thread;
    private final FinishedHandler _finishedHandler;

    public abstract void run();

    public abstract void onPostExec();

    public void start() {
        this._thread.setDaemon(true);
        this._thread.setUncaughtExceptionHandler((thread, exception) -> {
            if (exception instanceof FinishedException) {
                this.onPostExec();
            } else {
                exception.printStackTrace();
            }
            this._finishedHandler.finished();
        });
        this._thread.start();
    }

    public AsyncTask(@Nonnull FinishedHandler finishedHandler) {
        this._finishedHandler = finishedHandler;
        this._thread = new Thread(() -> {
            this.run();
            throw new FinishedException();
        });
    }

    public static interface FinishedHandler {
        public void finished();
    }

    public static class FinishedException
    extends RuntimeException {
    }
}

