/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.validation.controlflow;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.LocalVarDef;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.utils.Utils;
import de.peeeq.wurstscript.validation.controlflow.VState;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;

class VarStates {
    final ImmutableMap<LocalVarDef, VState> states;
    final boolean thisDestroyed;

    public VarStates(ImmutableMap<LocalVarDef, VState> states, boolean thisDestroyed) {
        this.states = states;
        this.thisDestroyed = thisDestroyed;
    }

    VarStates merge(VarStates other) {
        ImmutableMap<LocalVarDef, VState> merged = Utils.mergeMaps(this.states, other.states, VState::merge);
        return new VarStates(merged, this.thisDestroyed || other.thisDestroyed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VarStates varStates = (VarStates)o;
        return this.thisDestroyed == varStates.thisDestroyed && Objects.equals(this.states, varStates.states);
    }

    public int hashCode() {
        return Objects.hash(this.states, this.thisDestroyed);
    }

    public static VarStates initial(Set<LocalVarDef> r) {
        ImmutableMap.Builder s = ImmutableMap.builder();
        for (LocalVarDef v : r) {
            s.put((Object)v, (Object)VState.initial);
        }
        return new VarStates((ImmutableMap<LocalVarDef, VState>)s.build(), false);
    }

    public boolean destroyed(NameDef v) {
        VState s = (VState)this.states.get((Object)v);
        return s != null && s.mightBeDestroyed;
    }

    public boolean uninitialized(NameDef v) {
        VState s = (VState)this.states.get((Object)v);
        return s != null && s.mightBeUninitialized;
    }

    public VarStates addRead(LocalVarDef v, Element r) {
        VState s = this.getVarState(v);
        if (s == null) {
            s = VState.initialDefined;
        }
        s = s.addRead(r);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry e : this.states.entrySet()) {
            if (e.getKey() == v) continue;
            builder.put(e);
        }
        ImmutableMap rs = builder.put((Object)v, (Object)s).build();
        return new VarStates((ImmutableMap<LocalVarDef, VState>)rs, this.thisDestroyed);
    }

    public ImmutableSet<WStatement> getUnreadWrites(NameDef var) {
        ImmutableSet.Builder res = ImmutableSet.builder();
        VState vState = (VState)this.states.get((Object)var);
        if (vState == null) {
            return ImmutableSet.of();
        }
        for (WStatement wr : vState.allWrites) {
            if (!vState.writesAndReads.get((Object)wr).isEmpty()) continue;
            res.add((Object)wr);
        }
        return res.build();
    }

    public VarStates addWrite(LocalVarDef var, WStatement s) {
        ImmutableMap.Builder res = ImmutableMap.builder();
        for (Map.Entry e : this.states.entrySet()) {
            if (e.getKey() == var) continue;
            res.put(e);
        }
        VState vState = this.getVarState(var);
        if (vState == null) {
            vState = VState.initialDefined;
        }
        vState = vState.addWrite(s);
        res.put((Object)var, (Object)vState);
        return new VarStates((ImmutableMap<LocalVarDef, VState>)res.build(), this.thisDestroyed);
    }

    public VarStates addDestroy(LocalVarDef var) {
        ImmutableMap.Builder res = ImmutableMap.builder();
        for (Map.Entry e : this.states.entrySet()) {
            if (e.getKey() == var) continue;
            res.put(e);
        }
        res.put((Object)var, (Object)VState.destroyed);
        return new VarStates((ImmutableMap<LocalVarDef, VState>)res.build(), this.thisDestroyed);
    }

    private @Nullable VState getVarState(LocalVarDef var) {
        return (VState)this.states.get((Object)var);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VarStates [");
        for (Map.Entry e : this.states.entrySet()) {
            sb.append("\n\t");
            sb.append(((LocalVarDef)e.getKey()).getName()).append(" -> ").append(e.getValue());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isThisDestroyed() {
        return this.thisDestroyed;
    }

    public VarStates withThisDestroyed(boolean thisDestroyed) {
        return new VarStates(this.states, thisDestroyed);
    }
}

