/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.jassprinter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.peeeq.wurstscript.jassAst.Element;
import de.peeeq.wurstscript.jassAst.JassArrayVar;
import de.peeeq.wurstscript.jassAst.JassFunction;
import de.peeeq.wurstscript.jassAst.JassFunctions;
import de.peeeq.wurstscript.jassAst.JassInitializedVar;
import de.peeeq.wurstscript.jassAst.JassNative;
import de.peeeq.wurstscript.jassAst.JassNatives;
import de.peeeq.wurstscript.jassAst.JassOp;
import de.peeeq.wurstscript.jassAst.JassOpAnd;
import de.peeeq.wurstscript.jassAst.JassOpDiv;
import de.peeeq.wurstscript.jassAst.JassOpEquals;
import de.peeeq.wurstscript.jassAst.JassOpGreater;
import de.peeeq.wurstscript.jassAst.JassOpGreaterEq;
import de.peeeq.wurstscript.jassAst.JassOpLess;
import de.peeeq.wurstscript.jassAst.JassOpLessEq;
import de.peeeq.wurstscript.jassAst.JassOpMinus;
import de.peeeq.wurstscript.jassAst.JassOpMult;
import de.peeeq.wurstscript.jassAst.JassOpNot;
import de.peeeq.wurstscript.jassAst.JassOpOr;
import de.peeeq.wurstscript.jassAst.JassOpPlus;
import de.peeeq.wurstscript.jassAst.JassOpUnequals;
import de.peeeq.wurstscript.jassAst.JassProg;
import de.peeeq.wurstscript.jassAst.JassSimpleVar;
import de.peeeq.wurstscript.jassAst.JassSimpleVars;
import de.peeeq.wurstscript.jassAst.JassStatement;
import de.peeeq.wurstscript.jassAst.JassStmtSet;
import de.peeeq.wurstscript.jassAst.JassTypeDef;
import de.peeeq.wurstscript.jassAst.JassTypeDefs;
import de.peeeq.wurstscript.jassAst.JassVar;
import de.peeeq.wurstscript.jassAst.JassVars;
import de.peeeq.wurstscript.utils.Utils;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class JassPrinter {
    public static final String WURST_COMMENT_RAW = "// this script was compiled with wurst ";
    public static final String WURST_COMMENT = "// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367";
    private final boolean withSpace;
    private final JassProg prog;

    public JassPrinter(boolean withSpace, JassProg prog) {
        this.withSpace = withSpace;
        this.prog = prog;
    }

    public void printProg(StringBuilder sb) {
        Preconditions.checkNotNull((Object)sb);
        Preconditions.checkNotNull((Object)this.prog);
        sb.append("// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367\n");
        this.printTypes(sb, this.prog.getDefs());
        this.printGlobals(sb, this.prog.getGlobals());
        this.printNatives(sb, this.prog.getNatives());
        this.printFunctions(sb, this.prog.getFunctions());
    }

    private String additionalNewline() {
        return this.withSpace ? "\n" : "";
    }

    static void printIndent(StringBuilder sb, int i, boolean withSpace) {
        if (withSpace) {
            Utils.printIndent(sb, i);
        }
    }

    static String comma(boolean withSpace) {
        return withSpace ? ", " : ",";
    }

    static String assign(boolean withSpace) {
        return withSpace ? " = " : "=";
    }

    private void printGlobals(StringBuilder sb, JassVars globals) {
        sb.append("globals\n");
        for (JassVar g : globals) {
            this.printJassGlobalVar(sb, g);
        }
        sb.append("endglobals\n");
    }

    private void printTypes(StringBuilder sb, JassTypeDefs defs) {
        for (JassTypeDef d : defs) {
            JassPrinter.printTypeDef(d, sb, false);
        }
    }

    private void printNatives(StringBuilder sb, JassNatives natives) {
        for (JassNative n : natives) {
            JassPrinter.printNative(n, sb, false);
        }
    }

    private void printJassGlobalVar(final StringBuilder sb, JassVar g) {
        if (this.prog.attrIgnoredVariables().contains(g)) {
            return;
        }
        g.match(new JassVar.MatcherVoid(){

            @Override
            public void case_JassSimpleVar(JassSimpleVar v) {
                sb.append(v.getType()).append(" ").append(v.getName()).append("\n");
            }

            @Override
            public void case_JassArrayVar(JassArrayVar v) {
                sb.append(v.getType()).append(" array ").append(v.getName()).append("\n");
            }

            @Override
            public void case_JassInitializedVar(JassInitializedVar jassInitializedVar) {
                if (jassInitializedVar.getIsBj()) {
                    if (!JassPrinter.this.withSpace) {
                        return;
                    }
                    sb.append("// ");
                }
                sb.append(jassInitializedVar.getType()).append(" ").append(jassInitializedVar.getName()).append("=");
                jassInitializedVar.getVal().print(sb, JassPrinter.this.withSpace);
                sb.append("\n");
            }
        });
    }

    private void printFunctions(StringBuilder sb, JassFunctions functions) {
        for (JassFunction f : functions) {
            this.printFunction(sb, f);
        }
    }

    private void printFunction(StringBuilder sb, JassFunction f) {
        if (this.prog.attrIgnoredFunctions().contains(f)) {
            return;
        }
        this.printComment(sb, f, 0);
        sb.append("function ");
        sb.append(f.getName());
        sb.append(" takes ");
        if (f.getParams().size() == 0) {
            sb.append("nothing");
        } else {
            sb.append(JassPrinter.printParams(f.getParams(), this.withSpace));
        }
        sb.append(" returns ");
        sb.append(f.getReturnType());
        sb.append("\n");
        LinkedList body = Lists.newLinkedList((Iterable)f.getBody());
        LinkedHashSet locals = Sets.newLinkedHashSet();
        for (JassVar v : f.getLocals()) {
            if (v instanceof JassInitializedVar) {
                JassPrinter.printIndent(sb, 1, this.withSpace);
                sb.append("local ");
                sb.append(v.getType());
                sb.append(" ");
                sb.append(v.getName());
                JassInitializedVar ji = (JassInitializedVar)v;
                sb.append(JassPrinter.assign(this.withSpace));
                ji.getVal().print(sb, this.withSpace);
                sb.append("\n");
                continue;
            }
            locals.add(v);
        }
        while (body.size() > 0 && body.get(0) instanceof JassStmtSet) {
            JassStmtSet set = (JassStmtSet)body.get(0);
            JassVar localVar = null;
            for (JassVar v : locals) {
                if (!set.getLeft().equals(v.getName())) continue;
                localVar = v;
                break;
            }
            if (localVar == null) break;
            JassPrinter.printIndent(sb, 1, this.withSpace);
            sb.append("local ");
            sb.append(localVar.getType());
            sb.append(" ");
            sb.append(localVar.getName());
            sb.append(JassPrinter.assign(this.withSpace));
            set.getRight().print(sb, this.withSpace);
            sb.append("\n");
            locals.remove(localVar);
            body.remove(0);
        }
        for (JassVar v : locals) {
            JassPrinter.printIndent(sb, 1, this.withSpace);
            sb.append("local ");
            sb.append(v.getType());
            if (v instanceof JassArrayVar) {
                sb.append(" array");
            }
            sb.append(" ");
            sb.append(v.getName());
            sb.append("\n");
        }
        JassPrinter.printStatements(sb, 1, body, this.withSpace);
        sb.append("endfunction\n").append(this.additionalNewline());
    }

    private static String printParams(JassSimpleVars params, boolean withSpace) {
        return params.stream().map(v -> v.getType() + " " + v.getName()).collect(Collectors.joining(JassPrinter.comma(withSpace)));
    }

    private void printComment(StringBuilder sb, Element f, int indent) {
        if (this.withSpace && this.prog.attrComments().containsKey(f)) {
            JassPrinter.printIndent(sb, indent, this.withSpace);
            sb.append("// ").append(this.prog.attrComments().get(f)).append("\n");
        }
    }

    static void printStatements(StringBuilder sb, int indent, List<JassStatement> statements, boolean withSpace) {
        for (JassStatement s : statements) {
            JassPrinter.printIndent(sb, indent, withSpace);
            s.print(sb, indent, withSpace);
            sb.append("\n");
        }
    }

    public static int precedence(JassOp op) {
        return op.match(new JassOp.Matcher<Integer>(){

            @Override
            public Integer case_JassOpDiv(JassOpDiv jassOpDiv) {
                return 4;
            }

            @Override
            public Integer case_JassOpLess(JassOpLess jassOpLess) {
                return 2;
            }

            @Override
            public Integer case_JassOpAnd(JassOpAnd jassOpAnd) {
                return 0;
            }

            @Override
            public Integer case_JassOpUnequals(JassOpUnequals jassOpUnequals) {
                return 2;
            }

            @Override
            public Integer case_JassOpGreaterEq(JassOpGreaterEq jassOpGreaterEq) {
                return 2;
            }

            @Override
            public Integer case_JassOpMinus(JassOpMinus jassOpMinus) {
                return 3;
            }

            @Override
            public Integer case_JassOpMult(JassOpMult jassOpMult) {
                return 4;
            }

            @Override
            public Integer case_JassOpGreater(JassOpGreater jassOpGreater) {
                return 2;
            }

            @Override
            public Integer case_JassOpPlus(JassOpPlus jassOpPlus) {
                return 3;
            }

            @Override
            public Integer case_JassOpLessEq(JassOpLessEq jassOpLessEq) {
                return 2;
            }

            @Override
            public Integer case_JassOpOr(JassOpOr jassOpOr) {
                return 1;
            }

            @Override
            public Integer case_JassOpEquals(JassOpEquals jassOpEquals) {
                return 2;
            }

            @Override
            public Integer case_JassOpNot(JassOpNot jassOpNot) {
                return 5;
            }
        });
    }

    public String printProg() {
        StringBuilder sb = new StringBuilder();
        this.printProg(sb);
        return sb.toString();
    }

    public static void printTypeDef(JassTypeDef jassTypeDef, StringBuilder sb, boolean withSpace2) {
        sb.append("type ");
        sb.append(jassTypeDef.getName());
        sb.append(" extends ");
        sb.append(jassTypeDef.getExt());
        sb.append("\n");
    }

    public static void printNative(JassNative jassNative, StringBuilder sb, boolean withSpace) {
        sb.append("native ");
        sb.append(jassNative.getName());
        sb.append(" takes ");
        if (jassNative.getParams().size() == 0) {
            sb.append("nothing");
        } else {
            sb.append(JassPrinter.printParams(jassNative.getParams(), withSpace));
        }
        sb.append(" returns ");
        sb.append(jassNative.getReturnType());
        sb.append("\n");
    }
}

