/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes.names;

import de.peeeq.wurstscript.ast.AstElementWithTypeParameters;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.EnumDef;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.StructureDef;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.attributes.names.Visibility;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.WurstType;
import java.util.List;
import java.util.stream.Stream;

public abstract class NameLink {
    protected final List<TypeParamDef> typeParams;
    private final Visibility visibility;
    private final WScope definedIn;

    public NameLink(Visibility visibility, WScope definedIn, List<TypeParamDef> typeParams) {
        this.visibility = visibility;
        this.definedIn = definedIn;
        this.typeParams = typeParams;
    }

    protected static Stream<TypeParamDef> typeParams(Element scope) {
        if (scope instanceof AstElementWithTypeParameters) {
            return ((AstElementWithTypeParameters)scope).getTypeParameters().stream();
        }
        return Stream.of(new TypeParamDef[0]);
    }

    private static int calcLevel(WScope definedIn) {
        if (definedIn instanceof StructureDef) {
            StructureDef struct = (StructureDef)definedIn;
            return struct.attrLevel();
        }
        return 0;
    }

    protected static Visibility calcVisibility(WScope definedIn, NameDef nameDef) {
        if (definedIn.getParent() instanceof WPackage) {
            if (nameDef.attrIsPublic()) {
                return Visibility.PUBLIC;
            }
            return Visibility.PRIVATE_HERE;
        }
        if (definedIn instanceof StructureDef) {
            if (nameDef.attrIsPrivate()) {
                return Visibility.PRIVATE_HERE;
            }
            if (nameDef.attrIsProtected()) {
                return Visibility.PROTECTED_HERE;
            }
            return Visibility.PUBLIC;
        }
        if (definedIn instanceof TupleDef) {
            return Visibility.PUBLIC;
        }
        if (definedIn instanceof EnumDef) {
            return Visibility.PUBLIC;
        }
        return Visibility.LOCAL;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public abstract String getName();

    public abstract NameDef getDef();

    public WScope getDefinedIn() {
        return this.definedIn;
    }

    public List<TypeParamDef> getTypeParams() {
        return this.typeParams;
    }

    public NameLink hidingPrivate() {
        if (this.visibility == Visibility.PRIVATE_HERE) {
            return this.withVisibility(Visibility.PRIVATE_OTHER);
        }
        return this;
    }

    public NameLink hidingPrivateAndProtected() {
        if (this.visibility == Visibility.PRIVATE_HERE) {
            return this.withVisibility(Visibility.PRIVATE_OTHER);
        }
        if (this.visibility == Visibility.PROTECTED_HERE) {
            return this.withVisibility(Visibility.PROTECTED_OTHER);
        }
        return this;
    }

    public abstract NameLink withVisibility(Visibility var1);

    public int getLevel() {
        return NameLink.calcLevel(this.definedIn);
    }

    public abstract boolean receiverCompatibleWith(WurstType var1, Element var2);

    public abstract NameLink withTypeArgBinding(Element var1, VariableBinding var2);

    public abstract WurstType getTyp();

    public abstract NameLink withDef(NameDef var1);
}

