/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprBinary;
import de.peeeq.wurstscript.ast.ExprIntVal;
import de.peeeq.wurstscript.ast.ExprUnary;
import de.peeeq.wurstscript.ast.ExprVarAccess;
import de.peeeq.wurstscript.ast.GlobalVarDef;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.intermediatelang.ILconst;
import de.peeeq.wurstscript.intermediatelang.ILconstInt;

public class AttrConstantValue {
    public static ILconst calculate(Expr e) {
        throw new ConstantValueCalculationException(e.toString());
    }

    public static ILconst calculate(ExprIntVal e) {
        return new ILconstInt(e.getValI());
    }

    public static ILconst calculate(ExprVarAccess e) {
        GlobalVarDef g;
        NameLink v = e.attrNameLink();
        if (v != null && v.getDef() instanceof GlobalVarDef && (g = (GlobalVarDef)v.getDef()).attrIsConstant() && g.getInitialExpr() instanceof Expr) {
            Expr initial = (Expr)g.getInitialExpr();
            return initial.attrConstantValue();
        }
        throw new ConstantValueCalculationException(e.toString());
    }

    public static ILconst calculate(ExprBinary e) {
        WurstOperator op = e.getOp();
        return op.evaluateBinaryOperator(e.getLeft().attrConstantValue(), () -> e.getRight().attrConstantValue());
    }

    public static ILconst calculate(ExprUnary e) {
        WurstOperator op = e.getOpU();
        return op.evaluateUnaryOperator(e.getRight().attrConstantValue());
    }

    public static class ConstantValueCalculationException
    extends RuntimeException {
        public ConstantValueCalculationException(String msg) {
            super(msg);
        }
    }
}

