/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.types;

import com.google.common.collect.ImmutableList;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NoTypeExpr;
import de.peeeq.wurstscript.ast.OptTypeExpr;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.jassIm.ImExprOpt;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.VariablePosition;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeBoundTypeParam;
import de.peeeq.wurstscript.types.WurstTypeClassOrInterface;
import de.peeeq.wurstscript.types.WurstTypeInterface;
import de.peeeq.wurstscript.types.WurstTypeModuleInstanciation;
import io.vavr.control.Option;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public class WurstTypeClass
extends WurstTypeClassOrInterface {
    private final ClassDef classDef;

    public WurstTypeClass(ClassDef classDef, List<WurstTypeBoundTypeParam> typeParameters, boolean staticRef) {
        super(typeParameters, staticRef);
        if (classDef == null) {
            throw new IllegalArgumentException();
        }
        this.classDef = classDef;
    }

    @Override
    VariableBinding matchAgainstSupertypeIntern(WurstType obj, @Nullable Element location, VariableBinding mapping, VariablePosition variablePosition) {
        WurstTypeModuleInstanciation mi;
        ClassDef nearestClass;
        VariableBinding superMapping = super.matchAgainstSupertypeIntern(obj, location, mapping, variablePosition);
        if (superMapping != null) {
            return superMapping;
        }
        if (obj instanceof WurstTypeModuleInstanciation && (nearestClass = (mi = (WurstTypeModuleInstanciation)obj).getDef().attrNearestClassDef()) == this.classDef) {
            return this.extendMapping(mapping, this.getTypeArgBinding(), location);
        }
        return null;
    }

    private VariableBinding extendMapping(VariableBinding m1, VariableBinding m2, Element location) {
        for (TypeParamDef t : m2.keys()) {
            Option<WurstTypeBoundTypeParam> currentVal = m1.get(t);
            WurstTypeBoundTypeParam m2Val = (WurstTypeBoundTypeParam)m2.get(t).get();
            if (currentVal.isDefined()) {
                WurstTypeBoundTypeParam m1Val = (WurstTypeBoundTypeParam)currentVal.get();
                if (m1Val.equalsType(m2Val, location)) continue;
                return null;
            }
            m1 = m1.set(t, m2Val);
        }
        return m1;
    }

    public ImmutableList<WurstTypeInterface> implementedInterfaces() {
        this.classDef.getImplementsList().forEach(i -> {
            if (!(i.attrTyp() instanceof WurstTypeInterface)) {
                @Nullable NameDef nameDef = i.tryGetNameDef();
                if (nameDef != null) {
                    i.addError("<" + nameDef.getName() + "> is not an interface.");
                } else {
                    this.classDef.getNameId().addError("Expecting interface name after `implements`");
                }
            }
        });
        return (ImmutableList)this.classDef.getImplementsList().stream().filter(i -> i != null && i.attrTyp() instanceof WurstTypeInterface).map(i -> (WurstTypeInterface)i.attrTyp().setTypeArgs(this.getTypeArgBinding())).filter(i -> i.level() < this.level()).collect(ImmutableList.toImmutableList());
    }

    public @Nullable WurstTypeClass extendedClass() {
        OptTypeExpr extendedClass = this.classDef.getExtendedClass();
        if (extendedClass instanceof NoTypeExpr) {
            return null;
        }
        WurstType t = extendedClass.attrTyp();
        if (t instanceof WurstTypeClass) {
            WurstTypeClass ct = (WurstTypeClass)t;
            if (ct.level() >= this.level()) {
                return null;
            }
            return (WurstTypeClass)ct.setTypeArgs(this.getTypeArgBinding());
        }
        return null;
    }

    @Override
    public ClassDef getDef() {
        return this.classDef;
    }

    @Override
    public ImmutableList<? extends WurstTypeClassOrInterface> directSupertypes() {
        WurstTypeClass ec = this.extendedClass();
        if (ec == null) {
            return this.implementedInterfaces();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)ec);
        builder.addAll(this.implementedInterfaces());
        return builder.build();
    }

    public ClassDef getClassDef() {
        return this.classDef;
    }

    @Override
    public String getName() {
        return this.getDef().getName() + this.printTypeParams();
    }

    @Override
    public WurstType dynamic() {
        return new WurstTypeClass(this.getClassDef(), this.getTypeParameters(), false);
    }

    @Override
    public WurstType replaceTypeVars(List<WurstTypeBoundTypeParam> newTypes) {
        return new WurstTypeClass(this.classDef, newTypes, this.isStaticRef());
    }

    @Override
    public ImExprOpt getDefaultValue(ImTranslator tr) {
        return JassIm.ImIntVal(0);
    }

    public @Nullable TypeDef lookupInnerType(String typeName) {
        return this.getDef().getInnerClasses().stream().filter(ic -> ic.getName().equals(typeName)).findFirst().orElse(null);
    }
}

