/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.intermediatelang.optimizer;

import de.peeeq.wurstscript.intermediatelang.optimizer.SideEffectAnalyzer;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImIf;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.translation.imoptimizer.OptimizerPass;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import java.util.ListIterator;

public class BranchMerger
implements OptimizerPass {
    private SideEffectAnalyzer sideEffectAnalyzer;
    public int branchesMerged = 0;

    @Override
    public int optimize(ImTranslator trans) {
        this.branchesMerged = 0;
        ImProg prog = trans.getImProg();
        this.sideEffectAnalyzer = new SideEffectAnalyzer(prog);
        for (ImFunction func : prog.getFunctions()) {
            this.optimizeFunc(func);
        }
        return this.branchesMerged;
    }

    private void optimizeFunc(ImFunction func) {
        this.mergeBranches(func);
    }

    private void mergeBranches(ImFunction func) {
        func.getBody().accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImStmts stmts) {
                ListIterator it = stmts.listIterator();
                while (it.hasNext()) {
                    ImStmt s = (ImStmt)it.next();
                    if (s instanceof ImIf) {
                        ImStmt firstStmtElse;
                        ImStmt firstStmtThen;
                        ImIf ifStmt = (ImIf)s;
                        ifStmt.getThenBlock().accept(this);
                        ifStmt.getElseBlock().accept(this);
                        while (!ifStmt.getThenBlock().isEmpty() && !ifStmt.getElseBlock().isEmpty() && (firstStmtThen = (ImStmt)ifStmt.getThenBlock().get(0)).structuralEquals(firstStmtElse = (ImStmt)ifStmt.getElseBlock().get(0)) && !BranchMerger.this.sideEffectAnalyzer.mightAffect(firstStmtThen, ifStmt.getCondition())) {
                            ifStmt.getThenBlock().remove(0);
                            ifStmt.getElseBlock().remove(0);
                            it.previous();
                            it.add(firstStmtThen);
                            it.next();
                            ++BranchMerger.this.branchesMerged;
                        }
                        continue;
                    }
                    s.accept(this);
                }
            }
        });
    }

    @Override
    public String getName() {
        return "Branches merged";
    }
}

