/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.slk.app.doodads;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataList;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.DoodId;
import net.moonlightflower.wc3libs.dataTypes.app.DoodadClass;
import net.moonlightflower.wc3libs.dataTypes.app.Model;
import net.moonlightflower.wc3libs.dataTypes.app.PathingTex;
import net.moonlightflower.wc3libs.dataTypes.app.SoundLabel;
import net.moonlightflower.wc3libs.dataTypes.app.Tileset;
import net.moonlightflower.wc3libs.dataTypes.app.War3Bool;
import net.moonlightflower.wc3libs.dataTypes.app.War3Char;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.ObjId;
import net.moonlightflower.wc3libs.slk.ObjSLK;
import net.moonlightflower.wc3libs.slk.SLK;
import net.moonlightflower.wc3libs.slk.SLKState;

public class DoodSLK
extends ObjSLK<DoodSLK, DoodId, Obj> {
    public static final File GAME_PATH = new File("Doodads\\Doodads.slk");

    @Override
    @Nonnull
    public Map<DoodId, Obj> getObjs() {
        return this._objs;
    }

    @Override
    public void addObj(@Nonnull Obj val) {
        this._objs.put((DoodId)val.getId(), val);
    }

    @Override
    @Nonnull
    public Obj addObj(@Nonnull DoodId id) {
        if (this._objs.containsKey(id)) {
            return (Obj)this._objs.get(id);
        }
        Obj obj = new Obj(id);
        this.addObj(obj);
        return obj;
    }

    @Override
    protected void read(@Nonnull SLK<?, ? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slk) {
        for (Map.Entry<? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slkEntry : slk.getObjs().entrySet()) {
            ObjId id = slkEntry.getKey();
            SLK.Obj<? extends ObjId> slkObj = slkEntry.getValue();
            Obj obj = new Obj(slkObj);
            this.addObj(obj);
        }
    }

    @Override
    public void read(@Nonnull File file) throws IOException {
        super.read(file);
    }

    @Override
    public void write(@Nonnull File file) throws IOException {
        super.write(file);
    }

    public DoodSLK(SLK slk) {
        this.read(slk);
    }

    public DoodSLK() {
        this.addField(State.OBJ_ID);
        for (State state : State.values(State.class)) {
            this.addField(state);
        }
    }

    public DoodSLK(File file) throws IOException {
        this();
        this.read(file);
    }

    @Override
    @Nonnull
    public Obj createObj(@Nonnull ObjId id) {
        return new Obj(DoodId.valueOf(id));
    }

    @Override
    public void merge(@Nonnull DoodSLK other, boolean overwrite) {
        for (Map.Entry<DoodId, Obj> objEntry : other.getObjs().entrySet()) {
            DoodId objId = objEntry.getKey();
            Obj otherObj = objEntry.getValue();
            Obj obj = this.addObj(objId);
            obj.merge(otherObj);
        }
    }

    public static class Obj
    extends SLK.Obj<DoodId> {
        private final Map<State, DataType> _stateVals = new LinkedHashMap<State, DataType>();

        @Override
        public Map<State, DataType> getStateVals() {
            return new LinkedHashMap<State, DataType>(this._stateVals);
        }

        @Override
        protected void on_set(@Nonnull FieldId fieldId, @Nullable DataType val) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.put(state, val);
            }
        }

        @Override
        protected void on_remove(@Nonnull FieldId fieldId) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.remove(state);
            }
        }

        @Override
        protected void on_clear() {
            this._stateVals.clear();
        }

        public <T extends DataType> T get(State<T> state) throws DataTypeInfo.CastException {
            if (!super.contains((FieldId)state.getFieldId())) {
                return state.getDefVal();
            }
            return state.tryCastVal(super.get((FieldId)state.getFieldId()));
        }

        public <T extends DataType> void set(State<T> state, T val) {
            super.set((FieldId)state.getFieldId(), (DataType)val);
        }

        private void read(SLK.Obj<? extends ObjId> slkObj) {
            this.merge(slkObj, true);
        }

        public Obj(SLK.Obj<? extends ObjId> slkObj) {
            super(DoodId.valueOf(slkObj.getId()));
            this.read(slkObj);
        }

        public Obj(DoodId id) {
            super(id);
            for (State state : State.values(State.class)) {
                this.set((SLKState)state, (DataType)state.getDefVal());
            }
        }

        @Override
        public void reduce() {
        }
    }

    public static class State<T extends DataType>
    extends ObjSLK.State<T> {
        public static final State<DoodId> OBJ_ID = new State<DoodId>("doodID", DoodId.class);
        public static final State<War3Char> CATEGORY = new State<War3Char>("category", War3Char.class);
        public static final State<DataList<Tileset>> TILESETS = new State("tilesets", new DataTypeInfo((Class<? extends DataType>)DataList.class, (Class<? extends DataType>)Tileset.class));
        public static final State<War3Bool> TILESET_SPECIFIC = new State<War3Bool>("tilesetSpecific", War3Bool.class);
        public static final State<Model> MODEL = new State<Model>("file", Model.class);
        public static final State<War3String> COMMENT = new State<War3String>("comment", War3String.class);
        public static final State<War3String> NAME = new State<War3String>("Name", War3String.class);
        public static final State<DoodadClass> CLASS = new State<DoodadClass>("doodClass", DoodadClass.class);
        public static final State<SoundLabel> SOUND_LOOP = new State<SoundLabel>("soundLoop", SoundLabel.class);
        public static final State<War3Real> SELECTION_SIZE = new State<War3Real>("selSize", War3Real.class);
        public static final State<War3Real> SCALE_DEFAULT = new State<War3Real>("defScale", War3Real.class);
        public static final State<War3Real> SCALE_MIN = new State<War3Real>("minScale", War3Real.class);
        public static final State<War3Real> SCALE_MAX = new State<War3Real>("maxScale", War3Real.class);
        public static final State<War3Bool> CAN_PLACE_RAND_SCALE = new State<War3Bool>("canPlaceRandScale", War3Bool.class);
        public static final State<War3Bool> USE_CLICK_HELPER = new State<War3Bool>("useClickHelper", War3Bool.class);
        public static final State<War3Bool> IGNORE_MODEL_CLICK = new State<War3Bool>("ignoreModelClick", War3Bool.class);
        public static final State<War3Real> PITCH_MAX = new State<War3Real>("maxPitch", War3Real.class);
        public static final State<War3Real> ROLL_MAX = new State<War3Real>("maxRoll", War3Real.class);
        public static final State<War3Real> VISIBLE_RADIUS = new State<War3Real>("visRadius", War3Real.class);
        public static final State<War3Bool> WALKABLE = new State<War3Bool>("walkable", War3Bool.class);
        public static final State<War3Int> NUM_VAR = new State<War3Int>("numVar", War3Int.class);
        public static final State<War3Bool> ON_CLIFFS = new State<War3Bool>("onCliffs", War3Bool.class);
        public static final State<War3Bool> ON_WATER = new State<War3Bool>("onWater", War3Bool.class);
        public static final State<War3Bool> FLOATS = new State<War3Bool>("floats", War3Bool.class);
        public static final State<War3Bool> CASTS_SHADOW = new State<War3Bool>("shadow", War3Bool.class);
        public static final State<War3Bool> SHOW_IN_FOG = new State<War3Bool>("showInFog", War3Bool.class);
        public static final State<War3Bool> ANIM_IN_FOG = new State<War3Bool>("animInFog", War3Bool.class);
        public static final State<War3Real> FIXED_ROT = new State<War3Real>("fixedRot", War3Real.class);
        public static final State<PathingTex> PATH_TEX = new State<PathingTex>("pathTex", PathingTex.class);
        public static final State<War3Bool> SHOW_IN_MINIMAP = new State<War3Bool>("showInMM", War3Bool.class);
        public static final State<War3Bool> USE_MINIMAP_COLOR = new State<War3Bool>("useMMColor", War3Bool.class);
        public static final State<War3Int> MINIMAP_RED = new State<War3Int>("MMRed", War3Int.class);
        public static final State<War3Int> MINIMAP_GREEN = new State<War3Int>("MMGreen", War3Int.class);
        public static final State<War3Int> MINIMAP_BLUE = new State<War3Int>("MMBlue", War3Int.class);
        public static final State<War3Int> COLOR_RED1 = new State<War3Int>("vertR01", War3Int.class);
        public static final State<War3Int> COLOR_GREEN1 = new State<War3Int>("vertG01", War3Int.class);
        public static final State<War3Int> COLOR_BLUE1 = new State<War3Int>("vertB01", War3Int.class);
        public static final State<War3Int> COLOR_RED2 = new State<War3Int>("vertR02", War3Int.class);
        public static final State<War3Int> COLOR_GREEN2 = new State<War3Int>("vertG02", War3Int.class);
        public static final State<War3Int> COLOR_BLUE2 = new State<War3Int>("vertB02", War3Int.class);
        public static final State<War3Int> COLOR_RED3 = new State<War3Int>("vertR03", War3Int.class);
        public static final State<War3Int> COLOR_GREEN3 = new State<War3Int>("vertG03", War3Int.class);
        public static final State<War3Int> COLOR_BLUE3 = new State<War3Int>("vertB03", War3Int.class);
        public static final State<War3Int> COLOR_RED4 = new State<War3Int>("vertR04", War3Int.class);
        public static final State<War3Int> COLOR_GREEN4 = new State<War3Int>("vertG04", War3Int.class);
        public static final State<War3Int> COLOR_BLUE4 = new State<War3Int>("vertB04", War3Int.class);
        public static final State<War3Int> COLOR_RED5 = new State<War3Int>("vertR05", War3Int.class);
        public static final State<War3Int> COLOR_GREEN5 = new State<War3Int>("vertG05", War3Int.class);
        public static final State<War3Int> COLOR_BLUE5 = new State<War3Int>("vertB05", War3Int.class);
        public static final State<War3Int> COLOR_RED6 = new State<War3Int>("vertR06", War3Int.class);
        public static final State<War3Int> COLOR_GREEN6 = new State<War3Int>("vertG06", War3Int.class);
        public static final State<War3Int> COLOR_BLUE6 = new State<War3Int>("vertB06", War3Int.class);
        public static final State<War3Int> COLOR_RED7 = new State<War3Int>("vertR07", War3Int.class);
        public static final State<War3Int> COLOR_GREEN7 = new State<War3Int>("vertG07", War3Int.class);
        public static final State<War3Int> COLOR_BLUE7 = new State<War3Int>("vertB07", War3Int.class);
        public static final State<War3Int> COLOR_RED8 = new State<War3Int>("vertR08", War3Int.class);
        public static final State<War3Int> COLOR_GREEN8 = new State<War3Int>("vertG08", War3Int.class);
        public static final State<War3Int> COLOR_BLUE8 = new State<War3Int>("vertB08", War3Int.class);
        public static final State<War3Int> COLOR_RED9 = new State<War3Int>("vertR09", War3Int.class);
        public static final State<War3Int> COLOR_GREEN9 = new State<War3Int>("vertG09", War3Int.class);
        public static final State<War3Int> COLOR_BLUE9 = new State<War3Int>("vertB09", War3Int.class);
        public static final State<War3Int> COLOR_RED10 = new State<War3Int>("vertR10", War3Int.class);
        public static final State<War3Int> COLOR_GREEN10 = new State<War3Int>("vertG10", War3Int.class);
        public static final State<War3Int> COLOR_BLUE10 = new State<War3Int>("vertB10", War3Int.class);
        public static final State<War3Bool> IN_USER_LIST = new State<War3Bool>("UserList", War3Bool.class);
        public static final State<War3Bool> IN_BETA = new State<War3Bool>("InBeta", War3Bool.class);
        public static final State<War3Int> VERSION = new State<War3Int>("version", War3Int.class);

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo, @Nullable T defVal) {
            super(idString, typeInfo, defVal);
        }

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo) {
            super(idString, typeInfo);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type) {
            super(idString, type);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type, @Nullable T defVal) {
            super(idString, type, defVal);
        }
    }
}

