/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.app.Coords3DF;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.MDXObject;
import net.moonlightflower.wc3libs.misc.model.mdx.Track;
import net.moonlightflower.wc3libs.misc.model.mdx.TrackChunk;

public class Camera
extends MDXObject {
    private long _inclusiveSize = 0L;
    private String _name = "unset";
    private Coords3DF _pos;
    private float _fieldOfView = 0.0f;
    private float _farClippingPlane = 0.0f;
    private float _nearClippingPlane = 0.0f;
    private Coords3DF _targetPos;
    private final LinkedHashSet<Chunk> _chunks = new ObservableLinkedHashSet<Chunk>();
    private final LinkedHashSet<TranslationTrackChunk> _translationTrackChunks = new ObservableLinkedHashSet<TranslationTrackChunk>();
    private final LinkedHashSet<RotationTrackChunk> _rotationTrackChunks = new ObservableLinkedHashSet<RotationTrackChunk>();
    private LinkedHashSet<TargetTranslationTrackChunk> _targetTranslationTrackChunks = new ObservableLinkedHashSet<TargetTranslationTrackChunk>();

    public long getInclusiveSize() {
        return this._inclusiveSize;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    public void setName(@Nonnull String name) {
        this._name = name;
    }

    @Nonnull
    public Coords3DF getPos() {
        return this._pos;
    }

    public void setPos(@Nonnull Coords3DF pos) {
        this._pos = pos;
    }

    public float getFieldOfView() {
        return this._fieldOfView;
    }

    public void setFieldOfView(float fieldOfView) {
        this._fieldOfView = fieldOfView;
    }

    public float getFarClippingPlane() {
        return this._farClippingPlane;
    }

    public void setFarClippingPlane(float farClippingPlane) {
        this._farClippingPlane = farClippingPlane;
    }

    public float getNearClippingPlane() {
        return this._nearClippingPlane;
    }

    public void setNearClippingPlane(float nearClippingPlane) {
        this._nearClippingPlane = nearClippingPlane;
    }

    public Coords3DF getTargetPos() {
        return this._targetPos;
    }

    public void setTargetPos(@Nonnull Coords3DF targetPos) {
        this._targetPos = targetPos;
    }

    public LinkedHashSet<Chunk> getChunks() {
        return this._chunks;
    }

    public LinkedHashSet<TranslationTrackChunk> getTranslationTrackChunks() {
        return this._translationTrackChunks;
    }

    public void addTranslationTrackChunk(@Nonnull TranslationTrackChunk val) {
        this._chunks.add(val);
        this._translationTrackChunks.add(val);
    }

    public LinkedHashSet<RotationTrackChunk> getRotationTrackChunks() {
        return this._rotationTrackChunks;
    }

    public void addRotationTrackChunk(@Nonnull RotationTrackChunk val) {
        this._chunks.add(val);
        this._rotationTrackChunks.add(val);
    }

    public LinkedHashSet<TargetTranslationTrackChunk> getTargetTranslationTrackChunks() {
        return this._targetTranslationTrackChunks;
    }

    public void addTargetTranslationTrackChunk(@Nonnull TargetTranslationTrackChunk val) {
        this._chunks.add(val);
        this._targetTranslationTrackChunks.add(val);
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        MDXObject.SizeWriter sizeWriter = new MDXObject.SizeWriter();
        sizeWriter.write(stream);
        stream.writeBytes(Arrays.copyOf(this._name.getBytes(), 80));
        stream.writeFloat32(this._pos.getX());
        stream.writeFloat32(this._pos.getY());
        stream.writeFloat32(this._pos.getZ());
        stream.writeFloat32(this._fieldOfView);
        stream.writeFloat32(this._farClippingPlane);
        stream.writeFloat32(this._nearClippingPlane);
        stream.writeFloat32(this._targetPos.getX());
        stream.writeFloat32(this._targetPos.getY());
        stream.writeFloat32(this._targetPos.getZ());
        for (Chunk chunk : this.getChunks()) {
            chunk.write(stream);
        }
        sizeWriter.rewrite();
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public Camera(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this._inclusiveSize = stream.readUInt32("inclusiveSize");
        this._name = new String(stream.readBytes(80, "name"), StandardCharsets.US_ASCII);
        this._pos = new Coords3DF(stream.readFloat32("x").floatValue(), stream.readFloat32("y").floatValue(), stream.readFloat32("z").floatValue());
        this._fieldOfView = stream.readFloat32("fieldOfView").floatValue();
        this._farClippingPlane = stream.readFloat32("farClippingPlane").floatValue();
        this._nearClippingPlane = stream.readFloat32("nearClippingPlane").floatValue();
        this._targetPos = new Coords3DF(stream.readFloat32("targetX").floatValue(), stream.readFloat32("targetY").floatValue(), stream.readFloat32("targetZ").floatValue());
        LinkedHashMap<Id, MDX.TokenHandler> _tokenMap = new LinkedHashMap<Id, MDX.TokenHandler>();
        _tokenMap.put(TranslationTrackChunk.TOKEN, () -> this.addTranslationTrackChunk(new TranslationTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(RotationTrackChunk.TOKEN, () -> this.addRotationTrackChunk(new RotationTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(TargetTranslationTrackChunk.TOKEN, () -> this.addTargetTranslationTrackChunk(new TargetTranslationTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        while (!stream.eof()) {
            Id trackToken = stream.readId("trackToken");
            stream.rewind(4L);
            if (!_tokenMap.containsKey(trackToken)) break;
            MDX.TokenHandler handler = (MDX.TokenHandler)_tokenMap.get(trackToken);
            handler.run();
        }
    }

    public Camera() {
        this._pos = new Coords3DF(0.0f, 0.0f, 0.0f);
        this._targetPos = new Coords3DF(0.0f, 0.0f, 0.0f);
    }

    public static class TargetTranslationTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KTTR");
        private final LinkedHashSet<TargetTranslationTrack> _targetTranslationTracks = new ObservableLinkedHashSet<TargetTranslationTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._targetTranslationTracks;
        }

        public LinkedHashSet<TargetTranslationTrack> getTargetTranslationTracks() {
            return this._targetTranslationTracks;
        }

        public TargetTranslationTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._targetTranslationTracks.add(new TargetTranslationTrack(stream, this.getInterpolationType(), format));
            }
        }

        public TargetTranslationTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class TargetTranslationTrack
        extends Track {
            private Coords3DF _targetTranslation;
            private Coords3DF _inTan_targetTranslation;
            private Coords3DF _outTan_targetTranslation;

            @Nonnull
            public Coords3DF getTargetTranslation() {
                return this._targetTranslation;
            }

            public void setTargetTranslation(@Nonnull Coords3DF targetTranslation) {
                this._targetTranslation = targetTranslation;
            }

            @Nonnull
            public Coords3DF getInTanTargetTranslation() {
                return this._inTan_targetTranslation;
            }

            public void setInTanTargetTranslation(@Nonnull Coords3DF targetTranslation) {
                this._targetTranslation = targetTranslation;
            }

            @Nonnull
            public Coords3DF getOutTanTargetTranslation() {
                return this._outTan_targetTranslation;
            }

            public void setOutTanTargetTranslation(@Nonnull Coords3DF targetTranslation) {
                this._outTan_targetTranslation = targetTranslation;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._targetTranslation = new Coords3DF(stream.readFloat32("targetTranslationX").floatValue(), stream.readFloat32("targetTranslationY").floatValue(), stream.readFloat32("targetTranslationZ").floatValue());
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_targetTranslation = new Coords3DF(stream.readFloat32("inTan_targetTranslationX").floatValue(), stream.readFloat32("inTan_targetTranslationY").floatValue(), stream.readFloat32("inTan_targetTranslationZ").floatValue());
                    this._outTan_targetTranslation = new Coords3DF(stream.readFloat32("outTan_targetTranslationX").floatValue(), stream.readFloat32("outTan_targetTranslationY").floatValue(), stream.readFloat32("outTan_targetTranslationZ").floatValue());
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._targetTranslation.getX());
                stream.writeFloat32(this._targetTranslation.getY());
                stream.writeFloat32(this._targetTranslation.getZ());
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_targetTranslation.getX());
                    stream.writeFloat32(this._inTan_targetTranslation.getY());
                    stream.writeFloat32(this._inTan_targetTranslation.getZ());
                    stream.writeFloat32(this._outTan_targetTranslation.getX());
                    stream.writeFloat32(this._outTan_targetTranslation.getY());
                    stream.writeFloat32(this._outTan_targetTranslation.getZ());
                }
            }

            public TargetTranslationTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class RotationTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KCRL");
        private final LinkedHashSet<RotationTrack> _rotationTracks = new ObservableLinkedHashSet<RotationTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._rotationTracks;
        }

        public LinkedHashSet<RotationTrack> getRotationTracks() {
            return this._rotationTracks;
        }

        public RotationTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._rotationTracks.add(new RotationTrack(stream, this.getInterpolationType(), format));
            }
        }

        public RotationTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class RotationTrack
        extends Track {
            private long _rotation;
            private long _inTan_rotation;
            private long _outTan_rotation;

            public long getRotation() {
                return this._rotation;
            }

            public void setRotation(long rotation) {
                this._rotation = rotation;
            }

            public long getInTanRotation() {
                return this._inTan_rotation;
            }

            public void setInTanRotation(long rotation) {
                this._rotation = rotation;
            }

            public long getOutTanRotation() {
                return this._outTan_rotation;
            }

            public void setOutTanRotation(long rotation) {
                this._outTan_rotation = rotation;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._rotation = stream.readUInt32("rotation");
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_rotation = stream.readUInt32("inTan_rotation");
                    this._outTan_rotation = stream.readUInt32("outTan_rotation");
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeUInt32(this._rotation);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeUInt32(this._inTan_rotation);
                    stream.writeUInt32(this._outTan_rotation);
                }
            }

            public RotationTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class TranslationTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KCTR");
        private LinkedHashSet<TranslationTrack> _translationTracks = new ObservableLinkedHashSet<TranslationTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._translationTracks;
        }

        public LinkedHashSet<TranslationTrack> getTranslationTracks() {
            return this._translationTracks;
        }

        public TranslationTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._translationTracks.add(new TranslationTrack(stream, this.getInterpolationType(), format));
            }
        }

        public TranslationTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class TranslationTrack
        extends Track {
            private Coords3DF _translation;
            private Coords3DF _inTan_translation;
            private Coords3DF _outTan_translation;

            @Nonnull
            public Coords3DF getTranslation() {
                return this._translation;
            }

            public void setTranslation(@Nonnull Coords3DF translation) {
                this._translation = translation;
            }

            @Nonnull
            public Coords3DF getInTanTranslation() {
                return this._inTan_translation;
            }

            public void setInTanTranslation(@Nonnull Coords3DF translation) {
                this._inTan_translation = translation;
            }

            @Nonnull
            public Coords3DF getOutTanTranslation() {
                return this._outTan_translation;
            }

            public void setOutTanTranslation(@Nonnull Coords3DF translation) {
                this._outTan_translation = translation;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._translation = new Coords3DF(stream.readFloat32("translationX").floatValue(), stream.readFloat32("translationY").floatValue(), stream.readFloat32("translationZ").floatValue());
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_translation = new Coords3DF(stream.readFloat32("inTan_translationX").floatValue(), stream.readFloat32("inTan_translationY").floatValue(), stream.readFloat32("inTan_translationZ").floatValue());
                    this._outTan_translation = new Coords3DF(stream.readFloat32("outTan_translationX").floatValue(), stream.readFloat32("outTan_translationY").floatValue(), stream.readFloat32("outTan_translationZ").floatValue());
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._translation.getX());
                stream.writeFloat32(this._translation.getY());
                stream.writeFloat32(this._translation.getZ());
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_translation.getX());
                    stream.writeFloat32(this._inTan_translation.getY());
                    stream.writeFloat32(this._inTan_translation.getZ());
                    stream.writeFloat32(this._outTan_translation.getX());
                    stream.writeFloat32(this._outTan_translation.getY());
                    stream.writeFloat32(this._outTan_translation.getZ());
                }
            }

            public TranslationTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }
}

