/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.app;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.app.DOO;
import net.moonlightflower.wc3libs.bin.app.DOO_UNITS;
import net.moonlightflower.wc3libs.bin.app.W3C;
import net.moonlightflower.wc3libs.bin.app.W3R;
import net.moonlightflower.wc3libs.dataTypes.app.Bounds;
import net.moonlightflower.wc3libs.dataTypes.app.Color;
import net.moonlightflower.wc3libs.dataTypes.app.SoundLabel;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.dataTypes.app.WeatherId;

public class Placements {
    private DOO _doo;
    private DOO_UNITS _dooUnits;
    private W3C _w3c;
    private W3R _w3r;
    private final List<Rect> _rects = new ArrayList<Rect>();

    public List<Rect> getRects() {
        return new ArrayList<Rect>(this._rects);
    }

    public Rect addRect() {
        Rect rect = new Rect();
        this.getRects().add(rect);
        return rect;
    }

    public W3R encode() {
        W3R enc = new W3R();
        for (Rect rect : this.getRects()) {
            W3R.Rect encRect = enc.addRect();
            encRect.setBounds(rect.getBounds());
            encRect.setColor(rect.getColor());
            encRect.setIndex(rect.getIndex());
            encRect.setName(rect.getName());
            encRect.setSound(rect.getSound());
            encRect.setWeather(rect.getWeather());
        }
        return enc;
    }

    public void decode(@Nonnull W3R enc) {
        for (W3R.Rect encRect : enc.getRects()) {
            Rect rect = this.addRect();
            rect.setBounds(encRect.getBounds());
            rect.setColor(encRect.getColor());
            rect.setName(encRect.getName());
            rect.setSound(encRect.getSound());
            rect.setWeather(encRect.getWeather());
        }
    }

    public Placements(@Nonnull W3R w3r) {
        this._w3r = w3r;
    }

    public Placements() {
        this(new W3R());
    }

    public static class Rect {
        private War3Int _index;
        private Bounds _bounds;
        private War3String _name;
        private WeatherId _weather;
        private SoundLabel _sound;
        private Color _color;

        public War3Int getIndex() {
            return this._index;
        }

        public void setIndex(War3Int val) {
            this._index = val;
        }

        public Bounds getBounds() {
            return this._bounds;
        }

        public void setBounds(Bounds val) {
            this._bounds = val;
        }

        public War3String getName() {
            return this._name;
        }

        public void setName(War3String val) {
            this._name = val;
        }

        public WeatherId getWeather() {
            return this._weather;
        }

        public void setWeather(WeatherId val) {
            this._weather = val;
        }

        public SoundLabel getSound() {
            return this._sound;
        }

        public void setSound(SoundLabel val) {
            this._sound = val;
        }

        public Color getColor() {
            return this._color;
        }

        public void setColor(Color val) {
            this._color = val;
        }

        public Rect() {
            this.setBounds(new Bounds(0, 0, 0, 0));
        }
    }
}

