/*
 * Decompiled with CFR 0.152.
 */
package systems.crigges.jmpq3;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributesFile {
    private final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    private final byte[] file;
    private final int[] crc32;
    private final long[] timestamps;
    private final HashMap<String, Integer> refMap = new HashMap();
    private final CRC32 crcGen = new CRC32();

    public AttributesFile(int entries) {
        this.file = new byte[8 + 12 * entries];
        this.file[0] = 100;
        this.file[4] = 3;
        this.crc32 = new int[entries];
        this.timestamps = new long[entries];
    }

    public AttributesFile(byte[] file) {
        int i;
        this.file = file;
        ByteBuffer buffer = ByteBuffer.wrap(file);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.position(8);
        int fileCount = (file.length - 8) / 12 - 1;
        this.crc32 = new int[fileCount];
        this.timestamps = new long[fileCount];
        for (i = 0; i < fileCount; ++i) {
            this.crc32[i] = buffer.getInt();
        }
        for (i = 0; i < fileCount; ++i) {
            this.timestamps[i] = buffer.getLong();
        }
        this.log.debug("parsed attributes");
    }

    public void setEntry(int i, int crc, long timestamp) {
        this.crc32[i] = crc;
        this.timestamps[i] = timestamp;
    }

    public byte[] buildFile() {
        ByteBuffer buffer = ByteBuffer.wrap(this.file);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.position(8);
        for (int crc : this.crc32) {
            buffer.putInt(crc);
        }
        for (long timestamp : this.timestamps) {
            buffer.putLong(timestamp);
        }
        return buffer.array();
    }

    public int entries() {
        return this.crc32.length;
    }

    public int[] getCrc32() {
        return this.crc32;
    }

    public long[] getTimestamps() {
        return this.timestamps;
    }

    public byte[] getFile() {
        return this.file;
    }

    public void setNames(ArrayList<String> names) {
        int i = 0;
        for (String name : names) {
            this.refMap.put(name, i);
            ++i;
        }
    }

    public int getEntry(String name) {
        return this.refMap.getOrDefault(name, -1);
    }

    private int getCrc32(File file) throws IOException {
        return this.getCrc32(Files.readAllBytes(file.toPath()));
    }

    public int getCrc32(byte[] bytes) {
        this.crcGen.reset();
        this.crcGen.update(bytes);
        return (int)this.crcGen.getValue();
    }
}

