/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.intermediatelang;

import de.peeeq.wurstscript.intermediatelang.ILconst;
import de.peeeq.wurstscript.intermediatelang.ILconstAbstract;
import de.peeeq.wurstscript.intermediatelang.ILconstAddable;
import de.peeeq.wurstscript.intermediatelang.ILconstBool;
import de.peeeq.wurstscript.intermediatelang.ILconstInt;
import de.peeeq.wurstscript.intermediatelang.ILconstNum;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeReal;
import java.util.Objects;

public class ILconstReal
extends ILconstAbstract
implements ILconstNum {
    private final float val;

    public ILconstReal(String numVal) {
        this.val = Float.parseFloat(numVal);
    }

    public ILconstReal(double numVal) {
        this.val = (float)numVal;
    }

    @Override
    public String print() {
        return "" + this.val;
    }

    public WurstType getType() {
        return WurstTypeReal.instance();
    }

    @Override
    public ILconstNum negate() {
        return ILconstReal.create(-this.val);
    }

    static ILconstReal create(float f) {
        return new ILconstReal(f);
    }

    @Override
    public ILconstNum add(ILconstAddable other) {
        if (other instanceof ILconstInt) {
            return ILconstReal.create(this.val + (float)((ILconstInt)other).getVal());
        }
        if (other instanceof ILconstReal) {
            return ILconstReal.create(this.val + ((ILconstReal)other).getVal());
        }
        throw new Error();
    }

    @Override
    public ILconstNum sub(ILconstNum other) {
        if (other instanceof ILconstInt) {
            return ILconstReal.create(this.val - (float)((ILconstInt)other).getVal());
        }
        if (other instanceof ILconstReal) {
            return ILconstReal.create(this.val - ((ILconstReal)other).getVal());
        }
        throw new Error();
    }

    @Override
    public ILconstNum mul(ILconstNum other) {
        if (other instanceof ILconstInt) {
            return ILconstReal.create(this.val * (float)((ILconstInt)other).getVal());
        }
        if (other instanceof ILconstReal) {
            return ILconstReal.create(this.val * ((ILconstReal)other).getVal());
        }
        throw new Error();
    }

    @Override
    public ILconstNum div(ILconstNum other) {
        if (other instanceof ILconstInt) {
            return ILconstReal.create(this.val / (float)((ILconstInt)other).getVal());
        }
        if (other instanceof ILconstReal) {
            return ILconstReal.create(this.val / ((ILconstReal)other).getVal());
        }
        throw new Error();
    }

    public float getVal() {
        return this.val;
    }

    @Override
    public ILconstBool less(ILconstNum other) {
        if (other instanceof ILconstInt) {
            return ILconstBool.instance(this.val < (float)((ILconstInt)other).getVal());
        }
        if (other instanceof ILconstReal) {
            return ILconstBool.instance(this.val < ((ILconstReal)other).getVal());
        }
        throw new Error();
    }

    @Override
    public ILconstBool lessEq(ILconstNum other) {
        if (other instanceof ILconstInt) {
            return ILconstBool.instance(this.val <= (float)((ILconstInt)other).getVal());
        }
        if (other instanceof ILconstReal) {
            return ILconstBool.instance(this.val <= ((ILconstReal)other).getVal());
        }
        throw new Error();
    }

    @Override
    public ILconstBool greater(ILconstNum other) {
        if (other instanceof ILconstInt) {
            return ILconstBool.instance(this.val > (float)((ILconstInt)other).getVal());
        }
        if (other instanceof ILconstReal) {
            return ILconstBool.instance(this.val > ((ILconstReal)other).getVal());
        }
        throw new Error();
    }

    @Override
    public ILconstBool greaterEq(ILconstNum other) {
        if (other instanceof ILconstInt) {
            return ILconstBool.instance(this.val >= (float)((ILconstInt)other).getVal());
        }
        if (other instanceof ILconstReal) {
            return ILconstBool.instance(this.val >= ((ILconstReal)other).getVal());
        }
        throw new Error();
    }

    @Override
    public boolean isEqualTo(ILconst other) {
        if (other instanceof ILconstInt) {
            return this.val == (float)((ILconstInt)other).getVal();
        }
        if (other instanceof ILconstReal) {
            return this.val == ((ILconstReal)other).getVal();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(Float.valueOf(this.val));
    }
}

