/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver.requests;

import de.peeeq.wurstio.languageserver.BufferManager;
import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.requests.GetUsages;
import de.peeeq.wurstio.languageserver.requests.UserRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class RenameRequest
extends UserRequest<WorkspaceEdit> {
    private final RenameParams params;
    private final BufferManager bufferManager;

    public RenameRequest(RenameParams params, BufferManager bufferManager) {
        this.params = params;
        this.bufferManager = bufferManager;
    }

    @Override
    public WorkspaceEdit execute(ModelManager modelManager) {
        TextDocumentPositionParams pos = new TextDocumentPositionParams(this.params.getTextDocument(), this.params.getPosition());
        GetUsages getUsages = new GetUsages(pos, this.bufferManager, true);
        Object usages = getUsages.execute(modelManager);
        ArrayList<Either> edits = new ArrayList<Either>();
        Map<String, List<GetUsages.UsagesData>> usageMap = usages.stream().collect(Collectors.groupingBy(u -> u.getLocation().getUri()));
        for (Map.Entry<String, List<GetUsages.UsagesData>> e : usageMap.entrySet()) {
            String uri = e.getKey();
            VersionedTextDocumentIdentifier textDocument = new VersionedTextDocumentIdentifier();
            textDocument.setUri(uri);
            ArrayList<TextEdit> fileEdits = new ArrayList<TextEdit>();
            for (GetUsages.UsagesData usage : e.getValue()) {
                if (usage.getKind() != DocumentHighlightKind.Read) continue;
                fileEdits.add(new TextEdit(usage.getRange(), this.params.getNewName()));
            }
            edits.add(Either.forLeft((Object)new TextDocumentEdit(textDocument, fileEdits)));
        }
        return new WorkspaceEdit(edits);
    }
}

