/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.misc.ProcCaller;
import net.moonlightflower.wc3libs.port.Orient;

public class WinRegistryHandler {
    public WinRegistryHandler() throws UnsupportedOperationException {
        if (!Orient.isWindowsSystem()) {
            throw new UnsupportedOperationException("not a windows system: " + Orient.getSystem());
        }
    }

    public String get(@Nonnull File dir, @Nonnull String key) throws IOException {
        if (!Orient.isWindowsSystem()) {
            throw new UnsupportedOperationException("not a windows system: " + Orient.getSystem());
        }
        ProcCaller proc = this.getQueryingProcCaller(dir, key);
        proc.exec();
        String result = proc.getOutString();
        result = result.replaceAll("\\p{Cntrl}", "");
        String[] splits = result.split("    ");
        if (splits.length < 4) {
            return null;
        }
        return splits[3];
    }

    public Optional<String> maybeGet(@Nonnull String dirS, @Nonnull String key) {
        try {
            return Optional.ofNullable(this.get(dirS, key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    protected ProcCaller getQueryingProcCaller(@Nonnull File dir, @Nonnull String key) {
        return new ProcCaller("REG", "QUERY", dir.toString(), "/v", key);
    }

    public String get(@Nonnull String dirS, @Nonnull String key) throws IOException {
        return this.get(new File(dirS), key);
    }

    public String get(@Nonnull Entry entry) throws IOException {
        return this.get(entry._dir, entry._key);
    }

    public void set(@Nonnull File dir, @Nonnull String key, @Nonnull EntryType entryType, @Nonnull String val) throws IOException {
        if (!Orient.isWindowsSystem()) {
            throw new UnsupportedOperationException("not a windows system: " + Orient.getSystem());
        }
        ProcCaller proc = this.getUpdatingProcCaller(dir, key, entryType.name(), val);
        proc.exec();
        if (proc.exitVal() != 0) {
            throw new IOException(proc.getErrString());
        }
    }

    protected ProcCaller getUpdatingProcCaller(@Nonnull File dir, @Nonnull String key, @Nonnull String entryTypeName, @Nonnull String val) {
        return new ProcCaller("REG", "ADD", dir.toString(), "/v", key, "/t", entryTypeName, "/d", val, "/f");
    }

    public void set(@Nonnull Entry entry, @Nonnull String val) throws IOException {
        this.set(entry._dir, entry._key, entry._entryType, val);
    }

    public void remove(@Nonnull File dir, @Nonnull String key) throws IOException {
        if (!Orient.isWindowsSystem()) {
            throw new UnsupportedOperationException("not a windows system: " + Orient.getSystem());
        }
        ProcCaller proc = this.getDeletionProcCaller(dir, key);
        proc.exec();
        if (proc.exitVal() != 0) {
            throw new IOException(proc.getErrString());
        }
    }

    protected ProcCaller getDeletionProcCaller(@Nonnull File dir, @Nonnull String key) {
        return new ProcCaller("REG", "DELETE", dir.toString(), "/v", key, "/f");
    }

    public void remove(@Nonnull Entry entry) throws IOException {
        this.remove(entry._dir, entry._key);
    }

    public static class WorldEditEntry
    extends Entry {
        public static final String PREFIX = "HKCU\\Software\\Blizzard Entertainment\\WorldEdit";

        public WorldEditEntry(@Nonnull String key, @Nonnull EntryType entryType) {
            super(PREFIX, key, entryType);
        }
    }

    public static class Wc3LocalMachineEntry
    extends Entry {
        public static final String PREFIX = "HKLM\\Software\\Blizzard Entertainment\\Warcraft III";
        public static final Wc3Entry INSTALL_PATH = new Wc3Entry("InstallPath", EntryType.REG_SZ);
        public static final Wc3Entry INSTALL_PATH_X = new Wc3Entry("InstallPathX", EntryType.REG_SZ);
        public static final Wc3Entry WAR3_INSTALL_PATH = new Wc3Entry("War3InstallPath", EntryType.REG_SZ);

        public Wc3LocalMachineEntry(@Nonnull File dir, @Nonnull String key, @Nonnull EntryType entryType) {
            super(dir, key, entryType);
        }
    }

    public static class Wc3ReforgedEntry
    extends Entry {
        public static final String PREFIX = "HKLM\\Software\\WOW6432Node\\Blizzard Entertainment\\Warcraft III\\Capabilities";
        public static final Wc3Entry APPLICATION_ICON;
        public static final Wc3Entry INSTALL_PATH;

        public Wc3ReforgedEntry(@Nonnull String key, @Nonnull EntryType entryType) {
            super(PREFIX, key, entryType);
        }

        static {
            INSTALL_PATH = APPLICATION_ICON = new Wc3Entry("ApplicationIcon", EntryType.REG_SZ);
        }
    }

    public static class Wc3Entry
    extends Entry {
        public static final String PREFIX = "HKCU\\Software\\Blizzard Entertainment\\Warcraft III";
        public static final Wc3Entry ALLOW_LOCAL_FILES = new Wc3Entry("Allow Local Files", EntryType.REG_SZ);
        public static final Wc3Entry BATTLE_NET_GATEWAYS = new Wc3Entry("Battle.net Gateways", EntryType.REG_MULTI_SZ);
        public static final Wc3Entry INSTALL_PATH = new Wc3Entry("InstallPath", EntryType.REG_SZ);
        public static final Wc3Entry INSTALL_PATH_X = new Wc3Entry("InstallPathX", EntryType.REG_SZ);
        public static final Wc3Entry LOCALE = new Wc3Entry("Locale", EntryType.REG_SZ);
        public static final Wc3Entry MIGRATION_COMPLETE = new Wc3Entry("Migration Complete", EntryType.REG_DWORD);
        public static final Wc3Entry PREFERRED_GAME_VERSION = new Wc3Entry("Preferred Game Version", EntryType.REG_DWORD);
        public static final Wc3Entry PROGRAM = new Wc3Entry("Program", EntryType.REG_SZ);
        public static final Wc3Entry PROGRAM_X = new Wc3Entry("ProgramX", EntryType.REG_SZ);
        public static final Wc3Entry USER_GAME_SAVE_FOLDER = new Wc3Entry("User Game Save Folder", EntryType.REG_SZ);
        public static final Wc3Entry CD = new Wc3Entry("War3CD", EntryType.REG_SZ);
        public static final Wc3Entry CD_X = new Wc3Entry("War3XCD", EntryType.REG_SZ);

        public Wc3Entry(@Nonnull String key, @Nonnull EntryType entryType) {
            super(PREFIX, key, entryType);
        }

        public static class WorldEditEntry
        extends Entry {
            public static final String PREFIX = "HKCU\\Software\\Blizzard Entertainment\\Warcraft III\\WorldEdit";
            public static final WorldEditEntry LAST_OPEN_DIR = new WorldEditEntry("Last Open Directory", EntryType.REG_DWORD);

            public WorldEditEntry(@Nonnull String key, @Nonnull EntryType entryType) {
                super(PREFIX, key, entryType);
            }
        }

        public static class VideoEntry
        extends Entry {
            public static final String PREFIX = "HKCU\\Software\\Blizzard Entertainment\\Warcraft III\\Video";
            public static final VideoEntry ADAPTER = new VideoEntry("adapter", EntryType.REG_DWORD);
            public static final VideoEntry ANIM_QUALITY = new VideoEntry("animquality", EntryType.REG_DWORD);
            public static final VideoEntry CINE_BITS_PER_PIXEL = new VideoEntry("cinematicbpp", EntryType.REG_DWORD);
            public static final VideoEntry CINE_HEIGHT = new VideoEntry("cinematicheight", EntryType.REG_DWORD);
            public static final VideoEntry CINE_OVERRIDES = new VideoEntry("cinematicoverrides", EntryType.REG_DWORD);
            public static final VideoEntry CINE_REFRESH = new VideoEntry("cinematicrefresh", EntryType.REG_DWORD);
            public static final VideoEntry CINE_WIDTH = new VideoEntry("cinematicwidth", EntryType.REG_DWORD);
            public static final VideoEntry COLOR_DEPTH = new VideoEntry("colordepth", EntryType.REG_DWORD);
            public static final VideoEntry FIXED_ASPECT = new VideoEntry("fixedaspect", EntryType.REG_DWORD);
            public static final VideoEntry GAMMA = new VideoEntry("gamma", EntryType.REG_DWORD);
            public static final VideoEntry LIGHTS = new VideoEntry("lights", EntryType.REG_DWORD);
            public static final VideoEntry LOCK_FB = new VideoEntry("lockfb", EntryType.REG_DWORD);
            public static final VideoEntry MAX_FPS = new VideoEntry("maxfps", EntryType.REG_DWORD);
            public static final VideoEntry MIP_LEVEL = new VideoEntry("miplevel", EntryType.REG_DWORD);
            public static final VideoEntry MODEL_DETAIL = new VideoEntry("modeldetail", EntryType.REG_DWORD);
            public static final VideoEntry OCCLUSION = new VideoEntry("occlusion", EntryType.REG_DWORD);
            public static final VideoEntry PARTICLES = new VideoEntry("particles", EntryType.REG_DWORD);
            public static final VideoEntry REFRESH_RATE = new VideoEntry("refreshrate", EntryType.REG_DWORD);
            public static final VideoEntry RES_HEIGHT = new VideoEntry("resheight", EntryType.REG_DWORD);
            public static final VideoEntry RES_WIDTH = new VideoEntry("reswidth", EntryType.REG_DWORD);
            public static final VideoEntry SPELL_FILTER = new VideoEntry("spellfilter", EntryType.REG_DWORD);
            public static final VideoEntry TEX_COLOR_DEPTH = new VideoEntry("texcolordepth", EntryType.REG_DWORD);
            public static final VideoEntry TEX_QUALITY = new VideoEntry("texquality", EntryType.REG_DWORD);
            public static final VideoEntry UNIT_SHADOWS = new VideoEntry("unitshadows", EntryType.REG_DWORD);

            public VideoEntry(@Nonnull String key, @Nonnull EntryType entryType) {
                super(PREFIX, key, entryType);
            }
        }

        public static class StringEntry
        extends Entry {
            public static final String PREFIX = "HKCU\\Software\\Blizzard Entertainment\\Warcraft III\\String";
            public static final StringEntry USER_BNET = new StringEntry("userbnet", EntryType.REG_SZ);
            public static final StringEntry USER_LOCAL = new StringEntry("userlocal", EntryType.REG_SZ);

            public StringEntry(@Nonnull String key, @Nonnull EntryType entryType) {
                super(PREFIX, key, entryType);
            }
        }

        public static class SoundEntry
        extends Entry {
            public static final String PREFIX = "HKCU\\Software\\Blizzard Entertainment\\Warcraft III\\Sound";
            public static final SoundEntry AMBIENT = new SoundEntry("ambient", EntryType.REG_DWORD);
            public static final SoundEntry DO_NOT_USE_WAVE_OUT = new SoundEntry("donotusewaveout", EntryType.REG_DWORD);
            public static final SoundEntry ENV = new SoundEntry("environmental", EntryType.REG_DWORD);
            public static final SoundEntry MOVEMENT = new SoundEntry("movement", EntryType.REG_DWORD);
            public static final SoundEntry MUSIC = new SoundEntry("music", EntryType.REG_DWORD);
            public static final SoundEntry MUSIC_VOLUME = new SoundEntry("musicvolume", EntryType.REG_DWORD);
            public static final SoundEntry NO_MIDI = new SoundEntry("nomidi", EntryType.REG_DWORD);
            public static final SoundEntry NO_SOUND_WARN = new SoundEntry("nosoundwarn", EntryType.REG_DWORD);
            public static final SoundEntry POSITIONAL = new SoundEntry("positional", EntryType.REG_DWORD);
            public static final SoundEntry PROVIDER = new SoundEntry("provider", EntryType.REG_DWORD);
            public static final SoundEntry SFX = new SoundEntry("sfx", EntryType.REG_DWORD);
            public static final SoundEntry SFX_VOLUME = new SoundEntry("sfxvolume", EntryType.REG_DWORD);
            public static final SoundEntry SOFTWARE_MIDI = new SoundEntry("softwaremidi", EntryType.REG_DWORD);
            public static final SoundEntry SUBTITLES = new SoundEntry("subtitles", EntryType.REG_DWORD);
            public static final SoundEntry UNIT = new SoundEntry("unit", EntryType.REG_DWORD);

            public SoundEntry(@Nonnull String key, @Nonnull EntryType entryType) {
                super(PREFIX, key, entryType);
            }
        }

        public static class MiscEntry
        extends Entry {
            public static final String PREFIX = "HKCU\\Software\\Blizzard Entertainment\\Warcraft III\\Misc";
            public static final MiscEntry BATTLE_NET_GATEWAY = new MiscEntry("bnetGateway", EntryType.REG_DWORD);
            public static final MiscEntry CAMPAIGN_PROFILE = new MiscEntry("campaignprofile", EntryType.REG_SZ);
            public static final MiscEntry CHAT_SUPPORT = new MiscEntry("chatsupport", EntryType.REG_DWORD);
            public static final MiscEntry CLICKED_AD = new MiscEntry("clickedad", EntryType.REG_DWORD);
            public static final MiscEntry CLICKED_CLAN = new MiscEntry("clickedclan", EntryType.REG_DWORD);
            public static final MiscEntry CLICKED_LADDER = new MiscEntry("clickedladder", EntryType.REG_DWORD);
            public static final MiscEntry CLICKED_TOURNAMENT = new MiscEntry("clickedtourn", EntryType.REG_DWORD);
            public static final MiscEntry SEEN_INTRO = new MiscEntry("seenintromovie", EntryType.REG_DWORD);

            public MiscEntry(@Nonnull String key, @Nonnull EntryType entryType) {
                super(PREFIX, key, entryType);
            }
        }

        public static class MapEntry
        extends Entry {
            public static final String PREFIX = "HKCU\\Software\\Blizzard Entertainment\\Warcraft III\\Map";
            public static final MapEntry BATTLE_NET_V0 = new MapEntry("battlenet_V0", EntryType.REG_SZ);
            public static final MapEntry BATTLE_NET_V1 = new MapEntry("battlenet_V1", EntryType.REG_SZ);
            public static final MapEntry LAN_V0 = new MapEntry("lan_V0", EntryType.REG_SZ);
            public static final MapEntry LAN_V1 = new MapEntry("lan_V1", EntryType.REG_SZ);
            public static final MapEntry SKIRMISH_V0 = new MapEntry("skirmish_V0", EntryType.REG_SZ);
            public static final MapEntry SKIRMISH_V1 = new MapEntry("skirmish_V1", EntryType.REG_SZ);

            public MapEntry(@Nonnull String key, @Nonnull EntryType entryType) {
                super(PREFIX, key, entryType);
            }
        }

        public static class GameplayEntry
        extends Entry {
            public static final String PREFIX = "HKCU\\Software\\Blizzard Entertainment\\Warcraft III\\Gameplay";
            public static final GameplayEntry ALLY_FILTER = new GameplayEntry("allyFilter", EntryType.REG_DWORD);
            public static final GameplayEntry AMM_MAP_HASHES = new GameplayEntry("ammmaphashes", EntryType.REG_SZ);
            public static final GameplayEntry AMM_MAP_PREFS = new GameplayEntry("ammmapprefs", EntryType.REG_SZ);
            public static final GameplayEntry AMM_RACE = new GameplayEntry("ammrace", EntryType.REG_DWORD);
            public static final GameplayEntry AMM_STYLES = new GameplayEntry("ammstyles", EntryType.REG_SZ);
            public static final GameplayEntry AMM_TYPE = new GameplayEntry("ammtype", EntryType.REG_DWORD);
            public static final GameplayEntry AUTOSAVE_REPLAY = new GameplayEntry("autosaveReplay", EntryType.REG_DWORD);
            public static final GameplayEntry CREEP_FILTER = new GameplayEntry("creepFilter", EntryType.REG_DWORD);
            public static final GameplayEntry CUSTOM_FILTER = new GameplayEntry("customfilter", EntryType.REG_DWORD);
            public static final GameplayEntry CUSTOM_KEYS = new GameplayEntry("customkeys", EntryType.REG_DWORD);
            public static final GameplayEntry CUSTOM_MASK = new GameplayEntry("custommask", EntryType.REG_DWORD);
            public static final GameplayEntry FORMATIONS = new GameplayEntry("formations", EntryType.REG_DWORD);
            public static final GameplayEntry FORMATION_TOGGLE = new GameplayEntry("formationtoggle", EntryType.REG_DWORD);
            public static final GameplayEntry GAME_SPEED = new GameplayEntry("gamespeed", EntryType.REG_DWORD);
            public static final GameplayEntry HEALTH_BARS = new GameplayEntry("healthbars", EntryType.REG_DWORD);
            public static final GameplayEntry HERO_BAR = new GameplayEntry("herobar", EntryType.REG_DWORD);
            public static final GameplayEntry INPUT_SPROCKET = new GameplayEntry("inputsprocket", EntryType.REG_DWORD);
            public static final GameplayEntry KEY_SCROLL = new GameplayEntry("keyscroll", EntryType.REG_DWORD);
            public static final GameplayEntry MOUSE_SCROLL = new GameplayEntry("mousescroll", EntryType.REG_DWORD);
            public static final GameplayEntry MOUSE_SCROLL_DISABLE = new GameplayEntry("mousescrolldisable", EntryType.REG_DWORD);
            public static final GameplayEntry MULTIBOARD_ON = new GameplayEntry("multiboardon", EntryType.REG_DWORD);
            public static final GameplayEntry NET_GAME_PORT = new GameplayEntry("netgameport", EntryType.REG_DWORD);
            public static final GameplayEntry SCHED_RACE = new GameplayEntry("schedrace", EntryType.REG_DWORD);
            public static final GameplayEntry SUB_GROUP_ORDER = new GameplayEntry("subgrouporder", EntryType.REG_DWORD);
            public static final GameplayEntry TERRAIN_FILTER = new GameplayEntry("terrainFilter", EntryType.REG_DWORD);
            public static final GameplayEntry TOOLTIPS = new GameplayEntry("tooltips", EntryType.REG_DWORD);

            public GameplayEntry(@Nonnull String key, @Nonnull EntryType entryType) {
                super(PREFIX, key, entryType);
            }
        }

        public static class DelOpt3Entry
        extends Entry {
            public static final String PREFIX = "HKCU\\Software\\Blizzard Entertainment\\Warcraft III\\DelOpt3";
            public static final DelOpt3Entry FILE_0 = new DelOpt3Entry("File0", EntryType.REG_SZ);
            public static final DelOpt3Entry PATH_0 = new DelOpt3Entry("Path0", EntryType.REG_SZ);

            public DelOpt3Entry(@Nonnull String key, @Nonnull EntryType entryType) {
                super(PREFIX, key, entryType);
            }
        }

        public static class DelOpt2Entry
        extends Entry {
            public static final String PREFIX = "HKCU\\Software\\Blizzard Entertainment\\Warcraft III\\DelOpt2";
            public static final DelOpt2Entry FILE_0 = new DelOpt2Entry("File0", EntryType.REG_SZ);
            public static final DelOpt2Entry FILE_1 = new DelOpt2Entry("File1", EntryType.REG_SZ);
            public static final DelOpt2Entry FILE_2 = new DelOpt2Entry("File2", EntryType.REG_SZ);
            public static final DelOpt2Entry FILE_3 = new DelOpt2Entry("File3", EntryType.REG_SZ);
            public static final DelOpt2Entry PATH_0 = new DelOpt2Entry("Path0", EntryType.REG_SZ);
            public static final DelOpt2Entry PATH_1 = new DelOpt2Entry("Path1", EntryType.REG_SZ);
            public static final DelOpt2Entry PATH_2 = new DelOpt2Entry("Path2", EntryType.REG_SZ);
            public static final DelOpt2Entry PATH_3 = new DelOpt2Entry("Path3", EntryType.REG_SZ);

            public DelOpt2Entry(@Nonnull String key, @Nonnull EntryType entryType) {
                super(PREFIX, key, entryType);
            }
        }

        public static class DelOpt1Entry
        extends Entry {
            public static final String PREFIX = "HKCU\\Software\\Blizzard Entertainment\\Warcraft III\\DelOpt1";
            public static final DelOpt1Entry FILE_0 = new DelOpt1Entry("File0", EntryType.REG_SZ);
            public static final DelOpt1Entry PATH_0 = new DelOpt1Entry("Path0", EntryType.REG_SZ);

            public DelOpt1Entry(@Nonnull String key, @Nonnull EntryType entryType) {
                super(PREFIX, key, entryType);
            }
        }

        public static class DelOpt0Entry
        extends Entry {
            public static final String PREFIX = "HKCU\\Software\\Blizzard Entertainment\\Warcraft III\\DelOpt0";
            public static final DelOpt0Entry FILE_0 = new DelOpt0Entry("File0", EntryType.REG_SZ);
            public static final DelOpt0Entry FILE_1 = new DelOpt0Entry("File1", EntryType.REG_SZ);
            public static final DelOpt0Entry FILE_2 = new DelOpt0Entry("File2", EntryType.REG_SZ);
            public static final DelOpt0Entry PATH_0 = new DelOpt0Entry("Path0", EntryType.REG_SZ);
            public static final DelOpt0Entry PATH_1 = new DelOpt0Entry("Path1", EntryType.REG_SZ);
            public static final DelOpt0Entry PATH_2 = new DelOpt0Entry("Path2", EntryType.REG_SZ);

            public DelOpt0Entry(@Nonnull String key, @Nonnull EntryType entryType) {
                super(PREFIX, key, entryType);
            }
        }
    }

    public static class Entry {
        private final File _dir;
        private final String _key;
        private final EntryType _entryType;

        public Entry(@Nonnull File dir, @Nonnull String key, @Nonnull EntryType entryType) {
            this._dir = dir;
            this._key = key;
            this._entryType = entryType;
        }

        private Entry(@Nonnull String dirS, @Nonnull String key, @Nonnull EntryType entryType) {
            this(new File(dirS), key, entryType);
        }
    }

    public static enum EntryType {
        REG_SZ,
        REG_DWORD,
        REG_MULTI_SZ;

    }
}

