/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WImports;
import de.peeeq.wurstscript.ast.WPackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InitOrder {
    public static ImmutableList<WPackage> initDependencies(WPackage p) {
        LinkedHashSet packages = Sets.newLinkedHashSet();
        packages.addAll(p.attrImportedPackagesTransitive());
        WPackage configPackage = (WPackage)p.getModel().attrConfigOverridePackages().get((Object)p);
        if (configPackage != null) {
            packages.add(configPackage);
        }
        return ImmutableList.copyOf((Collection)packages);
    }

    public static ImmutableList<WPackage> initDependenciesTransitive(WPackage p) {
        ArrayList result = Lists.newArrayList();
        for (WPackage dep : p.attrInitDependencies()) {
            InitOrder.addInitDependenciesTransitive(dep, result);
        }
        return ImmutableList.copyOf((Collection)result);
    }

    private static void addInitDependenciesTransitive(WPackage p, List<WPackage> result) {
        if (result.contains(p)) {
            return;
        }
        result.add(p);
        for (WPackage dep : p.attrInitDependencies()) {
            InitOrder.addInitDependenciesTransitive(dep, result);
        }
    }

    public static ImmutableCollection<WPackage> importedPackagesTrans(WPackage p) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        HashSet reportedErrors = Sets.newHashSet();
        ArrayList callStack = Lists.newArrayList();
        InitOrder.collectImportedPackages(callStack, p, result, reportedErrors, false, false);
        InitOrder.collectImportedPackages(callStack, p, Sets.newLinkedHashSet(), reportedErrors, true, true);
        return ImmutableList.copyOf((Collection)result);
    }

    private static String getCyclicDependencyString(List<WPackage> callStack, WPackage imported) {
        return InitOrder.getCyclicDependencyString(callStack, imported, false);
    }

    private static String getCyclicDependencyString(List<WPackage> callStack, WPackage imported, boolean considerConfig) {
        StringBuilder msg = new StringBuilder();
        HashMap<WPackage, WPackage> configuredPackage = new HashMap<WPackage, WPackage>();
        if (considerConfig) {
            for (WPackage configured : imported.getModel().attrConfigOverridePackages().keySet()) {
                configuredPackage.put((WPackage)imported.getModel().attrConfigOverridePackages().get((Object)configured), configured);
            }
        }
        for (WPackage p : callStack) {
            Object packageString = p.getName();
            if (considerConfig && configuredPackage.containsKey(p)) {
                packageString = ((WPackage)configuredPackage.get(p)).getName() + "/" + (String)packageString;
            }
            msg.append((String)packageString).append(" -> ");
        }
        Object importedString = imported.getName();
        if (considerConfig && configuredPackage.containsKey(imported)) {
            importedString = ((WPackage)configuredPackage.get(imported)).getName() + "/" + (String)importedString;
        }
        return msg + (String)importedString;
    }

    private static String getErrorMsg(List<WPackage> callStack, WPackage imported) {
        String cyclicDependency = InitOrder.getCyclicDependencyString(callStack, imported, false);
        return "Cyclic init dependency between packages: " + cyclicDependency + "\nChange some imports to 'initlater' imports to avoid this problem.";
    }

    private static String getWarningMsg(List<WPackage> callStack, WPackage imported) {
        String cyclicDependency = InitOrder.getCyclicDependencyString(callStack, imported, true);
        return "Cyclic init dependency between packages: " + cyclicDependency + "\nChange some imports to 'initlater' imports to avoid this problem.\nThis will be an error in future Wurst versions.";
    }

    private static void reportCyclicDependency(List<WPackage> callStack, WPackage wPackage, Set<String> reportedErrors, boolean useWarnings) {
        String cyclicString = InitOrder.getCyclicDependencyString(callStack, wPackage);
        String errorMsg = InitOrder.getErrorMsg(callStack, wPackage);
        String warningMsg = InitOrder.getWarningMsg(callStack, wPackage);
        for (WImport imp : wPackage.getImports()) {
            if (callStack.size() <= 1 || imp.attrImportedPackage() != callStack.get(1)) continue;
            if (!reportedErrors.contains(cyclicString)) {
                reportedErrors.add(cyclicString);
                if (useWarnings) {
                    wPackage.addWarning(warningMsg);
                } else {
                    wPackage.addError(errorMsg);
                }
            }
            return;
        }
        if (!reportedErrors.contains(cyclicString)) {
            reportedErrors.add(cyclicString);
            if (useWarnings) {
                wPackage.addWarning(warningMsg);
            } else {
                wPackage.addError(errorMsg);
            }
        }
    }

    private static void addCollectImportedPackage(List<WPackage> callStack, WPackage p, Collection<WPackage> result, WImports imports, Set<String> reportedErrors, boolean considerConfig, boolean useWarnings) {
        for (WImport i : imports) {
            WPackage configPackage;
            WPackage imported = i.attrImportedPackage();
            if (imported == null || i.getIsInitLater() || imported == p) continue;
            if (imported == callStack.get(0)) {
                InitOrder.reportCyclicDependency(callStack, imported, reportedErrors, useWarnings);
                return;
            }
            if (!result.contains(imported)) {
                result.add(imported);
                InitOrder.collectImportedPackages(callStack, imported, result, reportedErrors, considerConfig, useWarnings);
            }
            if (!considerConfig || (configPackage = (WPackage)p.getModel().attrConfigOverridePackages().get((Object)imported)) == null || configPackage == p) continue;
            if (configPackage == callStack.get(0)) {
                InitOrder.reportCyclicDependency(callStack, configPackage, reportedErrors, useWarnings);
                return;
            }
            if (result.contains(configPackage)) continue;
            result.add(configPackage);
            InitOrder.collectImportedPackages(callStack, configPackage, result, reportedErrors, considerConfig, useWarnings);
        }
    }

    private static void collectImportedPackages(List<WPackage> callStack, WPackage p, Collection<WPackage> result, Set<String> reportedErrors, boolean considerConfig, boolean useWarnings) {
        callStack.add(p);
        InitOrder.addCollectImportedPackage(callStack, p, result, p.getImports(), reportedErrors, considerConfig, useWarnings);
        if (considerConfig) {
            for (Map.Entry e : p.getModel().attrConfigOverridePackages().entrySet()) {
                if (!((WPackage)e.getValue()).equals(p)) continue;
                InitOrder.addCollectImportedPackage(callStack, (WPackage)e.getKey(), result, ((WPackage)e.getKey()).getImports(), reportedErrors, considerConfig, useWarnings);
            }
        }
        callStack.remove(callStack.size() - 1);
    }
}

