/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import com.google.common.collect.ImmutableMultimap;
import de.peeeq.wurstscript.ast.Ast;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprThis;
import de.peeeq.wurstscript.ast.FunctionCall;
import de.peeeq.wurstscript.ast.LocalVarDef;
import de.peeeq.wurstscript.ast.Modifier;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NameRef;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.VarDef;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.types.WurstTypeArray;
import java.util.Map;

public class AttrClosureCapturedVariables {
    public static ImmutableMultimap<Element, VarDef> calculate(ExprClosure e) {
        ImmutableMultimap.Builder result = ImmutableMultimap.builder();
        AttrClosureCapturedVariables.collect((ImmutableMultimap.Builder<Element, VarDef>)result, e, e.getImplementation());
        return result.build();
    }

    private static void collect(ImmutableMultimap.Builder<Element, VarDef> result, ExprClosure closure, Element e) {
        if (e instanceof ExprClosure) {
            ExprClosure innerClosure = (ExprClosure)e;
            for (Map.Entry entry : innerClosure.attrCapturedVariables().entries()) {
                VarDef v = (VarDef)entry.getValue();
                if (v.attrNearestExprClosure() == closure) continue;
                result.put((Object)((Element)entry.getKey()), (Object)v);
            }
            return;
        }
        if (e instanceof NameRef) {
            VarDef v;
            NameRef nr = (NameRef)e;
            NameLink def = nr.attrNameLink();
            if (def != null && AttrClosureCapturedVariables.isLocalVariable(def.getDef()) && (v = (VarDef)def.getDef()).attrNearestExprClosure() != closure) {
                result.put((Object)nr, (Object)v);
                if (v.attrTyp() instanceof WurstTypeArray) {
                    nr.addError("Closures cannot capture local array variables.");
                }
            }
            if (nr.attrImplicitParameter() instanceof ExprThis) {
                result.put((Object)nr, (Object)AttrClosureCapturedVariables.dummyThisVar(closure));
            }
        } else if (e instanceof FunctionCall) {
            FunctionCall fc = (FunctionCall)e;
            if (fc.attrImplicitParameter() instanceof ExprThis) {
                result.put((Object)e, (Object)AttrClosureCapturedVariables.dummyThisVar(closure));
            }
        } else if (e instanceof ExprThis) {
            result.put((Object)e, (Object)AttrClosureCapturedVariables.dummyThisVar(closure));
        }
        for (int i = 0; i < e.size(); ++i) {
            AttrClosureCapturedVariables.collect(result, closure, e.get(i));
        }
    }

    private static boolean isLocalVariable(NameDef def) {
        return def instanceof LocalVarDef || def instanceof WParameter && !(def.getParent().getParent() instanceof TupleDef);
    }

    private static LocalVarDef dummyThisVar(ExprClosure closure) {
        return Ast.LocalVarDef(closure.getSource(), Ast.Modifiers(new Modifier[0]), Ast.NoTypeExpr(), Ast.Identifier(closure.getSource(), "this"), Ast.NoExpr());
    }
}

