/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.jassinterpreter.mocks;

import de.peeeq.wurstio.jassinterpreter.InterpreterException;
import de.peeeq.wurstio.jassinterpreter.providers.TimerProvider;
import de.peeeq.wurstscript.intermediatelang.ILconstBool;
import de.peeeq.wurstscript.intermediatelang.ILconstFuncRef;
import de.peeeq.wurstscript.intermediatelang.ILconstReal;
import de.peeeq.wurstscript.intermediatelang.IlConstHandle;
import de.peeeq.wurstscript.intermediatelang.interpreter.AbstractInterpreter;
import de.peeeq.wurstscript.intermediatelang.interpreter.TimerMockHandler;

public class TimerMock {
    private AbstractInterpreter interpreter;
    private TimerMockHandler timerMockHandler;
    private final TimerProvider timerProvider;
    private IlConstHandle timerHandle;
    private TimerMockHandler.RunTask runTask;
    private TimerMockHandler.PausedTask pausedTask;
    private long startedMillis;

    public TimerMock(AbstractInterpreter interpreter, TimerProvider timerProvider) {
        this.interpreter = interpreter;
        this.timerProvider = timerProvider;
        this.timerMockHandler = interpreter.getTimerMockHandler();
    }

    public void start(ILconstReal timeout, ILconstBool periodic, ILconstFuncRef handlerFunc) {
        if (this.runTask != null) {
            this.timerMockHandler.cancelTask(this.runTask);
        }
        this.pausedTask = null;
        this.startedMillis = System.currentTimeMillis();
        TimerMockRunnable toRun = new TimerMockRunnable(handlerFunc, periodic.getVal(), timeout.getVal());
        this.runTask = this.timerMockHandler.registerTimedAction(timeout.getVal(), toRun);
    }

    public void destroy() {
        if (this.runTask != null) {
            this.timerMockHandler.cancelTask(this.runTask);
        }
        this.runTask = null;
        this.pausedTask = null;
        this.interpreter = null;
        this.timerMockHandler = null;
        this.timerHandle = null;
    }

    public void setHandle(IlConstHandle handle) {
        this.timerHandle = handle;
    }

    public void pause() {
        if (this.runTask == null) {
            throw new InterpreterException("Trying to pause a timer that was not started.");
        }
        this.pausedTask = this.timerMockHandler.pauseTask(this.runTask);
        this.runTask = null;
    }

    public void resume() {
        if (this.pausedTask == null) {
            throw new InterpreterException("Trying to resume a timer that was not paused.");
        }
        this.runTask = this.timerMockHandler.resumeTask(this.pausedTask);
        this.pausedTask = null;
    }

    public long getElapsed() {
        return (System.currentTimeMillis() - this.startedMillis) / 1000L;
    }

    public class TimerMockRunnable
    implements Runnable {
        private final ILconstFuncRef handlerFunc;
        private final boolean periodic;
        private final float timeout;
        private boolean cancelled;

        public TimerMockRunnable(ILconstFuncRef handlerFunc, boolean periodic, float timeout) {
            this.handlerFunc = handlerFunc;
            this.periodic = periodic;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            TimerMock.this.timerProvider.setLastExpiredMock(TimerMock.this.timerHandle);
            TimerMock.this.interpreter.runFuncRef(this.handlerFunc, null);
            if (this.periodic) {
                TimerMock.this.timerMockHandler.registerTimedAction(this.timeout, this);
            }
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void resume() {
            this.cancelled = false;
        }
    }
}

