/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import com.google.common.collect.Lists;
import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.ast.ArrayInitializer;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.EndFunctionStatement;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.LocalVarDef;
import de.peeeq.wurstscript.ast.NoDefaultCase;
import de.peeeq.wurstscript.ast.StartFunctionStatement;
import de.peeeq.wurstscript.ast.StmtErr;
import de.peeeq.wurstscript.ast.StmtExitwhen;
import de.peeeq.wurstscript.ast.StmtForFrom;
import de.peeeq.wurstscript.ast.StmtForIn;
import de.peeeq.wurstscript.ast.StmtForRangeDown;
import de.peeeq.wurstscript.ast.StmtForRangeUp;
import de.peeeq.wurstscript.ast.StmtIf;
import de.peeeq.wurstscript.ast.StmtLoop;
import de.peeeq.wurstscript.ast.StmtReturn;
import de.peeeq.wurstscript.ast.StmtSet;
import de.peeeq.wurstscript.ast.StmtSkip;
import de.peeeq.wurstscript.ast.StmtWhile;
import de.peeeq.wurstscript.ast.SwitchCase;
import de.peeeq.wurstscript.ast.SwitchDefaultCaseStatements;
import de.peeeq.wurstscript.ast.SwitchStmt;
import de.peeeq.wurstscript.ast.WBlock;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.ast.WStatements;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImConst;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprs;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImIf;
import de.peeeq.wurstscript.jassIm.ImLExpr;
import de.peeeq.wurstscript.jassIm.ImReturn;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.CallType;
import de.peeeq.wurstscript.translation.imtranslation.ExprTranslation;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.TypesHelper;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeVararg;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class StmtTranslation {
    public static ImStmt translate(Expr s, ImTranslator t, ImFunction f) {
        return s.imTranslateExpr(t, f);
    }

    public static ImStmt translate(LocalVarDef s, ImTranslator t, ImFunction f) {
        ImVar v = t.getVarFor(s);
        f.getLocals().add(v);
        if (s.getInitialExpr() instanceof Expr) {
            Expr inital = (Expr)s.getInitialExpr();
            return JassIm.ImSet(s, JassIm.ImVarAccess(v), inital.imTranslateExpr(t, f));
        }
        if (s.getInitialExpr() instanceof ArrayInitializer) {
            ArrayInitializer ai = (ArrayInitializer)s.getInitialExpr();
            ImStmts stmts = JassIm.ImStmts(new ImStmt[0]);
            for (int i = 0; i < ai.getValues().size(); ++i) {
                Expr expr = (Expr)ai.getValues().get(i);
                ImExpr translatedExpr = expr.imTranslateExpr(t, f);
                stmts.add(JassIm.ImSet(s, JassIm.ImVarArrayAccess(s, v, JassIm.ImExprs(JassIm.ImIntVal(i))), translatedExpr));
            }
            return ImHelper.statementExprVoid(stmts);
        }
        return ImHelper.nullExpr();
    }

    public static ImStmt translate(StmtErr s, ImTranslator t, ImFunction f) {
        throw new CompileError(s.getSource(), "Source contains errors.");
    }

    public static ImStmt translate(StmtExitwhen s, ImTranslator t, ImFunction f) {
        return JassIm.ImExitwhen(s, s.getCond().imTranslateExpr(t, f));
    }

    public static ImStmt translate(StmtForFrom s, ImTranslator t, ImFunction f) {
        Expr iterationTarget = s.getIn();
        WurstType loopVarType = s.getLoopVar().attrTyp();
        ArrayList result = Lists.newArrayList();
        Optional<FuncLink> nextFuncOpt = s.attrGetNextFunc();
        Optional<FuncLink> hasNextFuncOpt = s.attrHasNextFunc();
        if (nextFuncOpt.isPresent() && hasNextFuncOpt.isPresent()) {
            ImExprs fromTarget;
            FuncLink nextFunc = nextFuncOpt.get();
            FuncLink hasNextFunc = hasNextFuncOpt.get();
            ImFunction nextFuncIm = t.getFuncFor(nextFunc.getDef());
            ImFunction hasNextFuncIm = t.getFuncFor(hasNextFunc.getDef());
            f.getLocals().add(t.getVarFor(s.getLoopVar()));
            if (iterationTarget.attrTyp().isStaticRef()) {
                fromTarget = JassIm.ImExprs(new ImExpr[0]);
            } else {
                ImExpr iterationTargetTr = iterationTarget.imTranslateExpr(t, f);
                ImVar fromVar = JassIm.ImVar(s, iterationTargetTr.attrTyp(), "from", false);
                f.getLocals().add(fromVar);
                result.add(JassIm.ImSet(s, JassIm.ImVarAccess(fromVar), iterationTargetTr));
                fromTarget = JassIm.ImExprs(JassIm.ImVarAccess(fromVar));
            }
            ImStmts imBody = JassIm.ImStmts(new ImStmt[0]);
            imBody.add(JassIm.ImExitwhen(s, JassIm.ImOperatorCall(WurstOperator.NOT, JassIm.ImExprs(JassIm.ImFunctionCall(s, hasNextFuncIm, JassIm.ImTypeArguments(new ImTypeArgument[0]), fromTarget, false, CallType.NORMAL)))));
            ImFunctionCall nextCall = JassIm.ImFunctionCall(s, nextFuncIm, JassIm.ImTypeArguments(new ImTypeArgument[0]), fromTarget.copy(), false, CallType.NORMAL);
            WurstType nextReturn = nextFunc.getReturnType();
            ImExpr nextCallWrapped = ExprTranslation.wrapTranslation(s, t, nextCall, nextReturn, loopVarType);
            imBody.add(JassIm.ImSet(s, JassIm.ImVarAccess(t.getVarFor(s.getLoopVar())), nextCallWrapped));
            imBody.addAll(t.translateStatements(f, s.getBody()));
            result.add(JassIm.ImLoop(s, imBody));
        }
        return ImHelper.statementExprVoid(JassIm.ImStmts(result));
    }

    public static ImStmt translate(final StmtForIn forIn, final ImTranslator t, ImFunction f) {
        Expr iterationTarget = forIn.getIn();
        WurstType itrType = iterationTarget.attrTyp();
        if (itrType instanceof WurstTypeVararg) {
            return StmtTranslation.case_StmtForVararg(forIn, t, f);
        }
        ArrayList result = Lists.newArrayList();
        Optional<FuncLink> iteratorFuncOpt = forIn.attrIteratorFunc();
        Optional<FuncLink> nextFuncOpt = forIn.attrGetNextFunc();
        Optional<FuncLink> hasNextFuncOpt = forIn.attrHasNextFunc();
        if (iteratorFuncOpt.isPresent() && nextFuncOpt.isPresent() && hasNextFuncOpt.isPresent()) {
            ImExprs iterationTargetList;
            FuncLink iteratorFunc = iteratorFuncOpt.get();
            FuncLink nextFunc = nextFuncOpt.get();
            FuncLink hasNextFunc = hasNextFuncOpt.get();
            WurstType loopVarType = forIn.getLoopVar().attrTyp();
            ImFunction iteratorFuncIm = t.getFuncFor(iteratorFunc.getDef());
            ImFunction nextFuncIm = t.getFuncFor(nextFunc.getDef());
            ImFunction hasNextFuncIm = t.getFuncFor(hasNextFunc.getDef());
            if (forIn.getIn().attrTyp().isStaticRef()) {
                iterationTargetList = JassIm.ImExprs(new ImExpr[0]);
            } else {
                ImExpr iterationTargetIm = forIn.getIn().imTranslateExpr(t, f);
                iterationTargetList = JassIm.ImExprs(iterationTargetIm);
            }
            ImFunctionCall iteratorCall = JassIm.ImFunctionCall(forIn, iteratorFuncIm, JassIm.ImTypeArguments(new ImTypeArgument[0]), iterationTargetList, false, CallType.NORMAL);
            ImVar iteratorVar = JassIm.ImVar(forIn.getLoopVar(), iteratorCall.attrTyp(), "iterator", false);
            f.getLocals().add(iteratorVar);
            f.getLocals().add(t.getVarFor(forIn.getLoopVar()));
            ImSet setIterator = JassIm.ImSet(forIn, JassIm.ImVarAccess(iteratorVar), iteratorCall);
            result.add(setIterator);
            ImStmts imBody = JassIm.ImStmts(new ImStmt[0]);
            imBody.add(JassIm.ImExitwhen(forIn, JassIm.ImOperatorCall(WurstOperator.NOT, JassIm.ImExprs(JassIm.ImFunctionCall(forIn, hasNextFuncIm, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(JassIm.ImVarAccess(iteratorVar)), false, CallType.NORMAL)))));
            ImFunctionCall nextCall = JassIm.ImFunctionCall(forIn, nextFuncIm, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(JassIm.ImVarAccess(iteratorVar)), false, CallType.NORMAL);
            WurstType nextReturn = nextFunc.getReturnType();
            ImExpr nextCallWrapped = ExprTranslation.wrapTranslation(forIn, t, nextCall, nextReturn, loopVarType);
            imBody.add(JassIm.ImSet(forIn, JassIm.ImVarAccess(t.getVarFor(forIn.getLoopVar())), nextCallWrapped));
            imBody.addAll(t.translateStatements(f, forIn.getBody()));
            Optional<FuncLink> closeFunc = forIn.attrCloseFunc();
            closeFunc.ifPresent(funcLink -> imBody.accept(new Element.DefaultVisitor((FuncLink)funcLink, iteratorVar){
                final /* synthetic */ FuncLink val$funcLink;
                final /* synthetic */ ImVar val$iteratorVar;
                {
                    this.val$funcLink = funcLink;
                    this.val$iteratorVar = imVar;
                }

                @Override
                public void visit(ImReturn imReturn) {
                    super.visit(imReturn);
                    imReturn.replaceBy(ImHelper.statementExprVoid(JassIm.ImStmts(JassIm.ImFunctionCall(forIn, t.getFuncFor(this.val$funcLink.getDef()), JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(JassIm.ImVarAccess(this.val$iteratorVar)), false, CallType.NORMAL), imReturn.copy())));
                }
            }));
            result.add(JassIm.ImLoop(forIn, imBody));
            closeFunc.ifPresent(nameLink -> result.add(JassIm.ImFunctionCall(forIn, t.getFuncFor(nameLink.getDef()), JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(JassIm.ImVarAccess(iteratorVar)), false, CallType.NORMAL)));
        }
        return ImHelper.statementExprVoid(JassIm.ImStmts(result));
    }

    private static ImStmt case_StmtForVararg(StmtForIn s, ImTranslator t, ImFunction f) {
        ArrayList result = Lists.newArrayList();
        ImVar loopVar = t.getVarFor(s.getLoopVar());
        result.add(JassIm.ImVarargLoop(s, JassIm.ImStmts(t.translateStatements(f, s.getBody())), loopVar));
        f.getLocals().add(loopVar);
        return ImHelper.statementExprVoid(JassIm.ImStmts(result));
    }

    public static ImStmt translate(StmtForRangeUp s, ImTranslator t, ImFunction f) {
        return StmtTranslation.case_StmtForRange(t, f, s.getLoopVar(), s.getTo(), s.getStep(), s.getBody(), WurstOperator.PLUS, WurstOperator.GREATER, s);
    }

    public static ImStmt translate(StmtForRangeDown s, ImTranslator t, ImFunction f) {
        return StmtTranslation.case_StmtForRange(t, f, s.getLoopVar(), s.getTo(), s.getStep(), s.getBody(), WurstOperator.MINUS, WurstOperator.LESS, s);
    }

    private static ImStmt case_StmtForRange(ImTranslator t, ImFunction f, LocalVarDef loopVar, Expr to, Expr step, WStatements body, WurstOperator opStep, WurstOperator opCompare, Element trace) {
        ImVar imLoopVar = t.getVarFor(loopVar);
        f.getLocals().add(imLoopVar);
        Expr from = (Expr)loopVar.getInitialExpr();
        ImExpr fromExpr = from.imTranslateExpr(t, f);
        ArrayList result = Lists.newArrayList();
        result.add(JassIm.ImSet(loopVar, JassIm.ImVarAccess(imLoopVar), fromExpr));
        ImExpr toExpr = StmtTranslation.addCacheVariableSmart(t, f, result, to, TypesHelper.imInt());
        ImExpr stepExpr = StmtTranslation.addCacheVariableSmart(t, f, result, step, TypesHelper.imInt());
        ImStmts imBody = JassIm.ImStmts(new ImStmt[0]);
        imBody.add(JassIm.ImExitwhen(trace, JassIm.ImOperatorCall(opCompare, JassIm.ImExprs(JassIm.ImVarAccess(imLoopVar), toExpr))));
        imBody.addAll(t.translateStatements(f, body));
        imBody.add(JassIm.ImSet(trace, JassIm.ImVarAccess(imLoopVar), JassIm.ImOperatorCall(opStep, JassIm.ImExprs(JassIm.ImVarAccess(imLoopVar), stepExpr))));
        result.add(JassIm.ImLoop(trace, imBody));
        return ImHelper.statementExprVoid(JassIm.ImStmts(result));
    }

    private static ImExpr addCacheVariableSmart(ImTranslator t, ImFunction f, List<ImStmt> result, Expr toCache, ImType type) {
        ImExpr r = toCache.imTranslateExpr(t, f);
        if (r instanceof ImConst) {
            return r;
        }
        ImVar tempVar = JassIm.ImVar(toCache, type, "temp", false);
        f.getLocals().add(tempVar);
        result.add(JassIm.ImSet(toCache, JassIm.ImVarAccess(tempVar), r));
        return JassIm.ImVarAccess(tempVar);
    }

    public static ImStmt translate(StmtIf s, ImTranslator t, ImFunction f) {
        return JassIm.ImIf(s, s.getCond().imTranslateExpr(t, f), JassIm.ImStmts(t.translateStatements(f, s.getThenBlock())), JassIm.ImStmts(t.translateStatements(f, s.getElseBlock())));
    }

    public static ImStmt translate(StmtLoop s, ImTranslator t, ImFunction f) {
        return JassIm.ImLoop(s, JassIm.ImStmts(t.translateStatements(f, s.getBody())));
    }

    public static ImStmt translate(StmtReturn s, ImTranslator t, ImFunction f) {
        return JassIm.ImReturn(s, s.getReturnedObj().imTranslateExprOpt(t, f));
    }

    public static ImStmt translate(StmtSet s, ImTranslator t, ImFunction f) {
        ImLExpr updated = s.getUpdatedExpr().imTranslateExprLvalue(t, f);
        ImExpr right = s.getRight().imTranslateExpr(t, f);
        return JassIm.ImSet(s, updated, right);
    }

    public static ImStmt translate(StmtWhile s, ImTranslator t, ImFunction f) {
        ArrayList body = Lists.newArrayList();
        body.add(JassIm.ImExitwhen(s.getCond(), JassIm.ImOperatorCall(WurstOperator.NOT, JassIm.ImExprs(s.getCond().imTranslateExpr(t, f)))));
        body.addAll(t.translateStatements(f, s.getBody()));
        return JassIm.ImLoop(s, JassIm.ImStmts(body));
    }

    public static ImStmt translate(StmtSkip s, ImTranslator translator, ImFunction f) {
        return ImHelper.nullExpr();
    }

    public static ImStmt translate(SwitchStmt switchStmt, ImTranslator t, ImFunction f) {
        ArrayList result = Lists.newArrayList();
        ImType type = switchStmt.getExpr().attrTyp().imTranslateType(t);
        ImExpr tempVar = StmtTranslation.addCacheVariableSmart(t, f, result, switchStmt.getExpr(), type);
        ImIf lastIf = null;
        for (int i = 0; i < switchStmt.getCases().size(); ++i) {
            SwitchCase cse = (SwitchCase)switchStmt.getCases().get(i);
            if (lastIf == null) {
                lastIf = JassIm.ImIf(switchStmt, StmtTranslation.translateSwitchCase(cse, tempVar, f, t), JassIm.ImStmts(t.translateStatements(f, cse.getStmts())), JassIm.ImStmts(new ImStmt[0]));
                result.add(lastIf);
                continue;
            }
            if (i == switchStmt.getCases().size() - 1 && switchStmt.getSwitchDefault() instanceof NoDefaultCase && switchStmt.calculateHandlesAllCases()) {
                lastIf.setElseBlock(JassIm.ImStmts(t.translateStatements(f, cse.getStmts())));
                continue;
            }
            ImIf tmp = JassIm.ImIf(switchStmt, StmtTranslation.translateSwitchCase(cse, tempVar, f, t), JassIm.ImStmts(t.translateStatements(f, cse.getStmts())), JassIm.ImStmts(new ImStmt[0]));
            lastIf.setElseBlock(JassIm.ImStmts(tmp));
            lastIf = tmp;
        }
        if (lastIf == null) {
            throw new CompileError(switchStmt.attrSource(), "No cases in switch?");
        }
        if (switchStmt.getSwitchDefault() instanceof SwitchDefaultCaseStatements) {
            SwitchDefaultCaseStatements dflt = (SwitchDefaultCaseStatements)switchStmt.getSwitchDefault();
            lastIf.setElseBlock(JassIm.ImStmts(t.translateStatements(f, dflt.getStmts())));
        } else if (switchStmt.getSwitchDefault() instanceof NoDefaultCase) {
            // empty if block
        }
        return ImHelper.statementExprVoid(JassIm.ImStmts(result));
    }

    private static ImExpr translateSwitchCase(SwitchCase cse, ImExpr tempVar, ImFunction f, ImTranslator t) {
        return cse.getExpressions().stream().map(e -> JassIm.ImOperatorCall(WurstOperator.EQ, JassIm.ImExprs(tempVar.copy(), e.imTranslateExpr(t, f)))).reduce((x, y) -> JassIm.ImOperatorCall(WurstOperator.OR, JassIm.ImExprs(x, y))).orElseGet(() -> JassIm.ImBoolVal(true));
    }

    public static ImStmt translate(EndFunctionStatement endFunctionStatement, ImTranslator translator, ImFunction f) {
        return ImHelper.nullExpr();
    }

    public static ImStmt translate(StartFunctionStatement startFunctionStatement, ImTranslator translator, ImFunction f) {
        return ImHelper.nullExpr();
    }

    public static ImStmt translate(WBlock block, ImTranslator translator, ImFunction f) {
        ImStmts stmts = JassIm.ImStmts(new ImStmt[0]);
        for (WStatement s : block.getBody()) {
            stmts.add(s.imTranslateStmt(translator, f));
        }
        return ImHelper.statementExprVoid(stmts);
    }
}

