/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import com.google.common.collect.Lists;
import de.peeeq.wurstscript.ast.ActionStatement;
import de.peeeq.wurstscript.ast.CompoundStatement;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.EndFunctionStatement;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprBoolVal;
import de.peeeq.wurstscript.ast.LoopStatement;
import de.peeeq.wurstscript.ast.StartFunctionStatement;
import de.peeeq.wurstscript.ast.StmtExitwhen;
import de.peeeq.wurstscript.ast.StmtIf;
import de.peeeq.wurstscript.ast.StmtLoop;
import de.peeeq.wurstscript.ast.StmtReturn;
import de.peeeq.wurstscript.ast.StmtWhile;
import de.peeeq.wurstscript.ast.SwitchCase;
import de.peeeq.wurstscript.ast.SwitchDefaultCaseStatements;
import de.peeeq.wurstscript.ast.SwitchStmt;
import de.peeeq.wurstscript.ast.WBlock;
import de.peeeq.wurstscript.ast.WEntity;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.ast.WStatements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public class Flow {
    private static int lastUsedIndex = 0;

    public static List<WStatement> getNext(ActionStatement s) {
        List<WStatement> r = Flow.getFollowingStatements(s);
        Flow.setPrevios(s, r);
        return r;
    }

    public static List<WStatement> getNext(StartFunctionStatement s) {
        List<WStatement> r = Flow.getFollowingStatements(s);
        Flow.setPrevios(s, r);
        return r;
    }

    public static List<WStatement> getNext(LoopStatement s) {
        List<Object> r = s instanceof StmtLoop ? Lists.newArrayList() : (s instanceof StmtWhile && Flow.isConstantBool(((StmtWhile)s).getCond(), true) ? Lists.newArrayList() : Flow.getFollowingStatements(s));
        if (!s.getBody().isEmpty()) {
            r.add((WStatement)s.getBody().get(0));
        }
        Flow.setPrevios(s, (List<WStatement>)r);
        return r;
    }

    public static List<WStatement> getNext(StmtExitwhen s) {
        LoopStatement loop = Flow.getParentLoopStatement(s);
        if (loop == null) {
            s.addError("Break statements must be used inside a loop.");
            return Collections.emptyList();
        }
        List<WStatement> next = Flow.getFollowingStatements(loop);
        if (!Flow.isConstantBool(s.getCond(), true)) {
            next.addAll(Flow.getFollowingStatements(s));
        }
        Flow.setPrevios(s, next);
        return next;
    }

    private static boolean isConstantBool(Expr cond, boolean value) {
        return cond instanceof ExprBoolVal && ((ExprBoolVal)cond).getValB() == value;
    }

    public static List<WStatement> getNext(StmtIf s) {
        ArrayList r = s.getThenBlock().isEmpty() || s.getElseBlock().isEmpty() ? Flow.getFollowingStatements(s) : Lists.newArrayList();
        if (!s.getThenBlock().isEmpty()) {
            r.add((WStatement)s.getThenBlock().get(0));
        }
        if (!s.getElseBlock().isEmpty()) {
            r.add((WStatement)s.getElseBlock().get(0));
        }
        Flow.setPrevios(s, r);
        return r;
    }

    public static List<WStatement> getNext(WBlock s) {
        if (s.getBody().isEmpty()) {
            return s.attrAfterBodyStatements();
        }
        return Collections.singletonList((WStatement)s.getBody().get(0));
    }

    public static List<WStatement> getNext(StmtReturn s) {
        EndFunctionStatement endStmt = Flow.findEndStatement(s);
        if (endStmt == null) {
            return Collections.emptyList();
        }
        endStmt.attrPreviousStatements().add(s);
        return Collections.singletonList(endStmt);
    }

    private static @Nullable EndFunctionStatement findEndStatement(@Nullable Element n) {
        WStatement last;
        WStatements stmts;
        if (n == null) {
            return null;
        }
        if (n instanceof WStatements && !(stmts = (WStatements)n).isEmpty() && (last = (WStatement)stmts.get(stmts.size() - 1)) instanceof EndFunctionStatement) {
            return (EndFunctionStatement)last;
        }
        return Flow.findEndStatement(n.getParent());
    }

    public static List<WStatement> getNext(SwitchStmt s) {
        ArrayList r = Lists.newArrayList();
        boolean following = false;
        for (SwitchCase c : s.getCases()) {
            if (c.getStmts().isEmpty()) {
                following = true;
                continue;
            }
            r.add((WStatement)c.getStmts().get(0));
        }
        if (s.getSwitchDefault() instanceof SwitchDefaultCaseStatements) {
            SwitchDefaultCaseStatements defaul = (SwitchDefaultCaseStatements)s.getSwitchDefault();
            if (defaul.getStmts().isEmpty()) {
                following = true;
            } else {
                r.add((WStatement)defaul.getStmts().get(0));
            }
        } else if (!s.calculateHandlesAllCases()) {
            following = true;
        }
        if (following) {
            r.addAll(Flow.getFollowingStatements(s));
        }
        Flow.setPrevios(s, r);
        return r;
    }

    private static List<WStatement> getFollowingStatements(WStatement s) {
        if (s.getParent() instanceof WStatements) {
            WStatements parent = (WStatements)s.getParent();
            ArrayList r = Lists.newArrayList();
            int index = s.attrListIndex();
            if (index + 1 < parent.size()) {
                r.add((WStatement)parent.get(index + 1));
            } else {
                CompoundStatement parentStmt = Flow.getParentStatement(parent);
                if (parentStmt != null) {
                    r.addAll(parentStmt.attrAfterBodyStatements());
                }
            }
            return r;
        }
        return Collections.emptyList();
    }

    private static @Nullable CompoundStatement getParentStatement(Element node) {
        if (node instanceof CompoundStatement) {
            return (CompoundStatement)node;
        }
        if (node instanceof WEntity) {
            return null;
        }
        return Flow.getParentStatement(node.getParent());
    }

    private static void setPrevios(WStatement s, List<WStatement> next) {
        for (WStatement n : next) {
            n.attrPreviousStatements().add(s);
        }
    }

    public static List<WStatement> getPrevious(WStatement s) {
        return Lists.newArrayListWithCapacity((int)1);
    }

    public static int getListIndex(WStatement s) {
        WStatements parent = (WStatements)s.getParent();
        int r = Flow.get(parent, lastUsedIndex) == s ? lastUsedIndex : (Flow.get(parent, lastUsedIndex + 1) == s ? lastUsedIndex + 1 : (Flow.get(parent, lastUsedIndex - 1) == s ? lastUsedIndex - 1 : parent.indexOf(s)));
        lastUsedIndex = r;
        return r;
    }

    private static @Nullable WStatement get(WStatements parent, int i) {
        if (i <= 0) {
            return null;
        }
        if (i >= parent.size()) {
            return null;
        }
        return (WStatement)parent.get(i);
    }

    public static List<WStatement> getAfterBody(LoopStatement loop) {
        ArrayList r = Lists.newArrayList();
        r.add(loop);
        r.addAll(Flow.getFollowingStatements(loop));
        return r;
    }

    public static List<WStatement> getAfterBody(StmtIf s) {
        return Flow.getFollowingStatements(s);
    }

    public static List<WStatement> getAfterBody(WBlock s) {
        return Flow.getFollowingStatements(s);
    }

    public static List<WStatement> getAfterBody(SwitchStmt s) {
        return Flow.getFollowingStatements(s);
    }

    private static @Nullable LoopStatement getParentLoopStatement(@Nullable Element node) {
        while (node != null) {
            if (node instanceof LoopStatement) {
                return (LoopStatement)node;
            }
            node = node.getParent();
        }
        return null;
    }

    public static List<WStatement> getNext(EndFunctionStatement endFunctionStatement) {
        return Collections.emptyList();
    }
}

