/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.updates.Updates;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0010\"\u00020\u000eH\u0007\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0007J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\bJ\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\bJ$\u0010\u001f\u001a\u00020\n2\b\u0010 \u001a\u0004\u0018\u00010\n2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\"J\u0016\u0010#\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\n2\u0006\u0010$\u001a\u00020%J\u001a\u0010&\u001a\u00020'\"\b\b\u0000\u0010(*\u00020)2\u0006\u0010*\u001a\u00020)H\u0002J\n\u0010+\u001a\u00020'*\u00020)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006,"}, d2={"Ldorkbox/util/Sys;", "", "()V", "GIGABYTE", "", "KILOBYTE", "MEGABYTE", "TERABYTE", "", "version", "", "getVersion", "()Ljava/lang/String;", "concatBytes", "", "arrayBytes", "", "([[B)[B", "copyBytes", "src", "position", "getBytesFromStream", "inputStream", "Ljava/io/InputStream;", "getExtension", "fileName", "getSizePretty", "size", "getTimePretty", "nanoSeconds", "getTimePrettyFull", "replaceStringFast", "string", "replacements", "", "searchStringFast", "c", "", "throwException0", "", "T", "", "t", "unchecked", "Utilities"})
@SourceDebugExtension(value={"SMAP\nSys.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sys.kt\ndorkbox/util/Sys\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,295:1\n1#2:296\n*E\n"})
public final class Sys {
    @NotNull
    public static final Sys INSTANCE = new Sys();
    @NotNull
    private static final String version = "1.46";
    public static final int KILOBYTE = 1024;
    public static final int MEGABYTE = 0x100000;
    public static final int GIGABYTE = 0x40000000;
    public static final long TERABYTE = 0x10000000000L;

    private Sys() {
    }

    @NotNull
    public final String getVersion() {
        return version;
    }

    @NotNull
    public final String replaceStringFast(@Nullable String string, @NotNull Map<String, String> replacements) {
        Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
        StringBuilder sb = new StringBuilder(string);
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            int start = sb.indexOf(key, 0);
            while (start > -1) {
                int end = start + key.length();
                int nextSearchStart = start + value.length();
                sb.replace(start, end, value);
                start = sb.indexOf(key, nextSearchStart);
            }
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        return string2;
    }

    public final int searchStringFast(@NotNull String string, char c) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (string.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public final String getSizePretty(long size) {
        String string;
        if (size > 0x10000000000L) {
            String string2 = "%2.2fTB";
            Object[] objectArray = new Object[]{(double)size / (double)0x10000000000L};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            return string3;
        }
        if (size > 0x40000000L) {
            String string4 = "%2.2fGB";
            Object[] objectArray = new Object[]{(double)size / (double)0x40000000};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
            return string5;
        }
        if (size > 0x100000L) {
            String string6 = "%2.2fMB";
            Object[] objectArray = new Object[]{(double)size / (double)0x100000};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(format, *args)");
            return string7;
        }
        if (size > 1024L) {
            String string8 = "%2.2fKB";
            Object[] objectArray = new Object[]{(double)size / (double)1024};
            String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(format, *args)");
        } else {
            string = "" + size + 'B';
        }
        return string;
    }

    @NotNull
    public final String getSizePretty(int size) {
        String string;
        if (size > 0x40000000) {
            String string2 = "%2.2fGB";
            Object[] objectArray = new Object[]{(double)size / (double)0x40000000};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            return string3;
        }
        if (size > 0x100000) {
            String string4 = "%2.2fMB";
            Object[] objectArray = new Object[]{(double)size / (double)0x100000};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
            return string5;
        }
        if (size > 1024) {
            String string6 = "%2.2fKB";
            Object[] objectArray = new Object[]{(double)size / (double)1024};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(format, *args)");
        } else {
            string = "" + size + 'B';
        }
        return string;
    }

    @NotNull
    public final String getTimePretty(long nanoSeconds) {
        TimeUnit unit = null;
        String text = null;
        if (TimeUnit.DAYS.convert(nanoSeconds, TimeUnit.NANOSECONDS) > 0L) {
            unit = TimeUnit.DAYS;
            text = "d";
        } else if (TimeUnit.HOURS.convert(nanoSeconds, TimeUnit.NANOSECONDS) > 0L) {
            unit = TimeUnit.HOURS;
            text = "h";
        } else if (TimeUnit.MINUTES.convert(nanoSeconds, TimeUnit.NANOSECONDS) > 0L) {
            unit = TimeUnit.MINUTES;
            text = "min";
        } else if (TimeUnit.SECONDS.convert(nanoSeconds, TimeUnit.NANOSECONDS) > 0L) {
            unit = TimeUnit.SECONDS;
            text = "s";
        } else if (TimeUnit.MILLISECONDS.convert(nanoSeconds, TimeUnit.NANOSECONDS) > 0L) {
            unit = TimeUnit.MILLISECONDS;
            text = "ms";
        } else if (TimeUnit.MICROSECONDS.convert(nanoSeconds, TimeUnit.NANOSECONDS) > 0L) {
            unit = TimeUnit.MICROSECONDS;
            text = "\u03bcs";
        } else {
            unit = TimeUnit.NANOSECONDS;
            text = "ns";
        }
        double value = (double)nanoSeconds / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
        String string = "%.4g" + text;
        Object[] objectArray = new Object[]{value};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    @NotNull
    public final String getTimePrettyFull(long nanoSeconds) {
        TimeUnit unit = null;
        String text = null;
        if (TimeUnit.DAYS.convert(nanoSeconds, TimeUnit.NANOSECONDS) > 0L) {
            unit = TimeUnit.DAYS;
            text = "day";
        } else if (TimeUnit.HOURS.convert(nanoSeconds, TimeUnit.NANOSECONDS) > 0L) {
            unit = TimeUnit.HOURS;
            text = "hour";
        } else if (TimeUnit.MINUTES.convert(nanoSeconds, TimeUnit.NANOSECONDS) > 0L) {
            unit = TimeUnit.MINUTES;
            text = "minute";
        } else if (TimeUnit.SECONDS.convert(nanoSeconds, TimeUnit.NANOSECONDS) > 0L) {
            unit = TimeUnit.SECONDS;
            text = "second";
        } else if (TimeUnit.MILLISECONDS.convert(nanoSeconds, TimeUnit.NANOSECONDS) > 0L) {
            unit = TimeUnit.MILLISECONDS;
            text = "milli-second";
        } else if (TimeUnit.MICROSECONDS.convert(nanoSeconds, TimeUnit.NANOSECONDS) > 0L) {
            unit = TimeUnit.MICROSECONDS;
            text = "micro-second";
        } else {
            unit = TimeUnit.NANOSECONDS;
            text = "nano-second";
        }
        double value = (double)nanoSeconds / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
        if (value > 1.0) {
            text = text + 's';
        }
        String string = "%.4g " + text;
        Object[] objectArray = new Object[]{value};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private final <T extends Throwable> void throwException0(Throwable t2) {
        Intrinsics.checkNotNull((Object)t2, (String)"null cannot be cast to non-null type T of dorkbox.util.Sys.throwException0");
        throw t2;
    }

    public final void unchecked(@NotNull Throwable $this$unchecked) {
        Intrinsics.checkNotNullParameter((Object)$this$unchecked, (String)"<this>");
        this.throwException0($this$unchecked);
    }

    @Deprecated(message="Use kotlin")
    @NotNull
    public final String getExtension(@NotNull String fileName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        int dot = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dot > -1) {
            String string2 = fileName.substring(dot + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string = "";
        }
        return string;
    }

    @Deprecated(message="Use kotlin")
    @NotNull
    public final byte[] getBytesFromStream(@NotNull InputStream inputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        byte[] buffer = new byte[4096];
        int read2 = 0;
        while (true) {
            int n;
            int it = n = inputStream.read(buffer);
            boolean bl = false;
            read2 = it;
            if (n <= 0) break;
            baos.write(buffer, 0, read2);
        }
        baos.flush();
        inputStream.close();
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"baos.toByteArray()");
        return byArray;
    }

    @Deprecated(message="Use kotlin")
    @JvmOverloads
    @NotNull
    public final byte[] copyBytes(@NotNull byte[] src, int position) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        int length = src.length - position;
        byte[] b = new byte[length];
        System.arraycopy(src, position, b, 0, length);
        return b;
    }

    public static /* synthetic */ byte[] copyBytes$default(Sys sys, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return sys.copyBytes(byArray, n);
    }

    @Deprecated(message="Use kotlin")
    @NotNull
    public final byte[] concatBytes(byte[] ... arrayBytes) {
        Intrinsics.checkNotNullParameter((Object)arrayBytes, (String)"arrayBytes");
        int length = 0;
        int n = ((Object[])arrayBytes).length;
        for (int i = 0; i < n; ++i) {
            byte[] bytes = arrayBytes[i];
            length += bytes.length;
        }
        byte[] concatBytes = new byte[length];
        length = 0;
        int n2 = ((Object[])arrayBytes).length;
        for (n = 0; n < n2; ++n) {
            byte[] bytes = arrayBytes[n];
            System.arraycopy(bytes, 0, concatBytes, length, bytes.length);
            length += bytes.length;
        }
        return concatBytes;
    }

    @Deprecated(message="Use kotlin")
    @JvmOverloads
    @NotNull
    public final byte[] copyBytes(@NotNull byte[] src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return Sys.copyBytes$default(this, src, 0, 2, null);
    }

    static {
        Updates.INSTANCE.add(Sys.class, "aebbb926aeb144739e9f3cab90ffaa72", version);
    }
}

