/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.map.importer;

import com.google.common.io.LittleEndianDataInputStream;
import de.peeeq.wurstio.mpq.MpqEditor;
import de.peeeq.wurstio.mpq.MpqEditorFactory;
import de.peeeq.wurstscript.RunArgs;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.utils.TempDir;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.bin.app.IMP;

public class ImportFile {
    private static final String DEFAULT_IMPORT_PATH = "war3mapImported\\";
    private static final int FILE_VERSION = 1;

    public static void extractImportsFromMap(File mapFile, RunArgs runArgs) {
        WLogger.info("Extracting all imported Files...");
        if (!mapFile.exists() || !mapFile.isFile() || mapFile.getName().endsWith("w3m")) {
            JOptionPane.showMessageDialog(null, "Map " + mapFile.getAbsolutePath() + " does not exist or is of wrong format (w3x only)");
            return;
        }
        try {
            File projectFolder = mapFile.getParentFile();
            File importDirectory = ImportFile.getImportDirectory(projectFolder);
            File tempMap = ImportFile.getCopyOfMap(mapFile);
            ImportFile.extractImportsFrom(importDirectory, tempMap, runArgs);
        }
        catch (Exception e) {
            WLogger.severe(e);
            JOptionPane.showMessageDialog(null, "Could not export objects (2): " + e.getMessage());
        }
    }

    private static void extractImportsFrom(File importDirectory, File tempMap, RunArgs runArgs) throws Exception {
        try (MpqEditor editor = MpqEditorFactory.getEditor(Optional.of(tempMap), true);){
            LinkedList<String> failed = ImportFile.extractImportedFiles(editor, importDirectory);
            if (failed.isEmpty()) {
                JOptionPane.showMessageDialog(null, "All imports were extracted to " + importDirectory.getAbsolutePath());
            } else {
                String message = "Following files could not be extracted:\n" + String.join((CharSequence)",", failed);
                WLogger.info(message);
                JOptionPane.showMessageDialog(null, message);
            }
        }
    }

    private static LinkedList<String> extractImportedFiles(MpqEditor mpq, File directory) {
        LinkedList<String> linkedList;
        byte[] temp;
        LinkedList<String> failed = new LinkedList<String>();
        try {
            temp = mpq.extractFile("war3map.imp");
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, "No vaild war3map.imp was found, or there are no imports");
            return failed;
        }
        LittleEndianDataInputStream reader = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(temp));
        try {
            int fileFormatVersion = reader.readInt();
            int fileCount = reader.readInt();
            WLogger.info("Imported FileCount: " + fileCount);
            for (int i = 1; i <= fileCount; ++i) {
                ImportFile.extractImportedFile(mpq, directory, failed, reader);
            }
            linkedList = failed;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return linkedList;
    }

    private static void extractImportedFile(MpqEditor mpq, File directory, LinkedList<String> failed, LittleEndianDataInputStream reader) throws Exception {
        byte b = reader.readByte();
        String path = directory.getPath() + "\\";
        Object mpqpath = "";
        if (ImportFile.isStandardPath(b)) {
            path = path + DEFAULT_IMPORT_PATH;
            mpqpath = (String)mpqpath + DEFAULT_IMPORT_PATH;
        }
        String filename = ImportFile.readString(reader);
        WLogger.info("Extracting file: " + filename);
        filename = filename.trim();
        mpqpath = (String)mpqpath + filename;
        path = path + filename;
        ImportFile.extractFile(mpq, directory, failed, path, (String)mpqpath, filename);
    }

    private static void extractFile(MpqEditor mpq, File directory, LinkedList<String> failed, String path, String mpqpath, String filename) throws Exception {
        File out = new File(path);
        out.getParentFile().mkdirs();
        try {
            byte[] xx = mpq.extractFile(mpqpath);
            com.google.common.io.Files.write((byte[])xx, (File)out);
        }
        catch (IOException e) {
            out.delete();
            out = new File(directory.getPath() + "\\war3mapImported\\" + filename);
            out.getParentFile().mkdirs();
            try {
                byte[] xx = mpq.extractFile(DEFAULT_IMPORT_PATH + mpqpath);
                com.google.common.io.Files.write((byte[])xx, (File)out);
            }
            catch (IOException e1) {
                failed.add(mpqpath);
            }
        }
    }

    private static boolean isStandardPath(byte b) {
        return b == 5 || b == 8;
    }

    private static String readString(LittleEndianDataInputStream reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            while (true) {
                char c;
                if ((c = (char)reader.readByte()) == '\u0000') {
                    return sb.toString();
                }
                sb.append(c);
            }
        }
        catch (EOFException e) {
            return sb.toString();
        }
    }

    private static LinkedList<File> getFilesOfDirectory(File dir, LinkedList<File> addTo) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                ImportFile.getFilesOfDirectory(f, addTo);
                continue;
            }
            addTo.add(f);
        }
        return addTo;
    }

    private static void insertImportedFiles(MpqEditor mpq, List<File> directories) throws Exception {
        IMP importFile = new IMP();
        for (File directory : directories) {
            LinkedList<File> files = new LinkedList<File>();
            ImportFile.getFilesOfDirectory(directory, files);
            for (File f : files) {
                Path p = f.toPath();
                p = directory.toPath().relativize(p);
                String normalizedWc3Path = p.toString().replaceAll("/", "\\\\");
                IMP.Obj importObj = new IMP.Obj();
                importObj.setPath(normalizedWc3Path);
                importObj.setStdFlag(IMP.StdFlag.CUSTOM);
                importFile.addObj(importObj);
                mpq.deleteFile(normalizedWc3Path);
                mpq.insertFile(normalizedWc3Path, f);
            }
        }
        mpq.deleteFile("war3map.imp");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (Wc3BinOutputStream wc3BinOutputStream = new Wc3BinOutputStream(byteArrayOutputStream);){
            importFile.write(wc3BinOutputStream);
        }
        byteArrayOutputStream.flush();
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        mpq.insertFile("war3map.imp", byteArray);
    }

    public static void importFilesFromImports(File projectFolder, MpqEditor ed) {
        LinkedList<File> folders = new LinkedList<File>();
        folders.add(ImportFile.getImportDirectory(projectFolder));
        folders.addAll(Arrays.asList(ImportFile.getTransientImportDirectories(projectFolder)));
        folders.removeIf(folder -> !folder.exists());
        try {
            ImportFile.insertImportedFiles(ed, folders);
        }
        catch (Exception e) {
            WLogger.severe(e);
            JOptionPane.showMessageDialog(null, "Couldn't import resources. " + e.getMessage());
        }
    }

    private static File getCopyOfMap(File mapFile) throws IOException {
        File mapTemp = File.createTempFile("temp", "w3x", TempDir.get());
        mapTemp.deleteOnExit();
        com.google.common.io.Files.copy((File)mapFile, (File)mapTemp);
        return mapTemp;
    }

    private static File getImportDirectory(File projectFolder) {
        return new File(projectFolder, "imports");
    }

    private static File[] getTransientImportDirectories(File projectFolder) {
        ArrayList paths = new ArrayList();
        Path dependencies = projectFolder.toPath().resolve("_build").resolve("dependencies");
        try (Stream<Path> spaths = Files.list(dependencies);){
            spaths.forEach(dependency -> {
                if (Files.exists(dependency.resolve("imports"), new LinkOption[0])) {
                    paths.add(dependency.resolve("imports"));
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File[] arr = new File[paths.size()];
        return paths.stream().map(Path::toFile).collect(Collectors.toList()).toArray(arr);
    }
}

