/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.app.Color;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.MDXObject;
import net.moonlightflower.wc3libs.misc.model.mdx.Node;
import net.moonlightflower.wc3libs.misc.model.mdx.Track;
import net.moonlightflower.wc3libs.misc.model.mdx.TrackChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.VisibilityTrack;

public class RibbonEmitter
extends MDXObject {
    private long _inclusiveSize = 0L;
    private Node _node;
    private float _heightAbove = 0.0f;
    private float _heightBelow = 0.0f;
    private Color _color;
    private float _lifespan = 0.0f;
    private long _textureSlot = 0L;
    private long _emissionRate = 0L;
    private long _rows;
    private long _columns;
    private long _materialId;
    private float _gravity;
    private final LinkedHashSet<Chunk> _chunks = new ObservableLinkedHashSet<Chunk>();
    private final LinkedHashSet<VisibilityTrackChunk> _visibilityTrackChunks = new ObservableLinkedHashSet<VisibilityTrackChunk>();
    private final LinkedHashSet<HeightAboveTrackChunk> _heightAboveTrackChunks = new ObservableLinkedHashSet<HeightAboveTrackChunk>();
    private final LinkedHashSet<HeightBelowTrackChunk> _heightBelowTrackChunks = new ObservableLinkedHashSet<HeightBelowTrackChunk>();
    private final LinkedHashSet<AlphaTrackChunk> _alphaTrackChunks = new ObservableLinkedHashSet<AlphaTrackChunk>();
    private final LinkedHashSet<ColorTrackChunk> _colorTrackChunks = new ObservableLinkedHashSet<ColorTrackChunk>();
    private List<TextureSlotTrackChunk> _textureSlotTrackChunks = new ArrayList<TextureSlotTrackChunk>();

    public long getInclusiveSize() {
        return this._inclusiveSize;
    }

    @Nonnull
    public Node getNode() {
        return this._node;
    }

    public void setNode(@Nonnull Node node) {
        this._node = node;
    }

    public float getHeightAbove() {
        return this._heightAbove;
    }

    public void setHeightAbove(float heightAbove) {
        this._heightAbove = heightAbove;
    }

    public float getHeightBelow() {
        return this._heightBelow;
    }

    public void setHeightBelow(float heightBelow) {
        this._heightBelow = heightBelow;
    }

    @Nonnull
    public Color getColor() {
        return this._color;
    }

    public void setColor(@Nonnull Color color) {
        this._color = color;
    }

    public float getLifespan() {
        return this._lifespan;
    }

    public void setLifespan(float lifespan) {
        this._lifespan = lifespan;
    }

    public long getTextureSlot() {
        return this._textureSlot;
    }

    public void setTextureSlot(long textureSlot) {
        this._textureSlot = textureSlot;
    }

    public long getEmissionRate() {
        return this._emissionRate;
    }

    public void setEmissionRate(long emissionRate) {
        this._emissionRate = emissionRate;
    }

    public long getRows() {
        return this._rows;
    }

    public void setRows(long rows) {
        this._rows = rows;
    }

    public long getColumns() {
        return this._columns;
    }

    public void setColumns(long columns) {
        this._columns = columns;
    }

    public long getMaterialId() {
        return this._materialId;
    }

    public void setMaterialId(long materialId) {
        this._materialId = materialId;
    }

    public float getGravity() {
        return this._gravity;
    }

    public void setGravity(float gravity) {
        this._gravity = gravity;
    }

    public LinkedHashSet<Chunk> getChunks() {
        return this._chunks;
    }

    public LinkedHashSet<VisibilityTrackChunk> getVisibilityTrackChunks() {
        return this._visibilityTrackChunks;
    }

    public void addVisibilityTrackChunk(@Nonnull VisibilityTrackChunk val) {
        this._chunks.add(val);
        this._visibilityTrackChunks.add(val);
    }

    public LinkedHashSet<HeightAboveTrackChunk> getHeightAboveTrackChunks() {
        return this._heightAboveTrackChunks;
    }

    public void addHeightAboveTrackChunk(@Nonnull HeightAboveTrackChunk val) {
        this._chunks.add(val);
        this._heightAboveTrackChunks.add(val);
    }

    public LinkedHashSet<HeightBelowTrackChunk> getHeightBelowTrackChunks() {
        return this._heightBelowTrackChunks;
    }

    public void addHeightBelowTrackChunk(@Nonnull HeightBelowTrackChunk val) {
        this._chunks.add(val);
        this._heightBelowTrackChunks.add(val);
    }

    public LinkedHashSet<AlphaTrackChunk> getAlphaTrackChunks() {
        return this._alphaTrackChunks;
    }

    public void addAlphaTrackChunk(@Nonnull AlphaTrackChunk val) {
        this._chunks.add(val);
        this._alphaTrackChunks.add(val);
    }

    public LinkedHashSet<ColorTrackChunk> getColorTrackChunks() {
        return this._colorTrackChunks;
    }

    public void addColorTrackChunk(@Nonnull ColorTrackChunk val) {
        this._chunks.add(val);
        this._colorTrackChunks.add(val);
    }

    public List<TextureSlotTrackChunk> getTextureSlotTrackChunks() {
        return new ArrayList<TextureSlotTrackChunk>(this._textureSlotTrackChunks);
    }

    public void addTextureSlotTrackChunk(@Nonnull TextureSlotTrackChunk val) {
        this._chunks.add(val);
        this._textureSlotTrackChunks.add(val);
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        MDXObject.SizeWriter sizeWriter = new MDXObject.SizeWriter();
        sizeWriter.write(stream);
        this._node.write(stream);
        stream.writeFloat32(this._heightAbove);
        stream.writeFloat32(this._heightBelow);
        stream.writeFloat32((float)this._color.getAlpha255() / 255.0f);
        stream.writeFloat32((float)this._color.getBlue255() / 255.0f);
        stream.writeFloat32((float)this._color.getGreen255() / 255.0f);
        stream.writeFloat32((float)this._color.getRed255() / 255.0f);
        stream.writeFloat32(this._lifespan);
        stream.writeUInt32(this._textureSlot);
        stream.writeUInt32(this._emissionRate);
        stream.writeUInt32(this._rows);
        stream.writeUInt32(this._columns);
        stream.writeUInt32(this._materialId);
        stream.writeFloat32(this._gravity);
        for (Chunk chunk : this.getChunks()) {
            chunk.write(stream);
        }
        sizeWriter.rewrite();
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public RibbonEmitter(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this._inclusiveSize = stream.readUInt32("inclusiveSize");
        this._node = new Node(stream);
        this._heightAbove = stream.readFloat32("heightAbove").floatValue();
        this._heightBelow = stream.readFloat32("heightBelow").floatValue();
        int alpha = (int)(stream.readFloat32("alpha").floatValue() * 255.0f);
        this._color = Color.fromBGRA255((int)(stream.readFloat32("blue").floatValue() * 255.0f), (int)(stream.readFloat32("green").floatValue() * 255.0f), (int)(stream.readFloat32("red").floatValue() * 255.0f), alpha);
        this._lifespan = stream.readFloat32("lifespan").floatValue();
        this._textureSlot = stream.readUInt32("textureSlot");
        this._emissionRate = stream.readUInt32("emissionRate");
        this._rows = stream.readUInt32("rows");
        this._columns = stream.readUInt32("columns");
        this._materialId = stream.readUInt32("materialId");
        this._gravity = stream.readFloat32("gravity").floatValue();
        LinkedHashMap<Id, MDX.TokenHandler> _tokenMap = new LinkedHashMap<Id, MDX.TokenHandler>();
        _tokenMap.put(VisibilityTrackChunk.TOKEN, () -> this.addVisibilityTrackChunk(new VisibilityTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(HeightAboveTrackChunk.TOKEN, () -> this.addHeightAboveTrackChunk(new HeightAboveTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(HeightBelowTrackChunk.TOKEN, () -> this.addHeightBelowTrackChunk(new HeightBelowTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(AlphaTrackChunk.TOKEN, () -> this.addAlphaTrackChunk(new AlphaTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(ColorTrackChunk.TOKEN, () -> this.addColorTrackChunk(new ColorTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(TextureSlotTrackChunk.TOKEN, () -> this.addTextureSlotTrackChunk(new TextureSlotTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        while (!stream.eof()) {
            Id trackToken = stream.readId("trackToken");
            stream.rewind(4L);
            if (!_tokenMap.containsKey(trackToken)) break;
            MDX.TokenHandler handler = (MDX.TokenHandler)_tokenMap.get(trackToken);
            handler.run();
        }
    }

    public RibbonEmitter() {
        this._node = new Node();
        this._color = Color.fromBGRA255(0, 0, 0, 0);
    }

    public static class TextureSlotTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KRTX");
        private final LinkedHashSet<TextureSlotTrack> _textureSlotTracks = new ObservableLinkedHashSet<TextureSlotTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._textureSlotTracks;
        }

        public LinkedHashSet<TextureSlotTrack> getTextureSlotTracks() {
            return this._textureSlotTracks;
        }

        public TextureSlotTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._textureSlotTracks.add(new TextureSlotTrack(stream, this.getInterpolationType(), format));
            }
        }

        public TextureSlotTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class TextureSlotTrack
        extends Track {
            private long _textureSlot;
            private long _inTan_textureSlot;
            private long _outTan_textureSlot;

            public long getTextureSlot() {
                return this._textureSlot;
            }

            public void setTextureSlot(long textureSlot) {
                this._textureSlot = textureSlot;
            }

            public long getInTanTextureSlot() {
                return this._inTan_textureSlot;
            }

            public void setInTanTextureSlot(long textureSlot) {
                this._inTan_textureSlot = textureSlot;
            }

            public long getOutTanTextureSlot() {
                return this._outTan_textureSlot;
            }

            public void setOutTanTextureSlot(long textureSlot) {
                this._outTan_textureSlot = textureSlot;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._textureSlot = stream.readUInt32("textureSlot");
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_textureSlot = stream.readUInt32("inTan_textureSlot");
                    this._outTan_textureSlot = stream.readUInt32("outTan_textureSlot");
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeUInt32(this._textureSlot);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeUInt32(this._inTan_textureSlot);
                    stream.writeUInt32(this._outTan_textureSlot);
                }
            }

            public TextureSlotTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class ColorTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KRCO");
        private final LinkedHashSet<ColorTrack> _colorTracks = new ObservableLinkedHashSet<ColorTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._colorTracks;
        }

        public LinkedHashSet<ColorTrack> getAlphaTracks() {
            return this._colorTracks;
        }

        public void addColorTrack(@Nonnull ColorTrack val) {
            this._colorTracks.add(val);
        }

        public ColorTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this.addColorTrack(new ColorTrack(stream, this.getInterpolationType(), format));
            }
        }

        public ColorTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class ColorTrack
        extends Track {
            private Color _color;
            private Color _inTan_color;
            private Color _outTan_color;

            @Nonnull
            public Color getColor() {
                return this._color;
            }

            public void setColor(@Nonnull Color color) {
                this._color = color;
            }

            @Nonnull
            public Color getInTanColor() {
                return this._inTan_color;
            }

            public void setInTanColor(@Nonnull Color color) {
                this._inTan_color = color;
            }

            public Color getOutTanColor() {
                return this._outTan_color;
            }

            public void setOutTanColor(@Nonnull Color color) {
                this._outTan_color = color;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._color = Color.fromBGR255((int)(stream.readFloat32("colorBlue").floatValue() * 255.0f), (int)(stream.readFloat32("colorGreen").floatValue() * 255.0f), (int)(stream.readFloat32("colorRed").floatValue() * 255.0f));
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_color = Color.fromBGR255((int)(stream.readFloat32("inTan_colorBlue").floatValue() * 255.0f), (int)(stream.readFloat32("inTan_colorGreen").floatValue() * 255.0f), (int)(stream.readFloat32("inTan_colorRed").floatValue() * 255.0f));
                    this._outTan_color = Color.fromBGR255((int)(stream.readFloat32("outTan_colorBlue").floatValue() * 255.0f), (int)(stream.readFloat32("outTan_colorGreen").floatValue() * 255.0f), (int)(stream.readFloat32("outTan_colorRed").floatValue() * 255.0f));
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32((float)this._color.getBlue255() / 255.0f);
                stream.writeFloat32((float)this._color.getGreen255() / 255.0f);
                stream.writeFloat32((float)this._color.getRed255() / 255.0f);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32((float)this._inTan_color.getBlue255() / 255.0f);
                    stream.writeFloat32((float)this._inTan_color.getGreen255() / 255.0f);
                    stream.writeFloat32((float)this._inTan_color.getRed255() / 255.0f);
                    stream.writeFloat32((float)this._outTan_color.getBlue255() / 255.0f);
                    stream.writeFloat32((float)this._outTan_color.getGreen255() / 255.0f);
                    stream.writeFloat32((float)this._outTan_color.getRed255() / 255.0f);
                }
            }

            public ColorTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class AlphaTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KRAL");
        private final LinkedHashSet<AlphaTrack> _alphaTracks = new ObservableLinkedHashSet<AlphaTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._alphaTracks;
        }

        public LinkedHashSet<AlphaTrack> getAlphaTracks() {
            return this._alphaTracks;
        }

        public AlphaTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._alphaTracks.add(new AlphaTrack(stream, this.getInterpolationType(), format));
            }
        }

        public AlphaTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class AlphaTrack
        extends Track {
            private float _alpha;
            private float _inTan_alpha;
            private float _outTan_alpha;

            public float getAlpha() {
                return this._alpha;
            }

            public void setAlpha(float alpha) {
                this._alpha = alpha;
            }

            public float getInTanAlpha() {
                return this._inTan_alpha;
            }

            public void setInTanAlpha(float alpha) {
                this._inTan_alpha = alpha;
            }

            public float getOutTanAlpha() {
                return this._outTan_alpha;
            }

            public void setOutTanAlpha(float alpha) {
                this._outTan_alpha = alpha;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._alpha = stream.readFloat32("alpha").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_alpha = stream.readFloat32("inTan_alpha").floatValue();
                    this._outTan_alpha = stream.readFloat32("outTan_alpha").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._alpha);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_alpha);
                    stream.writeFloat32(this._outTan_alpha);
                }
            }

            public AlphaTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class HeightBelowTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KRHB");
        private final LinkedHashSet<HeightBelowTrack> _heightBelowTracks = new ObservableLinkedHashSet<HeightBelowTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._heightBelowTracks;
        }

        public LinkedHashSet<HeightBelowTrack> getHeightBelowTracks() {
            return this._heightBelowTracks;
        }

        public HeightBelowTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._heightBelowTracks.add(new HeightBelowTrack(stream, this.getInterpolationType(), format));
            }
        }

        public HeightBelowTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class HeightBelowTrack
        extends Track {
            private float _heightBelow;
            private float _inTan_heightBelow;
            private float _outTan_heightBelow;

            public float getHeightBelow() {
                return this._heightBelow;
            }

            public void setHeightBelow(float heightBelow) {
                this._heightBelow = heightBelow;
            }

            public float getInTanHeightBelow() {
                return this._inTan_heightBelow;
            }

            public void setInTanHeightBelow(float heightBelow) {
                this._inTan_heightBelow = heightBelow;
            }

            public float getOutTanHeightBelow() {
                return this._outTan_heightBelow;
            }

            public void setOutTanHeightBelow(float heightBelow) {
                this._outTan_heightBelow = heightBelow;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._heightBelow = stream.readFloat32("heightBelow").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_heightBelow = stream.readFloat32("inTan_heightBelow").floatValue();
                    this._outTan_heightBelow = stream.readFloat32("outTan_heightBelow").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._heightBelow);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_heightBelow);
                    stream.writeFloat32(this._outTan_heightBelow);
                }
            }

            public HeightBelowTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class HeightAboveTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KRHA");
        private final LinkedHashSet<HeightAboveTrack> _heightAboveTracks = new ObservableLinkedHashSet<HeightAboveTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._heightAboveTracks;
        }

        public LinkedHashSet<HeightAboveTrack> getHeightAboveTracks() {
            return this._heightAboveTracks;
        }

        public HeightAboveTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._heightAboveTracks.add(new HeightAboveTrack(stream, this.getInterpolationType(), format));
            }
        }

        public HeightAboveTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class HeightAboveTrack
        extends Track {
            private float _heightAbove;
            private float _inTan_heightAbove;
            private float _outTan_heightAbove;

            public float getHeightAbove() {
                return this._heightAbove;
            }

            public void setHeightAbove(float heightAbove) {
                this._heightAbove = heightAbove;
            }

            public float getInTanHeightAbove() {
                return this._inTan_heightAbove;
            }

            public void setInTanHeightAbove(float heightAbove) {
                this._inTan_heightAbove = heightAbove;
            }

            public float getOutTanHeightAbove() {
                return this._outTan_heightAbove;
            }

            public void setOutTanHeightAbove(float heightAbove) {
                this._outTan_heightAbove = heightAbove;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._heightAbove = stream.readFloat32("heightAbove").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_heightAbove = stream.readFloat32("inTan_heightAbove").floatValue();
                    this._outTan_heightAbove = stream.readFloat32("outTan_heightAbove").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._heightAbove);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_heightAbove);
                    stream.writeFloat32(this._outTan_heightAbove);
                }
            }

            public HeightAboveTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class VisibilityTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KRVS");
        private final LinkedHashSet<VisibilityTrack> _visibilityTracks = new ObservableLinkedHashSet<VisibilityTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._visibilityTracks;
        }

        public LinkedHashSet<VisibilityTrack> getVisibilityTracks() {
            return this._visibilityTracks;
        }

        public VisibilityTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._visibilityTracks.add(new VisibilityTrack(stream, this.getInterpolationType(), format));
            }
        }

        public VisibilityTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }
    }
}

