/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.port.JMpqPort;
import net.moonlightflower.wc3libs.port.MpqPort;

public class WCT {
    public static final File GAME_PATH = new File("war3map.wct");
    private final List<Trig> _trigs = new ArrayList<Trig>();
    private String _headComment;
    private Trig _headTrig;

    @Nonnull
    public List<Trig> getTrigs() {
        return new ArrayList<Trig>(this._trigs);
    }

    private void addTrig(@Nonnull Trig val) {
        this._trigs.add(val);
    }

    @Nonnull
    public Trig addTrig() {
        Trig trig = new Trig();
        this.addTrig(trig);
        return trig;
    }

    public void setHeadComment(@Nullable String val) {
        this._headComment = val;
    }

    public void setHeadTrig(@Nullable Trig trig) {
        this._headTrig = trig;
    }

    public void read_0x0(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        int version = stream.readInt32();
        stream.checkFormatVersion(EncodingFormat.WCT_0x0.getVersion(), version);
        int trigsCount = stream.readInt32();
        for (int i = 1; i <= trigsCount; ++i) {
            this.addTrig(new Trig(stream, EncodingFormat.WCT_0x0));
        }
    }

    public void write_0x0(@Nonnull Wc3BinOutputStream stream) {
        stream.writeInt32(EncodingFormat.WCT_0x0.getVersion());
        stream.writeInt32(this._trigs.size());
        for (Trig trig : this._trigs) {
            trig.write(stream, EncodingFormat.WCT_0x0);
        }
    }

    public void read_0x1(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        int version = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.WCT_0x1.getVersion(), version);
        this._headComment = stream.readString("headComment");
        this._headTrig = new Trig(stream, EncodingFormat.WCT_0x1);
        int trigsCount = stream.readInt32("trigsCount");
        for (int i = 1; i <= trigsCount; ++i) {
            this.addTrig(new Trig(stream, EncodingFormat.WCT_0x1));
        }
    }

    public void write_0x1(@Nonnull Wc3BinOutputStream stream) {
        stream.writeInt32(EncodingFormat.WCT_0x1.getVersion());
        stream.writeString(this._headComment);
        this._headTrig.write(stream, EncodingFormat.WCT_0x1);
        stream.writeInt32(this._trigs.size());
        for (Trig trig : this._trigs) {
            trig.write(stream, EncodingFormat.WCT_0x1);
        }
    }

    private void read_auto(@Nonnull Wc3BinInputStream stream) throws Exception {
        int version = stream.readInt32();
        stream.rewind();
        this.read(stream, stream.getFormat(EncodingFormat.class, version));
    }

    private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws Exception {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: {
                this.read_auto(stream);
                break;
            }
            case WCT_0x1: {
                this.read_0x1(stream);
                break;
            }
            case WCT_0x0: {
                this.read_0x0(stream);
            }
        }
    }

    private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case WCT_0x1: 
            case AUTO: {
                this.write_0x1(stream);
                break;
            }
            case WCT_0x0: {
                this.write_0x0(stream);
            }
        }
    }

    private void read(@Nonnull Wc3BinInputStream stream) throws Exception {
        this.read(stream, EncodingFormat.AUTO);
    }

    public void write(@Nonnull Wc3BinOutputStream stream) {
        this.write(stream, EncodingFormat.AUTO);
    }

    public void write(@Nonnull File file) throws IOException {
        Wc3BinOutputStream outStream = new Wc3BinOutputStream(file);
        this.write(outStream);
        outStream.close();
    }

    public WCT(@Nonnull Wc3BinInputStream stream) throws Exception {
        this.read(stream);
    }

    public WCT(@Nonnull File file) throws Exception {
        Wc3BinInputStream inStream = new Wc3BinInputStream(file);
        this.read(inStream);
        inStream.close();
    }

    public WCT() {
    }

    @Nullable
    public static WCT ofMapFile(@Nonnull File mapFile) throws Exception {
        if (!mapFile.exists()) {
            throw new IOException(String.format("file %s does not exist", mapFile));
        }
        JMpqPort.Out port = new JMpqPort.Out();
        port.add(GAME_PATH);
        MpqPort.Out.Result portResult = port.commit(mapFile);
        if (!portResult.getExports().containsKey(GAME_PATH)) {
            throw new IOException("could not extract wct file");
        }
        InputStream inStream = portResult.getInputStream(GAME_PATH);
        if (inStream == null) {
            return null;
        }
        Wc3BinInputStream stream = new Wc3BinInputStream(inStream);
        WCT wct = new WCT();
        wct.read(stream);
        stream.close();
        return wct;
    }

    public static class EncodingFormat
    extends Format<Enum> {
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, -1);
        public static final EncodingFormat WCT_0x0 = new EncodingFormat(Enum.WCT_0x0, 0);
        public static final EncodingFormat WCT_0x1 = new EncodingFormat(Enum.WCT_0x1, 1);

        @Nullable
        public static EncodingFormat valueOf(@Nonnull Integer version) {
            return EncodingFormat.get(EncodingFormat.class, version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, int version) {
            super(enumVal, version);
        }

        public static enum Enum {
            AUTO,
            WCT_0x0,
            WCT_0x1;

        }
    }

    public static class Trig {
        private String _text;

        public String getText() {
            return this._text;
        }

        public void setText(@Nullable String val) {
            this._text = val;
        }

        public void read_0x0(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            int size = stream.readInt32("length");
            if (size > 0) {
                this.setText(new String(stream.readBytes(size, "text"), StandardCharsets.UTF_8));
            }
        }

        public void write_0x0(@Nonnull Wc3BinOutputStream stream) {
            byte[] textBytes = stream.stringToByteArray(this._text);
            if (textBytes == null) {
                stream.writeInt32(0);
            } else {
                textBytes = Arrays.copyOf(textBytes, textBytes.length);
                stream.writeInt32(textBytes.length);
                stream.writeBytes(textBytes);
            }
        }

        public void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case WCT_0x1: 
                case WCT_0x0: {
                    this.read_0x0(stream);
                }
            }
        }

        public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case WCT_0x1: 
                case WCT_0x0: 
                case AUTO: {
                    this.write_0x0(stream);
                }
            }
        }

        public Trig(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this.read(stream, format);
        }

        public Trig() {
        }
    }
}

