/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver;

import de.peeeq.wurstio.languageserver.LanguageWorker;
import de.peeeq.wurstio.languageserver.requests.CodeActionRequest;
import de.peeeq.wurstio.languageserver.requests.CodeLensRequest;
import de.peeeq.wurstio.languageserver.requests.Colors;
import de.peeeq.wurstio.languageserver.requests.DocumentSymbolRequest;
import de.peeeq.wurstio.languageserver.requests.FoldingRangeRequest;
import de.peeeq.wurstio.languageserver.requests.GetCompletions;
import de.peeeq.wurstio.languageserver.requests.GetDefinition;
import de.peeeq.wurstio.languageserver.requests.GetUsages;
import de.peeeq.wurstio.languageserver.requests.HoverInfo;
import de.peeeq.wurstio.languageserver.requests.RenameRequest;
import de.peeeq.wurstio.languageserver.requests.SignatureInfo;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.attributes.prettyPrint.PrettyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.ColorPresentation;
import org.eclipse.lsp4j.ColorPresentationParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentColorParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;

public class WurstTextDocumentService
implements TextDocumentService {
    private final LanguageWorker worker;

    public WurstTextDocumentService(LanguageWorker worker) {
        this.worker = worker;
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        WLogger.info("completion");
        return this.worker.handle(new GetCompletions(position, this.worker.getBufferManager())).thenApply(Either::forRight);
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        WLogger.info("resolveCompletionItem");
        return null;
    }

    public CompletableFuture<Hover> hover(HoverParams hoverParams) {
        WLogger.info("hover");
        return this.worker.handle(new HoverInfo((TextDocumentPositionParams)hoverParams, this.worker.getBufferManager()));
    }

    public CompletableFuture<SignatureHelp> signatureHelp(SignatureHelpParams helpParams) {
        WLogger.info("signatureHelp");
        return this.worker.handle(new SignatureInfo((TextDocumentPositionParams)helpParams));
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams definitionParams) {
        WLogger.info("definition");
        return this.worker.handle(new GetDefinition((TextDocumentPositionParams)definitionParams, this.worker.getBufferManager()));
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        WLogger.info("references");
        return this.worker.handle(new GetUsages((TextDocumentPositionParams)params, this.worker.getBufferManager(), true)).thenApply(udList -> udList.stream().map(GetUsages.UsagesData::getLocation).collect(Collectors.toList()));
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(DocumentHighlightParams highlightParams) {
        WLogger.info("documentHighlight");
        return this.worker.handle(new GetUsages((TextDocumentPositionParams)highlightParams, this.worker.getBufferManager(), false)).thenApply(udList -> udList.stream().map(GetUsages.UsagesData::toDocumentHighlight).collect(Collectors.toList()));
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        return this.worker.handle(new DocumentSymbolRequest(params));
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        WLogger.info("codeAction");
        return this.worker.handle(new CodeActionRequest(params, this.worker.getBufferManager()));
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        return this.worker.handle(new CodeLensRequest.GetCodeLens(params, this.worker.getBufferManager()));
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        return this.worker.handle(new CodeLensRequest.Resolve(unresolved));
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        WLogger.info("formatting");
        TextDocumentIdentifier doc = params.getTextDocument();
        String buffer = this.worker.getBufferManager().getBuffer(doc);
        String ending = doc.getUri().substring(doc.getUri().lastIndexOf("."));
        String clean = PrettyUtils.pretty(buffer, ending);
        String[] lines = buffer.split("\n");
        Range range = new Range(new Position(0, 0), new Position(lines.length, lines[lines.length - 1].length()));
        TextEdit textEdit = new TextEdit(range, clean);
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        edits.add(textEdit);
        return CompletableFuture.completedFuture(edits);
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        WLogger.info("rangeFormatting");
        return null;
    }

    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        WLogger.info("onTypeFormatting");
        return null;
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        WLogger.info("rename");
        return this.worker.handle(new RenameRequest(params, this.worker.getBufferManager()));
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        WLogger.info("didOpen");
    }

    public void didChange(DidChangeTextDocumentParams params) {
        WLogger.info("didChange");
        this.worker.handleChange(params);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        WLogger.info("didClose");
    }

    public void didSave(DidSaveTextDocumentParams params) {
        WLogger.info("didSave");
    }

    public CompletableFuture<List<ColorInformation>> documentColor(DocumentColorParams params) {
        return this.worker.handle(new Colors.DocumentColorRequest(params));
    }

    public CompletableFuture<List<ColorPresentation>> colorPresentation(ColorPresentationParams params) {
        return this.worker.handle(new Colors.ColorPresentationRequest(params));
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        return this.worker.handle(new FoldingRangeRequest(params));
    }
}

