/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.hex;

import dorkbox.hex.HexExtensionsKt;
import dorkbox.updates.Updates;
import java.math.BigInteger;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0016J6\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00122\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001b2\b\b\u0002\u0010\u001d\u001a\u00020\u0019J\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0016J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0002J%\u0010\"\u001a\u00020\u0010*\u00020\u000b2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001d\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b#J-\u0010\"\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u001b2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001d\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b#J-\u0010\"\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0013\u001a\u00020$2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001d\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ldorkbox/hex/Hex;", "", "()V", "HEX_CHARS", "", "HEX_REGEX", "Lkotlin/text/Regex;", "getHEX_REGEX$HexUtilities", "()Lkotlin/text/Regex;", "UPPER_HEX_CHARS", "bigInt10", "Ljava/math/BigInteger;", "kotlin.jvm.PlatformType", "bigIntN10", "prefix", "version", "", "decode", "", "value", "", "encode", "", "bytes", "usePrefix", "", "start", "", "length", "toUpperCase", "encodeUpper", "hexToDecimal", "char", "", "tweakHex", "tweakHex$HexUtilities", "", "HexUtilities"})
@SourceDebugExtension(value={"SMAP\nHexExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HexExtensions.kt\ndorkbox/hex/Hex\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,388:1\n1#2:389\n*E\n"})
public final class Hex {
    @NotNull
    public static final Hex INSTANCE = new Hex();
    @NotNull
    public static final String version = "1.1";
    @NotNull
    private static final char[] HEX_CHARS;
    @NotNull
    private static final char[] UPPER_HEX_CHARS;
    @NotNull
    private static final Regex HEX_REGEX;
    @NotNull
    private static final char[] prefix;
    private static final BigInteger bigInt10;
    private static final BigInteger bigIntN10;

    private Hex() {
    }

    @NotNull
    public final Regex getHEX_REGEX$HexUtilities() {
        return HEX_REGEX;
    }

    @NotNull
    public final String encode(byte value) {
        char[] hexString = new char[2];
        byte toInt = value;
        hexString[0] = HEX_CHARS[(toInt & 0xF0) >> 4];
        hexString[1] = HEX_CHARS[toInt & 0xF];
        return new String(hexString);
    }

    @NotNull
    public final String encodeUpper(byte value) {
        char[] hexString = new char[2];
        byte toInt = value;
        hexString[0] = UPPER_HEX_CHARS[(toInt & 0xF0) >> 4];
        hexString[1] = UPPER_HEX_CHARS[toInt & 0xF];
        return new String(hexString);
    }

    @NotNull
    public final String encode(@NotNull byte[] bytes, boolean usePrefix, int start, int length, boolean toUpperCase) {
        char[] hexString;
        char[] cArray;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (!(start >= 0)) {
            boolean $i$a$-require-Hex$encode$42 = false;
            String $i$a$-require-Hex$encode$42 = "Start (" + start + ") must be >= 0";
            throw new IllegalArgumentException($i$a$-require-Hex$encode$42.toString());
        }
        if (!(length >= 0)) {
            boolean $i$a$-require-Hex$encode$52 = false;
            String $i$a$-require-Hex$encode$52 = "Limit (" + length + ") must be >= 0";
            throw new IllegalArgumentException($i$a$-require-Hex$encode$52.toString());
        }
        if (!(bytes.length == 0 || start < bytes.length)) {
            boolean $i$a$-require-Hex$encode$62 = false;
            String $i$a$-require-Hex$encode$62 = "Start (" + start + ") position must be smaller than the size of the byte array";
            throw new IllegalArgumentException($i$a$-require-Hex$encode$62.toString());
        }
        int length2 = length < bytes.length ? length : bytes.length;
        int j = 0;
        if (usePrefix) {
            j = 2;
            char[] array = new char[j + 2 * (length2 - start)];
            ArraysKt.copyInto$default((char[])prefix, (char[])array, (int)0, (int)0, (int)0, (int)14, null);
            cArray = array;
        } else {
            j = 0;
            cArray = hexString = new char[2 * (length2 - start)];
        }
        if (toUpperCase) {
            for (int i = start; i < length2; ++i) {
                byte toInt = bytes[i];
                hexString[j++] = UPPER_HEX_CHARS[(toInt & 0xF0) >> 4];
                hexString[j++] = UPPER_HEX_CHARS[toInt & 0xF];
            }
        } else {
            for (int i = start; i < length2; ++i) {
                byte toInt = bytes[i];
                hexString[j++] = HEX_CHARS[(toInt & 0xF0) >> 4];
                hexString[j++] = HEX_CHARS[toInt & 0xF];
            }
        }
        return new String(hexString);
    }

    public static /* synthetic */ String encode$default(Hex hex, byte[] byArray, boolean bl, int n, int n2, boolean bl2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            bl = true;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = byArray.length;
        }
        if ((n3 & 0x10) != 0) {
            bl2 = false;
        }
        return hex.encode(byArray, bl, n, n2, bl2);
    }

    private final int hexToDecimal(char c) {
        int n;
        char c2 = c;
        boolean bl = '0' <= c2 ? c2 < ':' : false;
        if (bl) {
            n = c - 48;
        } else {
            boolean bl2 = 'A' <= c2 ? c2 < 'G' : false;
            if (bl2) {
                n = c - 65 + 10;
            } else {
                boolean bl3 = 'a' <= c2 ? c2 < 'g' : false;
                if (bl3) {
                    n = c - 97 + 10;
                } else {
                    throw new IllegalArgumentException("" + '\'' + c + "' is not a valid hexadecimal character");
                }
            }
        }
        return n;
    }

    @NotNull
    public final byte[] decode(@NotNull CharSequence value) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CharSequence cleanInput = HexExtensionsKt.removeHexPrefix(value);
        if (cleanInput.length() == 0) {
            return new byte[0];
        }
        if (cleanInput.length() % 2 != 0) {
            throw new IllegalArgumentException("hex-string '" + value + "' must have an even number of digits");
        }
        byte[] $this$decode_u24lambda_u243 = byArray = new byte[cleanInput.length() / 2];
        boolean bl = false;
        for (int i = 0; i < cleanInput.length(); i += 2) {
            $this$decode_u24lambda_u243[i / 2] = (byte)((INSTANCE.hexToDecimal(cleanInput.charAt(i)) << 4) + INSTANCE.hexToDecimal(cleanInput.charAt(i + 1)));
        }
        return byArray;
    }

    @NotNull
    public final String tweakHex$HexUtilities(@NotNull String $this$tweakHex, int value, boolean usePrefix, boolean toUpperCase) {
        String string;
        String prefix;
        Intrinsics.checkNotNullParameter((Object)$this$tweakHex, (String)"<this>");
        String string2 = usePrefix ? (-10 < value && value < 10 ? "0x0" : "0x") : (prefix = -10 < value && value < 10 ? "0" : "");
        if (toUpperCase) {
            StringBuilder stringBuilder = new StringBuilder().append(prefix);
            String string3 = $this$tweakHex.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            string = stringBuilder.append(string3).toString();
        } else {
            string = prefix + $this$tweakHex;
        }
        return string;
    }

    public static /* synthetic */ String tweakHex$HexUtilities$default(Hex hex, String string, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        return hex.tweakHex$HexUtilities(string, n, bl, bl2);
    }

    @NotNull
    public final String tweakHex$HexUtilities(@NotNull String $this$tweakHex, long value, boolean usePrefix, boolean toUpperCase) {
        String string;
        String prefix;
        Intrinsics.checkNotNullParameter((Object)$this$tweakHex, (String)"<this>");
        String string2 = usePrefix ? (-10L < value && value < 10L ? "0x0" : "0x") : (prefix = -10L < value && value < 10L ? "0" : "");
        if (toUpperCase) {
            StringBuilder stringBuilder = new StringBuilder().append(prefix);
            String string3 = $this$tweakHex.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            string = stringBuilder.append(string3).toString();
        } else {
            string = prefix + $this$tweakHex;
        }
        return string;
    }

    public static /* synthetic */ String tweakHex$HexUtilities$default(Hex hex, String string, long l, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return hex.tweakHex$HexUtilities(string, l, bl, bl2);
    }

    @NotNull
    public final String tweakHex$HexUtilities(@NotNull BigInteger $this$tweakHex, boolean usePrefix, boolean toUpperCase) {
        String string;
        String prefix;
        Intrinsics.checkNotNullParameter((Object)$this$tweakHex, (String)"<this>");
        String asHex = $this$tweakHex.toString(16);
        String string2 = usePrefix ? (bigIntN10.compareTo($this$tweakHex) < 0 && $this$tweakHex.compareTo(bigInt10) < 0 ? "0x0" : "0x") : (prefix = bigIntN10.compareTo($this$tweakHex) > 0 && $this$tweakHex.compareTo(bigInt10) < 0 ? "0" : "");
        if (toUpperCase) {
            StringBuilder stringBuilder = new StringBuilder().append(prefix);
            Intrinsics.checkNotNullExpressionValue((Object)asHex, (String)"asHex");
            String string3 = asHex.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            string = stringBuilder.append(string3).toString();
        } else {
            string = prefix + asHex;
        }
        return string;
    }

    public static /* synthetic */ String tweakHex$HexUtilities$default(Hex hex, BigInteger bigInteger, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return hex.tweakHex$HexUtilities(bigInteger, bl, bl2);
    }

    static {
        Updates.INSTANCE.add(Hex.class, "e52265b05ab54361a011ca8d406b9db9", version);
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        HEX_CHARS = cArray;
        cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        UPPER_HEX_CHARS = cArray;
        HEX_REGEX = new Regex("(0[xX])?[0-9a-fA-F]+");
        char[] cArray2 = "0x".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
        prefix = cArray2;
        bigInt10 = BigInteger.valueOf(10L);
        bigIntN10 = BigInteger.valueOf(-10L);
    }
}

