/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.luaAst;

import de.peeeq.wurstscript.luaAst.Element;
import de.peeeq.wurstscript.luaAst.LuaExpr;
import de.peeeq.wurstscript.luaAst.LuaExprFuncRef;
import de.peeeq.wurstscript.luaAst.LuaExprFunctionAbstraction;
import de.peeeq.wurstscript.luaAst.LuaExprFunctionCall;
import de.peeeq.wurstscript.luaAst.LuaExprMethodCall;
import de.peeeq.wurstscript.luaAst.LuaExprOpt;
import de.peeeq.wurstscript.luaAst.LuaExprVarAccess;
import de.peeeq.wurstscript.luaAst.LuaFunction;
import de.peeeq.wurstscript.luaAst.LuaMethod;
import de.peeeq.wurstscript.luaAst.LuaParams;
import de.peeeq.wurstscript.luaAst.LuaStatement;
import de.peeeq.wurstscript.luaAst.LuaStatements;
import de.peeeq.wurstscript.luaAst.LuaVariable;
import de.peeeq.wurstscript.translation.lua.printing.LuaPrinter;
import java.util.function.Consumer;

class LuaExprFunctionAbstractionImpl
implements LuaExprFunctionAbstraction {
    private Element parent;
    private LuaParams params;
    private LuaStatements body;

    LuaExprFunctionAbstractionImpl(LuaParams params, LuaStatements body) {
        if (params == null) {
            throw new IllegalArgumentException("Element params must not be null.");
        }
        if (body == null) {
            throw new IllegalArgumentException("Element body must not be null.");
        }
        this.params = params;
        this.body = body;
        params.setParent(this);
        body.setParent(this);
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree.Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    @Override
    public void replaceBy(Element other) {
        if (this.parent == null) {
            throw new RuntimeException("Node not attached to tree.");
        }
        for (int i = 0; i < this.parent.size(); ++i) {
            if (this.parent.get(i) != this) continue;
            this.parent.set(i, other);
            return;
        }
    }

    @Override
    public void setParams(LuaParams params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        this.params.setParent(null);
        params.setParent(this);
        this.params = params;
    }

    @Override
    public LuaParams getParams() {
        return this.params;
    }

    @Override
    public void setBody(LuaStatements body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        this.body.setParent(null);
        body.setParent(this);
        this.body = body;
    }

    @Override
    public LuaStatements getBody() {
        return this.body;
    }

    @Override
    public Element get(int i) {
        switch (i) {
            case 0: {
                return this.params;
            }
            case 1: {
                return this.body;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public Element set(int i, Element newElem) {
        switch (i) {
            case 0: {
                LuaParams oldElem = this.params;
                this.setParams((LuaParams)newElem);
                return oldElem;
            }
            case 1: {
                LuaStatements oldElem = this.body;
                this.setBody((LuaStatements)newElem);
                return oldElem;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public void forEachElement(Consumer<? super Element> action) {
        action.accept(this.params);
        action.accept(this.body);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public LuaExprFunctionAbstraction copy() {
        LuaExprFunctionAbstractionImpl result = new LuaExprFunctionAbstractionImpl(this.params.copy(), this.body.copy());
        return result;
    }

    @Override
    public LuaExprFunctionAbstraction copyWithRefs() {
        final LuaExprFunctionAbstraction res = this.copy();
        final LuaExprFunctionAbstractionImpl self = this;
        res.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(LuaExprMethodCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getMethod(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setMethod((LuaMethod)res.followPath(self.pathTo(e.getMethod())));
                }
            }

            @Override
            public void visit(LuaExprFunctionCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }

            @Override
            public void visit(LuaExprVarAccess e) {
                Element elem;
                super.visit(e);
                for (elem = e.getVar(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setVar((LuaVariable)res.followPath(self.pathTo(e.getVar())));
                }
            }

            @Override
            public void visit(LuaExprFuncRef e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }
        });
        return res;
    }

    @Override
    public void clearAttributes() {
        this.params.clearAttributes();
        this.body.clearAttributes();
        this.clearAttributesLocal();
    }

    @Override
    public void clearAttributesLocal() {
    }

    @Override
    public void accept(Element.Visitor v) {
        v.visit(this);
    }

    @Override
    public <T> T match(LuaStatement.Matcher<T> matcher) {
        return matcher.case_LuaExprFunctionAbstraction(this);
    }

    @Override
    public void match(LuaStatement.MatcherVoid matcher) {
        matcher.case_LuaExprFunctionAbstraction(this);
    }

    @Override
    public <T> T match(LuaExpr.Matcher<T> matcher) {
        return matcher.case_LuaExprFunctionAbstraction(this);
    }

    @Override
    public void match(LuaExpr.MatcherVoid matcher) {
        matcher.case_LuaExprFunctionAbstraction(this);
    }

    @Override
    public <T> T match(LuaExprOpt.Matcher<T> matcher) {
        return matcher.case_LuaExprFunctionAbstraction(this);
    }

    @Override
    public void match(LuaExprOpt.MatcherVoid matcher) {
        matcher.case_LuaExprFunctionAbstraction(this);
    }

    @Override
    public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaExprFunctionAbstraction(this);
    }

    @Override
    public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaExprFunctionAbstraction(this);
    }

    public String toString() {
        return "LuaExprFunctionAbstraction(" + this.params + ", " + this.body + ")";
    }

    @Override
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaExprFunctionAbstraction) {
            LuaExprFunctionAbstraction o = (LuaExprFunctionAbstraction)e;
            return this.params.structuralEquals(o.getParams()) && this.body.structuralEquals(o.getBody());
        }
        return false;
    }

    @Override
    public void print(StringBuilder sb, int indent) {
        LuaPrinter.print(this, sb, indent);
    }
}

