/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import de.peeeq.wurstscript.ast.Ast;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprFunctionCall;
import de.peeeq.wurstscript.ast.ExprMemberArrayVar;
import de.peeeq.wurstscript.ast.ExprMemberMethod;
import de.peeeq.wurstscript.ast.ExprMemberVar;
import de.peeeq.wurstscript.ast.ExprThis;
import de.peeeq.wurstscript.ast.ExprVarAccess;
import de.peeeq.wurstscript.ast.ExprVarArrayAccess;
import de.peeeq.wurstscript.ast.ExtensionFuncDef;
import de.peeeq.wurstscript.ast.FunctionCall;
import de.peeeq.wurstscript.ast.HasReceiver;
import de.peeeq.wurstscript.ast.NameRef;
import de.peeeq.wurstscript.ast.OptExpr;
import de.peeeq.wurstscript.ast.VarDef;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.types.WurstType;
import org.eclipse.jdt.annotation.Nullable;

public class AttrImplicitParameter {
    public static OptExpr getImplicitParameter(ExprMemberVar e) {
        Expr result = AttrImplicitParameter.getImplicitParameterUsingLeft(e);
        if (result == null) {
            return AttrImplicitParameter.getImplicitParamterCaseNormalVar(e);
        }
        return result;
    }

    public static OptExpr getImplicitParameter(ExprMemberArrayVar e) {
        Expr result = AttrImplicitParameter.getImplicitParameterUsingLeft(e);
        if (result == null) {
            return AttrImplicitParameter.getImplicitParamterCaseNormalVar(e);
        }
        return result;
    }

    public static OptExpr getImplicitParameter(ExprVarAccess e) {
        return AttrImplicitParameter.getImplicitParamterCaseNormalVar(e);
    }

    public static OptExpr getImplicitParameter(ExprVarArrayAccess e) {
        return AttrImplicitParameter.getImplicitParamterCaseNormalVar(e);
    }

    public static OptExpr getImplicitParameter(ExprFunctionCall e) {
        return AttrImplicitParameter.getImplicitParameterCaseNormalFunctionCall(e);
    }

    public static OptExpr getImplicitParameter(ExprMemberMethod e) {
        Expr result = AttrImplicitParameter.getImplicitParameterUsingLeft(e);
        if (result == null) {
            return AttrImplicitParameter.getImplicitParameterCaseNormalFunctionCall(e);
        }
        FuncLink calledFunc = e.attrFuncLink();
        if (calledFunc != null && !calledFunc.getDef().attrIsDynamicClassMember() && !(calledFunc.getDef() instanceof ExtensionFuncDef)) {
            e.addError("Cannot call static method " + e.getFuncName() + " on an object.");
        }
        return result;
    }

    private static @Nullable Expr getImplicitParameterUsingLeft(HasReceiver e) {
        if (e.getLeft().attrTyp().isStaticRef()) {
            return null;
        }
        return e.getLeft();
    }

    private static OptExpr getImplicitParameterCaseNormalFunctionCall(FunctionCall e) {
        FuncLink calledFunc = e.attrFuncLink();
        return AttrImplicitParameter.getFunctionCallImplicitParameter(e, calledFunc, true);
    }

    static OptExpr getFunctionCallImplicitParameter(FunctionCall e, FuncLink calledFunc, boolean showError) {
        HasReceiver hasReceiver;
        Expr res;
        if (e instanceof HasReceiver && (res = AttrImplicitParameter.getImplicitParameterUsingLeft(hasReceiver = (HasReceiver)((Object)e))) != null) {
            return res;
        }
        if (calledFunc == null) {
            return Ast.NoExpr();
        }
        if (calledFunc.getDef().attrIsDynamicClassMember()) {
            if (e.attrIsDynamicContext()) {
                ExprThis t = Ast.ExprThis(e.getSource());
                t.setParent(e);
                if (showError && !t.attrTyp().isSubtypeOf(calledFunc.getReceiverType(), e)) {
                    e.addError("Cannot access dynamic function " + e.getFuncName() + " from context of type " + t.attrTyp() + ".");
                }
                return t;
            }
            if (showError) {
                e.addError("Cannot call dynamic function " + e.getFuncName() + " from static context.");
            }
            return Ast.NoExpr();
        }
        return Ast.NoExpr();
    }

    private static OptExpr getImplicitParamterCaseNormalVar(NameRef e) {
        VarDef varDef;
        NameLink def = e.attrNameLink();
        if (def != null && def.getDef() instanceof VarDef && (varDef = (VarDef)def.getDef()).attrIsDynamicClassMember()) {
            if (e.attrIsDynamicContext()) {
                ExprThis t = Ast.ExprThis(e.getSource());
                t.setParent(e);
                WurstType thisType = t.attrTyp();
                if (!def.receiverCompatibleWith(thisType, e)) {
                    e.addError("Cannot access dynamic variable " + varDef.getName() + " from context of type " + thisType + ".");
                }
                return t;
            }
            e.addError("Cannot access dynamic variable " + varDef.getName() + " from static context.");
            return Ast.NoExpr();
        }
        return Ast.NoExpr();
    }
}

