/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver;

import com.google.common.io.Files;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstscript.WLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;

public class BufferManager {
    private final Map<WFile, StringBuilder> currentBuffer = new HashMap<WFile, StringBuilder>();
    private final Map<WFile, Integer> latestVersion = new HashMap<WFile, Integer>();

    public synchronized String getBuffer(TextDocumentIdentifier textDocument) {
        WFile uri = WFile.create(textDocument.getUri());
        return this.getBuffer(uri);
    }

    public String getBuffer(WFile uri) {
        StringBuilder sb = this.currentBuffer.get(uri);
        if (sb == null) {
            return this.readFileFromDisk(uri);
        }
        return sb.toString();
    }

    private StringBuilder buffer(WFile uri) {
        return this.currentBuffer.computeIfAbsent(uri, k -> new StringBuilder());
    }

    synchronized void handleFileChange(FileEvent fileEvent) {
        WFile uri = WFile.create(fileEvent.getUri());
        switch (fileEvent.getType()) {
            case Created: 
            case Changed: {
                this.readFileFromDisk(uri);
            }
            case Deleted: {
                this.currentBuffer.remove(uri);
            }
        }
    }

    private String readFileFromDisk(WFile uri) {
        try {
            File file;
            try {
                file = uri.getFile();
            }
            catch (FileNotFoundException e) {
                WLogger.info("URI " + uri + " cannot be opened by Wurst: " + e);
                return "";
            }
            String str = Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
            StringBuilder sb = this.buffer(uri);
            sb.replace(0, sb.length(), str);
            return sb.toString();
        }
        catch (IOException e) {
            WLogger.severe("Could not read file " + uri);
            WLogger.severe(e);
            throw new RuntimeException(e);
        }
    }

    synchronized void handleChange(DidChangeTextDocumentParams params) {
        WFile uri = WFile.create(params.getTextDocument().getUri());
        int version = params.getTextDocument().getVersion();
        if (version < this.getTextDocumentVersion(uri)) {
            return;
        }
        this.latestVersion.put(uri, version);
        StringBuilder sb = this.buffer(uri);
        for (TextDocumentContentChangeEvent contentChange : params.getContentChanges()) {
            if (contentChange.getRange() == null) {
                sb.replace(0, sb.length(), contentChange.getText());
                continue;
            }
            int start = this.getOffset(sb, contentChange.getRange().getStart());
            int end = this.getOffset(sb, contentChange.getRange().getEnd());
            sb.replace(start, end - start, contentChange.getText());
        }
    }

    public synchronized int getTextDocumentVersion(WFile uri) {
        return this.latestVersion.getOrDefault(uri, -1);
    }

    private int getOffset(StringBuilder sb, Position position) {
        int line = 1;
        for (int pos = 0; pos < sb.length() && line < position.getLine(); ++pos) {
            if (sb.charAt(pos) != '\n') continue;
            ++line;
        }
        return Math.min(pos += position.getCharacter(), sb.length() - 1);
    }

    public synchronized void updateFile(WFile wFile, String contents) {
        StringBuilder sb = this.buffer(wFile);
        sb.replace(0, sb.length(), contents);
    }
}

