/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.lua.translation;

import de.peeeq.wurstscript.jassIm.ImExitwhen;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImIf;
import de.peeeq.wurstscript.jassIm.ImLoop;
import de.peeeq.wurstscript.jassIm.ImReturn;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImTupleType;
import de.peeeq.wurstscript.jassIm.ImVarargLoop;
import de.peeeq.wurstscript.luaAst.LuaAst;
import de.peeeq.wurstscript.luaAst.LuaExpr;
import de.peeeq.wurstscript.luaAst.LuaIf;
import de.peeeq.wurstscript.luaAst.LuaStatement;
import de.peeeq.wurstscript.luaAst.LuaTableConstructor;
import de.peeeq.wurstscript.luaAst.LuaVariable;
import de.peeeq.wurstscript.translation.lua.translation.ExprTranslation;
import de.peeeq.wurstscript.translation.lua.translation.LuaTranslator;
import java.util.List;

public class StmtTranslation {
    public static void translate(ImExpr e, List<LuaStatement> res, LuaTranslator tr) {
        LuaExpr expr = e.translateToLua(tr);
        res.add(expr);
    }

    public static void translate(ImExitwhen s, List<LuaStatement> res, LuaTranslator tr) {
        LuaIf r = LuaAst.LuaIf(s.getCondition().translateToLua(tr), LuaAst.LuaStatements(LuaAst.LuaBreak()), LuaAst.LuaStatements(new LuaStatement[0]));
        res.add(r);
    }

    public static void translate(ImLoop s, List<LuaStatement> res, LuaTranslator tr) {
        res.add(LuaAst.LuaWhile(LuaAst.LuaExprBoolVal(true), tr.translateStatements(s.getBody())));
    }

    public static void translate(ImIf s, List<LuaStatement> res, LuaTranslator tr) {
        res.add(LuaAst.LuaIf(s.getCondition().translateToLua(tr), tr.translateStatements(s.getThenBlock()), tr.translateStatements(s.getElseBlock())));
    }

    public static void translate(ImReturn s, List<LuaStatement> res, LuaTranslator tr) {
        res.add(LuaAst.LuaReturn(tr.translateOptional(s.getReturnValue())));
    }

    public static void translate(ImSet s, List<LuaStatement> res, LuaTranslator tr) {
        LuaExpr left = s.getLeft().translateToLua(tr);
        LuaExpr right = s.getRight().translateToLua(tr);
        if (s.getRight().attrTyp() instanceof ImTupleType) {
            ImTupleType tt = (ImTupleType)s.getRight().attrTyp();
            if (!(right instanceof LuaTableConstructor)) {
                right = LuaAst.LuaExprFunctionCall(ExprTranslation.getTupleCopyFunc(tt, tr), LuaAst.LuaExprlist(right));
            }
        }
        res.add(LuaAst.LuaAssignment(left, right));
    }

    public static void translate(ImVarargLoop loop, List<LuaStatement> res, LuaTranslator tr) {
        LuaVariable loopVar = tr.luaVar.getFor(loop.getLoopVar());
        LuaVariable i = LuaAst.LuaVariable(tr.uniqueName("i"), LuaAst.LuaExprIntVal("0"));
        res.add(LuaAst.LuaLiteral("local __args = table.pack(...)"));
        res.add(LuaAst.LuaLiteral("for " + i.getName() + "=1,__args.n do"));
        res.add(LuaAst.LuaAssignment(LuaAst.LuaExprVarAccess(loopVar), LuaAst.LuaExprArrayAccess(LuaAst.LuaLiteral("__args"), LuaAst.LuaExprlist(LuaAst.LuaExprVarAccess(i)))));
        tr.translateStatements(res, loop.getBody());
        res.add(LuaAst.LuaLiteral("end"));
    }
}

