/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.parser.antlr;

import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.antlr.WurstParser;
import de.peeeq.wurstscript.ast.Arguments;
import de.peeeq.wurstscript.ast.Ast;
import de.peeeq.wurstscript.ast.AstElementWithArgs;
import de.peeeq.wurstscript.ast.AstElementWithIndexes;
import de.peeeq.wurstscript.ast.AstElementWithSource;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassDefs;
import de.peeeq.wurstscript.ast.ClassSlot;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.ConstructorDefs;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.EnumMember;
import de.peeeq.wurstscript.ast.EnumMembers;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprBinary;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprDestroy;
import de.peeeq.wurstscript.ast.ExprEmpty;
import de.peeeq.wurstscript.ast.ExprFuncRef;
import de.peeeq.wurstscript.ast.ExprFunctionCall;
import de.peeeq.wurstscript.ast.ExprIntVal;
import de.peeeq.wurstscript.ast.ExprList;
import de.peeeq.wurstscript.ast.ExprMemberMethod;
import de.peeeq.wurstscript.ast.ExprNewObject;
import de.peeeq.wurstscript.ast.ExprStatementsBlock;
import de.peeeq.wurstscript.ast.ExprVarAccess;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.FuncDefs;
import de.peeeq.wurstscript.ast.GlobalVarDef;
import de.peeeq.wurstscript.ast.GlobalVarDefs;
import de.peeeq.wurstscript.ast.Identifier;
import de.peeeq.wurstscript.ast.Indexes;
import de.peeeq.wurstscript.ast.InitBlock;
import de.peeeq.wurstscript.ast.JassGlobalBlock;
import de.peeeq.wurstscript.ast.JassToplevelDeclaration;
import de.peeeq.wurstscript.ast.JassToplevelDeclarations;
import de.peeeq.wurstscript.ast.LocalVarDef;
import de.peeeq.wurstscript.ast.Modifier;
import de.peeeq.wurstscript.ast.Modifiers;
import de.peeeq.wurstscript.ast.ModuleInstanciation;
import de.peeeq.wurstscript.ast.ModuleInstanciations;
import de.peeeq.wurstscript.ast.ModuleUse;
import de.peeeq.wurstscript.ast.ModuleUses;
import de.peeeq.wurstscript.ast.NameRef;
import de.peeeq.wurstscript.ast.NativeType;
import de.peeeq.wurstscript.ast.NoExpr;
import de.peeeq.wurstscript.ast.NoTypeExpr;
import de.peeeq.wurstscript.ast.OnDestroyDef;
import de.peeeq.wurstscript.ast.OptExpr;
import de.peeeq.wurstscript.ast.OptTypeExpr;
import de.peeeq.wurstscript.ast.StmtReturn;
import de.peeeq.wurstscript.ast.SuperConstructorCall;
import de.peeeq.wurstscript.ast.SwitchCase;
import de.peeeq.wurstscript.ast.SwitchCases;
import de.peeeq.wurstscript.ast.SwitchDefaultCase;
import de.peeeq.wurstscript.ast.TypeExpr;
import de.peeeq.wurstscript.ast.TypeExprList;
import de.peeeq.wurstscript.ast.TypeExprResolved;
import de.peeeq.wurstscript.ast.TypeParamConstraints;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.TypeParamDefs;
import de.peeeq.wurstscript.ast.VarInitialization;
import de.peeeq.wurstscript.ast.WEntities;
import de.peeeq.wurstscript.ast.WEntity;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WImports;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WPackages;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WParameters;
import de.peeeq.wurstscript.ast.WShortParameter;
import de.peeeq.wurstscript.ast.WShortParameters;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.ast.WStatements;
import de.peeeq.wurstscript.attributes.CompilationUnitInfo;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.attributes.ErrorHandler;
import de.peeeq.wurstscript.jass.AntlrJassParseTreeTransformer;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.parser.WPosWithComments;
import de.peeeq.wurstscript.types.WurstTypeInt;
import de.peeeq.wurstscript.utils.LineOffsets;
import de.peeeq.wurstscript.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.jdt.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class AntlrWurstParseTreeTransformer {
    private final String file;
    private final ErrorHandler cuErrorHandler;
    private final LineOffsets lineOffsets;
    private final Deque<Token> commentTokens;
    private final List<WPosWithComments> positions = new ArrayList<WPosWithComments>();
    private final boolean storeComments;

    public AntlrWurstParseTreeTransformer(String file, ErrorHandler cuErrorHandler, LineOffsets lineOffsets, Deque<Token> commentTokens, boolean storeComments) {
        this.file = file;
        this.cuErrorHandler = cuErrorHandler;
        this.lineOffsets = lineOffsets;
        this.commentTokens = commentTokens;
        this.storeComments = storeComments;
    }

    public CompilationUnit transform(WurstParser.CompilationUnitContext cu) {
        JassToplevelDeclarations jassDecls = Ast.JassToplevelDeclarations(new JassToplevelDeclaration[0]);
        WPackages packages = Ast.WPackages(new WPackage[0]);
        try {
            for (WurstParser.TopLevelDeclarationContext decl : cu.decls) {
                if (decl.jassTopLevelDeclaration() != null) {
                    jassDecls.add(this.transformJassToplevelDecl(decl.jassTopLevelDeclaration()));
                    continue;
                }
                if (decl.wpackage() == null) continue;
                packages.add(this.transformPackage(decl.wpackage()));
            }
        }
        catch (CompileError e) {
            this.cuErrorHandler.sendError(e);
            WLogger.warning("Compilation error in parse tree transformer", e);
        }
        catch (NullPointerException e) {
            WLogger.warning("Error transforming compilation unit " + this.line(cu), e);
        }
        CompilationUnit res = Ast.CompilationUnit(new CompilationUnitInfo(this.cuErrorHandler), jassDecls, packages);
        this.addComments(res);
        return res;
    }

    private void addComments(CompilationUnit cu) {
        if (!this.storeComments || this.positions.isEmpty()) {
            return;
        }
        this.positions.sort(Comparator.comparing(WPos::getLeftPos).thenComparing(Comparator.comparing(WPos::getRightPos).reversed()));
        List positions2 = this.positions.stream().sorted(Comparator.comparing(WPos::getRightPos).thenComparing(Comparator.comparing(WPos::getLeftPos).reversed())).collect(Collectors.toList());
        int pos = 0;
        int pos2 = 0;
        block0: while (!this.commentTokens.isEmpty() && pos < this.positions.size()) {
            Token token = this.commentTokens.removeFirst();
            while (this.positions.get(pos).getLeftPos() < token.getStopIndex()) {
                if (++pos < this.positions.size()) continue;
                this.commentTokens.addFirst(token);
                break block0;
            }
            WPosWithComments posAfterComment = this.positions.get(pos);
            while (pos2 + 1 < positions2.size() && ((WPosWithComments)positions2.get(pos2 + 1)).getRightPos() < token.getStartIndex()) {
                if (++pos2 < positions2.size()) continue;
                this.commentTokens.addFirst(token);
                break block0;
            }
            WPosWithComments posBeforeComment = (WPosWithComments)positions2.get(pos2);
            WPosWithComments.Comment comment = this.tokenToComment(token);
            if (comment.getPos().getLine() == posBeforeComment.getEndLine()) {
                posBeforeComment.addCommentAfter(comment);
                continue;
            }
            posAfterComment.addCommentBefore(comment);
        }
        for (Token t : this.commentTokens) {
            ((WPosWithComments)Utils.getLast(positions2)).addCommentAfter(this.tokenToComment(t));
        }
    }

    private JassToplevelDeclaration transformJassToplevelDecl(WurstParser.JassTopLevelDeclarationContext d) {
        if (d.jassFuncDef() != null) {
            return this.transformJassFuncDef(d.jassFuncDef());
        }
        if (d.jassGlobalsBlock() != null) {
            return this.transformJassGlobalsBlock(d.jassGlobalsBlock());
        }
        if (d.jassNativeDecl() != null) {
            return this.transformJassNativeDecl(d.jassNativeDecl());
        }
        if (d.jassTypeDecl() != null) {
            return this.transformJassTypeDecl(d.jassTypeDecl());
        }
        throw this.error(d, "unhandled case: " + this.text(d));
    }

    private Identifier text(@Nullable Token t) {
        if (t == null) {
            return Ast.Identifier(new WPos(this.file, this.lineOffsets, 1, 0), "");
        }
        return Ast.Identifier(this.source(t), t.getText());
    }

    private Identifier text(@Nullable ParserRuleContext c) {
        if (c == null) {
            return Ast.Identifier(new WPos(this.file, this.lineOffsets, 1, 0), "");
        }
        return Ast.Identifier(this.source(c), c.getText());
    }

    private String rawText(@Nullable ParserRuleContext c) {
        if (c == null) {
            return "";
        }
        return c.getText();
    }

    private String rawText(@Nullable Token c) {
        if (c == null) {
            return "";
        }
        return c.getText();
    }

    private JassToplevelDeclaration transformJassTypeDecl(WurstParser.JassTypeDeclContext t) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        Identifier name = this.text(t.name);
        OptTypeExpr optTyp = this.transformOptionalType(t.typeExpr());
        return Ast.NativeType(this.source(t), modifiers, name, optTyp);
    }

    private JassToplevelDeclaration transformJassNativeDecl(WurstParser.JassNativeDeclContext n) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        FuncSig sig = this.transformFuncSig(n.jassFuncSignature());
        return Ast.NativeFunc(this.source(n), modifiers, sig.name, sig.formalParameters, sig.returnType);
    }

    private JassToplevelDeclaration transformJassGlobalsBlock(WurstParser.JassGlobalsBlockContext g) {
        JassGlobalBlock result = Ast.JassGlobalBlock(new GlobalVarDef[0]);
        for (WurstParser.JassGlobalDeclContext v : g.jassGlobalDecl()) {
            Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
            if (v.constant != null) {
                modifiers.add(Ast.ModConstant(this.source(v.constant)));
            }
            OptTypeExpr optTyp = this.transformOptionalType(v.typeExpr());
            Identifier name = this.text(v.name);
            OptExpr initialExpr = this.transformOptionalExpr(v.initial);
            result.add(Ast.GlobalVarDef(this.source(v), modifiers, optTyp, name, initialExpr));
        }
        return result;
    }

    private JassToplevelDeclaration transformJassFuncDef(WurstParser.JassFuncDefContext f) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        FuncSig sig = this.transformFuncSig(f.jassFuncSignature());
        WStatements body = this.transformJassLocals(f.jassLocals);
        body.addAll((Collection)this.transformJassStatements(f.jassStatements()).removeAll());
        return Ast.FuncDef(this.source(f), modifiers, sig.name, sig.typeParams, sig.formalParameters, sig.returnType, body);
    }

    private WStatements transformJassLocals(List<WurstParser.JassLocalContext> jassLocals) {
        WStatements result = Ast.WStatements(new WStatement[0]);
        for (WurstParser.JassLocalContext l : jassLocals) {
            Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
            OptTypeExpr optTyp = this.transformOptionalType(l.typeExpr());
            Identifier name = this.text(l.name);
            OptExpr initialExpr = this.transformOptionalExpr(l.initial);
            result.add(Ast.LocalVarDef(this.source(l), modifiers, optTyp, name, initialExpr));
        }
        return result;
    }

    private WStatements transformJassStatements(WurstParser.JassStatementsContext stmts) {
        WStatements result = Ast.WStatements(new WStatement[0]);
        if (stmts != null && stmts.jassStatement() != null) {
            for (WurstParser.JassStatementContext s : stmts.jassStatement()) {
                result.add(this.transformJassStatement(s));
            }
        }
        return result;
    }

    private WStatement transformJassStatement(WurstParser.JassStatementContext s) {
        try {
            if (s.jassStatementCall() != null) {
                return this.transformJassStatementCall(s.jassStatementCall());
            }
            if (s.jassStatementExithwhen() != null) {
                return this.transformJassStatementExitwhen(s.jassStatementExithwhen());
            }
            if (s.jassStatementIf() != null) {
                return this.transformJassStatementIf(s.jassStatementIf());
            }
            if (s.jassStatementLoop() != null) {
                return this.transformJassStatementLoop(s.jassStatementLoop());
            }
            if (s.jassStatementReturn() != null) {
                return this.transformJassStatementReturn(s.jassStatementReturn());
            }
            if (s.jassStatementSet() != null) {
                return this.transformJassStatementSet(s.jassStatementSet());
            }
        }
        catch (NullPointerException t) {
            WLogger.warning("Error when transforming statement " + this.line(s), t);
            return Ast.StmtErr(this.source(s));
        }
        throw this.error(s, "unhandled case: " + this.text(s));
    }

    private String line(ParserRuleContext s) {
        if (s == null) {
            return "file " + this.file;
        }
        Token start = s.start;
        if (start == null) {
            return "file " + this.file;
        }
        return "file " + this.file + ", line " + start.getLine();
    }

    private WStatement transformJassStatementSet(WurstParser.JassStatementSetContext s) {
        return Ast.StmtSet(this.source(s), this.transformAssignable(s.left), this.transformExpr(s.right));
    }

    private WStatement transformJassStatementReturn(WurstParser.JassStatementReturnContext s) {
        OptExpr r = this.transformOptionalExpr(s.expr());
        if (r instanceof ExprEmpty) {
            r = Ast.NoExpr();
        }
        return Ast.StmtReturn(this.source(s), r);
    }

    private WStatement transformJassStatementLoop(WurstParser.JassStatementLoopContext s) {
        return Ast.StmtLoop(this.source(s), this.transformJassStatements(s.jassStatements()));
    }

    private WStatement transformJassStatementIf(WurstParser.JassStatementIfContext s) {
        WStatements thenBlock = this.transformJassStatements(s.thenStatements);
        WStatements elseBlock = this.transformJassElseIfs(s.jassElseIfs());
        return Ast.StmtIf(this.source(s), this.transformExpr(s.cond), thenBlock, elseBlock, !this.isEndif(s.jassElseIfs()));
    }

    private boolean isEndif(WurstParser.JassElseIfsContext s) {
        return s.JASS_ELSEIF() != null;
    }

    private WStatements transformJassElseIfs(WurstParser.JassElseIfsContext s) {
        if (s == null) {
            return Ast.WStatements(new WStatement[0]);
        }
        if (s.cond != null) {
            return Ast.WStatements(Ast.StmtIf(this.source(s), this.transformExpr(s.cond), this.transformJassStatements(s.thenStatements), this.transformJassElseIfs(s.jassElseIfs()), !this.isEndif(s.jassElseIfs())));
        }
        if (s.elseStmts != null) {
            return this.transformJassStatements(s.elseStmts);
        }
        return Ast.WStatements(new WStatement[0]);
    }

    private WStatement transformJassStatementExitwhen(WurstParser.JassStatementExithwhenContext s) {
        return Ast.StmtExitwhen(this.source(s), this.transformExpr(s.cond));
    }

    private WStatement transformJassStatementCall(WurstParser.JassStatementCallContext s) {
        return this.transformFunctionCall(s.exprFunctionCall());
    }

    private WPackage transformPackage(WurstParser.WpackageContext p) {
        WPos source = this.source(p);
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        WImports imports = Ast.WImports(new WImport[0]);
        for (WurstParser.WImportContext i : p.imports) {
            imports.add(this.transformImport(i));
        }
        WEntities elements = Ast.WEntities(new WEntity[0]);
        for (WurstParser.EntityContext e : p.entities) {
            WEntity en = this.transformEntity(e);
            if (en == null) continue;
            elements.add(en);
        }
        return Ast.WPackage(source, modifiers, this.text(p.name), imports, elements);
    }

    private @Nullable WEntity transformEntity(WurstParser.EntityContext e) {
        try {
            if (e.nativeType() != null) {
                return this.transformNativeType(e.nativeType());
            }
            if (e.funcDef() != null) {
                return this.transformFuncDef(e.funcDef());
            }
            if (e.varDef() != null) {
                return this.transformVardef(e.varDef());
            }
            if (e.initBlock() != null) {
                return this.transformInit(e.initBlock());
            }
            if (e.nativeDef() != null) {
                return this.transformNativeDef(e.nativeDef());
            }
            if (e.classDef() != null) {
                return this.transformClassDef(e.classDef());
            }
            if (e.enumDef() != null) {
                return this.transformEnumDef(e.enumDef());
            }
            if (e.moduleDef() != null) {
                return this.transformModuleDef(e.moduleDef());
            }
            if (e.interfaceDef() != null) {
                return this.transformInterfaceDef(e.interfaceDef());
            }
            if (e.tupleDef() != null) {
                return this.transformTupleDef(e.tupleDef());
            }
            if (e.extensionFuncDef() != null) {
                return this.transformExtensionFuncDef(e.extensionFuncDef());
            }
            if (e.exception != null) {
                return null;
            }
            throw this.error(e, "not implemented " + this.text(e));
        }
        catch (NullPointerException npe) {
            WLogger.warning("Error transforming entity in line " + this.line(e), npe);
            return null;
        }
    }

    private WEntity transformExtensionFuncDef(WurstParser.ExtensionFuncDefContext f) {
        WPos src = this.source(f);
        Modifiers modifiers = this.transformModifiers(f.modifiersWithDoc());
        TypeExpr extendedType = this.transformTypeExpr(f.receiverType);
        FuncSig sig = this.transformFuncSig(f.funcSignature());
        WStatements body = this.transformStatements(f.statementsBlock());
        return Ast.ExtensionFuncDef(src, modifiers, extendedType, sig.name, sig.typeParams, sig.formalParameters, sig.returnType, body);
    }

    private Modifiers transformModifiers(WurstParser.ModifiersWithDocContext ms) {
        Modifiers result = Ast.Modifiers(new Modifier[0]);
        if (ms.hotdocComment() != null) {
            result.add(Ast.WurstDoc(this.source(ms.hotdocComment()), ms.hotdocComment().getText()));
        }
        for (WurstParser.ModifierContext m : ms.modifiers) {
            result.add(this.transformModifier(m));
        }
        return result;
    }

    private Modifier transformModifier(WurstParser.ModifierContext m) {
        WPos src = this.source(m);
        if (m.annotation() != null) {
            return Ast.Annotation(src, Ast.Identifier(this.source(m.annotation().name), m.annotation().name.getText().substring(1).toLowerCase()), this.transformArgumentList(m.annotation().argumentList()));
        }
        switch (m.modType.getType()) {
            case 18: {
                return Ast.VisibilityPublic(src);
            }
            case 20: {
                return Ast.VisibilityPrivate(src);
            }
            case 21: {
                return Ast.VisibilityProtected(src);
            }
            case 19: {
                return Ast.VisibilityPublicread(src);
            }
            case 32: {
                return Ast.ModStatic(src);
            }
            case 34: {
                return Ast.ModOverride(src);
            }
            case 31: {
                return Ast.ModAbstract(src);
            }
            case 46: {
                return Ast.ModConstant(src);
            }
            case 3: {
                return Ast.ModVararg(src);
            }
        }
        throw this.error(m, "not implemented");
    }

    private WEntity transformTupleDef(WurstParser.TupleDefContext t) {
        WPos src = this.source(t);
        Modifiers modifiers = this.transformModifiers(t.modifiersWithDoc());
        Identifier name = this.text(t.name);
        WParameters parameters = this.transformFormalParameters(t.formalParameters(), false);
        NoTypeExpr returnTyp = Ast.NoTypeExpr();
        return Ast.TupleDef(src, modifiers, name, parameters, returnTyp);
    }

    private WEntity transformInterfaceDef(WurstParser.InterfaceDefContext i) {
        WPos src = this.source(i);
        Modifiers modifiers = this.transformModifiers(i.modifiersWithDoc());
        Identifier name = this.text(i.name);
        TypeParamDefs typeParameters = this.transformTypeParams(i.typeParams());
        TypeExprList extendsList = Ast.TypeExprList(new TypeExpr[0]);
        for (WurstParser.TypeExprContext ex : i.extended) {
            extendsList.add(this.transformTypeExpr(ex));
        }
        ClassSlotResult slots = this.transformClassSlots(src, i.classSlots());
        return Ast.InterfaceDef(src, modifiers, name, typeParameters, extendsList, slots.methods, slots.vars, slots.constructors, slots.moduleInstanciations, slots.moduleUses, slots.onDestroy);
    }

    private ClassSlotResult transformClassSlots(WPos src, WurstParser.ClassSlotsContext slots) {
        ClassSlotResult result = new ClassSlotResult();
        if (slots != null && slots.slots != null) {
            for (WurstParser.ClassSlotContext slot : slots.slots) {
                ClassSlot s = this.transformClassSlot(slot);
                if (s instanceof ConstructorDef) {
                    result.constructors.add((ConstructorDef)s);
                    continue;
                }
                if (s instanceof FuncDef) {
                    result.methods.add((FuncDef)s);
                    continue;
                }
                if (s instanceof ModuleUse) {
                    result.moduleUses.add((ModuleUse)s);
                    continue;
                }
                if (s instanceof OnDestroyDef) {
                    if (result.onDestroy == null) {
                        result.onDestroy = (OnDestroyDef)s;
                        continue;
                    }
                    throw new CompileError(s.attrSource(), "ondestroy already defined.");
                }
                if (s instanceof GlobalVarDef) {
                    result.vars.add((GlobalVarDef)s);
                    continue;
                }
                if (s instanceof ClassDef) {
                    result.innerClasses.add((ClassDef)s);
                    continue;
                }
                if (s == null) continue;
                throw this.error(slot, "unexpected classslot: " + s.getClass().getSimpleName());
            }
        }
        if (result.onDestroy == null) {
            result.onDestroy = Ast.OnDestroyDef(src.artificial(), Ast.WStatements(new WStatement[0]));
        }
        return result;
    }

    private ClassSlot transformClassSlot(WurstParser.ClassSlotContext s) {
        try {
            if (s.constructorDef() != null) {
                return this.transformConstructorDef(s.constructorDef());
            }
            if (s.moduleUse() != null) {
                return this.transformModuleUse(s.moduleUse());
            }
            if (s.ondestroyDef() != null) {
                return this.transformOndestroyDef(s.ondestroyDef());
            }
            if (s.varDef() != null) {
                return this.transformVardef(s.varDef());
            }
            if (s.funcDef() != null) {
                return this.transformFuncDef(s.funcDef());
            }
            if (s.classDef() != null) {
                return this.transformClassDef(s.classDef());
            }
            if (s.exception != null) {
                return null;
            }
            throw this.error(s, "not matched: " + this.text(s));
        }
        catch (NullPointerException npe) {
            WLogger.warning("Error transforming classlot in " + this.line(s), npe);
            return null;
        }
    }

    private OnDestroyDef transformOndestroyDef(WurstParser.OndestroyDefContext o) {
        return Ast.OnDestroyDef(this.source(o), this.transformStatements(o.statementsBlock()));
    }

    private ClassSlot transformModuleUse(WurstParser.ModuleUseContext u) {
        return Ast.ModuleUse(this.source(u), this.text(u.moduleName), this.transformTypeArgs(u.typeArgs()));
    }

    private ConstructorDef transformConstructorDef(WurstParser.ConstructorDefContext c) {
        WPos source = this.source(c);
        Modifiers modifiers = this.transformModifiers(c.modifiersWithDoc());
        WParameters parameters = this.transformFormalParameters(c.formalParameters(), true);
        WStatements body = this.transformStatementList(c.stmts);
        SuperConstructorCall superCall = this.transformSuperCall(c.superCall());
        return Ast.ConstructorDef(source, modifiers, parameters, superCall, body);
    }

    private SuperConstructorCall transformSuperCall(WurstParser.SuperCallContext sc) {
        if (sc == null) {
            return Ast.NoSuperConstructorCall();
        }
        return Ast.SomeSuperConstructorCall(this.source(sc), this.source(sc.superKeyword), this.transformExprs(sc.superArgs));
    }

    private WStatements transformStatementList(List<WurstParser.StatementContext> stmts) {
        WStatements result = Ast.WStatements(new WStatement[0]);
        for (WurstParser.StatementContext s : stmts) {
            this.transformStatement(result, s);
        }
        return result;
    }

    private WEntity transformModuleDef(WurstParser.ModuleDefContext i) {
        WPos src = this.source(i);
        Modifiers modifiers = this.transformModifiers(i.modifiersWithDoc());
        Identifier name = this.text(i.name);
        TypeParamDefs typeParameters = this.transformTypeParams(i.typeParams());
        ClassSlotResult slots = this.transformClassSlots(src, i.classSlots());
        return Ast.ModuleDef(src, modifiers, name, typeParameters, slots.innerClasses, slots.methods, slots.vars, slots.constructors, slots.moduleInstanciations, slots.moduleUses, slots.onDestroy);
    }

    private WEntity transformEnumDef(WurstParser.EnumDefContext i) {
        WPos src = this.source(i);
        Modifiers modifiers = this.transformModifiers(i.modifiersWithDoc());
        Identifier name = this.text(i.name);
        EnumMembers members = Ast.EnumMembers(new EnumMember[0]);
        for (Token m : i.enumMembers) {
            members.add(Ast.EnumMember(this.source(m), Ast.Modifiers(new Modifier[0]), this.text(m)));
        }
        return Ast.EnumDef(src, modifiers, name, members);
    }

    private ClassDef transformClassDef(WurstParser.ClassDefContext i) {
        WPos src = this.source(i);
        Modifiers modifiers = this.transformModifiers(i.modifiersWithDoc());
        Identifier name = this.text(i.name);
        TypeParamDefs typeParameters = this.transformTypeParams(i.typeParams());
        OptTypeExpr extendedClass = this.transformOptionalType(i.extended);
        TypeExprList implementsList = Ast.TypeExprList(new TypeExpr[0]);
        for (WurstParser.TypeExprContext ex : i.implemented) {
            implementsList.add(this.transformTypeExpr(ex));
        }
        ClassSlotResult slots = this.transformClassSlots(src, i.classSlots());
        return Ast.ClassDef(src, modifiers, name, typeParameters, extendedClass, implementsList, slots.innerClasses, slots.methods, slots.vars, slots.constructors, slots.moduleInstanciations, slots.moduleUses, slots.onDestroy);
    }

    private NativeType transformNativeType(WurstParser.NativeTypeContext n) {
        OptTypeExpr extended = n.extended != null ? Ast.TypeExprSimple(this.source(n.extended), Ast.NoTypeExpr(), this.rawText(n.extended), Ast.TypeExprList(new TypeExpr[0])) : Ast.NoTypeExpr();
        return Ast.NativeType(this.source(n), Ast.Modifiers(new Modifier[0]), this.text(n.name), extended);
    }

    private FuncDef transformFuncDef(WurstParser.FuncDefContext f) {
        FuncSig sig = this.transformFuncSig(f.funcSignature());
        Modifiers modifiers = this.transformModifiers(f.modifiersWithDoc());
        WStatements body = this.transformStatements(f.statementsBlock());
        return Ast.FuncDef(this.source(f), modifiers, sig.name, sig.typeParams, sig.formalParameters, sig.returnType, body);
    }

    private GlobalVarDef transformVardef(WurstParser.VarDefContext v) {
        WPos source = this.source(v);
        Modifiers modifiers = this.transformModifiers(v.modifiersWithDoc());
        if (v.constant != null) {
            modifiers.add(Ast.ModConstant(this.source(v.constant)));
        }
        VarInitialization initialExpr = this.transformVarInit(v.variableInit());
        Identifier name = this.text(v.name);
        OptTypeExpr optTyp = this.transformOptionalType(v.varType);
        return Ast.GlobalVarDef(source, modifiers, optTyp, name, initialExpr);
    }

    private VarInitialization transformVarInit(WurstParser.VariableInitContext e) {
        if (e == null) {
            return Ast.NoExpr();
        }
        if (e.arrayInit() != null) {
            return this.transformArrayInit(e.arrayInit());
        }
        return this.transformExpr(e.initial);
    }

    private VarInitialization transformArrayInit(WurstParser.ArrayInitContext e) {
        return Ast.ArrayInitializer(this.source(e), this.transformExprlist(e.exprList()));
    }

    private ExprList transformExprlist(WurstParser.ExprListContext es) {
        return this.transformExprlist(es.exprs);
    }

    private ExprList transformExprlist(List<WurstParser.ExprContext> es) {
        ExprList result = Ast.ExprList(new Expr[0]);
        if (es != null) {
            for (WurstParser.ExprContext e : es) {
                result.add(this.transformExpr(e));
            }
        }
        if (result.size() == 1 && result.get(0) instanceof ExprEmpty) {
            result.clear();
        }
        return result;
    }

    private InitBlock transformInit(WurstParser.InitBlockContext i) {
        return Ast.InitBlock(this.source(i), this.transformStatements(i.statementsBlock()));
    }

    private WStatements transformStatements(WurstParser.StatementsBlockContext b) {
        WStatements result = Ast.WStatements(new WStatement[0]);
        if (b != null) {
            for (WurstParser.StatementContext s : b.statement()) {
                this.transformStatement(result, s);
            }
        }
        return result;
    }

    private void transformStatement(WStatements result, WurstParser.StatementContext s) {
        if (s.stmtSet() != null) {
            this.transformStmtSet(result, s.stmtSet());
        } else {
            result.add(this.transformStatement2(s));
        }
        WStatement ws = (WStatement)result.get(result.size() - 1);
        if (s.externalLambda() != null) {
            Expr lambda = this.transformExternalLambda(s.externalLambda());
            Element e = ws;
            while (true) {
                if (e instanceof AstElementWithSource) {
                    AstElementWithSource sourced = e;
                    sourced.setSource(sourced.getSource().withRightPos(lambda.getSource().getRightPos()));
                }
                if (e instanceof AstElementWithArgs) {
                    AstElementWithArgs fc = (AstElementWithArgs)e;
                    fc.getArgs().add(lambda);
                    return;
                }
                if (e instanceof ExprEmpty) {
                    e.replaceBy(lambda);
                    return;
                }
                if (e.size() == 0) break;
                e = e.get(e.size() - 1);
            }
            this.cuErrorHandler.sendError(new CompileError(this.source(s.externalLambda()), "External Lambda-block can only be used after function calls."));
        }
    }

    private Expr transformExternalLambda(WurstParser.ExternalLambdaContext el) {
        WShortParameters closureParams = this.transformShortFormalParameters(el.shortFormalParameters());
        WPos paramSource = this.source(el.shortFormalParameters());
        WPos source = this.source(el.statementsBlock()).withLeftPos(paramSource.getLeftPos());
        return Ast.ExprClosure(source, this.source(el.arrow), closureParams, Ast.ExprStatementsBlock(this.source(el.statementsBlock()), this.transformStatements(el.statementsBlock())));
    }

    private WStatement transformStatement2(WurstParser.StatementContext s) {
        if (s.stmtIf() != null) {
            return this.transformIf(s.stmtIf());
        }
        if (s.stmtWhile() != null) {
            return this.transformWhile(s.stmtWhile());
        }
        if (s.localVarDef() != null) {
            return this.transformLocalVarDef(s.localVarDef());
        }
        if (s.expr() != null) {
            Expr e = this.transformExpr(s.expr());
            if (e instanceof WStatement) {
                return (WStatement)((Object)e);
            }
            this.cuErrorHandler.sendError(new CompileError(this.source(s), Utils.printElement(e) + " cannot be used here. A full statement is required."));
            return Ast.StmtErr(this.source(s));
        }
        if (s.stmtReturn() != null) {
            return this.transformReturn(s.stmtReturn());
        }
        if (s.stmtForLoop() != null) {
            return this.transformForLoop(s.stmtForLoop());
        }
        if (s.stmtBreak() != null) {
            return Ast.StmtExitwhen(this.source(s), Ast.ExprBoolVal(this.source(s), true));
        }
        if (s.stmtSkip() != null) {
            return Ast.StmtSkip(this.source(s));
        }
        if (s.stmtSwitch() != null) {
            return this.transformSwitch(s.stmtSwitch());
        }
        if (s.exception != null) {
            return Ast.StmtErr(this.source(s));
        }
        throw this.error(s, "not implemented: " + this.text(s) + "\n" + s.toStringTree());
    }

    private WStatement transformSwitch(WurstParser.StmtSwitchContext s) {
        Expr expr = this.transformExpr(s.expr());
        SwitchCases cases = Ast.SwitchCases(new SwitchCase[0]);
        for (WurstParser.SwitchCaseContext c : s.switchCase()) {
            ExprList e = this.transformExprlist(c.expr());
            WStatements stmts = this.transformStatements(c.statementsBlock());
            cases.add(Ast.SwitchCase(this.source(c), e, stmts));
        }
        SwitchDefaultCase switchDefault = s.switchDefaultCase() != null ? Ast.SwitchDefaultCaseStatements(this.source(s.switchDefaultCase()), this.transformStatements(s.switchDefaultCase().statementsBlock())) : Ast.NoDefaultCase();
        return Ast.SwitchStmt(this.source(s), expr, cases, switchDefault);
    }

    private WStatement transformWhile(WurstParser.StmtWhileContext s) {
        return Ast.StmtWhile(this.source(s), this.transformExpr(s.cond), this.transformStatements(s.statementsBlock()));
    }

    private ExprDestroy transformExprDestroy(WurstParser.ExprDestroyContext e) {
        return Ast.ExprDestroy(this.source(e), this.transformExpr(e.expr()));
    }

    private StmtReturn transformReturn(WurstParser.StmtReturnContext s) {
        OptExpr r = this.transformOptionalExpr(s.expr());
        if (r instanceof ExprEmpty) {
            r = Ast.NoExpr();
        }
        return Ast.StmtReturn(this.source(s), r);
    }

    private boolean useTemporaryIndex(Expr idx) {
        return !(idx instanceof ExprIntVal) && !(idx instanceof ExprVarAccess);
    }

    private NameRef addTemporaryIndexes(WStatements result, WPos src, NameRef expr) {
        if (expr instanceof AstElementWithIndexes) {
            NameRef tempIndexExpr = expr.copy();
            Indexes indexes = ((AstElementWithIndexes)((Object)tempIndexExpr)).getIndexes();
            for (int i = 0; i < indexes.size(); ++i) {
                Expr idx = ((Expr)indexes.get(i)).copy();
                if (!this.useTemporaryIndex(idx)) continue;
                TypeExprResolved optTyp = Ast.TypeExprResolved(src, WurstTypeInt.instance());
                String tempName = "index_temp_" + idx.getSource().getLine() + "_" + idx.getSource().getStartColumn();
                Identifier identifier = Ast.Identifier(src, tempName);
                Modifiers modifiers = Ast.Modifiers(Ast.ModConstant(src));
                LocalVarDef local = Ast.LocalVarDef(src, modifiers, optTyp, identifier, idx);
                result.add(local);
                indexes.set(i, (Object)Ast.ExprVarAccess(src, identifier.copy()));
            }
            return tempIndexExpr;
        }
        return expr;
    }

    private void transformStmtSet(WStatements result, WurstParser.StmtSetContext s) {
        NameRef updatedExpr = this.transformAssignable(s.left);
        WPos src = this.source(s);
        if (s.assignOp != null) {
            Expr right = this.transformExpr(s.right);
            WurstOperator op = this.getAssignOp(s.assignOp);
            if (op != null) {
                updatedExpr = this.addTemporaryIndexes(result, src, updatedExpr);
                right = Ast.ExprBinary(src, updatedExpr.copy(), op, right);
                result.add(Ast.StmtSet(src, updatedExpr, right));
            } else {
                result.add(Ast.StmtSet(src, updatedExpr, right));
            }
            return;
        }
        if (s.incOp != null) {
            updatedExpr = this.addTemporaryIndexes(result, src, updatedExpr);
            ExprBinary right = Ast.ExprBinary(src, updatedExpr.copy(), WurstOperator.PLUS, Ast.ExprIntVal(src, "1"));
            result.add(Ast.StmtSet(src, updatedExpr, right));
            return;
        }
        if (s.decOp != null) {
            updatedExpr = this.addTemporaryIndexes(result, src, updatedExpr);
            ExprBinary right = Ast.ExprBinary(src, updatedExpr.copy(), WurstOperator.MINUS, Ast.ExprIntVal(src, "1"));
            result.add(Ast.StmtSet(src, updatedExpr, right));
            return;
        }
        throw this.error(s, "not implemented");
    }

    private WurstOperator getAssignOp(Token assignOp) {
        switch (assignOp.getType()) {
            case 114: {
                return WurstOperator.PLUS;
            }
            case 115: {
                return WurstOperator.MINUS;
            }
            case 116: {
                return WurstOperator.MULT;
            }
            case 117: {
                return WurstOperator.DIV_REAL;
            }
            case 107: {
                return null;
            }
        }
        throw this.error(this.source(assignOp), "unhandled assign op: " + this.text(assignOp));
    }

    private NameRef transformAssignable(WurstParser.ExprAssignableContext e) {
        if (e.exprMemberVar() != null) {
            return this.transformExprMemberVar(e.exprMemberVar());
        }
        if (e.exprVarAccess() != null) {
            return this.transformExprVarAccess(e.exprVarAccess());
        }
        throw this.error(e, "not implemented: " + this.text(e));
    }

    private NameRef transformExprVarAccess(WurstParser.ExprVarAccessContext e) {
        if (e.indexes() == null) {
            return Ast.ExprVarAccess(this.source(e), this.text(e.varname));
        }
        return Ast.ExprVarArrayAccess(this.source(e), this.text(e.varname), this.transformIndexes(e.indexes()));
    }

    private NameRef transformExprMemberVar(WurstParser.ExprMemberVarContext e) {
        return this.transformExprMemberVarAccess2(this.source(e), e.expr(), e.dots, e.varname, e.indexes());
    }

    private NameRef transformExprMemberVarAccess2(WPos source, WurstParser.ExprContext e_expr, Token e_dots, Token e_varname, @Nullable WurstParser.IndexesContext e_indexes) {
        Expr left = this.transformExpr(e_expr);
        Identifier varName = this.text(e_varname);
        if (e_indexes != null) {
            Indexes indexes = this.transformIndexes(e_indexes);
            if (e_dots.getType() == 99) {
                return Ast.ExprMemberArrayVarDot(source, left, varName, indexes);
            }
            return Ast.ExprMemberArrayVarDotDot(source, left, varName, indexes);
        }
        if (e_dots.getType() == 99) {
            return Ast.ExprMemberVarDot(source, left, varName);
        }
        return Ast.ExprMemberVarDotDot(source, left, varName);
    }

    private WStatement transformForLoop(WurstParser.StmtForLoopContext s) {
        if (s.forRangeLoop() != null) {
            return this.transformForRangeLoop(s.forRangeLoop());
        }
        if (s.forIteratorLoop() != null) {
            return this.transformForIteratorLoop(s.forIteratorLoop());
        }
        return Ast.StmtErr(this.source(s));
    }

    private WStatement transformForRangeLoop(WurstParser.ForRangeLoopContext s) {
        WPos source = this.source(s);
        LocalVarDef loopVar = this.transformLocalVarDef(s.loopVar);
        loopVar.setInitialExpr(this.transformExpr(s.start));
        Expr to = this.transformExpr(s.end);
        Expr step = s.step == null ? Ast.ExprIntVal(this.source(s.direction), "1") : this.transformExpr(s.step);
        WStatements body = this.transformStatements(s.statementsBlock());
        if (s.direction.getType() == 56) {
            return Ast.StmtForRangeUp(source, loopVar, to, step, body);
        }
        if (s.direction.getType() == 57) {
            return Ast.StmtForRangeDown(source, loopVar, to, step, body);
        }
        throw this.error(s, "not implemented: " + this.text(s));
    }

    private LocalVarDef transformLocalVarDef(WurstParser.LocalVarDefInlineContext v) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        OptTypeExpr optTyp = this.transformOptionalType(v.typeExpr());
        Identifier name = this.text(v.name);
        NoExpr initialExpr = Ast.NoExpr();
        return Ast.LocalVarDef(this.source(v), modifiers, optTyp, name, initialExpr);
    }

    private WStatement transformForIteratorLoop(WurstParser.ForIteratorLoopContext s) {
        WPos source = this.source(s);
        LocalVarDef loopVar = this.transformLocalVarDef(s.loopVar);
        Expr in = this.transformExpr(s.iteratorExpr);
        WStatements body = this.transformStatements(s.statementsBlock());
        if (s.iterStyle.getType() == 10) {
            return Ast.StmtForIn(source, loopVar, in, body);
        }
        return Ast.StmtForFrom(source, loopVar, in, body);
    }

    private LocalVarDef transformLocalVarDef(WurstParser.LocalVarDefContext l) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        if (l.let != null) {
            modifiers.add(Ast.ModConstant(this.source(l.let)));
        }
        OptTypeExpr optTyp = this.transformOptionalType(l.type);
        Identifier name = this.text(l.name);
        VarInitialization initialExpr = this.transformVarInit(l.variableInit());
        return Ast.LocalVarDef(this.source(l), modifiers, optTyp, name, initialExpr);
    }

    private OptExpr transformOptionalExpr(WurstParser.ExprContext e) {
        if (e == null) {
            return Ast.NoExpr();
        }
        Expr r = this.transformExpr(e);
        return r;
    }

    private ExprNewObject transformExprNewObject(WurstParser.ExprNewObjectContext e) {
        Identifier typeName = this.text(e.className);
        TypeExprList typeArgs = this.transformTypeArgs(e.typeArgs());
        Arguments args = this.transformArgumentList(e.argumentList());
        return Ast.ExprNewObject(this.source(e), typeName, typeArgs, args);
    }

    private Arguments transformArgumentList(WurstParser.ArgumentListContext al) {
        if (al == null) {
            return Ast.Arguments(new Expr[0]);
        }
        return this.transformExprs(al.exprList());
    }

    private ExprMemberMethod transformMemberMethodCall2(WPos source, WurstParser.ExprContext receiver, Token dots, Token funcName, WurstParser.TypeArgsContext typeArgs, WurstParser.ArgumentListContext args) {
        Expr left = this.transformExpr(receiver);
        if (dots.getType() == 99) {
            return Ast.ExprMemberMethodDot(source, left, this.text(funcName), this.transformTypeArgs(typeArgs), this.transformArgumentList(args));
        }
        return Ast.ExprMemberMethodDotDot(source, left, this.text(funcName), this.transformTypeArgs(typeArgs), this.transformArgumentList(args));
    }

    private ExprFunctionCall transformFunctionCall(WurstParser.ExprFunctionCallContext c) {
        return Ast.ExprFunctionCall(this.source(c), this.text(c.funcName), this.transformTypeArgs(c.typeArgs()), this.transformArgumentList(c.argumentList()));
    }

    private Arguments transformExprs(WurstParser.ExprListContext es) {
        Arguments result = Ast.Arguments(new Expr[0]);
        if (es != null) {
            for (WurstParser.ExprContext e : es.exprs) {
                result.add(this.transformExpr(e));
            }
        }
        if (result.size() == 1 && result.get(0) instanceof ExprEmpty) {
            result.clear();
        }
        return result;
    }

    private WStatement transformIf(WurstParser.StmtIfContext i) {
        Expr cond = this.transformExpr(i.cond);
        WStatements thenBlock = this.transformStatements(i.thenStatements);
        WStatements elseBlock = i.elseStatements() != null ? (i.elseStatements().stmtIf() != null ? Ast.WStatements(this.transformIf(i.elseStatements().stmtIf())) : this.transformStatements(i.elseStatements().statementsBlock())) : Ast.WStatements(new WStatement[0]);
        return Ast.StmtIf(this.source(i), cond, thenBlock, elseBlock, i.ELSE() != null);
    }

    private Expr transformExpr(WurstParser.ExprContext e) {
        try {
            ParseTree right;
            WPos source = this.source(e);
            if (e.exprPrimary() != null) {
                return this.transformExprPrimary(e.exprPrimary());
            }
            if (e.left != null && e.right != null && e.op != null) {
                return Ast.ExprBinary(source, this.transformExpr(e.left), this.transformOp(e.op), this.transformExpr(e.right));
            }
            if (e.op != null && e.op.getType() == 40) {
                return Ast.ExprUnary(source, WurstOperator.NOT, this.transformExpr(e.right));
            }
            if (e.op != null && e.op.getType() == 94) {
                return Ast.ExprUnary(source, WurstOperator.UNARY_MINUS, this.transformExpr(e.right));
            }
            if (e.castToType != null) {
                return Ast.ExprCast(source, this.transformTypeExpr(e.castToType), this.transformExpr(e.left));
            }
            if (e.dotsVar != null) {
                return this.transformExprMemberVarAccess2(source, e.receiver, e.dotsVar, e.varName, e.indexes());
            }
            if (e.dotsCall != null) {
                return this.transformMemberMethodCall2(source, e.receiver, e.dotsCall, e.funcName, e.typeArgs(), e.argumentList());
            }
            if (e.instaneofType != null) {
                return Ast.ExprInstanceOf(source, this.transformTypeExpr(e.instaneofType), this.transformExpr(e.left));
            }
            if (e.cond != null) {
                return Ast.ExprIfElse(source, this.transformExpr(e.cond), this.transformExpr(e.ifTrueExpr), this.transformExpr(e.ifFalseExpr));
            }
            ParseTree left = this.getLeftParseTree(e);
            if (left != null) {
                source = source.withLeftPos(1 + this.stopPos(left));
            }
            if ((right = this.getRightParseTree(e)) != null) {
                source = source.withRightPos(this.beginPos(right));
            }
            return Ast.ExprEmpty(source);
        }
        catch (NullPointerException t) {
            WLogger.warning("Error transforming expression in line " + this.line(e), t);
            return Ast.ExprIncomplete(this.source(e), "Incomplete expression.");
        }
    }

    private int beginPos(ParseTree left) {
        if (left instanceof ParserRuleContext) {
            ParserRuleContext left2 = (ParserRuleContext)left;
            return left2.getStart().getStartIndex();
        }
        if (left instanceof TerminalNode) {
            TerminalNode left2 = (TerminalNode)left;
            return left2.getSymbol().getStartIndex();
        }
        throw new Error("unhandled case: " + left.getClass() + "  // " + left);
    }

    private int stopPos(ParseTree left) {
        if (left instanceof ParserRuleContext) {
            ParserRuleContext left2 = (ParserRuleContext)left;
            return left2.getStop().getStopIndex();
        }
        if (left instanceof TerminalNode) {
            TerminalNode left2 = (TerminalNode)left;
            return left2.getSymbol().getStopIndex();
        }
        throw new Error("unhandled case: " + left.getClass() + "  // " + left);
    }

    private ParseTree getLeftParseTree(ParserRuleContext e) {
        if (e == null || e.getParent() == null) {
            return null;
        }
        ParserRuleContext parent = e.getParent();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChild(i) != e) continue;
            if (i > 0) {
                return parent.getChild(i - 1);
            }
            return this.getLeftParseTree(parent);
        }
        return null;
    }

    private ParseTree getRightParseTree(ParserRuleContext e) {
        if (e == null || e.getParent() == null) {
            return null;
        }
        ParserRuleContext parent = e.getParent();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChild(i) != e) continue;
            if (i < parent.getChildCount() - 1) {
                return parent.getChild(i + 1);
            }
            return this.getRightParseTree(parent);
        }
        return null;
    }

    private WurstOperator transformOp(Token op) {
        switch (op.getType()) {
            case 39: {
                return WurstOperator.OR;
            }
            case 38: {
                return WurstOperator.AND;
            }
            case 108: {
                return WurstOperator.EQ;
            }
            case 109: {
                return WurstOperator.NOTEQ;
            }
            case 111: {
                return WurstOperator.LESS_EQ;
            }
            case 110: {
                return WurstOperator.LESS;
            }
            case 113: {
                return WurstOperator.GREATER_EQ;
            }
            case 112: {
                return WurstOperator.GREATER;
            }
            case 92: {
                return WurstOperator.PLUS;
            }
            case 94: {
                return WurstOperator.MINUS;
            }
            case 96: {
                return WurstOperator.MULT;
            }
            case 97: {
                return WurstOperator.DIV_REAL;
            }
            case 52: {
                return WurstOperator.DIV_INT;
            }
            case 98: {
                return WurstOperator.MOD_REAL;
            }
            case 53: {
                return WurstOperator.MOD_INT;
            }
            case 40: {
                return WurstOperator.NOT;
            }
        }
        throw this.error(this.source(op), "not implemented: " + this.text(op));
    }

    private Expr transformExprPrimary(WurstParser.ExprPrimaryContext e) {
        if (e.atom != null) {
            return this.transformAtom(e.atom);
        }
        if (e.varname != null) {
            if (e.indexes() != null) {
                Indexes index = this.transformIndexes(e.indexes());
                return Ast.ExprVarArrayAccess(this.source(e), this.text(e.varname), index);
            }
            return Ast.ExprVarAccess(this.source(e), this.text(e.varname));
        }
        if (e.expr() != null) {
            return this.transformExpr(e.expr());
        }
        if (e.exprFunctionCall() != null) {
            return this.transformFunctionCall(e.exprFunctionCall());
        }
        if (e.exprNewObject() != null) {
            return this.transformExprNewObject(e.exprNewObject());
        }
        if (e.exprClosure() != null) {
            return this.transformClosure(e.exprClosure());
        }
        if (e.exprStatementsBlock() != null) {
            return this.transformExprStatementsBlock(e.exprStatementsBlock());
        }
        if (e.exprFuncRef() != null) {
            return this.transformExprFuncRef(e.exprFuncRef());
        }
        if (e.exprDestroy() != null) {
            return this.transformExprDestroy(e.exprDestroy());
        }
        throw this.error(e, "not implemented " + this.text(e));
    }

    private ExprFuncRef transformExprFuncRef(WurstParser.ExprFuncRefContext e) {
        String scopeName = e.scopeName == null ? "" : this.rawText(e.scopeName);
        Identifier funcName = this.text(e.funcName);
        return Ast.ExprFuncRef(this.source(e), scopeName, funcName);
    }

    private ExprStatementsBlock transformExprStatementsBlock(WurstParser.ExprStatementsBlockContext e) {
        return Ast.ExprStatementsBlock(this.source(e), this.transformStatements(e.statementsBlock()));
    }

    private ExprClosure transformClosure(WurstParser.ExprClosureContext e) {
        Expr implementation;
        WShortParameters parameters = this.transformShortFormalParameters(e.shortFormalParameters());
        if (e.expr() != null) {
            implementation = this.transformExpr(e.expr());
        } else if (e.skip != null) {
            implementation = Ast.ExprStatementsBlock(this.source(e.skip), Ast.WStatements(Ast.StmtSkip(this.source(e.skip))));
        } else {
            throw new RuntimeException("not implemented: " + this.text(e));
        }
        return Ast.ExprClosure(this.source(e), this.source(e.arrow), parameters, implementation);
    }

    private Indexes transformIndexes(WurstParser.IndexesContext indexes) {
        Indexes result = Ast.Indexes(new Expr[0]);
        result.add(this.transformExpr(indexes.expr()));
        return result;
    }

    private Expr transformAtom(Token a) {
        WPos source = this.source(a);
        switch (a.getType()) {
            case 131: {
                return Ast.ExprIntVal(source, this.rawText(a));
            }
            case 130: {
                return Ast.ExprRealVal(source, this.rawText(a));
            }
            case 129: {
                return Ast.ExprStringVal(source, this.getStringVal(source, this.rawText(a)));
            }
            case 13: {
                return Ast.ExprNull(source);
            }
            case 60: {
                return Ast.ExprBoolVal(source, true);
            }
            case 61: {
                return Ast.ExprBoolVal(source, false);
            }
            case 41: {
                return Ast.ExprThis(source);
            }
            case 64: {
                return Ast.ExprSuper(source);
            }
        }
        throw this.error(this.source(a), "not implemented: " + this.text(a));
    }

    private String getStringVal(WPos source, String text) {
        StringBuilder res = new StringBuilder();
        AntlrJassParseTreeTransformer.buildStringVal(source, text, res);
        return res.toString();
    }

    private WEntity transformNativeDef(WurstParser.NativeDefContext n) {
        Modifiers modifiers = this.transformModifiers(n.modifiersWithDoc());
        FuncSig sig = this.transformFuncSig(n.funcSignature());
        return Ast.NativeFunc(this.source(n), modifiers, sig.name, sig.formalParameters, sig.returnType);
    }

    private FuncSig transformFuncSig(WurstParser.FuncSignatureContext s) {
        TypeParamDefs typeParams = this.transformTypeParams(s.typeParams());
        WParameters formalParameters = this.transformFormalParameters(s.formalParameters(), true);
        OptTypeExpr returnType = this.transformOptionalType(s.returnType);
        return new FuncSig(this.text(s.name), typeParams, formalParameters, returnType);
    }

    private FuncSig transformFuncSig(WurstParser.JassFuncSignatureContext s) {
        TypeParamDefs typeParams = Ast.TypeParamDefs(new TypeParamDef[0]);
        WParameters formalParameters = Ast.WParameters(new WParameter[0]);
        for (WurstParser.FormalParameterContext p : s.args) {
            formalParameters.add(this.transformFormalParameter(p, false));
        }
        OptTypeExpr returnType = this.transformOptionalType(s.returnType);
        return new FuncSig(this.text(s.name), typeParams, formalParameters, returnType);
    }

    private OptTypeExpr transformOptionalType(WurstParser.TypeExprContext t) {
        if (t == null) {
            return Ast.NoTypeExpr();
        }
        return this.transformTypeExpr(t);
    }

    private TypeExpr transformTypeExpr(WurstParser.TypeExprContext t) throws Error {
        OptTypeExpr scopeType = t.typeExpr() != null ? this.transformTypeExpr(t.typeExpr()) : Ast.NoTypeExpr();
        if (t.thistype != null) {
            return Ast.TypeExprThis(this.source(t), scopeType);
        }
        if (t.typeName != null) {
            String typeName = this.rawText(t.typeName);
            TypeExprList typeArgs = this.transformTypeArgs(t.typeArgs());
            return Ast.TypeExprSimple(this.source(t), scopeType, typeName, typeArgs);
        }
        if (t.typeExpr() != null) {
            return Ast.TypeExprArray(this.source(t), (TypeExpr)scopeType, this.transformOptionalExpr(t.arraySize));
        }
        return Ast.TypeExprSimple(this.source(t), scopeType, "", Ast.TypeExprList(new TypeExpr[0]));
    }

    private CompileError error(WPos source, String msg) {
        return new CompileError(source, msg);
    }

    private CompileError error(ParserRuleContext source, String msg) {
        return new CompileError(this.source(source), msg);
    }

    private TypeExprList transformTypeArgs(WurstParser.TypeArgsContext typeArgs) {
        TypeExprList result = Ast.TypeExprList(new TypeExpr[0]);
        for (WurstParser.TypeExprContext e : typeArgs.args) {
            result.add(this.transformTypeExpr(e));
        }
        return result;
    }

    private WParameters transformFormalParameters(WurstParser.FormalParametersContext ps, boolean makeConstant) {
        WParameters result = Ast.WParameters(new WParameter[0]);
        for (WurstParser.FormalParameterContext p : ps.params) {
            result.add(this.transformFormalParameter(p, makeConstant));
        }
        return result;
    }

    private WShortParameters transformShortFormalParameters(WurstParser.ShortFormalParametersContext ps) {
        if (ps.singleParam != null) {
            return Ast.WShortParameters(Ast.WShortParameter(this.source(ps.singleParam).artificial(), Ast.Modifiers(Ast.ModConstant(this.source(ps.singleParam).artificial())), Ast.NoTypeExpr(), this.text(ps.singleParam)));
        }
        WShortParameters result = Ast.WShortParameters(new WShortParameter[0]);
        for (WurstParser.ShortFormalParameterContext p : ps.params) {
            result.add(this.transformShortFormalParameter(p));
        }
        return result;
    }

    private WParameter transformFormalParameter(WurstParser.FormalParameterContext p, boolean makeConstant) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        if (p.vararg != null) {
            modifiers.add(Ast.ModVararg(this.source(p).artificial()));
        }
        if (makeConstant) {
            modifiers.add(Ast.ModConstant(this.source(p).artificial()));
        }
        return Ast.WParameter(this.source(p), modifiers, this.transformTypeExpr(p.typeExpr()), this.text(p.name));
    }

    private WShortParameter transformShortFormalParameter(WurstParser.ShortFormalParameterContext p) {
        Modifiers modifiers = Ast.Modifiers(Ast.ModConstant(this.source(p).artificial()));
        return Ast.WShortParameter(this.source(p), modifiers, this.transformOptionalType(p.typeExpr()), this.text(p.name));
    }

    private TypeParamDefs transformTypeParams(WurstParser.TypeParamsContext typeParams) {
        TypeParamDefs result = Ast.TypeParamDefs(new TypeParamDef[0]);
        if (typeParams != null && typeParams.params != null) {
            for (WurstParser.TypeParamContext p : typeParams.params) {
                result.add(this.transformTypeParam(p));
            }
        }
        return result;
    }

    private TypeParamDef transformTypeParam(WurstParser.TypeParamContext p) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        TypeParamConstraints typeParamClasses = this.tranformTypeParamConstraints(p.typeParamConstraints());
        return Ast.TypeParamDef(this.source(p), modifiers, this.text(p.name), typeParamClasses);
    }

    private TypeParamConstraints tranformTypeParamConstraints(WurstParser.TypeParamConstraintsContext tc) {
        if (tc == null) {
            return Ast.NoTypeParamConstraints();
        }
        TypeExprList res = Ast.TypeExprList(new TypeExpr[0]);
        for (WurstParser.TypeExprContext t : tc.constraints) {
            res.add(this.transformTypeExpr(t));
        }
        return res;
    }

    private WImport transformImport(WurstParser.WImportContext i) {
        return Ast.WImport(this.source(i), i.isPublic != null, i.isInitLater != null, this.text(i.importedPackage));
    }

    private WPos source(ParserRuleContext p) {
        int stopIndex;
        if (p.stop.getType() == 126) {
            stopIndex = p.stop.getStartIndex() + 1;
            if (p.stop.getText().contains("\r")) {
                ++stopIndex;
            }
        } else {
            stopIndex = p.stop.getStopIndex() + 1;
        }
        return this.makeWPos(p.start.getStartIndex(), stopIndex);
    }

    private WPos source(Token p) {
        int start = p.getStartIndex();
        int stop = p.getStopIndex() + 1;
        return this.makeWPos(start, stop);
    }

    @NotNull
    private WPos makeWPos(int start, int stop) {
        if (this.storeComments) {
            WPosWithComments pos = new WPosWithComments(this.file, this.lineOffsets, start, stop);
            this.positions.add(pos);
            return pos;
        }
        return new WPos(this.file, this.lineOffsets, start, stop);
    }

    @NotNull
    private WPosWithComments.Comment tokenToComment(Token comment) {
        WPos commentPos = new WPos(this.file, this.lineOffsets, comment.getStartIndex(), comment.getStopIndex());
        boolean isSingleLine = comment.getType() == 137;
        return new WPosWithComments.Comment(commentPos, comment.getText(), isSingleLine);
    }

    static class ClassSlotResult {
        public ClassDefs innerClasses = Ast.ClassDefs(new ClassDef[0]);
        public ConstructorDefs constructors = Ast.ConstructorDefs(new ConstructorDef[0]);
        public ModuleInstanciations moduleInstanciations = Ast.ModuleInstanciations(new ModuleInstanciation[0]);
        public GlobalVarDefs vars = Ast.GlobalVarDefs(new GlobalVarDef[0]);
        public FuncDefs methods = Ast.FuncDefs(new FuncDef[0]);
        public ModuleUses moduleUses = Ast.ModuleUses(new ModuleUse[0]);
        public OnDestroyDef onDestroy = null;

        ClassSlotResult() {
        }
    }

    static class FuncSig {
        Identifier name;
        TypeParamDefs typeParams;
        WParameters formalParameters;
        OptTypeExpr returnType;

        public FuncSig(Identifier name, TypeParamDefs typeParams, WParameters formalParameters, OptTypeExpr returnType) {
            this.name = name;
            this.typeParams = typeParams;
            this.formalParameters = formalParameters;
            this.returnType = returnType;
        }
    }
}

