/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.bytes;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0010\r\n\u0002\b\u0006\u0018\u0000 n2\u00020\u0001:\u0001nB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u000b\u001a\u00020\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0013\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\u0018\u001a\u00020\bJ\b\u0010\u0019\u001a\u00020\u0004H\u0016J\u0006\u0010\u000f\u001a\u00020\u0004J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u0006\u0010\u001d\u001a\u00020\u0011J\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010 \u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\"\u0010!\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\"\u001a\u00020\u00042\b\b\u0002\u0010#\u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u0004J\u0006\u0010%\u001a\u00020&J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010'\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0004J\u0006\u0010(\u001a\u00020)J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u0011J\u000e\u0010(\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u0004J\u001e\u0010(\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u0011J\u000e\u0010,\u001a\u00020-2\u0006\u0010$\u001a\u00020\u0004J\u0006\u0010.\u001a\u00020/J\u0016\u0010.\u001a\u00020/2\u0006\u0010*\u001a\u00020/2\u0006\u0010+\u001a\u00020\u0011J\u000e\u0010.\u001a\u00020/2\u0006\u0010\u000f\u001a\u00020\u0004J\u001e\u0010.\u001a\u00020/2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010*\u001a\u00020/2\u0006\u0010+\u001a\u00020\u0011J\u000e\u00100\u001a\u0002012\u0006\u0010$\u001a\u00020\u0004J\u0006\u00102\u001a\u00020\u0004J\u000e\u00102\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0011J\u000e\u00102\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u0016\u00102\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0011J\u000e\u00103\u001a\u0002042\u0006\u0010$\u001a\u00020\u0004J\u0016\u00103\u001a\u0002042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0011J\u0006\u00105\u001a\u000206J\u000e\u00105\u001a\u0002062\u0006\u0010+\u001a\u00020\u0011J\u000e\u00105\u001a\u0002062\u0006\u0010\u000f\u001a\u00020\u0004J\u0016\u00105\u001a\u0002062\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0011J\u0010\u00107\u001a\u0002062\u0006\u0010+\u001a\u00020\u0011H\u0002J\u000e\u00108\u001a\u0002092\u0006\u0010$\u001a\u00020\u0004J\u0016\u00108\u001a\u0002092\u0006\u0010$\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0011J\u0006\u0010:\u001a\u00020;J\u000e\u0010:\u001a\u00020;2\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010<\u001a\u00020\u0004J\u000e\u0010<\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010=\u001a\u00020>2\u0006\u0010$\u001a\u00020\u0004J\b\u0010?\u001a\u0004\u0018\u00010\u001bJ\u000e\u0010@\u001a\n\u0018\u00010Aj\u0004\u0018\u0001`BJ\u0010\u0010C\u001a\u00020\u00142\u0006\u0010D\u001a\u00020\u0004H\u0002J\u0010\u0010E\u001a\u00020\u00042\u0006\u0010F\u001a\u00020\u0004H\u0002J\u0010\u0010G\u001a\u00020\u00042\u0006\u0010F\u001a\u00020\u0004H\u0002J\u0018\u0010H\u001a\u00020\u00142\u0006\u0010D\u001a\u00020\u00042\u0006\u0010I\u001a\u00020\u0004H\u0002J\u0010\u0010J\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0011H\u0002J\u0010\u0010K\u001a\u0002062\u0006\u0010+\u001a\u00020\u0011H\u0002J\u0006\u0010L\u001a\u00020\u0004J\u0010\u0010M\u001a\u00020\u00112\u0006\u0010N\u001a\u00020\u0004H\u0002J\u0006\u0010O\u001a\u00020\u0014J\u000e\u0010P\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010P\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010Q\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010R\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0004J\u0006\u0010S\u001a\u00020\bJ\b\u0010T\u001a\u00020\u001bH\u0016J\u0010\u0010U\u001a\u00020\u00142\b\u0010V\u001a\u0004\u0018\u00010\u001bJ\u0018\u0010W\u001a\u00020\u00142\u0006\u0010V\u001a\u00020\u001b2\u0006\u0010D\u001a\u00020\u0004H\u0002J\u000e\u0010X\u001a\u00020\u00142\u0006\u0010V\u001a\u00020\u0011J\u000e\u0010Y\u001a\u00020\u00142\u0006\u0010V\u001a\u00020\u001fJ\u000e\u0010Y\u001a\u00020\u00142\u0006\u0010V\u001a\u00020\u0004J\u000e\u0010Z\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\bJ\u001e\u0010Z\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u000e\u0010[\u001a\u00020\u00142\u0006\u0010V\u001a\u00020&J\u000e\u0010\\\u001a\u00020\u00142\u0006\u0010]\u001a\u00020\rJ\u000e\u0010^\u001a\u00020\u00142\u0006\u0010V\u001a\u00020)J\u001e\u0010^\u001a\u00020\u00042\u0006\u0010V\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u0011J\u000e\u0010_\u001a\u00020\u00142\u0006\u0010]\u001a\u00020-J\u000e\u0010`\u001a\u00020\u00142\u0006\u0010V\u001a\u00020/J\u001e\u0010`\u001a\u00020\u00042\u0006\u0010V\u001a\u00020/2\u0006\u0010*\u001a\u00020/2\u0006\u0010+\u001a\u00020\u0011J\u000e\u0010a\u001a\u00020\u00142\u0006\u0010]\u001a\u000201J\u000e\u0010b\u001a\u00020\u00142\u0006\u0010V\u001a\u00020\u0004J\u0016\u0010b\u001a\u00020\u00042\u0006\u0010V\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0011J\u000e\u0010c\u001a\u00020\u00142\u0006\u0010]\u001a\u000204J\u0016\u0010c\u001a\u00020\u00142\u0006\u0010]\u001a\u0002042\u0006\u0010+\u001a\u00020\u0011J\u000e\u0010d\u001a\u00020\u00142\u0006\u0010V\u001a\u000206J\u0016\u0010d\u001a\u00020\u00042\u0006\u0010V\u001a\u0002062\u0006\u0010+\u001a\u00020\u0011J\u000e\u0010e\u001a\u00020\u00142\u0006\u0010]\u001a\u000209J\u0016\u0010e\u001a\u00020\u00142\u0006\u0010]\u001a\u0002092\u0006\u0010+\u001a\u00020\u0011J\u000e\u0010f\u001a\u00020\u00142\u0006\u0010V\u001a\u00020\u0004J\u000e\u0010g\u001a\u00020\u00142\u0006\u0010]\u001a\u00020>J\u0010\u0010h\u001a\u00020\u00142\b\u0010V\u001a\u0004\u0018\u00010iJ\u0010\u0010h\u001a\u00020\u00142\b\u0010V\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010j\u001a\u00020\u00142\u0006\u0010V\u001a\u00020\u0004H\u0002J \u0010k\u001a\u00020\u00142\u0006\u0010V\u001a\u00020i2\u0006\u0010D\u001a\u00020\u00042\u0006\u0010I\u001a\u00020\u0004H\u0002J\u0016\u0010l\u001a\u00020\u00042\u0006\u0010V\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0011J\u0016\u0010m\u001a\u00020\u00042\u0006\u0010V\u001a\u0002062\u0006\u0010+\u001a\u00020\u0011R\u000e\u0010\n\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006o"}, d2={"Ldorkbox/bytes/ByteArrayBuffer;", "", "()V", "bufferSize", "", "maxBufferSize", "(II)V", "buffer", "", "([BI)V", "bytes", "capacity", "chars", "", "maxCapacity", "position", "canReadInt", "", "canReadLong", "clear", "", "clearSecure", "equals", "other", "getBuffer", "hashCode", "readAscii", "", "readAscii_slow", "readBoolean", "readByte", "", "readByteUnsigned", "readBytes", "offset", "count", "length", "readChar", "", "readChars", "readDouble", "", "precision", "optimizePositive", "readDoubles", "", "readFloat", "", "readFloats", "", "readInt", "readInts", "", "readLong", "", "readLong_slow", "readLongs", "", "readShort", "", "readShortUnsigned", "readShorts", "", "readString", "readStringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "readUtf8", "charCount", "readUtf8Length", "b", "readUtf8Length_slow", "readUtf8_slow", "charIndex", "readVarInt", "readVarLong", "remaining", "require", "required", "rewind", "setBuffer", "setPosition", "skip", "toBytes", "toString", "writeAscii", "value", "writeAscii_slow", "writeBoolean", "writeByte", "writeBytes", "writeChar", "writeChars", "object", "writeDouble", "writeDoubles", "writeFloat", "writeFloats", "writeInt", "writeInts", "writeLong", "writeLongs", "writeShort", "writeShorts", "writeString", "", "writeUtf8Length", "writeUtf8_slow", "writeVarInt", "writeVarLong", "Companion", "ByteUtilities"})
@SourceDebugExtension(value={"SMAP\nByteArrayBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteArrayBuffer.kt\ndorkbox/bytes/ByteArrayBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1865:1\n1#2:1866\n*E\n"})
public final class ByteArrayBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int capacity;
    private int maxCapacity;
    private int position;
    private byte[] bytes;
    @NotNull
    private char[] chars;
    @NotNull
    public static final String version = "2.0";

    public ByteArrayBuffer() {
        this.chars = new char[32];
    }

    public ByteArrayBuffer(int bufferSize, int maxBufferSize) {
        this.chars = new char[32];
        if (!(maxBufferSize >= -1)) {
            boolean bl = false;
            String string = "maxBufferSize cannot be < -1: " + maxBufferSize;
            throw new IllegalArgumentException(string.toString());
        }
        this.capacity = bufferSize;
        this.maxCapacity = maxBufferSize == -1 ? Integer.MAX_VALUE : maxBufferSize;
        this.bytes = new byte[bufferSize];
    }

    public /* synthetic */ ByteArrayBuffer(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        this(n, n2);
    }

    public ByteArrayBuffer(@NotNull byte[] buffer, int maxBufferSize) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.chars = new char[32];
        this.setBuffer(buffer, maxBufferSize);
    }

    public /* synthetic */ ByteArrayBuffer(byte[] byArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = byArray.length;
        }
        this(byArray, n);
    }

    public final void setBuffer(@NotNull byte[] buffer, int maxBufferSize) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (!(maxBufferSize >= -1)) {
            boolean bl = false;
            String string = "maxBufferSize cannot be < -1: " + maxBufferSize;
            throw new IllegalArgumentException(string.toString());
        }
        this.bytes = buffer;
        this.maxCapacity = maxBufferSize == -1 ? Integer.MAX_VALUE : maxBufferSize;
        this.capacity = buffer.length;
        this.position = 0;
    }

    @NotNull
    public final byte[] getBuffer() {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        return byArray;
    }

    public final void setBuffer(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.setBuffer(buffer, buffer.length);
    }

    @NotNull
    public final byte[] toBytes() {
        byte[] newBuffer = new byte[this.position];
        if (this.position > 0) {
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            System.arraycopy(byArray, 0, newBuffer, 0, this.position);
        }
        return newBuffer;
    }

    public final int remaining() {
        return this.capacity - this.position;
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int position() {
        return this.position;
    }

    public final void setPosition(int position) {
        this.position = position;
    }

    public final void clear() {
        this.position = 0;
    }

    public final void rewind() {
        this.position = 0;
    }

    public final void clearSecure() {
        this.position = 0;
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int n = this.capacity;
        for (int i = 0; i < n; ++i) {
            buffer[i] = 0;
        }
    }

    public final void skip(int count) {
        int count2 = count;
        int skipCount = Math.min(this.capacity - this.position, count2);
        while (true) {
            this.position += skipCount;
            if ((count2 -= skipCount) == 0) break;
            skipCount = Math.min(count2, this.capacity);
            this.require(skipCount);
        }
    }

    private final boolean require(int required) {
        if (this.capacity - this.position >= required) {
            return false;
        }
        if (required > this.maxCapacity) {
            throw new IOException("Buffer overflow. Max capacity: " + this.maxCapacity + ", required: " + required);
        }
        while (this.capacity - this.position < required) {
            if (this.capacity == this.maxCapacity) {
                throw new IOException("Buffer overflow. Available: " + (this.capacity - this.position) + ", required: " + required);
            }
            if (this.capacity == 0) {
                this.capacity = 1;
            }
            this.capacity = RangesKt.coerceAtMost((int)((int)((double)this.capacity * 1.6)), (int)this.maxCapacity);
            if (this.capacity < 0) {
                this.capacity = this.maxCapacity;
            }
            byte[] newBuffer = new byte[this.capacity];
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            System.arraycopy(byArray, 0, newBuffer, 0, this.position);
            this.bytes = newBuffer;
        }
        return true;
    }

    public final void writeByte(byte value) {
        if (this.position == this.capacity) {
            this.require(1);
        }
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        int n = this.position;
        this.position = n + 1;
        byArray[n] = value;
    }

    public final void writeByte(int value) {
        if (this.position == this.capacity) {
            this.require(1);
        }
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        int n = this.position;
        this.position = n + 1;
        byArray[n] = (byte)value;
    }

    public final void writeBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.writeBytes(bytes, 0, bytes.length);
    }

    public final void writeBytes(@NotNull byte[] bytes, int offset, int count) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int offset2 = offset;
        int count2 = count;
        int copyCount = RangesKt.coerceAtMost((int)(this.capacity - this.position), (int)count2);
        while (true) {
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            System.arraycopy(bytes, offset2, byArray, this.position, copyCount);
            this.position += copyCount;
            if ((count2 -= copyCount) == 0) {
                return;
            }
            offset2 += copyCount;
            copyCount = Math.min(this.capacity, count2);
            this.require(copyCount);
        }
    }

    public final byte readByte() {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        int n = this.position;
        this.position = n + 1;
        return byArray[n];
    }

    public final int readByteUnsigned() {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        int n = this.position;
        this.position = n + 1;
        return byArray[n] & 0xFF;
    }

    public final byte readByte(int position) {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        return byArray[position];
    }

    public final int readByteUnsigned(int position) {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        return byArray[position] & 0xFF;
    }

    @NotNull
    public final byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return bytes;
    }

    public final void readBytes(@NotNull byte[] bytes, int offset, int count) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        System.arraycopy(byArray, this.position, bytes, offset, count);
        this.position += count;
    }

    public static /* synthetic */ void readBytes$default(ByteArrayBuffer byteArrayBuffer, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        byteArrayBuffer.readBytes(byArray, n, n2);
    }

    public final void writeInt(int value) {
        this.require(4);
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value >> 24);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value >> 16);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value >> 8);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)value;
    }

    public final int writeInt(int value, boolean optimizePositive) {
        return this.writeVarInt(value, optimizePositive);
    }

    public final int writeVarInt(int value, boolean optimizePositive) {
        int value2 = value;
        if (!optimizePositive) {
            value2 = value2 << 1 ^ value2 >> 31;
        }
        if (value2 >>> 7 == 0) {
            this.require(1);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            int n = this.position;
            this.position = n + 1;
            byArray[n] = (byte)value2;
            return 1;
        }
        if (value2 >>> 14 == 0) {
            this.require(2);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 & 0x7F | 0x80);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 7);
            return 2;
        }
        if (value2 >>> 21 == 0) {
            this.require(3);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 & 0x7F | 0x80);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 7 | 0x80);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 14);
            return 3;
        }
        if (value2 >>> 28 == 0) {
            this.require(4);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 & 0x7F | 0x80);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 7 | 0x80);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 14 | 0x80);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 21);
            return 4;
        }
        this.require(5);
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value2 & 0x7F | 0x80);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value2 >>> 7 | 0x80);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value2 >>> 14 | 0x80);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value2 >>> 21 | 0x80);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value2 >>> 28);
        return 5;
    }

    public final int readInt() {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int position = this.position;
        int value = (buffer[position] & 0xFF) << 24 | (buffer[position + 1] & 0xFF) << 16 | (buffer[position + 2] & 0xFF) << 8 | buffer[position + 3] & 0xFF;
        this.position = position + 4;
        return value;
    }

    public final int readInt(int position) {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int value = (buffer[position] & 0xFF) << 24 | (buffer[position + 1] & 0xFF) << 16 | (buffer[position + 2] & 0xFF) << 8 | buffer[position + 3] & 0xFF;
        this.position = position + 4;
        return value;
    }

    public final int readInt(boolean optimizePositive) {
        return this.readVarInt(optimizePositive);
    }

    public final int readInt(int position, boolean optimizePositive) {
        int pos = this.position;
        this.position = position;
        int value = this.readVarInt(optimizePositive);
        this.position = pos;
        return value;
    }

    private final int readVarInt(boolean optimizePositive) {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int n = this.position;
        this.position = n + 1;
        byte b = buffer[n];
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            int n2 = this.position;
            this.position = n2 + 1;
            b = buffer[n2];
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                n2 = this.position;
                this.position = n2 + 1;
                b = buffer[n2];
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    n2 = this.position;
                    this.position = n2 + 1;
                    b = buffer[n2];
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        n2 = this.position;
                        this.position = n2 + 1;
                        b = buffer[n2];
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    public final boolean canReadInt() {
        if (this.capacity - this.position >= 5) {
            return true;
        }
        if (this.position + 1 > this.capacity) {
            return false;
        }
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int p = this.position;
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        return (buffer[p++] & 0x80) == 0 ? true : p != this.capacity;
    }

    public final boolean canReadInt(int position) {
        if (this.capacity - position >= 5) {
            return true;
        }
        if (position + 1 > this.capacity) {
            return false;
        }
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int p = position;
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        return (buffer[p++] & 0x80) == 0 ? true : p != this.capacity;
    }

    public final void writeString(@Nullable String value) {
        boolean permitAscii;
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        if (charCount == 0) {
            this.writeByte(129);
            return;
        }
        boolean bl = 2 <= charCount ? charCount < 33 : (permitAscii = false);
        if (permitAscii) {
            for (int i = 0; i < charCount; ++i) {
                if (value.charAt(i) <= '\u007f') continue;
                permitAscii = false;
                break;
            }
            if (permitAscii) {
                if (this.capacity - this.position < charCount) {
                    this.writeAscii_slow(value, charCount);
                } else {
                    byte[] stringBytes = StringsKt.encodeToByteArray$default((String)value, (int)0, (int)charCount, (boolean)false, (int)4, null);
                    byte[] byArray = this.bytes;
                    if (this.bytes == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                        byArray = null;
                    }
                    ArraysKt.copyInto$default((byte[])stringBytes, (byte[])byArray, (int)this.position, (int)0, (int)0, (int)12, null);
                    this.position += charCount;
                }
                byte[] byArray = this.bytes;
                if (this.bytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                    byArray = null;
                }
                byte value1 = (byte)(byArray[this.position - 1] | 0x80);
                byte[] byArray2 = this.bytes;
                if (this.bytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                    byArray2 = null;
                }
                byArray2[this.position - 1] = value1;
                return;
            }
        }
        this.writeUtf8Length(charCount + 1);
        int charIndex = 0;
        if (this.capacity - this.position >= charCount) {
            char c;
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int position = this.position;
            while (charIndex < charCount && (c = value.charAt(charIndex)) <= '\u007f') {
                buffer[position++] = (byte)c;
                ++charIndex;
            }
            this.position = position;
        }
        if (charIndex < charCount) {
            this.writeUtf8_slow(value, charCount, charIndex);
        }
    }

    public final void writeString(@Nullable CharSequence value) {
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        if (charCount == 0) {
            this.writeByte(129);
            return;
        }
        this.writeUtf8Length(charCount + 1);
        int charIndex = 0;
        if (this.capacity - this.position >= charCount) {
            char c;
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int position = this.position;
            while (charIndex < charCount && (c = value.charAt(charIndex)) <= '\u007f') {
                buffer[position++] = (byte)c;
                ++charIndex;
            }
            this.position = position;
        }
        if (charIndex < charCount) {
            this.writeUtf8_slow(value, charCount, charIndex);
        }
    }

    public final void writeAscii(@Nullable String value) {
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        switch (charCount) {
            case 0: {
                this.writeByte(129);
                return;
            }
            case 1: {
                this.writeByte(130);
                this.writeByte(value.charAt(0));
                return;
            }
        }
        if (this.capacity - this.position < charCount) {
            this.writeAscii_slow(value, charCount);
        } else {
            byte[] stringBytes = StringsKt.encodeToByteArray$default((String)value, (int)0, (int)charCount, (boolean)false, (int)4, null);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            ArraysKt.copyInto$default((byte[])stringBytes, (byte[])byArray, (int)this.position, (int)0, (int)0, (int)12, null);
            this.position += charCount;
        }
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] byArray2 = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray2 = null;
        }
        byArray[this.position - 1] = (byte)(byArray2[this.position - 1] | 0x80);
    }

    private final void writeUtf8Length(int value) {
        if (value >>> 6 == 0) {
            this.require(1);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            int n = this.position;
            this.position = n + 1;
            byArray[n] = (byte)(value | 0x80);
        } else if (value >>> 13 == 0) {
            this.require(2);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value | 0x40 | 0x80);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value >>> 6);
        } else if (value >>> 20 == 0) {
            this.require(3);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value | 0x40 | 0x80);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value >>> 6 | 0x80);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value >>> 13);
        } else if (value >>> 27 == 0) {
            this.require(4);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value | 0x40 | 0x80);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value >>> 6 | 0x80);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value >>> 13 | 0x80);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value >>> 20);
        } else {
            this.require(5);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value | 0x40 | 0x80);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value >>> 6 | 0x80);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value >>> 13 | 0x80);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value >>> 20 | 0x80);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value >>> 27);
        }
    }

    private final void writeUtf8_slow(CharSequence value, int charCount, int charIndex) {
        for (int charIndex2 = charIndex; charIndex2 < charCount; ++charIndex2) {
            int n;
            char c;
            if (this.position == this.capacity) {
                this.require(RangesKt.coerceAtMost((int)this.capacity, (int)(charCount - charIndex2)));
            }
            if ((c = value.charAt(charIndex2)) <= '\u007f') {
                byte[] byArray = this.bytes;
                if (this.bytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                    byArray = null;
                }
                n = this.position;
                this.position = n + 1;
                byArray[n] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                byte[] byArray = this.bytes;
                if (this.bytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                    byArray = null;
                }
                n = this.position;
                this.position = n + 1;
                byArray[n] = (byte)(0xE0 | c >> 12 & 0xF);
                this.require(2);
                byte[] byArray2 = this.bytes;
                if (this.bytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                    byArray2 = null;
                }
                byte[] buffer = byArray2;
                int n2 = this.position;
                this.position = n2 + 1;
                buffer[n2] = (byte)(0x80 | c >> 6 & 0x3F);
                n2 = this.position;
                this.position = n2 + 1;
                buffer[n2] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            n = this.position;
            this.position = n + 1;
            byArray[n] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.require(1);
            byte[] byArray3 = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray3 = null;
            }
            n = this.position;
            this.position = n + 1;
            byArray3[n] = (byte)(0x80 | c & 0x3F);
        }
    }

    private final void writeAscii_slow(String value, int charCount) {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int charIndex = 0;
        int charsToWrite = RangesKt.coerceAtMost((int)charCount, (int)(this.capacity - this.position));
        while (charIndex < charCount) {
            byte[] stringBytes = StringsKt.encodeToByteArray$default((String)value, (int)charIndex, (int)(charIndex + charsToWrite), (boolean)false, (int)4, null);
            ArraysKt.copyInto$default((byte[])stringBytes, (byte[])buffer, (int)this.position, (int)0, (int)0, (int)12, null);
            this.position += charsToWrite;
            if (!this.require(charsToWrite = Math.min(charCount - (charIndex += charsToWrite), this.capacity))) continue;
            byte[] byArray2 = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray2 = null;
            }
            buffer = byArray2;
        }
    }

    @Nullable
    public final String readString() {
        int available = this.capacity - this.position;
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        int n = this.position;
        this.position = n + 1;
        byte b = byArray[n];
        if ((b & 0x80) == 0) {
            return this.readAscii();
        }
        int charCount = available >= 5 ? this.readUtf8Length(b) : this.readUtf8Length_slow(b);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
        }
        if (this.chars.length < --charCount) {
            this.chars = new char[charCount];
        }
        if (available < charCount) {
            throw new BufferUnderflowException();
        }
        this.readUtf8(charCount);
        return new String(this.chars, 0, charCount);
    }

    private final int readUtf8Length(int b) {
        int b2 = b;
        int result = b2 & 0x3F;
        if ((b2 & 0x40) != 0) {
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int n = this.position;
            this.position = n + 1;
            b2 = buffer[n];
            result |= (b2 & 0x7F) << 6;
            if ((b2 & 0x80) != 0) {
                n = this.position;
                this.position = n + 1;
                b2 = buffer[n];
                result |= (b2 & 0x7F) << 13;
                if ((b2 & 0x80) != 0) {
                    n = this.position;
                    this.position = n + 1;
                    b2 = buffer[n];
                    result |= (b2 & 0x7F) << 20;
                    if ((b2 & 0x80) != 0) {
                        n = this.position;
                        this.position = n + 1;
                        b2 = buffer[n];
                        result |= (b2 & 0x7F) << 27;
                    }
                }
            }
        }
        return result;
    }

    private final int readUtf8Length_slow(int b) {
        int b2 = b;
        int result = b2 & 0x3F;
        if ((b2 & 0x40) != 0) {
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int n = this.position;
            this.position = n + 1;
            b2 = buffer[n];
            result |= (b2 & 0x7F) << 6;
            if ((b2 & 0x80) != 0) {
                n = this.position;
                this.position = n + 1;
                b2 = buffer[n];
                result |= (b2 & 0x7F) << 13;
                if ((b2 & 0x80) != 0) {
                    n = this.position;
                    this.position = n + 1;
                    b2 = buffer[n];
                    result |= (b2 & 0x7F) << 20;
                    if ((b2 & 0x80) != 0) {
                        n = this.position;
                        this.position = n + 1;
                        b2 = buffer[n];
                        result |= (b2 & 0x7F) << 27;
                    }
                }
            }
        }
        return result;
    }

    private final void readUtf8(int charCount) {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int position = this.position;
        char[] chars = this.chars;
        int charIndex = 0;
        int spaceAvailable = this.capacity - this.position;
        int count = Math.min(spaceAvailable, charCount);
        byte b = 0;
        while (charIndex < count) {
            if ((b = buffer[position++]) < 0) {
                --position;
                break;
            }
            chars[charIndex++] = (char)b;
        }
        this.position = position;
        if (charIndex < charCount) {
            this.readUtf8_slow(charCount, charIndex);
        }
    }

    private final void readUtf8_slow(int charCount, int charIndex) {
        byte[] buffer;
        int charIndex2 = charIndex;
        char[] chars = this.chars;
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = buffer = null;
        }
        while (charIndex2 < charCount) {
            int n = this.position;
            this.position = n + 1;
            int b = buffer[n] & 0xFF;
            switch (b >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[charIndex2] = (char)b;
                    break;
                }
                case 12: 
                case 13: {
                    int n2 = this.position;
                    this.position = n2 + 1;
                    chars[charIndex2] = (char)((b & 0x1F) << 6 | buffer[n2] & 0x3F);
                    break;
                }
                case 14: {
                    int n2 = this.position;
                    this.position = n2 + 1;
                    int n3 = (b & 0xF) << 12 | (buffer[n2] & 0x3F) << 6;
                    n2 = this.position;
                    this.position = n2 + 1;
                    chars[charIndex2] = (char)(n3 | buffer[n2] & 0x3F);
                }
            }
            ++charIndex2;
        }
    }

    private final String readAscii() {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int end = this.position;
        int start = end - 1;
        int limit = this.capacity;
        byte b = 0;
        do {
            if (end != limit) continue;
            return this.readAscii_slow();
        } while (((b = buffer[end++]) & 0x80) == 0);
        buffer[end - 1] = (byte)(buffer[end - 1] & 0x7F);
        String value = new String(buffer, start, end - start, Charsets.UTF_8);
        buffer[end - 1] = (byte)(buffer[end - 1] | 0x80);
        this.position = end;
        return value;
    }

    private final String readAscii_slow() {
        byte b;
        int n = this.position;
        this.position = n + -1;
        int charCount = this.capacity - this.position;
        if (charCount > this.chars.length) {
            this.chars = new char[charCount * 2];
        }
        char[] chars = this.chars;
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int i = this.position;
        int ii = 0;
        int n2 = this.capacity;
        while (i < n2) {
            chars[ii] = (char)buffer[i];
            ++i;
            ++ii;
        }
        this.position = this.capacity;
        while (true) {
            int n3 = this.position;
            this.position = n3 + 1;
            b = buffer[n3];
            if (charCount == chars.length) {
                char[] newChars = new char[charCount * 2];
                System.arraycopy(chars, 0, newChars, 0, charCount);
                chars = newChars;
                this.chars = newChars;
            }
            if ((b & 0x80) == 128) break;
            chars[charCount++] = (char)b;
        }
        chars[charCount++] = (char)(b & 0x7F);
        return new String(chars, 0, charCount);
    }

    @Nullable
    public final StringBuilder readStringBuilder() {
        int available = this.capacity - this.position;
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        int n = this.position;
        this.position = n + 1;
        byte b = byArray[n];
        if ((b & 0x80) == 0) {
            return new StringBuilder(this.readAscii());
        }
        int charCount = available >= 5 ? this.readUtf8Length(b) : this.readUtf8Length_slow(b);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return new StringBuilder();
            }
        }
        if (this.chars.length < --charCount) {
            this.chars = new char[charCount];
        }
        this.readUtf8(charCount);
        StringBuilder builder = new StringBuilder(charCount);
        builder.append(this.chars, 0, charCount);
        return builder;
    }

    public final void writeFloat(float value) {
        this.writeInt(Float.floatToIntBits(value));
    }

    public final int writeFloat(float value, float precision, boolean optimizePositive) {
        return this.writeInt((int)(value * precision), optimizePositive);
    }

    public final float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public final float readFloat(float precision, boolean optimizePositive) {
        return (float)this.readInt(optimizePositive) / precision;
    }

    public final float readFloat(int position) {
        return Float.intBitsToFloat(this.readInt(position));
    }

    public final float readFloat(int position, float precision, boolean optimizePositive) {
        return (float)this.readInt(position, optimizePositive) / precision;
    }

    public final void writeShort(int value) {
        this.require(2);
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value >>> 8);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)value;
    }

    public final short readShort() {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int n = this.position;
        this.position = n + 1;
        int n2 = (buffer[n] & 0xFF) << 8;
        n = this.position;
        this.position = n + 1;
        return (short)(n2 | buffer[n] & 0xFF);
    }

    public final int readShortUnsigned() {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int n = this.position;
        this.position = n + 1;
        int n2 = (buffer[n] & 0xFF) << 8;
        n = this.position;
        this.position = n + 1;
        return (n2 | buffer[n]) & 0xFF;
    }

    public final short readShort(int position) {
        int position2 = position;
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        return (short)(((buffer[position2++] & 0xFF) << 8 | buffer[position2]) & 0xFF);
    }

    public final int readShortUnsigned(int position) {
        int position2 = position;
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        return ((buffer[position2++] & 0xFF) << 8 | buffer[position2]) & 0xFF;
    }

    public final void writeLong(long value) {
        this.require(8);
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value >>> 56);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value >>> 48);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value >>> 40);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value >>> 32);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value >>> 24);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value >>> 16);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value >>> 8);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)value;
    }

    public final int writeLong(long value, boolean optimizePositive) {
        return this.writeVarLong(value, optimizePositive);
    }

    public final int writeVarLong(long value, boolean optimizePositive) {
        long value2 = value;
        if (!optimizePositive) {
            value2 = value2 << 1 ^ value2 >> 63;
        }
        if (value2 >>> 7 == 0L) {
            this.require(1);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            int n = this.position;
            this.position = n + 1;
            byArray[n] = (byte)value2;
            return 1;
        }
        if (value2 >>> 14 == 0L) {
            this.require(2);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 & 0x7FL | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 7);
            return 2;
        }
        if (value2 >>> 21 == 0L) {
            this.require(3);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 & 0x7FL | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 7 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 14);
            return 3;
        }
        if (value2 >>> 28 == 0L) {
            this.require(4);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 & 0x7FL | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 7 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 14 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 21);
            return 4;
        }
        if (value2 >>> 35 == 0L) {
            this.require(5);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 & 0x7FL | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 7 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 14 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 21 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 28);
            return 5;
        }
        if (value2 >>> 42 == 0L) {
            this.require(6);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 & 0x7FL | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 7 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 14 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 21 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 28 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 35);
            return 6;
        }
        if (value2 >>> 49 == 0L) {
            this.require(7);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 & 0x7FL | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 7 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 14 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 21 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 28 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 35 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 42);
            return 7;
        }
        if (value2 >>> 56 == 0L) {
            this.require(8);
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] buffer = byArray;
            int n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 & 0x7FL | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 7 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 14 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 21 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 28 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 35 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 42 | 0x80L);
            n = this.position;
            this.position = n + 1;
            buffer[n] = (byte)(value2 >>> 49);
            return 8;
        }
        this.require(9);
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value2 & 0x7FL | 0x80L);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value2 >>> 7 | 0x80L);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value2 >>> 14 | 0x80L);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value2 >>> 21 | 0x80L);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value2 >>> 28 | 0x80L);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value2 >>> 35 | 0x80L);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value2 >>> 42 | 0x80L);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value2 >>> 49 | 0x80L);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value2 >>> 56);
        return 9;
    }

    public final boolean canReadLong() {
        if (this.capacity - this.position >= 9) {
            return true;
        }
        if (this.position + 1 > this.capacity) {
            return false;
        }
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int p = this.position;
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        return (buffer[p++] & 0x80) == 0 ? true : p != this.capacity;
    }

    public final boolean canReadLong(int position) {
        if (this.capacity - position >= 9) {
            return true;
        }
        if (position + 1 > this.capacity) {
            return false;
        }
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int p = position;
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        if ((buffer[p++] & 0x80) == 0) {
            return true;
        }
        if (p == this.capacity) {
            return false;
        }
        return (buffer[p++] & 0x80) == 0 ? true : p != this.capacity;
    }

    public final long readLong() {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int n = this.position;
        this.position = n + 1;
        long l = (long)buffer[n] << 56;
        n = this.position;
        this.position = n + 1;
        long l2 = l | (long)(buffer[n] & 0xFF) << 48;
        n = this.position;
        this.position = n + 1;
        long l3 = l2 | (long)(buffer[n] & 0xFF) << 40;
        n = this.position;
        this.position = n + 1;
        long l4 = l3 | (long)(buffer[n] & 0xFF) << 32;
        n = this.position;
        this.position = n + 1;
        long l5 = l4 | (long)(buffer[n] & 0xFF) << 24;
        n = this.position;
        this.position = n + 1;
        long l6 = l5 | (long)(buffer[n] & 0xFF) << 16;
        n = this.position;
        this.position = n + 1;
        long l7 = l6 | (long)(buffer[n] & 0xFF) << 8;
        n = this.position;
        this.position = n + 1;
        return l7 | (long)(buffer[n] & 0xFF);
    }

    public final long readLong(boolean optimizePositive) {
        return this.readVarLong(optimizePositive);
    }

    public final long readLong(int position) {
        int position2 = position;
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        return (long)buffer[position2++] << 56 | (long)(buffer[position2++] & 0xFF) << 48 | (long)(buffer[position2++] & 0xFF) << 40 | (long)(buffer[position2++] & 0xFF) << 32 | (long)(buffer[position2++] & 0xFF) << 24 | (long)(buffer[position2++] & 0xFF) << 16 | (long)(buffer[position2++] & 0xFF) << 8 | (long)(buffer[position2] & 0xFF);
    }

    public final long readLong(int position, boolean optimizePositive) {
        int pos = this.position;
        this.position = position;
        long value = this.readVarLong(optimizePositive);
        this.position = pos;
        return value;
    }

    private final long readVarLong(boolean optimizePositive) {
        if (this.capacity - this.position < 9) {
            return this.readLong_slow(optimizePositive);
        }
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        int n = this.position;
        this.position = n + 1;
        byte b = byArray[n];
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            byte[] byArray2 = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray2 = null;
            }
            byte[] buffer = byArray2;
            int n2 = this.position;
            this.position = n2 + 1;
            b = buffer[n2];
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                n2 = this.position;
                this.position = n2 + 1;
                b = buffer[n2];
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    n2 = this.position;
                    this.position = n2 + 1;
                    b = buffer[n2];
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        n2 = this.position;
                        this.position = n2 + 1;
                        b = buffer[n2];
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            n2 = this.position;
                            this.position = n2 + 1;
                            b = buffer[n2];
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                n2 = this.position;
                                this.position = n2 + 1;
                                b = buffer[n2];
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    n2 = this.position;
                                    this.position = n2 + 1;
                                    b = buffer[n2];
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        n2 = this.position;
                                        this.position = n2 + 1;
                                        b = buffer[n2];
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!optimizePositive) {
            result = result >>> 1 ^ -(result & 1L);
        }
        return result;
    }

    private final long readLong_slow(boolean optimizePositive) {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int n = this.position;
        this.position = n + 1;
        byte b = buffer[n];
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            int n2 = this.position;
            this.position = n2 + 1;
            b = buffer[n2];
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                n2 = this.position;
                this.position = n2 + 1;
                b = buffer[n2];
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    n2 = this.position;
                    this.position = n2 + 1;
                    b = buffer[n2];
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        n2 = this.position;
                        this.position = n2 + 1;
                        b = buffer[n2];
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            n2 = this.position;
                            this.position = n2 + 1;
                            b = buffer[n2];
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                n2 = this.position;
                                this.position = n2 + 1;
                                b = buffer[n2];
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    n2 = this.position;
                                    this.position = n2 + 1;
                                    b = buffer[n2];
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        n2 = this.position;
                                        this.position = n2 + 1;
                                        b = buffer[n2];
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!optimizePositive) {
            result = result >>> 1 ^ -(result & 1L);
        }
        return result;
    }

    public final void writeBoolean(boolean value) {
        this.require(1);
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        int n = this.position;
        this.position = n + 1;
        byArray[n] = (byte)(value ? 1 : 0);
    }

    public final boolean readBoolean() {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        int n = this.position;
        this.position = n + 1;
        return byArray[n] == 1;
    }

    public final boolean readBoolean(int position) {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        return byArray[position] == 1;
    }

    public final void writeChar(char value) {
        this.require(2);
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)(value >>> 8);
        n = this.position;
        this.position = n + 1;
        buffer[n] = (byte)value;
    }

    public final char readChar() {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        int n = this.position;
        this.position = n + 1;
        int n2 = (buffer[n] & 0xFF) << 8;
        n = this.position;
        this.position = n + 1;
        return (char)(n2 | buffer[n] & 0xFF);
    }

    public final char readChar(int position) {
        int position2 = position;
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        byte[] buffer = byArray;
        return (char)(((buffer[position2++] & 0xFF) << 8 | buffer[position2]) & 0xFF);
    }

    public final void writeDouble(double value) {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public final int writeDouble(double value, double precision, boolean optimizePositive) {
        return this.writeLong((long)(value * precision), optimizePositive);
    }

    public final double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public final double readDouble(double precision, boolean optimizePositive) {
        return (double)this.readLong(optimizePositive) / precision;
    }

    public final double readDouble(int position) {
        return Double.longBitsToDouble(this.readLong(position));
    }

    public final double readDouble(int position, double precision, boolean optimizePositive) {
        return (double)this.readLong(position, optimizePositive) / precision;
    }

    public final void writeInts(@NotNull int[] object, boolean optimizePositive) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            this.writeInt(object[i], optimizePositive);
        }
    }

    @NotNull
    public final int[] readInts(int length, boolean optimizePositive) {
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readInt(optimizePositive);
        }
        return array;
    }

    public final void writeLongs(@NotNull long[] object, boolean optimizePositive) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            this.writeLong(object[i], optimizePositive);
        }
    }

    @NotNull
    public final long[] readLongs(int length, boolean optimizePositive) {
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readLong(optimizePositive);
        }
        return array;
    }

    public final void writeInts(@NotNull int[] object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            this.writeInt(object[i]);
        }
    }

    @NotNull
    public final int[] readInts(int length) {
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readInt();
        }
        return array;
    }

    public final void writeLongs(@NotNull long[] object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            this.writeLong(object[i]);
        }
    }

    @NotNull
    public final long[] readLongs(int length) {
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readLong();
        }
        return array;
    }

    public final void writeFloats(@NotNull float[] object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            this.writeFloat(object[i]);
        }
    }

    @NotNull
    public final float[] readFloats(int length) {
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readFloat();
        }
        return array;
    }

    public final void writeShorts(@NotNull short[] object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            this.writeShort(object[i]);
        }
    }

    @NotNull
    public final short[] readShorts(int length) {
        short[] array = new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readShort();
        }
        return array;
    }

    public final void writeChars(@NotNull char[] object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            this.writeChar(object[i]);
        }
    }

    @NotNull
    public final char[] readChars(int length) {
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readChar();
        }
        return array;
    }

    public final void writeDoubles(@NotNull double[] object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            this.writeDouble(object[i]);
        }
    }

    @NotNull
    public final double[] readDoubles(int length) {
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readDouble();
        }
        return array;
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (!(other instanceof ByteArrayBuffer)) {
            bl = false;
        } else {
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            byte[] byArray2 = ((ByteArrayBuffer)other).bytes;
            if (((ByteArrayBuffer)other).bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray2 = null;
            }
            bl = Arrays.equals(byArray, byArray2);
        }
        return bl;
    }

    public int hashCode() {
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        return Arrays.hashCode(byArray);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("ByteBuffer2 ");
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        return stringBuilder.append(Arrays.toString(byArray)).toString();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldorkbox/bytes/ByteArrayBuffer$Companion;", "", "()V", "version", "", "intLength", "", "value", "optimizePositive", "", "longLength", "", "ByteUtilities"})
    public static final class Companion {
        private Companion() {
        }

        public final int intLength(int value, boolean optimizePositive) {
            int value2 = value;
            if (!optimizePositive) {
                value2 = value2 << 1 ^ value2 >> 31;
            }
            if (value2 >>> 7 == 0) {
                return 1;
            }
            if (value2 >>> 14 == 0) {
                return 2;
            }
            if (value2 >>> 21 == 0) {
                return 3;
            }
            return value2 >>> 28 == 0 ? 4 : 5;
        }

        public final int longLength(long value, boolean optimizePositive) {
            long value2 = value;
            if (!optimizePositive) {
                value2 = value2 << 1 ^ value2 >> 63;
            }
            if (value2 >>> 7 == 0L) {
                return 1;
            }
            if (value2 >>> 14 == 0L) {
                return 2;
            }
            if (value2 >>> 21 == 0L) {
                return 3;
            }
            if (value2 >>> 28 == 0L) {
                return 4;
            }
            if (value2 >>> 35 == 0L) {
                return 5;
            }
            if (value2 >>> 42 == 0L) {
                return 6;
            }
            if (value2 >>> 49 == 0L) {
                return 7;
            }
            return value2 >>> 56 == 0L ? 8 : 9;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

