/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSetView;
import net.moonlightflower.wc3libs.misc.model.mdx.AttachmentChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.BoneChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.CameraChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.CollisionShapeChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.EventObjectChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.GeosetAnimChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.GeosetChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.GlobalSequenceChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.HelperChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.LightChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.MaterialChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.ModelInfoChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.Node;
import net.moonlightflower.wc3libs.misc.model.mdx.ParticleEmitter2;
import net.moonlightflower.wc3libs.misc.model.mdx.ParticleEmitter2Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.ParticleEmitterChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.PivotPointChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.RibbonEmitterChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.SequenceChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.SoundChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.TexAnimChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.TextureChunk;
import net.moonlightflower.wc3libs.misc.model.mdx.VersionChunk;

public class MDX {
    private final ObservableLinkedHashSet<Chunk> _chunks = new ObservableLinkedHashSet();
    private final LinkedHashSet<SequenceChunk> _sequenceChunks = new ObservableLinkedHashSetView<Chunk, SequenceChunk>(this._chunks, chunk -> chunk instanceof SequenceChunk);
    private final LinkedHashSet<GlobalSequenceChunk> _globalSequenceChunks = new ObservableLinkedHashSetView<Chunk, GlobalSequenceChunk>(this._chunks, chunk -> chunk instanceof GlobalSequenceChunk);
    private final LinkedHashSet<TextureChunk> _textureChunks = new ObservableLinkedHashSetView<Chunk, TextureChunk>(this._chunks, chunk -> chunk instanceof TextureChunk);
    private final LinkedHashSet<SoundChunk> _soundChunks = new ObservableLinkedHashSetView<Chunk, SoundChunk>(this._chunks, chunk -> chunk instanceof SoundChunk);
    private final LinkedHashSet<MaterialChunk> _materialChunks = new ObservableLinkedHashSetView<Chunk, MaterialChunk>(this._chunks, chunk -> chunk instanceof MaterialChunk);
    private final LinkedHashSet<TexAnimChunk> _texAnimChunks = new ObservableLinkedHashSetView<Chunk, TexAnimChunk>(this._chunks, chunk -> chunk instanceof TexAnimChunk);
    private final LinkedHashSet<GeosetChunk> _geosetChunks = new ObservableLinkedHashSetView<Chunk, GeosetChunk>(this._chunks, chunk -> chunk instanceof GeosetChunk);
    private final LinkedHashSet<GeosetAnimChunk> _geosetAnimChunks = new ObservableLinkedHashSetView<Chunk, GeosetAnimChunk>(this._chunks, chunk -> chunk instanceof GeosetAnimChunk);
    private final LinkedHashSet<BoneChunk> _boneChunks = new ObservableLinkedHashSetView<Chunk, BoneChunk>(this._chunks, chunk -> chunk instanceof BoneChunk);
    private final LinkedHashSet<LightChunk> _lightChunks = new ObservableLinkedHashSetView<Chunk, LightChunk>(this._chunks, chunk -> chunk instanceof LightChunk);
    private final LinkedHashSet<HelperChunk> _helperChunks = new ObservableLinkedHashSetView<Chunk, HelperChunk>(this._chunks, chunk -> chunk instanceof HelperChunk);
    private final LinkedHashSet<AttachmentChunk> _attachmentChunks = new ObservableLinkedHashSetView<Chunk, AttachmentChunk>(this._chunks, chunk -> chunk instanceof AttachmentChunk);
    private final LinkedHashSet<PivotPointChunk> _pivotPointChunks = new ObservableLinkedHashSetView<Chunk, PivotPointChunk>(this._chunks, chunk -> chunk instanceof PivotPointChunk);
    private final LinkedHashSet<ParticleEmitterChunk> _particleEmitterChunks = new ObservableLinkedHashSetView<Chunk, ParticleEmitterChunk>(this._chunks, chunk -> chunk instanceof ParticleEmitterChunk);
    private final LinkedHashSet<ParticleEmitter2Chunk> _particleEmitter2Chunks = new ObservableLinkedHashSetView<Chunk, ParticleEmitter2Chunk>(this._chunks, chunk -> chunk instanceof ParticleEmitter2Chunk);
    private final LinkedHashSet<RibbonEmitterChunk> _ribbonEmitterChunks = new ObservableLinkedHashSetView<Chunk, RibbonEmitterChunk>(this._chunks, chunk -> chunk instanceof RibbonEmitterChunk);
    private final LinkedHashSet<EventObjectChunk> _eventObjectChunks = new ObservableLinkedHashSetView<Chunk, EventObjectChunk>(this._chunks, chunk -> chunk instanceof EventObjectChunk);
    private final LinkedHashSet<CameraChunk> _cameraChunks = new ObservableLinkedHashSetView<Chunk, CameraChunk>(this._chunks, chunk -> chunk instanceof CameraChunk);
    private final LinkedHashSet<CollisionShapeChunk> _collisionShapeChunks = new ObservableLinkedHashSetView<Chunk, CollisionShapeChunk>(this._chunks, chunk -> chunk instanceof CollisionShapeChunk);
    public static Id TOKEN = Id.valueOf("MDLX");

    public LinkedHashSet<Chunk> getChunks() {
        return this._chunks;
    }

    @Nonnull
    public Optional<VersionChunk> getVersionChunk() {
        return this._chunks.stream().filter(chunk -> chunk instanceof VersionChunk).map(chunk -> (VersionChunk)chunk).findFirst();
    }

    @Nonnull
    public final Optional<ModelInfoChunk> getModelInfoChunk() {
        return this._chunks.stream().filter(chunk -> chunk instanceof ModelInfoChunk).map(chunk -> (ModelInfoChunk)chunk).findFirst();
    }

    @Nonnull
    public LinkedHashSet<SequenceChunk> getSequenceChunks() {
        return this._sequenceChunks;
    }

    @Nonnull
    public LinkedHashSet<GlobalSequenceChunk> getGlobalSequenceChunks() {
        return this._globalSequenceChunks;
    }

    @Nonnull
    public LinkedHashSet<TextureChunk> getTextureChunks() {
        return this._textureChunks;
    }

    @Nonnull
    public LinkedHashSet<SoundChunk> getSoundChunks() {
        return this._soundChunks;
    }

    @Nonnull
    public LinkedHashSet<MaterialChunk> getMaterialChunks() {
        return this._materialChunks;
    }

    @Nonnull
    public LinkedHashSet<TexAnimChunk> getTextureAnimChunks() {
        return this._texAnimChunks;
    }

    @Nonnull
    public LinkedHashSet<GeosetChunk> getGeosetChunks() {
        return this._geosetChunks;
    }

    @Nonnull
    public LinkedHashSet<GeosetAnimChunk> getGeosetAnimChunks() {
        return this._geosetAnimChunks;
    }

    @Nonnull
    public LinkedHashSet<BoneChunk> getBoneChunks() {
        return this._boneChunks;
    }

    @Nonnull
    public LinkedHashSet<LightChunk> getLightChunks() {
        return this._lightChunks;
    }

    @Nonnull
    public LinkedHashSet<HelperChunk> getHelperChunks() {
        return this._helperChunks;
    }

    @Nonnull
    public LinkedHashSet<AttachmentChunk> getAttachmentChunks() {
        return this._attachmentChunks;
    }

    @Nonnull
    public LinkedHashSet<PivotPointChunk> getPivotPointChunks() {
        return this._pivotPointChunks;
    }

    @Nonnull
    public LinkedHashSet<ParticleEmitterChunk> getParticleEmitterChunks() {
        return this._particleEmitterChunks;
    }

    @Nonnull
    public LinkedHashSet<ParticleEmitter2Chunk> getParticleEmitter2Chunks() {
        return this._particleEmitter2Chunks;
    }

    @Nonnull
    public LinkedHashSet<RibbonEmitterChunk> getRibbonEmitterChunks() {
        return this._ribbonEmitterChunks;
    }

    @Nonnull
    public LinkedHashSet<EventObjectChunk> getEventObjectChunks() {
        return this._eventObjectChunks;
    }

    @Nonnull
    public LinkedHashSet<CameraChunk> getCameraChunks() {
        return this._cameraChunks;
    }

    @Nonnull
    public LinkedHashSet<CollisionShapeChunk> getCollisionShapeChunks() {
        return this._collisionShapeChunks;
    }

    private void read_0x0(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Id startToken = stream.readId("startToken");
        if (!startToken.equals(TOKEN)) {
            throw new IllegalArgumentException("invalid " + TOKEN + " startToken (" + startToken + ")");
        }
        LinkedHashMap<Id, TokenHandler> _tokenMap = new LinkedHashMap<Id, TokenHandler>();
        _tokenMap.put(VersionChunk.TOKEN, () -> this._chunks.add(new VersionChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(ModelInfoChunk.TOKEN, () -> this._chunks.add(new ModelInfoChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(SequenceChunk.TOKEN, () -> this._sequenceChunks.add(new SequenceChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(GlobalSequenceChunk.TOKEN, () -> this._globalSequenceChunks.add(new GlobalSequenceChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(TextureChunk.TOKEN, () -> this._textureChunks.add(new TextureChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(SoundChunk.TOKEN, () -> this._soundChunks.add(new SoundChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(MaterialChunk.TOKEN, () -> this._materialChunks.add(new MaterialChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(TexAnimChunk.TOKEN, () -> this._texAnimChunks.add(new TexAnimChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(GeosetChunk.TOKEN, () -> this._geosetChunks.add(new GeosetChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(GeosetAnimChunk.TOKEN, () -> this._geosetAnimChunks.add(new GeosetAnimChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(BoneChunk.TOKEN, () -> this._boneChunks.add(new BoneChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(LightChunk.TOKEN, () -> this._lightChunks.add(new LightChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(HelperChunk.TOKEN, () -> this._helperChunks.add(new HelperChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(AttachmentChunk.TOKEN, () -> this._attachmentChunks.add(new AttachmentChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(PivotPointChunk.TOKEN, () -> this._pivotPointChunks.add(new PivotPointChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(ParticleEmitterChunk.TOKEN, () -> this._particleEmitterChunks.add(new ParticleEmitterChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(ParticleEmitter2Chunk.TOKEN, () -> this._particleEmitter2Chunks.add(new ParticleEmitter2Chunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(RibbonEmitterChunk.TOKEN, () -> this._ribbonEmitterChunks.add(new RibbonEmitterChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(EventObjectChunk.TOKEN, () -> this._eventObjectChunks.add(new EventObjectChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(CameraChunk.TOKEN, () -> this._cameraChunks.add(new CameraChunk(stream, EncodingFormat.MDX_0x0)));
        _tokenMap.put(CollisionShapeChunk.TOKEN, () -> this._collisionShapeChunks.add(new CollisionShapeChunk(stream, EncodingFormat.MDX_0x0)));
        while (!stream.eof()) {
            Id chunkToken = stream.readId("chunkToken");
            if (_tokenMap.containsKey(chunkToken)) {
                TokenHandler handler = (TokenHandler)_tokenMap.get(chunkToken);
                stream.rewind(4L);
                handler.run();
                continue;
            }
            System.err.println("unknown chunk " + chunkToken + ";" + Arrays.toString(chunkToken.toString().getBytes()));
            long size = stream.readUInt32("header_size");
            stream.skip(size);
        }
    }

    private void write_0x0(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        stream.writeId(TOKEN);
        for (Chunk chunk : this.getChunks()) {
            chunk.write(stream, EncodingFormat.MDX_0x0);
        }
    }

    private void read_auto(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this.read(stream, EncodingFormat.MDX_0x0);
    }

    private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: {
                this.read_auto(stream);
                break;
            }
            case MDX_0x0: {
                this.read_0x0(stream);
            }
        }
    }

    private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: 
            case MDX_0x0: {
                this.write_0x0(stream);
            }
        }
    }

    private void read(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this.read(stream, EncodingFormat.AUTO);
    }

    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, EncodingFormat.AUTO);
    }

    private void read(@Nonnull File file, @Nonnull EncodingFormat format) throws IOException {
        this.read(new Wc3BinInputStream(file), format);
    }

    public void write(@Nonnull File file, @Nonnull EncodingFormat format) throws IOException {
        Wc3BinOutputStream outStream = new Wc3BinOutputStream(file);
        this.write(outStream, format);
        outStream.close();
    }

    private void read(@Nonnull File file) throws IOException {
        this.read(file, EncodingFormat.AUTO);
    }

    public void write(@Nonnull File file) throws IOException {
        this.write(new Wc3BinOutputStream(file));
    }

    public MDX() {
    }

    public MDX(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this.read(stream);
    }

    public MDX(@Nonnull File file) throws IOException {
        this.read(file);
    }

    public void squish() {
        for (Chunk chunk : this.getChunks()) {
            if (chunk instanceof GeosetChunk) {
                this.squishGeoset((GeosetChunk)chunk);
                continue;
            }
            if (chunk instanceof PivotPointChunk) {
                this.squishPivot((PivotPointChunk)chunk);
                continue;
            }
            if (chunk instanceof BoneChunk) {
                this.squishBone((BoneChunk)chunk);
                continue;
            }
            if (chunk instanceof ModelInfoChunk) {
                this.squishModelInfo((ModelInfoChunk)chunk);
                continue;
            }
            if (!(chunk instanceof ParticleEmitter2Chunk)) continue;
            this.squishParticleEmitter2((ParticleEmitter2Chunk)chunk);
        }
    }

    private void squishParticleEmitter2(ParticleEmitter2Chunk chunk) {
        for (ParticleEmitter2 particleEmitter2 : chunk.getParticleEmitter2s()) {
            particleEmitter2.squish();
        }
    }

    private void squishModelInfo(ModelInfoChunk chunk) {
        chunk.setName("");
        chunk.getExtent().squish();
    }

    private void squishBone(BoneChunk chunk) {
        chunk.getBones().forEach(bone -> this.squishNode(bone.getNode()));
    }

    private void squishNode(Node node) {
        node.getRotationTrackChunks().forEach(rotationTrackChunk -> rotationTrackChunk.getRotationTracks().forEach(rotationTrack -> {
            rotationTrack.setRotation(rotationTrack.getRotation().squish());
            rotationTrack.setInTanRotation(rotationTrack.getInTanRotation().squish());
            rotationTrack.setOutTanRotation(rotationTrack.getOutTanRotation().squish());
        }));
        node.getTranslationTrackChunks().forEach(translationTrackChunk -> translationTrackChunk.getTranslationTracks().forEach(translationTrack -> {
            translationTrack.setTranslation(translationTrack.getTranslation().squish());
            translationTrack.setInTanTranslation(translationTrack.getInTanTranslation().squish());
            translationTrack.setOutTanTranslation(translationTrack.getOutTanTranslation().squish());
        }));
        node.getScalingTrackChunks().forEach(scalingTrackChunk -> scalingTrackChunk.getScalingTracks().forEach(scalingTrack -> {
            scalingTrack.setScaling(scalingTrack.getScaling().squish());
            scalingTrack.setInTanScaling(scalingTrack.getInTanScaling().squish());
            scalingTrack.setOutTanScaling(scalingTrack.getOutTanScaling().squish());
        }));
    }

    private void squishPivot(PivotPointChunk chunk) {
        chunk.getPivotPoints().forEach(pivotPoint -> pivotPoint.setPos(pivotPoint.getPos().squish()));
    }

    private void squishGeoset(GeosetChunk chunk) {
        chunk.getGeosets().forEach(geoset -> {
            geoset.getVertexChunk().getVertices().forEach(vertex -> vertex.setPos(vertex.getPos().squish()));
            geoset.getVertexNormalChunk().getVertices().forEach(vertex -> vertex.setPos(vertex.getPos().squish()));
            geoset.getTexCoordSetChunk().getTexCoordSets().forEach(texCoordSet -> texCoordSet.getTexCoords().forEach(texCoord -> texCoord.setPos(texCoord.getPos().squish())));
        });
    }

    public static interface TokenHandler {
        public void run() throws BinStream.StreamException;
    }

    public static class EncodingFormat
    extends Format<Enum> {
        private static Map<Integer, EncodingFormat> _map = new LinkedHashMap<Integer, EncodingFormat>();
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, -1);
        public static final EncodingFormat MDX_0x0 = new EncodingFormat(Enum.MDX_0x0, 0);

        public static EncodingFormat valueOf(int version) {
            return _map.get(version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, int version) {
            super(enumVal, version);
            _map.put(version, this);
        }

        public static enum Enum {
            AUTO,
            MDX_0x0;

        }
    }
}

