/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.immutablecollections;

import de.peeeq.immutablecollections.ImmutableListEmpty;
import java.util.Arrays;
import org.eclipse.jdt.annotation.Nullable;

public abstract class ImmutableList<T>
implements Iterable<T> {
    private int hashCode = 0;

    public abstract ImmutableList<T> appFront(T var1);

    public abstract <R extends T> ImmutableList<T> cons(ImmutableList<R> var1);

    public abstract T head();

    public abstract ImmutableList<T> tail();

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(T elem) {
        for (Object t : this) {
            if (!t.equals(elem)) continue;
            return true;
        }
        return false;
    }

    public static <T> ImmutableList<T> emptyList() {
        return ImmutableListEmpty.instance();
    }

    @SafeVarargs
    public static <T> ImmutableList<T> of(T ... elems) {
        ImmutableList<T> result = ImmutableList.emptyList();
        for (int i = elems.length - 1; i >= 0; --i) {
            T elem = elems[i];
            if (elem == null) {
                throw new IllegalArgumentException("Elem " + i + " is null.");
            }
            result = result.appFront(elem);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("List(");
        boolean first = true;
        for (Object t : this) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(t);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            Object[] elements = new Object[this.size()];
            int i = 0;
            for (Object t : this) {
                elements[i] = t;
                ++i;
            }
            this.hashCode = Arrays.hashCode(elements);
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof ImmutableList) {
            ImmutableList other = (ImmutableList)obj;
            if (other.size() != this.size() || other.hashCode() != this.hashCode()) {
                return false;
            }
            if (this.size() == 0) {
                return true;
            }
            if (!other.head().equals(this.head())) {
                return false;
            }
            if (this.size() > 1) {
                return other.tail().equals(this.tail());
            }
            return true;
        }
        return false;
    }

    public ImmutableList<T> appBack(T elem) {
        return this.cons(ImmutableList.emptyList().appFront(elem));
    }

    public abstract ImmutableList<T> removeAll(T var1);
}

