/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.datastructures;

import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TransitiveClosure<T> {
    private final Multimap<T, T> base;

    public TransitiveClosure(Multimap<T, T> base) {
        this.base = base;
    }

    public List<T> getAsList(T start) {
        return this.get(start).collect(Collectors.toList());
    }

    public Stream<T> get(T start) {
        HashSet visited = new HashSet();
        return this.base.get(start).stream().flatMap(c -> this.visit(c, visited));
    }

    private Stream<T> visit(T start, Set<T> visited) {
        if (visited.contains(start)) {
            return Stream.empty();
        }
        visited.add(start);
        return Stream.concat(Stream.of(start), this.base.get(start).stream().flatMap(c -> this.visit(c, visited)));
    }
}

