/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.intermediatelang.optimizer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImConst;
import de.peeeq.wurstscript.jassIm.ImExitwhen;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImIf;
import de.peeeq.wurstscript.jassIm.ImLoop;
import de.peeeq.wurstscript.jassIm.ImMemberAccess;
import de.peeeq.wurstscript.jassIm.ImMethodCall;
import de.peeeq.wurstscript.jassIm.ImOperatorCall;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImTupleSelection;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.ImVarRead;
import de.peeeq.wurstscript.jassIm.ImVarargLoop;
import de.peeeq.wurstscript.translation.imoptimizer.OptimizerPass;
import de.peeeq.wurstscript.translation.imtranslation.AssertProperty;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.TypesHelper;
import de.peeeq.wurstscript.utils.MapWithIndexes;
import de.peeeq.wurstscript.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;

public class TempMerger
implements OptimizerPass {
    private int totalMerged = 0;

    @Override
    public String getName() {
        return "Temp variables merged";
    }

    @Override
    public int optimize(ImTranslator trans) {
        ImProg prog = trans.getImProg();
        this.totalMerged = 0;
        trans.assertProperties(AssertProperty.FLAT, AssertProperty.NOTUPLES);
        prog.clearAttributes();
        for (ImFunction f : ImHelper.calculateFunctionsOfProg(prog)) {
            this.optimizeFunc(f);
        }
        prog.flatten(trans);
        return this.totalMerged;
    }

    void optimizeFunc(ImFunction f) {
        this.optimizeStatements(f.getBody());
    }

    private void optimizeStatements(ImStmts stmts) {
        Knowledge kn = new Knowledge();
        Replacement replacement = null;
        block0: do {
            kn.clear();
            for (ImStmt s : stmts) {
                ImSet imSet;
                if (s instanceof ImSet && (imSet = (ImSet)s).getRight() instanceof ImVarAccess && imSet.getLeft() instanceof ImVarAccess) {
                    ImVarAccess right = (ImVarAccess)imSet.getRight();
                    ImVarAccess left = (ImVarAccess)imSet.getLeft();
                    if (left.getVar() == right.getVar()) {
                        ++this.totalMerged;
                        imSet.replaceBy(ImHelper.nullExpr());
                        continue;
                    }
                }
                if ((replacement = this.processStatement(s, kn)) == null) continue;
                ++this.totalMerged;
                replacement.apply();
                continue block0;
            }
        } while (replacement != null);
        for (ImStmt s : stmts) {
            if (s instanceof ImIf) {
                ImIf imIf = (ImIf)s;
                this.optimizeStatements(imIf.getThenBlock());
                this.optimizeStatements(imIf.getElseBlock());
                continue;
            }
            if (s instanceof ImLoop) {
                ImLoop imLoop = (ImLoop)s;
                this.optimizeStatements(imLoop.getBody());
                continue;
            }
            if (!(s instanceof ImVarargLoop)) continue;
            ImVarargLoop imVarargLoop = (ImVarargLoop)s;
            this.optimizeStatements(imVarargLoop.getBody());
        }
    }

    private @Nullable Replacement processStatement(ImStmt s, Knowledge kn) {
        Replacement rep = this.getPossibleReplacement(s, kn);
        if (rep != null) {
            return rep;
        }
        if (this.containsFuncCall(s)) {
            kn.invalidateGlobals();
        }
        if (this.readsGlobal(s)) {
            kn.invalidateMutatingExpressions();
        }
        if (s instanceof ImSet) {
            ImSet imSet = (ImSet)s;
            if (imSet.getLeft() instanceof ImVarAccess) {
                ImVarAccess va = (ImVarAccess)imSet.getLeft();
                kn.update(va.getVar(), imSet);
            } else if (imSet.getLeft() instanceof ImVarArrayAccess) {
                ImVarArrayAccess va = (ImVarArrayAccess)imSet.getLeft();
                kn.invalidateVar(va.getVar());
            } else if (imSet.getLeft() instanceof ImMemberAccess) {
                ImMemberAccess ma = (ImMemberAccess)imSet.getLeft();
                kn.invalidateVar(ma.getVar());
            } else if (imSet.getLeft() instanceof ImTupleSelection) {
                kn.invalidateVar(TypesHelper.getTupleVar((ImTupleSelection)imSet.getLeft()));
            }
        } else if (s instanceof ImExitwhen || s instanceof ImIf || s instanceof ImLoop || s instanceof ImVarargLoop) {
            kn.clear();
        }
        return null;
    }

    private @Nullable Replacement getPossibleReplacement(Element elem, Knowledge kn) {
        ImVarRead va;
        if (kn.isEmpty()) {
            return null;
        }
        if (elem instanceof ImVarAccess) {
            ImVarAccess va2 = (ImVarAccess)elem;
            if (!va2.isUsedAsLValue()) {
                return kn.getReplacementIfPossible(va2);
            }
        } else {
            ImOperatorCall opCall;
            if (elem instanceof ImLoop) {
                return null;
            }
            if (elem instanceof ImVarargLoop) {
                return null;
            }
            if (elem instanceof ImIf) {
                ImIf imIf = (ImIf)elem;
                return this.getPossibleReplacement(imIf.getCondition(), kn);
            }
            if (elem instanceof ImOperatorCall && (opCall = (ImOperatorCall)elem).getOp().isLazy()) {
                return this.getPossibleReplacement((Element)opCall.getArguments().get(0), kn);
            }
        }
        for (int i = 0; i < elem.size(); ++i) {
            Replacement r = this.getPossibleReplacement(elem.get(i), kn);
            if (r == null) continue;
            return r;
        }
        if (elem instanceof ImFunctionCall) {
            kn.invalidateGlobals();
        } else if (elem instanceof ImMethodCall) {
            kn.invalidateGlobals();
        } else if (elem instanceof ImVarRead && (va = (ImVarRead)elem).getVar().isGlobal()) {
            kn.invalidateMutatingExpressions();
        }
        return null;
    }

    private boolean containsFuncCall(Element elem) {
        if (elem instanceof ImFunctionCall || elem instanceof ImMethodCall) {
            return true;
        }
        boolean r = false;
        for (int i = 0; i < elem.size(); ++i) {
            r = this.containsFuncCall(elem.get(i));
            if (!r) continue;
            return true;
        }
        return false;
    }

    private boolean readsVar(Element elem, ImVar left) {
        ImVarRead va;
        if (elem instanceof ImVarRead && (va = (ImVarRead)elem).getVar() == left) {
            return true;
        }
        if (elem instanceof ImMemberAccess && ((ImMemberAccess)elem).getVar() == left) {
            return true;
        }
        for (int i = 0; i < elem.size(); ++i) {
            if (!this.readsVar(elem.get(i), left)) continue;
            return true;
        }
        return false;
    }

    private boolean readsGlobal(Element elem) {
        ImVarRead va;
        if (elem instanceof ImVarRead && (va = (ImVarRead)elem).getVar().isGlobal()) {
            return true;
        }
        if (elem instanceof ImMemberAccess) {
            return true;
        }
        for (int i = 0; i < elem.size(); ++i) {
            if (!this.readsGlobal(elem.get(i))) continue;
            return true;
        }
        return false;
    }

    private Collection<ImVarRead> readVariables(Element e) {
        ArrayList result = Lists.newArrayList();
        this.collectReadVariables(result, e);
        return result;
    }

    private void collectReadVariables(Collection<ImVarRead> result, Element e) {
        if (e instanceof ImVarRead) {
            result.add((ImVarRead)e);
        }
        for (int i = 0; i < e.size(); ++i) {
            this.collectReadVariables(result, e.get(i));
        }
    }

    private boolean isSimplePureExpr(ImExpr e) {
        if (e instanceof ImConst) {
            return true;
        }
        if (e instanceof ImVarAccess) {
            ImVarAccess va = (ImVarAccess)e;
            return !va.getVar().isGlobal();
        }
        return false;
    }

    class Knowledge {
        private final MapWithIndexes<ImVar, VarKnowledge> currentValues = new MapWithIndexes();
        private final MapWithIndexes.Index<ImVar, ImVar> readBy = this.currentValues.createMultiIndex(v -> v.dependsOn);
        private final MapWithIndexes.PredIndex<ImVar> globalState = this.currentValues.createPredicateIndex(v -> v.dependsOnGlobals);
        private final MapWithIndexes.PredIndex<ImVar> mutating = this.currentValues.createPredicateIndex(v -> v.isMutating);

        Knowledge() {
        }

        public void invalidateGlobals() {
            this.currentValues.removeAll(this.globalState.lookup());
        }

        public void invalidateMutatingExpressions() {
            this.currentValues.removeAll(this.mutating.lookup());
        }

        public void clear() {
            this.currentValues.clear();
        }

        public @Nullable Replacement getReplacementIfPossible(ImVarAccess va) {
            for (Map.Entry<ImVar, VarKnowledge> e : this.currentValues.entrySet()) {
                if (e.getKey() != va.getVar()) continue;
                return new Replacement(e.getValue().imSet, va);
            }
            return null;
        }

        public boolean isEmpty() {
            return this.currentValues.isEmpty();
        }

        public void update(ImVar left, ImSet set) {
            this.invalidateVar(left);
            if (this.isMergable(left, set.getRight())) {
                VarKnowledge k = new VarKnowledge(set);
                this.currentValues.put(left, k);
            }
        }

        private boolean isMergable(ImVar left, ImExpr e) {
            ImVarAccess va;
            if (left.isGlobal()) {
                return false;
            }
            if (e instanceof ImVarAccess && (va = (ImVarAccess)e).getVar() == left) {
                return false;
            }
            if (left.attrReads().size() == 1) {
                return true;
            }
            return TempMerger.this.isSimplePureExpr(e);
        }

        private void invalidateVar(ImVar left) {
            this.currentValues.remove(left);
            if (left.isGlobal()) {
                this.invalidateGlobals();
            } else {
                this.currentValues.removeAll(this.readBy.lookup(left));
            }
        }

        public String toString() {
            ArrayList keys = Lists.newArrayList(this.currentValues.keySet());
            keys.sort(Utils.compareByNameIm());
            StringBuilder sb = new StringBuilder();
            for (ImVar v : keys) {
                ImSet s = this.currentValues.get((ImVar)v).imSet;
                sb.append(v.getName()).append(" -> ").append(s).append(", ");
            }
            return sb.toString();
        }

        class VarKnowledge {
            private final ImSet imSet;
            private final Set<ImVar> dependsOn;
            private final boolean dependsOnGlobals;
            private final boolean isMutating;

            public VarKnowledge(ImSet imSet, Set<ImVar> dependsOn, boolean dependsOnGlobals, boolean isMutating) {
                this.imSet = imSet;
                this.dependsOn = dependsOn;
                this.dependsOnGlobals = dependsOnGlobals;
                this.isMutating = isMutating;
            }

            public VarKnowledge(ImSet set) {
                this.imSet = set;
                this.dependsOn = new LinkedHashSet<ImVar>();
                this.collectReadVariables(this.dependsOn, set.getRight());
                boolean containsFuncCall = TempMerger.this.containsFuncCall(set);
                this.dependsOnGlobals = containsFuncCall || TempMerger.this.readsGlobal(set.getRight());
                this.isMutating = containsFuncCall;
            }

            private void collectReadVariables(Collection<ImVar> result, Element e) {
                if (e instanceof ImVarRead) {
                    result.add(((ImVarRead)e).getVar());
                }
                if (e instanceof ImMemberAccess) {
                    result.add(((ImMemberAccess)e).getVar());
                }
                for (int i = 0; i < e.size(); ++i) {
                    this.collectReadVariables(result, e.get(i));
                }
            }
        }
    }

    class Replacement {
        public final ImSet set;
        public final ImVarAccess read;

        public Replacement(ImSet set, ImVarAccess read) {
            Preconditions.checkArgument((boolean)(set.getLeft() instanceof ImVarAccess));
            this.set = set;
            this.read = read;
        }

        public String toString() {
            return "replace " + this.read + ", using " + this.set;
        }

        public void apply() {
            ImExpr e = this.set.getRight();
            if (this.getAssignedVar().attrReads().size() <= 1) {
                this.set.replaceBy(ImHelper.nullExpr());
                for (ImVarRead r : TempMerger.this.readVariables(this.set)) {
                    r.getVar().attrReads().remove(r);
                }
            }
            ImExpr newE = e.copy();
            this.read.replaceBy(newE);
            this.getAssignedVar().attrReads().remove(this.read);
            for (ImVarRead r : TempMerger.this.readVariables(newE)) {
                r.getVar().attrReads().add(r);
            }
        }

        private ImVar getAssignedVar() {
            return ((ImVarAccess)this.set.getLeft()).getVar();
        }
    }
}

