/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.peParser;

import dorkbox.os.OS;
import dorkbox.peParser.ByteArray;
import dorkbox.peParser.headers.COFFFileHeader;
import dorkbox.peParser.headers.Header;
import dorkbox.peParser.headers.OptionalHeader;
import dorkbox.peParser.headers.SectionTable;
import dorkbox.peParser.headers.SectionTableEntry;
import dorkbox.peParser.headers.resources.ResourceDataEntry;
import dorkbox.peParser.headers.resources.ResourceDirectoryEntry;
import dorkbox.peParser.headers.resources.ResourceDirectoryHeader;
import dorkbox.peParser.misc.DirEntry;
import dorkbox.peParser.types.ByteDefinition;
import dorkbox.peParser.types.ImageDataDir;
import dorkbox.peParser.types.ResourceDirName;
import dorkbox.peParser.types.WORD;
import dorkbox.updates.Updates;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J2\u0010'\u001a\u00020(2\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010+0*2\u000e\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010+0*2\b\u0010-\u001a\u0004\u0018\u00010+H\u0002J\u0010\u0010.\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Ldorkbox/peParser/PE;", "", "fileName", "", "(Ljava/lang/String;)V", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "coffHeader", "Ldorkbox/peParser/headers/COFFFileHeader;", "fileBytes", "Ldorkbox/peParser/ByteArray;", "getFileBytes", "()Ldorkbox/peParser/ByteArray;", "setFileBytes", "(Ldorkbox/peParser/ByteArray;)V", "info", "getInfo", "()Ljava/lang/String;", "invalidFile", "", "isPE", "()Z", "largestResourceAsStream", "Ljava/io/ByteArrayInputStream;", "getLargestResourceAsStream", "()Ljava/io/ByteArrayInputStream;", "optionalHeader", "Ldorkbox/peParser/headers/OptionalHeader;", "getOptionalHeader", "()Ldorkbox/peParser/headers/OptionalHeader;", "setOptionalHeader", "(Ldorkbox/peParser/headers/OptionalHeader;)V", "pEOffset", "", "getPEOffset", "()I", "sectionTable", "Ldorkbox/peParser/headers/SectionTable;", "collect", "", "directoryEntries", "Ljava/util/LinkedList;", "Ldorkbox/peParser/headers/resources/ResourceDirectoryEntry;", "resourceEntries", "entry", "fromInputStream", "Companion", "PeParser"})
@SourceDebugExtension(value={"SMAP\nPE.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PE.kt\ndorkbox/peParser/PE\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n1#2:314\n*E\n"})
public final class PE {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ByteArray fileBytes;
    @Nullable
    private COFFFileHeader coffHeader;
    @Nullable
    private OptionalHeader optionalHeader;
    @Nullable
    private SectionTable sectionTable;
    private boolean invalidFile;
    @NotNull
    private static final String version = "3.3";
    private static final int PE_OFFSET_LOCATION = 60;
    @NotNull
    private static final byte[] PE_SIG;

    @Nullable
    public final ByteArray getFileBytes() {
        return this.fileBytes;
    }

    public final void setFileBytes(@Nullable ByteArray byteArray) {
        this.fileBytes = byteArray;
    }

    @Nullable
    public final OptionalHeader getOptionalHeader() {
        return this.optionalHeader;
    }

    public final void setOptionalHeader(@Nullable OptionalHeader optionalHeader) {
        this.optionalHeader = optionalHeader;
    }

    public PE(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File file = new File(fileName);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.fromInputStream(fileInputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PE(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        try {
            this.fromInputStream(inputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final void fromInputStream(InputStream inputStream) throws FileNotFoundException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        byte[] buffer = new byte[4096];
        int read = 0;
        while (true) {
            int n;
            int it = n = inputStream.read(buffer);
            boolean bl = false;
            read = it;
            if (n <= 0) break;
            baos.write(buffer, 0, read);
        }
        baos.flush();
        inputStream.close();
        byte[] bytes = baos.toByteArray();
        this.invalidFile = bytes.length == 0;
        this.fileBytes = new ByteArray(bytes);
        if (this.isPE()) {
            int offset = this.getPEOffset() + PE_SIG.length;
            ByteArray byteArray = this.fileBytes;
            Intrinsics.checkNotNull((Object)byteArray);
            byteArray.seek(offset);
            ByteArray byteArray2 = this.fileBytes;
            Intrinsics.checkNotNull((Object)byteArray2);
            this.coffHeader = new COFFFileHeader(byteArray2);
            ByteArray byteArray3 = this.fileBytes;
            Intrinsics.checkNotNull((Object)byteArray3);
            this.optionalHeader = new OptionalHeader(byteArray3);
            COFFFileHeader cOFFFileHeader = this.coffHeader;
            Intrinsics.checkNotNull((Object)cOFFFileHeader);
            WORD wORD = cOFFFileHeader.getNumberOfSections();
            Intrinsics.checkNotNull((Object)wORD);
            int numberOfEntries = wORD.get-Mh2AYeg() & 0xFFFF;
            ByteArray byteArray4 = this.fileBytes;
            Intrinsics.checkNotNull((Object)byteArray4);
            SectionTable sectionTable = this.sectionTable = new SectionTable(byteArray4, numberOfEntries);
            Intrinsics.checkNotNull((Object)sectionTable);
            block1: for (SectionTableEntry section : sectionTable.getSections()) {
                long sectionAddress = (long)section.getVIRTUAL_ADDRESS().get-pVg5ArA() & 0xFFFFFFFFL;
                long sectionSize = (long)section.getSIZE_OF_RAW_DATA().get-pVg5ArA() & 0xFFFFFFFFL;
                OptionalHeader optionalHeader = this.optionalHeader;
                Intrinsics.checkNotNull((Object)optionalHeader);
                for (ImageDataDir entry : optionalHeader.getTables()) {
                    long optionAddress = (long)entry.get-pVg5ArA() & 0xFFFFFFFFL;
                    if (sectionAddress > optionAddress || sectionAddress + sectionSize <= optionAddress) continue;
                    entry.setSection(section);
                    continue block1;
                }
            }
            OptionalHeader optionalHeader = this.optionalHeader;
            Intrinsics.checkNotNull((Object)optionalHeader);
            for (ImageDataDir entry : optionalHeader.getTables()) {
                SectionTableEntry section;
                if (entry.getType() != DirEntry.RESOURCE || (section = entry.getSection()) == null) continue;
                long delta = ((long)section.getVIRTUAL_ADDRESS().get-pVg5ArA() & 0xFFFFFFFFL) - ((long)section.getPOINTER_TO_RAW_DATA().get-pVg5ArA() & 0xFFFFFFFFL);
                long offsetInFile = ((long)entry.get-pVg5ArA() & 0xFFFFFFFFL) - delta;
                if (offsetInFile > Integer.MAX_VALUE) {
                    throw new RuntimeException("Unable to set offset to more than 2gb!");
                }
                ByteArray byteArray5 = this.fileBytes;
                Intrinsics.checkNotNull((Object)byteArray5);
                byteArray5.seek((int)offsetInFile);
                ByteArray byteArray6 = this.fileBytes;
                Intrinsics.checkNotNull((Object)byteArray6);
                byteArray6.mark();
                ByteArray byteArray7 = this.fileBytes;
                Intrinsics.checkNotNull((Object)byteArray7);
                Header root = new ResourceDirectoryHeader(byteArray7, section, 0);
                entry.setData(root);
            }
        }
    }

    @NotNull
    public final String getInfo() {
        String string;
        if (this.isPE()) {
            StringBuilder b = new StringBuilder();
            b.append("PE signature offset: ").append(this.getPEOffset()).append(OS.INSTANCE.getLINE_SEPARATOR()).append("PE signature correct: ").append("yes").append(OS.INSTANCE.getLINE_SEPARATOR()).append(OS.INSTANCE.getLINE_SEPARATOR()).append("----------------").append(OS.INSTANCE.getLINE_SEPARATOR()).append("COFF header info").append(OS.INSTANCE.getLINE_SEPARATOR()).append("----------------").append(OS.INSTANCE.getLINE_SEPARATOR());
            COFFFileHeader cOFFFileHeader = this.coffHeader;
            Intrinsics.checkNotNull((Object)cOFFFileHeader);
            for (ByteDefinition<?> bd : cOFFFileHeader.getHeaders()) {
                bd.format(b);
            }
            b.append(OS.INSTANCE.getLINE_SEPARATOR());
            b.append("--------------------").append(OS.INSTANCE.getLINE_SEPARATOR()).append("Optional header info").append(OS.INSTANCE.getLINE_SEPARATOR()).append("--------------------").append(OS.INSTANCE.getLINE_SEPARATOR());
            OptionalHeader optionalHeader = this.optionalHeader;
            Intrinsics.checkNotNull((Object)optionalHeader);
            for (ByteDefinition<?> bd : optionalHeader.getHeaders()) {
                bd.format(b);
            }
            b.append(OS.INSTANCE.getLINE_SEPARATOR());
            b.append(OS.INSTANCE.getLINE_SEPARATOR()).append("-------------").append(OS.INSTANCE.getLINE_SEPARATOR()).append("Section Table").append(OS.INSTANCE.getLINE_SEPARATOR()).append("-------------").append(OS.INSTANCE.getLINE_SEPARATOR()).append(OS.INSTANCE.getLINE_SEPARATOR());
            SectionTable sectionTable = this.sectionTable;
            Intrinsics.checkNotNull((Object)sectionTable);
            for (SectionTableEntry section : sectionTable.getSections()) {
                for (ByteDefinition<?> bd : section.getHeaders()) {
                    bd.format(b);
                }
            }
            b.append(OS.INSTANCE.getLINE_SEPARATOR());
            String string2 = b.toString();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = "PE signature not found. The given file is not a PE file. " + OS.INSTANCE + ".LINE_SEPARATOR";
        }
        return string;
    }

    private final int getPEOffset() {
        ByteArray byteArray = this.fileBytes;
        Intrinsics.checkNotNull((Object)byteArray);
        byteArray.mark();
        ByteArray byteArray2 = this.fileBytes;
        Intrinsics.checkNotNull((Object)byteArray2);
        byteArray2.seek(60);
        ByteArray byteArray3 = this.fileBytes;
        Intrinsics.checkNotNull((Object)byteArray3);
        int read = byteArray3.readUShort-BwKQO78(2) & 0xFFFF;
        ByteArray byteArray4 = this.fileBytes;
        Intrinsics.checkNotNull((Object)byteArray4);
        byteArray4.reset();
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isPE() {
        boolean bl;
        if (this.invalidFile) {
            return false;
        }
        int saved = -1;
        try {
            int offset = this.getPEOffset();
            ByteArray byteArray = this.fileBytes;
            Intrinsics.checkNotNull((Object)byteArray);
            saved = byteArray.position();
            ByteArray byteArray2 = this.fileBytes;
            Intrinsics.checkNotNull((Object)byteArray2);
            byteArray2.seek(0);
            int n = PE_SIG.length;
            for (int i = 0; i < n; ++i) {
                ByteArray byteArray3 = this.fileBytes;
                Intrinsics.checkNotNull((Object)byteArray3);
                if (byteArray3.readRaw(offset + i) == PE_SIG[i]) continue;
                boolean bl2 = false;
                return bl2;
            }
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        finally {
            if (saved != -1) {
                ByteArray byteArray = this.fileBytes;
                Intrinsics.checkNotNull((Object)byteArray);
                byteArray.seek(saved);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ByteArrayInputStream getLargestResourceAsStream() {
        OptionalHeader optionalHeader = this.optionalHeader;
        Intrinsics.checkNotNull((Object)optionalHeader);
        for (ImageDataDir mainEntry : optionalHeader.getTables()) {
            void var7_11;
            ResourceDirectoryHeader root;
            if (mainEntry.getType() != DirEntry.RESOURCE) continue;
            LinkedList<ResourceDirectoryEntry> directoryEntries = new LinkedList<ResourceDirectoryEntry>();
            LinkedList<ResourceDirectoryEntry> resourceEntries = new LinkedList<ResourceDirectoryEntry>();
            ResourceDirectoryEntry entry = null;
            ResourceDirectoryHeader resourceDirectoryHeader = root = (ResourceDirectoryHeader)mainEntry.getData();
            Intrinsics.checkNotNull((Object)resourceDirectoryHeader);
            for (ResourceDirectoryEntry rootEntry : resourceDirectoryHeader.getEntries()) {
                this.collect(directoryEntries, resourceEntries, rootEntry);
                directoryEntries.add(rootEntry);
            }
            while (true) {
                Object e = directoryEntries.poll();
                ResourceDirectoryEntry it = (ResourceDirectoryEntry)e;
                boolean bl = false;
                entry = it;
                if (e == null) break;
                this.collect(directoryEntries, resourceEntries, entry);
            }
            Object var7_10 = null;
            Iterator iterator = resourceEntries.iterator();
            while (iterator.hasNext()) {
                ResourceDirectoryEntry resourceEntry;
                ResourceDirectoryEntry resourceDirectoryEntry = resourceEntry = (ResourceDirectoryEntry)iterator.next();
                Intrinsics.checkNotNull((Object)resourceDirectoryEntry);
                ResourceDataEntry dataEntry = resourceDirectoryEntry.getResourceDataEntry();
                if (var7_11 != null) {
                    long l = (long)var7_11.getSIZE().get-pVg5ArA() & 0xFFFFFFFFL;
                    ResourceDataEntry resourceDataEntry = dataEntry;
                    Intrinsics.checkNotNull((Object)resourceDataEntry);
                    if (l >= ((long)resourceDataEntry.getSIZE().get-pVg5ArA() & 0xFFFFFFFFL)) continue;
                }
                ResourceDataEntry resourceDataEntry = dataEntry;
            }
            void v5 = var7_11;
            Intrinsics.checkNotNull((Object)v5);
            ByteArray byteArray = this.fileBytes;
            Intrinsics.checkNotNull((Object)byteArray);
            return new ByteArrayInputStream(v5.getData(byteArray));
        }
        return null;
    }

    private final void collect(LinkedList<ResourceDirectoryEntry> directoryEntries, LinkedList<ResourceDirectoryEntry> resourceEntries, ResourceDirectoryEntry entry) {
        ResourceDirectoryEntry resourceDirectoryEntry = entry;
        Intrinsics.checkNotNull((Object)resourceDirectoryEntry);
        if (resourceDirectoryEntry.isDirectory()) {
            ResourceDirectoryHeader resourceDirectoryHeader = entry.getDirectory();
            Intrinsics.checkNotNull((Object)resourceDirectoryHeader);
            for (ResourceDirectoryEntry dirEntry : resourceDirectoryHeader.getEntries()) {
                directoryEntries.add(dirEntry);
            }
        } else {
            resourceEntries.add(entry);
        }
    }

    static {
        String string = "PE\u0000\u0000";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        PE_SIG = byArray;
        Updates.INSTANCE.add(PE.class, "5f5fafe156ba4e8f94c28f0c283aa509", version);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\bJ\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\bH\u0002J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u0004J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Ldorkbox/peParser/PE$Companion;", "", "()V", "PE_OFFSET_LOCATION", "", "PE_SIG", "", "version", "", "getVersion", "()Ljava/lang/String;", "executablePath", "includeNulls", "str", "indexOf", "outerArray", "smallerArray", "begin", "removeNulls", "PeParser"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getVersion() {
            return version;
        }

        @Nullable
        public final String getVersion(@NotNull String executablePath) throws Exception {
            Intrinsics.checkNotNullParameter((Object)executablePath, (String)"executablePath");
            PE pe = new PE(executablePath);
            if (pe.invalidFile) {
                throw new Exception("No version found:" + executablePath);
            }
            OptionalHeader optionalHeader = pe.getOptionalHeader();
            Intrinsics.checkNotNull((Object)optionalHeader);
            for (ImageDataDir mainEntry : optionalHeader.getTables()) {
                ResourceDirectoryHeader root;
                if (mainEntry.getType() != DirEntry.RESOURCE) continue;
                ResourceDirectoryHeader resourceDirectoryHeader = root = (ResourceDirectoryHeader)mainEntry.getData();
                Intrinsics.checkNotNull((Object)resourceDirectoryHeader);
                ResourceDirectoryEntry[] resourceDirectoryEntryArray = resourceDirectoryHeader.getEntries();
                int n = resourceDirectoryEntryArray.length;
                for (int i = 0; i < n; ++i) {
                    ResourceDirectoryEntry rootEntry;
                    ResourceDirectoryEntry resourceDirectoryEntry = rootEntry = resourceDirectoryEntryArray[i];
                    Intrinsics.checkNotNull((Object)resourceDirectoryEntry);
                    ResourceDirName resourceDirName = resourceDirectoryEntry.getNAME();
                    Intrinsics.checkNotNull((Object)resourceDirName);
                    if (!Intrinsics.areEqual((Object)"Version", (Object)resourceDirName.get())) continue;
                    ResourceDirectoryHeader resourceDirectoryHeader2 = rootEntry.getDirectory();
                    Intrinsics.checkNotNull((Object)resourceDirectoryHeader2);
                    ResourceDirectoryEntry resourceDirectoryEntry2 = resourceDirectoryHeader2.getEntries()[0];
                    Intrinsics.checkNotNull((Object)resourceDirectoryEntry2);
                    ResourceDirectoryHeader resourceDirectoryHeader3 = resourceDirectoryEntry2.getDirectory();
                    Intrinsics.checkNotNull((Object)resourceDirectoryHeader3);
                    ResourceDirectoryEntry resourceDirectoryEntry3 = resourceDirectoryHeader3.getEntries()[0];
                    Intrinsics.checkNotNull((Object)resourceDirectoryEntry3);
                    ResourceDataEntry resourceDataEntry = resourceDirectoryEntry3.getResourceDataEntry();
                    Intrinsics.checkNotNull((Object)resourceDataEntry);
                    ByteArray byteArray = pe.getFileBytes();
                    Intrinsics.checkNotNull((Object)byteArray);
                    byte[] versionInfoData = resourceDataEntry.getData(byteArray);
                    int fileVersionIndex = dorkbox.peParser.PE$Companion.indexOf$default(this, versionInfoData, this.includeNulls("FileVersion"), 0, 4, null) + 26;
                    byte[] byArray = new byte[]{0, 0};
                    int fileVersionEndIndex = this.indexOf(versionInfoData, byArray, fileVersionIndex);
                    return this.removeNulls(new String(versionInfoData, fileVersionIndex, fileVersionEndIndex - fileVersionIndex, Charsets.UTF_8));
                }
            }
            throw new Exception("No version found:" + executablePath);
        }

        private final byte[] includeNulls(String str) {
            char[] cArray = str.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            char[] chars = cArray;
            byte[] result = new byte[chars.length * 2];
            int i = 0;
            int j = 0;
            while (i < result.length) {
                result[i] = (byte)chars[j];
                i += 2;
                ++j;
            }
            return result;
        }

        private final String removeNulls(String str) {
            String string;
            String string2 = str;
            if (string2 != null) {
                CharSequence charSequence = string2;
                Regex regex = new Regex("\\x00");
                String string3 = "";
                string = regex.replace(charSequence, string3);
            } else {
                string = null;
            }
            return string;
        }

        public final int indexOf(@NotNull byte[] outerArray, @NotNull byte[] smallerArray, int begin) {
            Intrinsics.checkNotNullParameter((Object)outerArray, (String)"outerArray");
            Intrinsics.checkNotNullParameter((Object)smallerArray, (String)"smallerArray");
            int n = outerArray.length - smallerArray.length + 1;
            for (int i = begin; i < n; ++i) {
                boolean found = true;
                int n2 = smallerArray.length;
                for (int j = 0; j < n2; ++j) {
                    if (outerArray[i + j] == smallerArray[j]) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                return i;
            }
            return -1;
        }

        public static /* synthetic */ int indexOf$default(Companion companion, byte[] byArray, byte[] byArray2, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            return companion.indexOf(byArray, byArray2, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

