/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.app.Color;
import net.moonlightflower.wc3libs.dataTypes.app.Coords2DI;
import net.moonlightflower.wc3libs.misc.UnsupportedFormatException;
import net.moonlightflower.wc3libs.misc.image.BLP;
import net.moonlightflower.wc3libs.misc.image.FxImg;
import net.moonlightflower.wc3libs.misc.image.Wc3RasterImg;
import net.moonlightflower.wc3libs.port.JMpqPort;
import net.moonlightflower.wc3libs.port.MpqPort;

public class MMP {
    public static final File GAME_PATH = new File("war3map.mmp");
    private List<Icon> _icons = new ArrayList<Icon>();

    @Nonnull
    public List<Icon> getIcons() {
        return this._icons;
    }

    @Nonnull
    public Icon addIcon() {
        Icon icon = new Icon();
        this._icons.add(icon);
        return icon;
    }

    @Nonnull
    public FxImg toFXImg() throws Exception {
        BufferedImage img = new BufferedImage(256, 256, 2);
        LinkedHashMap<File, IconImg> iconImgMap = new LinkedHashMap<File, IconImg>();
        for (Icon icon : this.getIcons()) {
            IconImg iconImg;
            File imgPath = icon.getType().getImgPath();
            if (imgPath == null) continue;
            if (!iconImgMap.containsKey(imgPath)) {
                MpqPort.Out.Result portResult = new JMpqPort().getGameFiles(imgPath);
                InputStream inStream = portResult.getInputStream(imgPath);
                iconImg = new IconImg(inStream);
                inStream.close();
                iconImgMap.put(imgPath, iconImg);
            } else {
                iconImg = (IconImg)iconImgMap.get(imgPath);
            }
            if (iconImg == null) continue;
            int[] pxBuf = iconImg._pxBuf;
            if (icon.getColor() != null) {
                pxBuf = Arrays.copyOf(pxBuf, pxBuf.length);
                double alphaFactor = (double)icon.getColor().getAlpha255() / 255.0;
                double redFactor = (double)icon.getColor().getRed255() / 255.0;
                double greenFactor = (double)icon.getColor().getGreen255() / 255.0;
                double blueFactor = (double)icon.getColor().getBlue255() / 255.0;
                for (int i = 0; i < pxBuf.length; ++i) {
                    int alpha = (int)((double)(pxBuf[i] >> 24 & 0xFF) * alphaFactor);
                    int red = (int)((double)(pxBuf[i] >> 24 & 0xFF) * redFactor);
                    int green = (int)((double)(pxBuf[i] >> 24 & 0xFF) * greenFactor);
                    int blue = (int)((double)(pxBuf[i] >> 24 & 0xFF) * blueFactor);
                    pxBuf[i] = (alpha << 24) + (red << 16) + (green << 8) + blue;
                }
            }
            int minX = icon.getCoords().getX() - iconImg._width / 2;
            int minY = icon.getCoords().getY() - iconImg._height / 2;
            int maxX = Math.min(img.getWidth() - 1, minX + iconImg._width);
            int maxY = Math.min(img.getHeight() - 1, minY + iconImg._height);
            int width = maxX - minX;
            int height = maxY - minY;
            int xOff = Math.max(-minX, 0);
            int yOff = Math.max(-minY, 0);
            img.setRGB(minX, minY, width - xOff, height - yOff, pxBuf, iconImg._width * yOff + xOff, iconImg._width);
        }
        return new FxImg(img);
    }

    @Nonnull
    public Wc3RasterImg toImg() throws Exception {
        return new Wc3RasterImg(this.toFXImg());
    }

    private void read_0x0(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        int unknown = stream.readInt32();
        int iconsCount = stream.readInt32();
        for (int i = 0; i < iconsCount; ++i) {
            Icon icon = this.addIcon();
            icon.read(stream, EncodingFormat.MMP_0x0);
        }
    }

    private void write_0x0(@Nonnull Wc3BinOutputStream stream) {
        stream.writeInt32(0);
        stream.writeInt32(this._icons.size());
        for (Icon icon : this._icons) {
            icon.write(stream, EncodingFormat.MMP_0x0);
        }
    }

    private void read_auto(@Nonnull Wc3BinInputStream stream) throws Exception {
        int version = stream.readInt32();
        stream.rewind();
        EncodingFormat format = EncodingFormat.valueOf(version);
        if (format == null) {
            throw new Exception(String.format("unknown format %x", version));
        }
        this.read(stream, format);
    }

    private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws Exception {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: {
                this.read_auto(stream);
                break;
            }
            case MMP_0x0: {
                this.read_0x0(stream);
            }
        }
    }

    private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case MMP_0x0: 
            case AUTO: {
                this.write_0x0(stream);
            }
        }
    }

    private void read(@Nonnull Wc3BinInputStream stream) throws Exception {
        this.read(stream, EncodingFormat.AUTO);
    }

    public void write(@Nonnull Wc3BinOutputStream stream) {
        this.write(stream, EncodingFormat.AUTO);
    }

    public MMP(@Nonnull Wc3BinInputStream stream) throws Exception {
        this.read(stream);
    }

    public MMP() {
    }

    public MMP(@Nonnull File file) throws Exception {
        Wc3BinInputStream inStream = new Wc3BinInputStream(file);
        this.read(inStream);
        inStream.close();
    }

    @Nonnull
    public static MMP ofMapFile(@Nonnull File mapFile) throws Exception {
        JMpqPort.Out port = new JMpqPort.Out();
        port.add(GAME_PATH);
        MpqPort.Out.Result portResult = port.commit(mapFile);
        if (!portResult.getExports().containsKey(GAME_PATH)) {
            throw new IOException("could not extract info file");
        }
        MMP mmp = new MMP();
        mmp.read(new Wc3BinInputStream(portResult.getInputStream(GAME_PATH)));
        return mmp;
    }

    public static class EncodingFormat
    extends Format<Enum> {
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, -1);
        public static final EncodingFormat MMP_0x0 = new EncodingFormat(Enum.MMP_0x0, 0);

        @Nullable
        public static EncodingFormat valueOf(@Nonnull Integer version) {
            return EncodingFormat.get(EncodingFormat.class, version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, int version) {
            super(enumVal, version);
        }

        public static enum Enum {
            AUTO,
            MMP_0x0;

        }
    }

    public static class IconImg {
        public int _width;
        public int _height;
        public int[] _pxBuf;

        public IconImg(@Nonnull InputStream inStream) throws UnsupportedFormatException {
            FxImg fxImg = new BLP(inStream).getFXImg();
            int width = (int)fxImg.getWidth();
            int height = (int)fxImg.getHeight();
            int[] pxBuf = new int[width * height];
            fxImg.toBufImg().getRGB(0, 0, width, height, pxBuf, 0, width);
            this._width = width;
            this._height = height;
            this._pxBuf = pxBuf;
        }
    }

    public static class Icon {
        private IconType _type = IconType.GOLD_MINE;
        private Coords2DI _coords = new Coords2DI(0, 0);
        private Color _color = Color.fromBGRA255(0, 0, 0, 0);

        @Nonnull
        public IconType getType() {
            return this._type;
        }

        public void setType(@Nonnull IconType val) {
            this._type = val;
        }

        public Coords2DI getCoords() {
            return this._coords;
        }

        public void setCoords(Coords2DI val) {
            this._coords = val;
        }

        @Nullable
        public Color getColor() {
            return this._color;
        }

        public void setColor(@Nullable Color val) {
            this._color = val;
        }

        private void read_0x0(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this.setType(IconType.valueOf(stream.readInt32()));
            this.setCoords(new Coords2DI(stream.readInt32(), stream.readInt32()));
            short blue = stream.readUByte();
            short green = stream.readUByte();
            short red = stream.readUByte();
            short alpha = stream.readUByte();
            if (blue == 255 && green == 255 && red == 255 && alpha == 255) {
                this.setColor(null);
            } else {
                this.setColor(Color.fromBGRA255(blue, green, red, alpha));
            }
        }

        private void write_0x0(@Nonnull Wc3BinOutputStream stream) {
            stream.writeInt32(this.getType().getVal());
            Coords2DI coords = this.getCoords();
            stream.writeInt32(coords.getX());
            stream.writeInt32(coords.getY());
            Color color = this.getColor();
            if (color == null) {
                stream.writeUByte(255);
                stream.writeUByte(255);
                stream.writeUByte(255);
                stream.writeUByte(255);
            } else {
                stream.writeUByte(color.getBlue255());
                stream.writeUByte(color.getGreen255());
                stream.writeUByte(color.getRed255());
                stream.writeUByte(color.getAlpha255());
            }
        }

        public void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case MMP_0x0: {
                    this.read_0x0(stream);
                }
            }
        }

        public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case MMP_0x0: 
                case AUTO: {
                    this.write_0x0(stream);
                }
            }
        }

        public Icon(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this.read(stream, format);
        }

        public Icon() {
        }

        public static enum IconType {
            GOLD_MINE(0, new File("UI\\MiniMap\\minimap-gold.blp")),
            HOUSE(1, new File("UI\\MiniMap\\minimap-neutralbuilding.blp")),
            PLAYER_START(2, new File("UI\\MiniMap\\MiniMapIcon\\MinimapIconStartLoc.blp"));

            private static final Map<Integer, IconType> _map;
            private int _val;
            private File _imgPath;

            public int getVal() {
                return this._val;
            }

            public File getImgPath() {
                return this._imgPath;
            }

            public static IconType valueOf(int val) {
                return _map.get(val);
            }

            private IconType(int val, File imgPath) {
                this._val = val;
                this._imgPath = imgPath;
            }

            static {
                _map = new LinkedHashMap<Integer, IconType>();
                for (IconType iconType : IconType.values()) {
                    _map.put(iconType.getVal(), iconType);
                }
            }
        }
    }
}

