/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver.requests;

import de.peeeq.wurstio.languageserver.Convert;
import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.requests.UserRequest;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.EnumDef;
import de.peeeq.wurstscript.ast.ExtensionFuncDef;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.GlobalVarDef;
import de.peeeq.wurstscript.ast.InitBlock;
import de.peeeq.wurstscript.ast.InterfaceDef;
import de.peeeq.wurstscript.ast.ModuleDef;
import de.peeeq.wurstscript.ast.ModuleInstanciation;
import de.peeeq.wurstscript.ast.NativeFunc;
import de.peeeq.wurstscript.ast.NativeType;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.WEntity;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WurstModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class SymbolInformationRequest
extends UserRequest<Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>> {
    private final String query;

    public SymbolInformationRequest(WorkspaceSymbolParams params) {
        this.query = params.getQuery().toLowerCase();
    }

    @Override
    public Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>> execute(ModelManager modelManager) {
        return Either.forLeft(this.symbolsFromModel(modelManager.getModel()));
    }

    private List<SymbolInformation> symbolsFromModel(WurstModel model) {
        return model.stream().flatMap(cu -> this.symbolsFromCu((CompilationUnit)cu).stream()).filter(si -> (si.getContainerName() + "." + si.getName()).toLowerCase().contains(this.query)).collect(Collectors.toList());
    }

    private List<SymbolInformation> symbolsFromCu(CompilationUnit cu) {
        if (cu == null) {
            return Collections.emptyList();
        }
        ArrayList<SymbolInformation> result = new ArrayList<SymbolInformation>();
        for (WPackage p : cu.getPackages()) {
            this.addSymbolsForPackage(result, p);
        }
        return result;
    }

    private void addSymbolsForPackage(List<SymbolInformation> result, WPackage p) {
        result.add(new SymbolInformation(p.getName(), SymbolKind.Package, Convert.errorLocation(p), ""));
        for (WEntity e : p.getElements()) {
            this.addSymbolsForEntity(result, p.getName(), e);
        }
    }

    private void addSymbolsForEntity(final List<SymbolInformation> result, final String containerName, final WEntity e) {
        e.match(new WEntity.MatcherVoid(){

            private void add(String name, SymbolKind kind) {
                result.add(new SymbolInformation(name, kind, Convert.errorLocation(e), containerName));
            }

            @Override
            public void case_ExtensionFuncDef(ExtensionFuncDef extensionFuncDef) {
                this.add(extensionFuncDef.getName(), SymbolKind.Function);
            }

            @Override
            public void case_ClassDef(ClassDef classDef) {
                String name = classDef.getName();
                this.add(name, SymbolKind.Class);
                for (ClassDef c : classDef.getInnerClasses()) {
                    SymbolInformationRequest.this.addSymbolsForEntity(result, containerName + "." + name, c);
                }
                for (FuncDef f : classDef.getMethods()) {
                    SymbolInformationRequest.this.addSymbolsForEntity(result, containerName + "." + name, f);
                }
                for (GlobalVarDef v : classDef.getVars()) {
                    SymbolInformationRequest.this.addSymbolsForEntity(result, containerName + "." + name, v);
                }
            }

            @Override
            public void case_InterfaceDef(InterfaceDef interfaceDef) {
                String name = interfaceDef.getName();
                this.add(name, SymbolKind.Interface);
                for (FuncDef f : interfaceDef.getMethods()) {
                    SymbolInformationRequest.this.addSymbolsForEntity(result, containerName + "." + name, f);
                }
                for (GlobalVarDef v : interfaceDef.getVars()) {
                    SymbolInformationRequest.this.addSymbolsForEntity(result, containerName + "." + name, v);
                }
            }

            @Override
            public void case_ModuleInstanciation(ModuleInstanciation moduleInstanciation) {
            }

            @Override
            public void case_NativeType(NativeType nativeType) {
                this.add(nativeType.getName(), SymbolKind.Class);
            }

            @Override
            public void case_InitBlock(InitBlock initBlock) {
                this.add("init", SymbolKind.Function);
            }

            @Override
            public void case_TupleDef(TupleDef tupleDef) {
                this.add(tupleDef.getName(), SymbolKind.Class);
            }

            @Override
            public void case_FuncDef(FuncDef funcDef) {
                SymbolKind kind = funcDef.attrIsDynamicClassMember() ? SymbolKind.Method : SymbolKind.Function;
                this.add(funcDef.getName(), kind);
            }

            @Override
            public void case_NativeFunc(NativeFunc nativeFunc) {
                this.add(nativeFunc.getName(), SymbolKind.Function);
            }

            @Override
            public void case_GlobalVarDef(GlobalVarDef g) {
                SymbolKind kind = g.attrIsDynamicClassMember() ? SymbolKind.Field : SymbolKind.Variable;
                this.add(g.getName(), kind);
            }

            @Override
            public void case_EnumDef(EnumDef enumDef) {
                this.add(enumDef.getName(), SymbolKind.Class);
            }

            @Override
            public void case_TypeParamDef(TypeParamDef typeParamDef) {
                this.add(typeParamDef.getName(), SymbolKind.Class);
            }

            @Override
            public void case_ModuleDef(ModuleDef moduleDef) {
                String name = moduleDef.getName();
                this.add(name, SymbolKind.Class);
                for (ClassDef c : moduleDef.getInnerClasses()) {
                    SymbolInformationRequest.this.addSymbolsForEntity(result, containerName + "." + name, c);
                }
                for (FuncDef f : moduleDef.getMethods()) {
                    SymbolInformationRequest.this.addSymbolsForEntity(result, containerName + "." + name, f);
                }
                for (GlobalVarDef v : moduleDef.getVars()) {
                    SymbolInformationRequest.this.addSymbolsForEntity(result, containerName + "." + name, v);
                }
            }
        });
    }
}

