/*
 * Decompiled with CFR 0.152.
 */
package ru.eustas.zopfli;

import java.io.IOException;
import java.io.OutputStream;
import ru.eustas.zopfli.BitWriter;
import ru.eustas.zopfli.Cookie;
import ru.eustas.zopfli.Deflate;
import ru.eustas.zopfli.Options;
import ru.eustas.zopfli.Zopfli;
import ru.eustas.zopfli.ZopfliRuntimeException;

public class ZopfliOutputStream
extends OutputStream {
    private static final int DEFAULT_MASTER_BLOCK_SIZE = 262144;
    private static final int WINDOW_SIZE = 32768;
    private final OutputStream destination;
    private final Options options;
    private final Cookie cookie;
    private final BitWriter bitWriter;
    private final byte[] buffer;
    private final Zopfli.Checksum digest;
    private int offset;
    private int legacy;
    private boolean isClosed;

    public ZopfliOutputStream(OutputStream destination, Options options, Cookie cookie) throws IOException {
        this.options = options;
        this.destination = destination;
        this.cookie = cookie;
        this.bitWriter = new BitWriter(destination);
        this.buffer = new byte[32768 + cookie.masterBlockSize];
        this.digest = Zopfli.createDigest(options.outputType);
        Zopfli.writePrologue(options.outputType, this.bitWriter);
    }

    public ZopfliOutputStream(OutputStream destination, Options options) throws IOException {
        this(destination, options, new Cookie(262144));
    }

    public ZopfliOutputStream(OutputStream destination) throws IOException {
        this(destination, new Options());
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.offset > this.legacy) {
            this.compressBlock(true);
        } else {
            Zopfli.writeEmptyBlock(this.bitWriter, true);
        }
        Zopfli.writeEpilogue(this.options.outputType, this.bitWriter, this.digest);
        this.destination.close();
    }

    public void flush() throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("write after close");
        }
        if (this.offset > this.legacy) {
            this.compressBlock(false);
        }
        Zopfli.writeEmptyBlock(this.bitWriter, false);
        this.bitWriter.flush();
        this.destination.flush();
    }

    public void write(int b) throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("write after close");
        }
        this.buffer[this.offset++] = (byte)b;
        int fence = this.cookie.masterBlockSize + this.legacy;
        if (this.offset == fence) {
            this.compressBlock(false);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("write after close");
        }
        int from = off;
        int toWrite = len;
        while (toWrite > 0) {
            int fence = this.cookie.masterBlockSize + this.legacy;
            int chunk = fence - this.offset;
            if (toWrite < chunk) {
                chunk = toWrite;
            }
            System.arraycopy(b, from, this.buffer, this.offset, chunk);
            from += chunk;
            toWrite -= chunk;
            this.offset += chunk;
            if (this.offset != fence) continue;
            this.compressBlock(false);
        }
    }

    private void compressBlock(boolean isLast) throws IOException {
        try {
            Deflate.deflatePart(this.cookie, this.options, this.buffer, this.legacy, this.offset, isLast, this.bitWriter);
            this.digest.update(this.buffer, this.legacy, this.offset - this.legacy);
        }
        catch (ZopfliRuntimeException ex) {
            throw new IOException(ex);
        }
        if (this.offset > 32768) {
            System.arraycopy(this.buffer, this.offset - 32768, this.buffer, 0, 32768);
            this.legacy = 32768;
        } else {
            this.legacy = this.offset;
        }
        this.offset = this.legacy;
    }
}

