/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WParameters;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImAnyType;
import de.peeeq.wurstscript.jassIm.ImArrayType;
import de.peeeq.wurstscript.jassIm.ImArrayTypeMulti;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprs;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImNull;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSimpleType;
import de.peeeq.wurstscript.jassIm.ImStatementExpr;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImTupleType;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeVarRef;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.ImVars;
import de.peeeq.wurstscript.jassIm.ImVoid;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImHelper {
    public static Set<ImFunction> calculateFunctionsOfProg(ImProg prog) {
        HashSet<ImFunction> allFunctions = new HashSet<ImFunction>(prog.getFunctions());
        for (ImClass c : prog.getClasses()) {
            allFunctions.addAll(c.getFunctions());
        }
        return allFunctions;
    }

    static void translateParameters(WParameters params, ImVars result, ImTranslator t) {
        for (WParameter p : params) {
            result.add(t.getVarFor(p));
        }
    }

    public static ImType toArray(ImType t) {
        if (t instanceof ImArrayType) {
            return t;
        }
        if (t instanceof ImArrayTypeMulti) {
            ImArrayTypeMulti mat = (ImArrayTypeMulti)t;
            ArrayList<Integer> nsize = new ArrayList<Integer>(mat.getArraySize());
            nsize.add(32768);
            return JassIm.ImArrayTypeMulti(mat.getEntryType(), nsize);
        }
        return JassIm.ImArrayType(t);
    }

    public static void replaceVar(List<ImStmt> stmts, ImVar oldVar, ImVar newVar) {
        for (ImStmt s : stmts) {
            ImHelper.replaceVar(s, oldVar, newVar);
        }
    }

    public static void replaceVar(ImStmt s, final ImVar oldVar, final ImVar newVar) {
        s.accept(new VarReplaceVisitor(){

            @Override
            ImVar getReplaceVar(ImVar v) {
                super.visit(v);
                return v == oldVar ? newVar : null;
            }
        });
    }

    public static void replaceVar(ImStmt s, final Map<ImVar, ImVar> substitutions) {
        s.accept(new VarReplaceVisitor(){

            @Override
            ImVar getReplaceVar(ImVar v) {
                super.visit(v);
                return (ImVar)substitutions.get(v);
            }
        });
    }

    public static ImNull nullExpr() {
        return JassIm.ImNull(JassIm.ImVoid());
    }

    public static ImStatementExpr statementExprVoid(ImStmts stmts) {
        return JassIm.ImStatementExpr(stmts, ImHelper.nullExpr());
    }

    public static ImStatementExpr statementExprVoid(ImStmt ... stmts) {
        return ImHelper.statementExprVoid(JassIm.ImStmts(stmts));
    }

    public static void replaceElem(Element oldElem, Element newElement) {
        Element parent = oldElem.getParent();
        if (parent == null) {
            throw new Error("Element has no parent: " + oldElem);
        }
        for (int i = 0; i < parent.size(); ++i) {
            if (parent.get(i) != oldElem) continue;
            parent.set(i, newElement);
            return;
        }
        throw new Error("Element " + oldElem + " not found in parent. This should never happen ;)");
    }

    public static ImExpr defaultValueForType(ImSimpleType t) {
        String type;
        switch (type = t.getTypename()) {
            case "integer": {
                return JassIm.ImIntVal(0);
            }
            case "boolean": {
                return JassIm.ImBoolVal(false);
            }
            case "real": {
                return JassIm.ImRealVal("0.");
            }
        }
        return JassIm.ImNull(t);
    }

    public static ImExpr defaultValueForComplexType(final ImType t) {
        return t.match(new ImType.Matcher<ImExpr>(){

            @Override
            public ImExpr case_ImArrayTypeMulti(ImArrayTypeMulti imArrayTypeMulti) {
                throw new CompileError(t, "Cannot find default value for type " + t);
            }

            @Override
            public ImExpr case_ImAnyType(ImAnyType at) {
                return JassIm.ImNull(at);
            }

            @Override
            public ImExpr case_ImTupleType(ImTupleType tt) {
                ImExprs res = JassIm.ImExprs(new ImExpr[0]);
                for (ImType it : tt.getTypes()) {
                    res.add(ImHelper.defaultValueForComplexType(it));
                }
                return JassIm.ImTupleExpr(res);
            }

            @Override
            public ImExpr case_ImArrayType(ImArrayType imArrayType) {
                throw new CompileError(t, "Cannot find default value for type " + t);
            }

            @Override
            public ImExpr case_ImTypeVarRef(ImTypeVarRef imTypeVarRef) {
                throw new CompileError(t, "Cannot find default value for type " + t);
            }

            @Override
            public ImExpr case_ImVoid(ImVoid imVoid) {
                throw new CompileError(t, "Cannot find default value for type " + t);
            }

            @Override
            public ImExpr case_ImClassType(ImClassType imClassType) {
                return JassIm.ImIntVal(0);
            }

            @Override
            public ImExpr case_ImSimpleType(ImSimpleType st) {
                return ImHelper.defaultValueForType(st);
            }
        });
    }

    static abstract class VarReplaceVisitor
    extends Element.DefaultVisitor {
        VarReplaceVisitor() {
        }

        abstract ImVar getReplaceVar(ImVar var1);

        @Override
        public void visit(ImVarArrayAccess e) {
            super.visit(e);
            ImVar newVar = this.getReplaceVar(e.getVar());
            if (newVar != null) {
                e.setVar(newVar);
            }
        }

        @Override
        public void visit(ImVarAccess e) {
            super.visit(e);
            ImVar newVar = this.getReplaceVar(e.getVar());
            if (newVar != null) {
                e.setVar(newVar);
            }
        }
    }
}

