/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.luaAst;

import de.peeeq.wurstscript.luaAst.Element;
import de.peeeq.wurstscript.luaAst.LuaDefinition;
import de.peeeq.wurstscript.luaAst.LuaExprFuncRef;
import de.peeeq.wurstscript.luaAst.LuaExprFunctionCall;
import de.peeeq.wurstscript.luaAst.LuaExprMethodCall;
import de.peeeq.wurstscript.luaAst.LuaExprOpt;
import de.peeeq.wurstscript.luaAst.LuaExprVarAccess;
import de.peeeq.wurstscript.luaAst.LuaFunction;
import de.peeeq.wurstscript.luaAst.LuaMethod;
import de.peeeq.wurstscript.luaAst.LuaStatement;
import de.peeeq.wurstscript.luaAst.LuaVariable;
import de.peeeq.wurstscript.translation.lua.printing.LuaPrinter;
import java.util.Objects;
import java.util.function.Consumer;

class LuaVariableImpl
implements LuaVariable {
    private Element parent;
    private String name;
    private LuaExprOpt initialValue;

    LuaVariableImpl(String name, LuaExprOpt initialValue) {
        if (name == null) {
            throw new IllegalArgumentException("Element name must not be null.");
        }
        if (initialValue == null) {
            throw new IllegalArgumentException("Element initialValue must not be null.");
        }
        this.name = name;
        this.initialValue = initialValue;
        initialValue.setParent(this);
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree.Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    @Override
    public void replaceBy(Element other) {
        if (this.parent == null) {
            throw new RuntimeException("Node not attached to tree.");
        }
        for (int i = 0; i < this.parent.size(); ++i) {
            if (this.parent.get(i) != this) continue;
            this.parent.set(i, other);
            return;
        }
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setInitialValue(LuaExprOpt initialValue) {
        if (initialValue == null) {
            throw new IllegalArgumentException();
        }
        this.initialValue.setParent(null);
        initialValue.setParent(this);
        this.initialValue = initialValue;
    }

    @Override
    public LuaExprOpt getInitialValue() {
        return this.initialValue;
    }

    @Override
    public Element get(int i) {
        switch (i) {
            case 0: {
                return this.initialValue;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public Element set(int i, Element newElem) {
        switch (i) {
            case 0: {
                LuaExprOpt oldElem = this.initialValue;
                this.setInitialValue((LuaExprOpt)newElem);
                return oldElem;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public void forEachElement(Consumer<? super Element> action) {
        action.accept(this.initialValue);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public LuaVariable copy() {
        LuaVariableImpl result = new LuaVariableImpl(this.name, this.initialValue.copy());
        return result;
    }

    @Override
    public LuaVariable copyWithRefs() {
        final LuaVariable res = this.copy();
        final LuaVariableImpl self = this;
        res.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(LuaExprMethodCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getMethod(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setMethod((LuaMethod)res.followPath(self.pathTo(e.getMethod())));
                }
            }

            @Override
            public void visit(LuaExprFunctionCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }

            @Override
            public void visit(LuaExprVarAccess e) {
                Element elem;
                super.visit(e);
                for (elem = e.getVar(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setVar((LuaVariable)res.followPath(self.pathTo(e.getVar())));
                }
            }

            @Override
            public void visit(LuaExprFuncRef e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }
        });
        return res;
    }

    @Override
    public void clearAttributes() {
        this.initialValue.clearAttributes();
        this.clearAttributesLocal();
    }

    @Override
    public void clearAttributesLocal() {
    }

    @Override
    public void accept(Element.Visitor v) {
        v.visit(this);
    }

    @Override
    public <T> T match(LuaDefinition.Matcher<T> matcher) {
        return matcher.case_LuaVariable(this);
    }

    @Override
    public void match(LuaDefinition.MatcherVoid matcher) {
        matcher.case_LuaVariable(this);
    }

    @Override
    public <T> T match(LuaStatement.Matcher<T> matcher) {
        return matcher.case_LuaVariable(this);
    }

    @Override
    public void match(LuaStatement.MatcherVoid matcher) {
        matcher.case_LuaVariable(this);
    }

    @Override
    public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaVariable(this);
    }

    @Override
    public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaVariable(this);
    }

    public String toString() {
        return "LuaVariable(" + this.name + ", " + this.initialValue + ")";
    }

    @Override
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaVariable) {
            LuaVariable o = (LuaVariable)e;
            return Objects.equals(this.name, o.getName()) && this.initialValue.structuralEquals(o.getInitialValue());
        }
        return false;
    }

    @Override
    public void print(StringBuilder sb, int indent) {
        LuaPrinter.print(this, sb, indent);
    }
}

