/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes.prettyPrint;

import de.peeeq.wurstio.WurstCompilerJassImpl;
import de.peeeq.wurstscript.RunArgs;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.attributes.prettyPrint.MaxOneSpacer;
import de.peeeq.wurstscript.gui.WurstGuiCliImpl;
import de.peeeq.wurstscript.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.Nullable;

public class PrettyUtils {
    private static @Nullable Element lastElement = null;

    public static void pretty(List<String> args) throws IOException {
        if (args.size() == 0) {
            return;
        }
        String arg = args.get(0);
        if (args.equals("...")) {
            PrettyUtils.prettyAll(".");
        }
        if (arg.equals("tree") && args.size() >= 2) {
            PrettyUtils.debug(args.get(1));
            return;
        }
        String clean = PrettyUtils.pretty(new File(arg));
        System.out.println(clean);
    }

    public static String pretty(String source, String ending) {
        CompilationUnit cu = PrettyUtils.parse(source, ending);
        MaxOneSpacer spacer = new MaxOneSpacer();
        StringBuilder sb = new StringBuilder();
        cu.prettyPrint(spacer, sb, 0);
        return sb.toString();
    }

    private static void prettyPrint(String filename) {
        String clean = PrettyUtils.pretty(filename, filename.substring(filename.lastIndexOf(".")));
        System.out.println(clean);
    }

    public static void pretty(CompilationUnit cu) {
        MaxOneSpacer spacer = new MaxOneSpacer();
        StringBuilder sb = new StringBuilder();
        cu.prettyPrint(spacer, sb, 0);
        System.out.println(sb);
    }

    private static void debug(String filename) {
        String contents = PrettyUtils.readFile(filename);
        CompilationUnit cu = PrettyUtils.parse(contents, filename.substring(filename.lastIndexOf(".")));
        PrettyUtils.walkTree(cu, 0);
    }

    private static void check(Element e, int indent) {
        System.out.println(StringUtils.repeat((String)"\t", (int)indent) + Utils.printElement(e));
    }

    private static void walkTree(Element e, int indent) {
        lastElement = e;
        PrettyUtils.check(e, indent);
        lastElement = null;
        for (int i = 0; i < e.size(); ++i) {
            PrettyUtils.walkTree(e.get(i), indent + 1);
        }
    }

    private static void prettyAll(String root) throws IOException {
        Files.walk(Paths.get(root, new String[0]), new FileVisitOption[0]).filter(p -> p.toString().endsWith(".wurst")).forEach(p -> PrettyUtils.prettyPrint(p.toString()));
    }

    private static String pretty(File f) {
        String contents = PrettyUtils.readFile(f.toString());
        CompilationUnit cu = PrettyUtils.parse(contents, f.getName().substring(f.getName().lastIndexOf(".")));
        MaxOneSpacer spacer = new MaxOneSpacer();
        StringBuilder sb = new StringBuilder();
        cu.prettyPrint(spacer, sb, 0);
        return sb.toString();
    }

    private static String readFile(String filename) {
        String everything = "";
        try (BufferedReader br = new BufferedReader(new FileReader(filename));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
                line = br.readLine();
            }
            everything = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return everything;
    }

    private static CompilationUnit parse(String input, String ending) {
        WurstGuiCliImpl gui = new WurstGuiCliImpl();
        WurstCompilerJassImpl compiler = new WurstCompilerJassImpl(null, gui, null, new RunArgs("-prettyPrint"));
        return compiler.parse("format" + ending, new StringReader(input));
    }
}

